/*
 * Decompiled with CFR 0.152.
 */
package freenet.l10n;

import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;

public class L10n {
    public static final String CLASS_NAME = "L10n";
    private final LANGUAGE selectedLanguage;
    private static SimpleFieldSet currentTranslation = null;
    private static SimpleFieldSet fallbackTranslation = null;
    private static L10n currentClass = null;
    private static SimpleFieldSet translationOverride;
    private static final Object sync;

    L10n(LANGUAGE selected) {
        this.selectedLanguage = selected;
        try {
            File tmpFile = new File(selected.l10nOverrideFilename);
            if (tmpFile.exists() && tmpFile.canRead() && tmpFile.length() > 0L) {
                Logger.normal(this, "Override file detected : let's try to load it");
                translationOverride = SimpleFieldSet.readFrom(tmpFile, false, false);
            } else {
                File backup = new File(tmpFile.getParentFile(), tmpFile.getName() + ".bak");
                if (backup.exists() && backup.length() > 0L) {
                    Logger.normal(this, "Override-backup file detected : let's try to load it");
                    translationOverride = SimpleFieldSet.readFrom(backup, false, false);
                }
                translationOverride = null;
            }
        }
        catch (IOException e) {
            translationOverride = null;
            Logger.error(this, "IOError while accessing the file!" + e.getMessage(), e);
        }
        currentTranslation = L10n.loadTranslation(this.selectedLanguage);
        if (currentTranslation == null) {
            Logger.error(this, "The translation file for " + (Object)((Object)this.selectedLanguage) + " is invalid. The node will load an empty template.");
            currentTranslation = null;
            translationOverride = new SimpleFieldSet(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLanguage(String selectedLanguage) throws MissingResourceException {
        Object object = sync;
        synchronized (object) {
            Logger.normal(CLASS_NAME, "Changing the current language to : " + selectedLanguage);
            L10n oldClass = currentClass;
            LANGUAGE lang = LANGUAGE.mapToLanguage(selectedLanguage);
            if (lang == null) {
                currentClass = oldClass != null ? oldClass : new L10n(LANGUAGE.getDefault());
                Logger.error(CLASS_NAME, "The requested translation is not available!" + selectedLanguage);
                throw new MissingResourceException("The requested translation (" + selectedLanguage + ") hasn't been found!", CLASS_NAME, selectedLanguage);
            }
            currentClass = new L10n(lang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOverride(String key, String value) {
        key = key.trim();
        value = value.trim();
        Object object = sync;
        synchronized (object) {
            if (translationOverride == null) {
                translationOverride = new SimpleFieldSet(false);
            }
            if ("".equals(value) || value.equals(currentTranslation.get(key))) {
                translationOverride.removeValue(key);
            } else {
                value = value.replaceAll("(\r|\n|\t)+", "");
                translationOverride.putOverwrite(key, value);
                Logger.normal(CLASS_NAME, "Got a new translation key: set the Override!");
            }
            L10n._saveTranslationFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void _saveTranslationFile() {
        FileOutputStream fos = null;
        File finalFile = new File(L10n.getSelectedLanguage().l10nOverrideFilename);
        try {
            try {
                File tempFile = new File(finalFile.getParentFile(), finalFile.getName() + ".bak");
                Logger.minor(CLASS_NAME, "The temporary filename is : " + tempFile);
                fos = new FileOutputStream(tempFile);
                translationOverride.writeTo(fos);
                FileUtil.renameTo(tempFile, finalFile);
                Logger.normal(CLASS_NAME, "Override file saved successfully!");
            }
            catch (IOException e) {
                Logger.error(CLASS_NAME, "Error while saving the translation override: " + e.getMessage(), e);
                Object var4_5 = null;
                Closer.close(fos);
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Closer.close(fos);
            throw throwable;
        }
        Closer.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFieldSet getCurrentLanguageTranslation() {
        Object object = sync;
        synchronized (object) {
            return currentTranslation == null ? null : new SimpleFieldSet(currentTranslation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFieldSet getOverrideForCurrentLanguageTranslation() {
        Object object = sync;
        synchronized (object) {
            return translationOverride == null ? null : new SimpleFieldSet(translationOverride);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFieldSet getDefaultLanguageTranslation() {
        Object object = sync;
        synchronized (object) {
            if (fallbackTranslation == null) {
                fallbackTranslation = L10n.loadTranslation(LANGUAGE.getDefault());
            }
            return new SimpleFieldSet(fallbackTranslation);
        }
    }

    public static String getString(String key) {
        return L10n.getString(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String key, boolean returnNullIfNotFound) {
        String result = null;
        Object object = sync;
        synchronized (object) {
            if (translationOverride != null) {
                result = translationOverride.get(key);
            }
        }
        if (result != null) {
            return result;
        }
        object = sync;
        synchronized (object) {
            if (currentTranslation != null) {
                result = currentTranslation.get(key);
            }
        }
        if (result != null) {
            return result;
        }
        Logger.normal(CLASS_NAME, "The translation for " + key + " hasn't been found (" + (Object)((Object)L10n.getSelectedLanguage()) + ")! please tell the maintainer.");
        return returnNullIfNotFound ? null : L10n.getDefaultString(key);
    }

    public static HTMLNode getHTMLNode(String key) {
        String value = L10n.getString(key, true);
        if (value != null) {
            return new HTMLNode("#", value);
        }
        HTMLNode translationField = new HTMLNode("span", "class", "translate_it");
        translationField.addChild("#", L10n.getDefaultString(key));
        translationField.addChild("a", "href", "/translation/?translate=" + key).addChild("small", " (translate it in your native language!)");
        return translationField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultString(String key) {
        String result = null;
        Object object = sync;
        synchronized (object) {
            if (fallbackTranslation == null) {
                fallbackTranslation = L10n.loadTranslation(LANGUAGE.getDefault());
            }
            result = fallbackTranslation.get(key);
        }
        if (result != null) {
            return result;
        }
        Logger.error(CLASS_NAME, "The default translation for " + key + " hasn't been found!");
        System.err.println("The default translation for " + key + " hasn't been found!");
        new Exception().printStackTrace();
        return key;
    }

    public static String getString(String key, String[] patterns, String[] values) {
        assert (patterns.length == values.length);
        String result = L10n.getString(key);
        for (int i = 0; i < patterns.length; ++i) {
            result = result.replaceAll("\\$\\{" + patterns[i] + "\\}", L10n.quoteReplacement(values[i]));
        }
        return result;
    }

    private static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LANGUAGE getSelectedLanguage() {
        Object object = sync;
        synchronized (object) {
            if (currentClass == null || L10n.currentClass.selectedLanguage == null) {
                return LANGUAGE.getDefault();
            }
            return L10n.currentClass.selectedLanguage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SimpleFieldSet loadTranslation(LANGUAGE lang) {
        SimpleFieldSet result = null;
        InputStream in = null;
        try {
            block4: {
                try {
                    ClassLoader loader = ClassLoader.getSystemClassLoader();
                    in = loader.getResourceAsStream(lang.l10nFilename);
                    if (in == null) break block4;
                    result = SimpleFieldSet.readFrom(in, false, false);
                }
                catch (Exception e) {
                    Logger.error(CLASS_NAME, "Error while loading the l10n file from " + lang.l10nFilename + " :" + e.getMessage(), e);
                    result = null;
                    Object var5_6 = null;
                    Closer.close(in);
                    return result;
                }
            }
            Object var5_5 = null;
            Closer.close(in);
            return result;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Closer.close(in);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOverridden(String key) {
        Object object = sync;
        synchronized (object) {
            if (translationOverride == null) {
                return false;
            }
            return translationOverride.get(key) != null;
        }
    }

    public static void addL10nSubstitution(HTMLNode node, String key, String[] patterns, String[] values) {
        String result = HTMLEncoder.encode(L10n.getString(key));
        assert (patterns.length == values.length);
        for (int i = 0; i < patterns.length; ++i) {
            result = result.replaceAll("\\$\\{" + patterns[i] + "\\}", L10n.quoteReplacement(values[i]));
        }
        node.addChild("%", result);
    }

    public static String getString(String key, String pattern, String value) {
        return L10n.getString(key, new String[]{pattern}, new String[]{value});
    }

    static {
        sync = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LANGUAGE {
        ENGLISH("en", "English", "eng"),
        SPANISH("es", "Espa\u00f1ol", "spa"),
        DANISH("da", "Dansk", "dan"),
        GERMAN("de", "Deutsch", "deu"),
        FINNISH("fi", "Suomi", "fin"),
        FRENCH("fr", "Fran\u00e7ais", "fra"),
        ITALIAN("it", "Italiano", "ita"),
        NORWEGIAN("no", "Norsk", "nor"),
        POLISH("pl", "Polski", "pol"),
        SWEDISH("se", "Svenska", "svk"),
        CHINESE("zh-cn", "\u4e2d\u6587(\u7b80\u4f53)", "chn"),
        CHINESE_TAIWAN("zh-tw", "\u4e2d\u6587(\u7e41\u9ad4)", "zh-tw"),
        UNLISTED("unlisted", "unlisted", "unlisted");

        public final String shortCode;
        public final String fullName;
        public final String isoCode;
        public final String l10nFilename;
        public final String l10nOverrideFilename;

        private LANGUAGE(String shortCode, String fullName, String isoCode) {
            this.shortCode = shortCode;
            this.fullName = fullName;
            this.isoCode = isoCode;
            this.l10nFilename = "freenet/l10n/freenet.l10n." + shortCode + ".properties";
            this.l10nOverrideFilename = "freenet.l10n." + shortCode + ".override.properties";
        }

        private LANGUAGE(LANGUAGE l) {
            this(l.shortCode, l.fullName, l.isoCode);
        }

        public static LANGUAGE mapToLanguage(String whatever) {
            for (LANGUAGE currentLanguage : LANGUAGE.values()) {
                if (!currentLanguage.shortCode.equalsIgnoreCase(whatever) && !currentLanguage.fullName.equalsIgnoreCase(whatever) && !currentLanguage.isoCode.equalsIgnoreCase(whatever) && !currentLanguage.toString().equalsIgnoreCase(whatever)) continue;
                return currentLanguage;
            }
            return null;
        }

        public static String[] valuesWithFullNames() {
            LANGUAGE[] allValues = LANGUAGE.values();
            String[] result = new String[allValues.length];
            for (int i = 0; i < allValues.length; ++i) {
                result[i] = allValues[i].fullName;
            }
            return result;
        }

        public static LANGUAGE getDefault() {
            return ENGLISH;
        }
    }
}

