/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import com.db4o.ObjectContainer;
import freenet.keys.BaseClientKey;
import freenet.keys.ClientKey;
import freenet.keys.ClientSSK;
import freenet.keys.FreenetURI;
import freenet.support.Fields;
import freenet.support.Logger;
import java.net.MalformedURLException;
import java.util.Arrays;

public class USK
extends BaseClientKey {
    protected static final String SEPARATOR = "-";
    public final byte cryptoAlgorithm;
    public final byte[] pubKeyHash;
    public final byte[] cryptoKey;
    public final String siteName;
    public final long suggestedEdition;
    private final int hashCode;

    public USK(byte[] pubKeyHash, byte[] cryptoKey, byte[] extra, String siteName, long suggestedEdition) throws MalformedURLException {
        this.pubKeyHash = pubKeyHash;
        this.cryptoKey = cryptoKey;
        this.siteName = siteName;
        this.suggestedEdition = suggestedEdition;
        if (extra == null) {
            throw new MalformedURLException("No extra bytes (third bit) in USK");
        }
        if (pubKeyHash == null) {
            throw new MalformedURLException("No pubkey hash (first bit) in USK");
        }
        if (cryptoKey == null) {
            throw new MalformedURLException("No crypto key (second bit) in USK");
        }
        ClientSSK tmp = new ClientSSK(siteName, pubKeyHash, extra, null, cryptoKey);
        this.cryptoAlgorithm = tmp.cryptoAlgorithm;
        if (pubKeyHash.length != 32) {
            throw new MalformedURLException("Pubkey hash wrong length: " + pubKeyHash.length + " should be " + 32);
        }
        if (cryptoKey.length != 32) {
            throw new MalformedURLException("Decryption key wrong length: " + cryptoKey.length + " should be " + 32);
        }
        this.hashCode = Fields.hashCode(pubKeyHash) ^ Fields.hashCode(cryptoKey) ^ siteName.hashCode() ^ (int)suggestedEdition ^ (int)(suggestedEdition >> 32);
    }

    public static USK create(FreenetURI uri) throws MalformedURLException {
        if (!uri.isUSK()) {
            throw new MalformedURLException("Not a USK");
        }
        return new USK(uri.getRoutingKey(), uri.getCryptoKey(), uri.getExtra(), uri.getDocName(), uri.getSuggestedEdition());
    }

    protected USK(byte[] pubKeyHash2, byte[] cryptoKey2, String siteName2, long suggestedEdition2, byte cryptoAlgorithm) {
        this.pubKeyHash = pubKeyHash2;
        this.cryptoKey = cryptoKey2;
        this.siteName = siteName2;
        this.suggestedEdition = suggestedEdition2;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.hashCode = Fields.hashCode(this.pubKeyHash) ^ Fields.hashCode(this.cryptoKey) ^ this.siteName.hashCode() ^ (int)this.suggestedEdition ^ (int)(this.suggestedEdition >> 32);
    }

    public USK(ClientSSK ssk, long myARKNumber) {
        this.pubKeyHash = ssk.pubKeyHash;
        this.cryptoKey = ssk.cryptoKey;
        this.siteName = ssk.docName;
        this.suggestedEdition = myARKNumber;
        this.cryptoAlgorithm = ssk.cryptoAlgorithm;
        if (this.siteName.matches(".*\\-[0-9]+(\\/.*)?$")) {
            Logger.normal(this, "POSSIBLE BUG: edition in ClientSSK " + ssk, new Exception("debug"));
        }
        this.hashCode = Fields.hashCode(this.pubKeyHash) ^ Fields.hashCode(this.cryptoKey) ^ this.siteName.hashCode() ^ (int)this.suggestedEdition ^ (int)(this.suggestedEdition >> 32);
    }

    public USK(USK usk) {
        this.pubKeyHash = new byte[usk.pubKeyHash.length];
        System.arraycopy(usk.pubKeyHash, 0, this.pubKeyHash, 0, usk.pubKeyHash.length);
        this.cryptoAlgorithm = usk.cryptoAlgorithm;
        this.cryptoKey = usk.cryptoKey;
        this.siteName = usk.siteName;
        this.suggestedEdition = usk.suggestedEdition;
        this.hashCode = Fields.hashCode(this.pubKeyHash) ^ Fields.hashCode(this.cryptoKey) ^ this.siteName.hashCode() ^ (int)this.suggestedEdition ^ (int)(this.suggestedEdition >> 32);
    }

    public FreenetURI getURI() {
        return new FreenetURI(this.pubKeyHash, this.cryptoKey, ClientSSK.getExtraBytes(this.cryptoAlgorithm), this.siteName, this.suggestedEdition);
    }

    public ClientSSK getSSK(long ver) {
        try {
            return new ClientSSK(this.siteName + SEPARATOR + ver, this.pubKeyHash, ClientSSK.getExtraBytes(this.cryptoAlgorithm), null, this.cryptoKey);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Caught " + e + " should not be possible in USK.getSSK", e);
            throw new Error(e);
        }
    }

    public ClientKey getSSK() {
        return this.getSSK(this.suggestedEdition);
    }

    public USK copy(long edition) {
        if (this.suggestedEdition == edition) {
            return this;
        }
        return new USK(this.pubKeyHash, this.cryptoKey, this.siteName, edition, this.cryptoAlgorithm);
    }

    public USK clearCopy() {
        return this.copy(0L);
    }

    public USK clone() {
        return new USK(this);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof USK)) {
            return false;
        }
        return this.equals(o, true);
    }

    public boolean equals(Object o, boolean includeVersion) {
        if (o instanceof USK) {
            USK u = (USK)o;
            if (!Arrays.equals(this.pubKeyHash, u.pubKeyHash)) {
                return false;
            }
            if (!Arrays.equals(this.cryptoKey, u.cryptoKey)) {
                return false;
            }
            if (!this.siteName.equals(u.siteName)) {
                return false;
            }
            return !includeVersion || this.suggestedEdition == u.suggestedEdition;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public FreenetURI getBaseSSK() {
        return new FreenetURI("SSK", this.siteName, this.pubKeyHash, this.cryptoKey, ClientSSK.getExtraBytes(this.cryptoAlgorithm));
    }

    public String toString() {
        return super.toString() + ':' + this.getURI();
    }

    public FreenetURI turnMySSKIntoUSK(FreenetURI uri) {
        if (uri.getKeyType().equals("SSK") && Arrays.equals(uri.getRoutingKey(), this.pubKeyHash) && Arrays.equals(uri.getCryptoKey(), this.cryptoKey) && Arrays.equals(uri.getExtra(), ClientSSK.getExtraBytes(this.cryptoAlgorithm)) && uri.getDocName() != null && uri.getDocName().startsWith(this.siteName)) {
            long edition;
            String doc = uri.getDocName();
            if ((doc = doc.substring(this.siteName.length())).length() < 2 || doc.charAt(0) != '-') {
                return uri;
            }
            doc = doc.substring(1);
            try {
                edition = Long.parseLong(doc);
            }
            catch (NumberFormatException e) {
                Logger.normal(this, "Trying to turn SSK back into USK: " + uri + " doc=" + doc + " caught " + e, e);
                return uri;
            }
            if (!doc.equals(Long.toString(edition))) {
                return uri;
            }
            return new FreenetURI("USK", this.siteName, uri.getAllMetaStrings(), this.pubKeyHash, this.cryptoKey, ClientSSK.getExtraBytes(this.cryptoAlgorithm), edition);
        }
        return uri;
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

