/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import com.db4o.ObjectContainer;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.SHA256;
import freenet.keys.Key;
import freenet.keys.NodeCHK;
import freenet.keys.SSKVerifyException;
import freenet.node.GetPubkey;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.Logger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;

public class NodeSSK
extends Key {
    final byte cryptoAlgorithm;
    final byte[] pubKeyHash;
    final byte[] encryptedHashedDocname;
    transient DSAPublicKey pubKey;
    final int hashCode;
    static final int SSK_VERSION = 1;
    static final int PUBKEY_HASH_SIZE = 32;
    static final int E_H_DOCNAME_SIZE = 32;
    static final byte BASE_TYPE = 2;
    public static final int FULL_KEY_LENGTH = 66;
    public static final int ROUTING_KEY_LENGTH = 32;

    public String toString() {
        return super.toString() + ":pkh=" + HexUtil.bytesToHex(this.pubKeyHash) + ":ehd=" + HexUtil.bytesToHex(this.encryptedHashedDocname);
    }

    public NodeSSK(byte[] pkHash, byte[] ehDocname, DSAPublicKey pubKey, byte cryptoAlgorithm) throws SSKVerifyException {
        super(NodeSSK.makeRoutingKey(pkHash, ehDocname));
        byte[] hash;
        this.encryptedHashedDocname = ehDocname;
        this.pubKeyHash = pkHash;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.pubKey = pubKey;
        if (pubKey != null && !Arrays.equals(hash = SHA256.digest(pubKey.asBytes()), pkHash)) {
            throw new SSKVerifyException("Invalid pubKey: wrong hash");
        }
        if (ehDocname.length != 32) {
            throw new IllegalArgumentException("ehDocname must be 32 bytes");
        }
        if (pkHash.length != 32) {
            throw new IllegalArgumentException("pubKeyHash must be 32 bytes");
        }
        this.hashCode = Fields.hashCode(pkHash) ^ Fields.hashCode(ehDocname);
    }

    private NodeSSK(NodeSSK key) {
        super(key);
        this.cryptoAlgorithm = key.cryptoAlgorithm;
        this.pubKey = key.pubKey;
        this.pubKeyHash = new byte[key.pubKeyHash.length];
        System.arraycopy(key.pubKeyHash, 0, this.pubKeyHash, 0, key.pubKeyHash.length);
        this.encryptedHashedDocname = new byte[key.encryptedHashedDocname.length];
        System.arraycopy(key.encryptedHashedDocname, 0, this.encryptedHashedDocname, 0, key.encryptedHashedDocname.length);
        this.hashCode = key.hashCode;
    }

    public Key cloneKey() {
        return new NodeSSK(this);
    }

    private static byte[] makeRoutingKey(byte[] pkHash, byte[] ehDocname) {
        MessageDigest md256 = SHA256.getMessageDigest();
        md256.update(ehDocname);
        md256.update(pkHash);
        byte[] key = md256.digest();
        SHA256.returnMessageDigest(md256);
        return key;
    }

    public void write(DataOutput _index) throws IOException {
        _index.writeShort(this.getType());
        _index.write(this.encryptedHashedDocname);
        _index.write(this.pubKeyHash);
    }

    public static Key readSSK(DataInput raf, byte cryptoAlgorithm) throws IOException {
        byte[] buf = new byte[32];
        raf.readFully(buf);
        byte[] buf2 = new byte[32];
        raf.readFully(buf2);
        try {
            return new NodeSSK(buf2, buf, null, cryptoAlgorithm);
        }
        catch (SSKVerifyException e) {
            IllegalStateException impossible = new IllegalStateException("Impossible: " + e);
            impossible.initCause(e);
            throw impossible;
        }
    }

    public short getType() {
        return (short)(512 + (this.cryptoAlgorithm & 0xFF));
    }

    public void writeToDataOutputStream(DataOutputStream stream) throws IOException {
        this.write(stream);
    }

    public boolean hasPubKey() {
        return this.pubKey != null;
    }

    public DSAPublicKey getPubKey() {
        return this.pubKey;
    }

    public byte[] getPubKeyHash() {
        return this.pubKeyHash;
    }

    public void setPubKey(DSAPublicKey pubKey2) throws SSKVerifyException {
        if (this.pubKey == pubKey2) {
            return;
        }
        if (pubKey2 == null) {
            return;
        }
        if (this.pubKey == null || !pubKey2.equals(this.pubKey)) {
            if (pubKey2 != null) {
                byte[] newPubKeyHash = SHA256.digest(pubKey2.asBytes());
                if (Arrays.equals(this.pubKeyHash, newPubKeyHash)) {
                    if (this.pubKey != null) {
                        Logger.error(this, "Found SHA-256 collision or something... WTF?");
                        throw new SSKVerifyException("Invalid new pubkey: " + pubKey2 + " old pubkey: " + this.pubKey);
                    }
                } else {
                    throw new SSKVerifyException("New pubkey has invalid hash");
                }
            }
            this.pubKey = pubKey2;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeSSK)) {
            return false;
        }
        NodeSSK key = (NodeSSK)o;
        if (!Arrays.equals(key.encryptedHashedDocname, this.encryptedHashedDocname)) {
            return false;
        }
        if (!Arrays.equals(key.pubKeyHash, this.pubKeyHash)) {
            return false;
        }
        return Arrays.equals(key.routingKey, this.routingKey);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public byte[] getKeyBytes() {
        return this.encryptedHashedDocname;
    }

    public byte[] getFullKey() {
        byte[] buf = new byte[66];
        short type = this.getType();
        buf[0] = (byte)(type >> 8);
        buf[1] = (byte)(type & 0xFF);
        System.arraycopy(this.encryptedHashedDocname, 0, buf, 2, 32);
        System.arraycopy(this.pubKeyHash, 0, buf, 34, 32);
        return buf;
    }

    public static NodeSSK construct(byte[] buf) throws SSKVerifyException {
        if (buf[0] != 2) {
            throw new SSKVerifyException("Unknown type byte " + buf[0]);
        }
        byte cryptoAlgorithm = buf[1];
        if (cryptoAlgorithm != 2) {
            throw new SSKVerifyException("Unknown crypto algorithm " + buf[1]);
        }
        byte[] encryptedHashedDocname = new byte[32];
        System.arraycopy(buf, 2, encryptedHashedDocname, 0, 32);
        byte[] pubkeyHash = new byte[32];
        System.arraycopy(buf, 34, pubkeyHash, 0, 32);
        return new NodeSSK(pubkeyHash, encryptedHashedDocname, null, cryptoAlgorithm);
    }

    public boolean grabPubkey(GetPubkey pubkeyCache) {
        if (this.pubKey != null) {
            return false;
        }
        this.pubKey = pubkeyCache.getKey(this.pubKeyHash);
        return this.pubKey != null;
    }

    public static byte[] routingKeyFromFullKey(byte[] keyBuf) {
        if (keyBuf.length != 66) {
            Logger.error(NodeSSK.class, "routingKeyFromFullKey() on buffer length " + keyBuf.length);
        }
        byte[] encryptedHashedDocname = new byte[32];
        byte[] pubKeyHash = new byte[32];
        System.arraycopy(keyBuf, 2, encryptedHashedDocname, 0, 32);
        System.arraycopy(keyBuf, 34, pubKeyHash, 0, 32);
        return NodeSSK.makeRoutingKey(pubKeyHash, encryptedHashedDocname);
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof NodeCHK) {
            return -1;
        }
        NodeSSK key = (NodeSSK)arg0;
        int result = Fields.compareBytes(this.encryptedHashedDocname, key.encryptedHashedDocname);
        if (result != 0) {
            return result;
        }
        return Fields.compareBytes(this.pubKeyHash, key.pubKeyHash);
    }

    public void removeFrom(ObjectContainer container) {
        super.removeFrom(container);
    }
}

