/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import com.db4o.ObjectContainer;
import freenet.keys.Key;
import freenet.keys.NodeSSK;
import freenet.support.Base64;
import freenet.support.Fields;
import freenet.support.Logger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class NodeCHK
extends Key {
    public static final short FULL_KEY_LENGTH = 34;
    public static final int KEY_LENGTH = 32;
    final byte cryptoAlgorithm;
    public static final int BLOCK_SIZE = 32768;
    public static final byte BASE_TYPE = 1;

    public NodeCHK(byte[] routingKey2, byte cryptoAlgorithm) {
        super(routingKey2);
        if (routingKey2.length != 32) {
            throw new IllegalArgumentException("Wrong length: " + routingKey2.length + " should be " + 32);
        }
        this.cryptoAlgorithm = cryptoAlgorithm;
    }

    private NodeCHK(NodeCHK key) {
        super(key);
        this.cryptoAlgorithm = key.cryptoAlgorithm;
    }

    public Key cloneKey() {
        return new NodeCHK(this);
    }

    public final void writeToDataOutputStream(DataOutputStream stream) throws IOException {
        this.write(stream);
    }

    public String toString() {
        return super.toString() + '@' + Base64.encode(this.routingKey) + ':' + Integer.toHexString(this.hash);
    }

    public final void write(DataOutput _index) throws IOException {
        _index.writeShort(this.getType());
        _index.write(this.routingKey);
    }

    public static Key readCHK(DataInput raf, byte algo) throws IOException {
        byte[] buf = new byte[32];
        raf.readFully(buf);
        return new NodeCHK(buf, algo);
    }

    public boolean equals(Object key) {
        if (key == this) {
            return true;
        }
        if (key instanceof NodeCHK) {
            NodeCHK chk = (NodeCHK)key;
            return Arrays.equals(chk.routingKey, this.routingKey) && this.cryptoAlgorithm == chk.cryptoAlgorithm;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public short getType() {
        return (short)(256 + (this.cryptoAlgorithm & 0xFF));
    }

    public byte[] getRoutingKey() {
        return this.routingKey;
    }

    public byte[] getFullKey() {
        byte[] buf = new byte[34];
        short type = this.getType();
        buf[0] = (byte)(type >> 8);
        buf[1] = (byte)(type & 0xFF);
        System.arraycopy(this.routingKey, 0, buf, 2, this.routingKey.length);
        return buf;
    }

    public static byte[] routingKeyFromFullKey(byte[] keyBuf) {
        if (keyBuf.length == 32) {
            return keyBuf;
        }
        if (keyBuf.length != 34) {
            Logger.error(NodeCHK.class, "routingKeyFromFullKey() on " + keyBuf.length + " bytes");
            return null;
        }
        if (keyBuf[0] != 1 || keyBuf[1] != 2) {
            if (keyBuf[keyBuf.length - 1] == 0 && keyBuf[keyBuf.length - 2] == 0) {
                Logger.minor(NodeCHK.class, "Recovering routing-key stored wrong as full-key (two nulls at end)");
            } else {
                Logger.error(NodeCHK.class, "Maybe recovering routing-key stored wrong as full-key");
            }
            byte[] out = new byte[32];
            System.arraycopy(keyBuf, 0, out, 0, 32);
            return out;
        }
        byte[] out = new byte[32];
        System.arraycopy(keyBuf, 2, out, 0, 32);
        return out;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof NodeSSK) {
            return 1;
        }
        NodeCHK key = (NodeCHK)arg0;
        return Fields.compareBytes(this.routingKey, key.routingKey);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

