/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import com.db4o.ObjectContainer;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.keys.USK;
import freenet.support.Logger;
import java.net.MalformedURLException;

public class InsertableUSK
extends USK {
    public final DSAPrivateKey privKey;
    public final DSAGroup group;

    public static InsertableUSK createInsertable(FreenetURI uri, boolean persistent) throws MalformedURLException {
        if (!uri.getKeyType().equalsIgnoreCase("USK")) {
            throw new MalformedURLException();
        }
        InsertableClientSSK ssk = InsertableClientSSK.create(uri.setKeyType("SSK"));
        return new InsertableUSK(ssk.docName, ssk.pubKeyHash, ssk.cryptoKey, ssk.privKey, persistent ? ssk.getCryptoGroup().cloneKey() : ssk.getCryptoGroup(), uri.getSuggestedEdition(), ssk.cryptoAlgorithm);
    }

    InsertableUSK(String docName, byte[] pubKeyHash, byte[] cryptoKey, DSAPrivateKey key, DSAGroup group, long suggestedEdition, byte cryptoAlgorithm) throws MalformedURLException {
        super(pubKeyHash, cryptoKey, docName, suggestedEdition, cryptoAlgorithm);
        if (cryptoKey.length != 32) {
            throw new MalformedURLException("Decryption key wrong length: " + cryptoKey.length + " should be " + 32);
        }
        this.privKey = key;
        this.group = group;
    }

    public FreenetURI getURI() {
        return new FreenetURI(this.pubKeyHash, this.cryptoKey, null, this.siteName, this.suggestedEdition);
    }

    public USK getUSK() {
        return new USK(this.pubKeyHash, this.cryptoKey, this.siteName, this.suggestedEdition, this.cryptoAlgorithm);
    }

    public InsertableClientSSK getInsertableSSK(long ver) {
        try {
            return new InsertableClientSSK(this.siteName + "-" + ver, this.pubKeyHash, new DSAPublicKey(this.group, this.privKey), this.privKey, this.cryptoKey, this.cryptoAlgorithm);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Caught " + e + " should not be possible in USK.getSSK", e);
            throw new Error(e);
        }
    }

    public InsertableUSK privCopy(long edition) {
        if (edition == this.suggestedEdition) {
            return this;
        }
        try {
            return new InsertableUSK(this.siteName, this.pubKeyHash, this.cryptoKey, this.privKey, this.group, edition, this.cryptoAlgorithm);
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.privKey, 5);
        this.privKey.removeFrom(container);
        container.activate((Object)this.group, 5);
        this.group.removeFrom(container);
        super.removeFrom(container);
    }
}

