/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import com.db4o.ObjectContainer;
import freenet.client.InsertException;
import freenet.support.Base64;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.IllegalBase64Exception;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.URLDecoder;
import freenet.support.URLEncodedFormatException;
import freenet.support.URLEncoder;
import freenet.support.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreenetURI
implements Cloneable {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final String keyType;
    private final String docName;
    private final String[] metaStr;
    private final byte[] routingKey;
    private final byte[] cryptoKey;
    private final byte[] extra;
    private final long suggestedEdition;
    private boolean hasHashCode;
    private int hashCode;
    static final String[] VALID_KEY_TYPES;
    public static final FreenetURI EMPTY_CHK_URI;
    protected static final Pattern URI_PREFIX;
    protected String toStringCache;
    static final byte CHK = 1;
    static final byte SSK = 2;
    static final byte KSK = 3;
    static final byte USK = 4;

    public synchronized int hashCode() {
        if (this.hasHashCode) {
            return this.hashCode;
        }
        int x = this.keyType.hashCode();
        if (this.docName != null) {
            x ^= this.docName.hashCode();
        }
        if (this.metaStr != null) {
            for (int i = 0; i < this.metaStr.length; ++i) {
                x ^= this.metaStr[i].hashCode();
            }
        }
        if (this.routingKey != null) {
            x ^= Fields.hashCode(this.routingKey);
        }
        if (this.cryptoKey != null) {
            x ^= Fields.hashCode(this.cryptoKey);
        }
        if (this.extra != null) {
            x ^= Fields.hashCode(this.extra);
        }
        if (this.keyType.equals("USK")) {
            x = (int)((long)x ^ this.suggestedEdition);
        }
        this.hashCode = x;
        this.hasHashCode = true;
        return x;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FreenetURI)) {
            return false;
        }
        FreenetURI f = (FreenetURI)o;
        if (!this.keyType.equals(f.keyType)) {
            return false;
        }
        if (this.keyType.equals("USK") && this.suggestedEdition != f.suggestedEdition) {
            return false;
        }
        if (this.docName == null ^ f.docName == null) {
            return false;
        }
        if (this.metaStr == null ^ f.metaStr == null) {
            return false;
        }
        if (this.routingKey == null ^ f.routingKey == null) {
            return false;
        }
        if (this.cryptoKey == null ^ f.cryptoKey == null) {
            return false;
        }
        if (this.extra == null ^ f.extra == null) {
            return false;
        }
        if (this.docName != null && !this.docName.equals(f.docName)) {
            return false;
        }
        if (this.metaStr != null && !Arrays.equals(this.metaStr, f.metaStr)) {
            return false;
        }
        if (this.routingKey != null && !Arrays.equals(this.routingKey, f.routingKey)) {
            return false;
        }
        if (this.cryptoKey != null && !Arrays.equals(this.cryptoKey, f.cryptoKey)) {
            return false;
        }
        return this.extra == null || Arrays.equals(this.extra, f.extra);
    }

    public boolean equalsKeypair(FreenetURI u2) {
        if (this.routingKey != null && this.cryptoKey != null) {
            return Arrays.equals(this.routingKey, u2.routingKey) && Arrays.equals(this.cryptoKey, u2.cryptoKey);
        }
        return false;
    }

    public final FreenetURI clone() {
        return new FreenetURI(this);
    }

    public FreenetURI(FreenetURI uri) {
        this.keyType = uri.keyType;
        this.docName = uri.docName;
        if (uri.metaStr != null) {
            this.metaStr = new String[uri.metaStr.length];
            System.arraycopy(uri.metaStr, 0, this.metaStr, 0, this.metaStr.length);
        } else {
            this.metaStr = null;
        }
        if (uri.routingKey != null) {
            this.routingKey = new byte[uri.routingKey.length];
            System.arraycopy(uri.routingKey, 0, this.routingKey, 0, this.routingKey.length);
        } else {
            this.routingKey = null;
        }
        if (uri.cryptoKey != null) {
            this.cryptoKey = new byte[uri.cryptoKey.length];
            System.arraycopy(uri.cryptoKey, 0, this.cryptoKey, 0, this.cryptoKey.length);
        } else {
            this.cryptoKey = null;
        }
        if (uri.extra != null) {
            this.extra = new byte[uri.extra.length];
            System.arraycopy(uri.extra, 0, this.extra, 0, this.extra.length);
        } else {
            this.extra = null;
        }
        this.suggestedEdition = uri.suggestedEdition;
        if (logMINOR) {
            Logger.minor(this, "Copied: " + this.toString() + " from " + uri.toString(), (Throwable)new Exception("debug"));
        }
    }

    public FreenetURI(String keyType, String docName) {
        this(keyType, docName, null, null, null, null);
    }

    public FreenetURI(String keyType, String docName, byte[] routingKey, byte[] cryptoKey, byte[] extra2) {
        this(keyType, docName, null, routingKey, cryptoKey, extra2);
    }

    public FreenetURI(String keyType, String docName, String metaStr, byte[] routingKey, byte[] cryptoKey) {
        String[] stringArray;
        if (metaStr == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = metaStr;
        }
        this(keyType, docName, stringArray, routingKey, cryptoKey, null);
    }

    public FreenetURI(String keyType, String docName, String[] metaStr, byte[] routingKey, byte[] cryptoKey, byte[] extra2) {
        this.keyType = keyType.trim().toUpperCase().intern();
        this.docName = docName;
        this.metaStr = metaStr;
        this.routingKey = routingKey;
        this.cryptoKey = cryptoKey;
        this.extra = extra2;
        this.suggestedEdition = -1L;
        if (logDEBUG) {
            Logger.minor(this, "Created from components: " + this.toString(), (Throwable)new Exception("debug"));
        }
    }

    public FreenetURI(String keyType, String docName, String[] metaStr, byte[] routingKey, byte[] cryptoKey, byte[] extra2, long suggestedEdition) {
        this.keyType = keyType.trim().toUpperCase().intern();
        this.docName = docName;
        this.metaStr = metaStr;
        this.routingKey = routingKey;
        this.cryptoKey = cryptoKey;
        this.extra = extra2;
        this.suggestedEdition = suggestedEdition;
        if (logDEBUG) {
            Logger.minor(this, "Created from components (B): " + this.toString(), (Throwable)new Exception("debug"));
        }
    }

    public FreenetURI(String URI2) throws MalformedURLException {
        int slash2;
        int atchar;
        if (URI2 == null) {
            throw new MalformedURLException("No URI specified");
        }
        if ((URI2 = URI2.trim()).indexOf(64) < 0 || URI2.indexOf(47) < 0) {
            try {
                URI2 = URLDecoder.decode(URI2, false);
            }
            catch (URLEncodedFormatException e) {
                throw new MalformedURLException("Invalid URI: no @ or /, or @ or / is escaped but there are invalid escapes");
            }
        }
        if ((atchar = (URI2 = URI_PREFIX.matcher(URI2).replaceFirst("")).indexOf(64)) == -1) {
            throw new MalformedURLException("There is no @ in that URI! (" + URI2 + ')');
        }
        String _keyType = URI2.substring(0, atchar).toUpperCase();
        URI2 = URI2.substring(atchar + 1);
        boolean validKeyType = false;
        for (int i = 0; i < VALID_KEY_TYPES.length; ++i) {
            if (!_keyType.equals(VALID_KEY_TYPES[i])) continue;
            validKeyType = true;
            _keyType = VALID_KEY_TYPES[i];
            break;
        }
        this.keyType = _keyType;
        if (!validKeyType) {
            throw new MalformedURLException("Invalid key type: " + this.keyType);
        }
        boolean isSSK = "SSK".equals(this.keyType);
        boolean isUSK = "USK".equals(this.keyType);
        boolean isKSK = "KSK".equals(this.keyType);
        ArrayList<String> sv = null;
        sv = new ArrayList<String>();
        if (isKSK) {
            URI2 = "/" + URI2;
        }
        while ((slash2 = URI2.lastIndexOf(47)) != -1) {
            String s;
            try {
                s = URLDecoder.decode(URI2.substring(slash2 + 1), true);
            }
            catch (URLEncodedFormatException e) {
                MalformedURLException ue = new MalformedURLException(e.toString());
                ue.initCause(e);
                throw ue;
            }
            if (s != null) {
                sv.add(s);
            }
            URI2 = URI2.substring(0, slash2);
        }
        if (isSSK || isUSK || isKSK) {
            if (sv.isEmpty()) {
                throw new MalformedURLException("No docname for " + this.keyType);
            }
            this.docName = (String)sv.remove(sv.size() - 1);
            if (isUSK) {
                if (sv.isEmpty()) {
                    throw new MalformedURLException("No suggested edition number for USK");
                }
                try {
                    this.suggestedEdition = Long.parseLong((String)sv.remove(sv.size() - 1));
                }
                catch (NumberFormatException e) {
                    MalformedURLException e1 = new MalformedURLException("Invalid suggested edition: " + e);
                    e1.initCause(e);
                    throw e1;
                }
            } else {
                this.suggestedEdition = -1L;
            }
        } else {
            this.docName = null;
            this.suggestedEdition = -1L;
        }
        if (!sv.isEmpty()) {
            this.metaStr = new String[sv.size()];
            for (int i = 0; i < this.metaStr.length; ++i) {
                this.metaStr[i] = ((String)sv.get(this.metaStr.length - 1 - i)).intern();
                if (this.metaStr[i] != null) continue;
                throw new NullPointerException();
            }
        } else {
            this.metaStr = null;
        }
        if (isKSK) {
            this.cryptoKey = null;
            this.extra = null;
            this.routingKey = null;
            return;
        }
        if ("CHK".equals(this.keyType)) {
            URI2 = URI2.split("[.]")[0];
        }
        StringTokenizer st = new StringTokenizer(URI2, ",");
        try {
            if (!st.hasMoreTokens()) {
                this.extra = null;
                this.cryptoKey = null;
                this.routingKey = null;
                return;
            }
            this.routingKey = Base64.decode(st.nextToken());
            if (!st.hasMoreTokens()) {
                this.extra = null;
                this.cryptoKey = null;
                return;
            }
            String t = st.nextToken();
            this.cryptoKey = Base64.decode(t);
            if (!st.hasMoreTokens()) {
                this.extra = null;
                return;
            }
            this.extra = Base64.decode(st.nextToken());
        }
        catch (IllegalBase64Exception e) {
            throw new MalformedURLException("Invalid Base64 quantity: " + e);
        }
        if (logDEBUG) {
            Logger.minor(this, "Created from parse: " + this.toString() + " from " + URI2, (Throwable)new Exception("debug"));
        }
    }

    public FreenetURI(byte[] pubKeyHash, byte[] cryptoKey, byte[] extra, String siteName, long suggestedEdition2) {
        this.keyType = "USK";
        this.routingKey = pubKeyHash;
        this.cryptoKey = cryptoKey;
        this.extra = extra;
        this.docName = siteName;
        this.suggestedEdition = suggestedEdition2;
        this.metaStr = null;
        if (logDEBUG) {
            Logger.minor(this, "Created from components (USK): " + this.toString(), (Throwable)new Exception("debug"));
        }
    }

    public void decompose() {
        String r = this.routingKey == null ? "none" : HexUtil.bytesToHex(this.routingKey);
        String k = this.cryptoKey == null ? "none" : HexUtil.bytesToHex(this.cryptoKey);
        String e = this.extra == null ? "none" : HexUtil.bytesToHex(this.extra);
        System.out.println("FreenetURI" + this);
        System.out.println("Key type   : " + this.keyType);
        System.out.println("Routing key: " + r);
        System.out.println("Crypto key : " + k);
        System.out.println("Extra      : " + e);
        System.out.println("Doc name   : " + (this.docName == null ? "none" : this.docName));
        System.out.print("Meta strings: ");
        if (this.metaStr == null) {
            System.err.println("none");
        } else {
            for (int i = 0; i < this.metaStr.length; ++i) {
                System.err.print(this.metaStr[i]);
                if (i == this.metaStr.length - 1) {
                    System.err.println();
                    continue;
                }
                System.err.print(", ");
            }
        }
    }

    public String getGuessableKey() {
        return this.getDocName();
    }

    public String getDocName() {
        return this.docName;
    }

    public String getMetaString() {
        return this.metaStr == null || this.metaStr.length == 0 ? null : this.metaStr[0];
    }

    public String lastMetaString() {
        return this.metaStr == null || this.metaStr.length == 0 ? null : this.metaStr[this.metaStr.length - 1];
    }

    public String[] getAllMetaStrings() {
        return this.metaStr;
    }

    public boolean hasMetaStrings() {
        return this.metaStr != null && this.metaStr.length != 0;
    }

    public byte[] getRoutingKey() {
        return this.routingKey;
    }

    public byte[] getCryptoKey() {
        return this.cryptoKey;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public FreenetURI popMetaString() {
        int metaStrLength;
        String[] newMetaStr = null;
        if (this.metaStr != null && (metaStrLength = this.metaStr.length) > 1) {
            newMetaStr = new String[metaStrLength - 1];
            System.arraycopy(this.metaStr, 1, newMetaStr, 0, newMetaStr.length);
        }
        return this.setMetaString(newMetaStr);
    }

    public FreenetURI dropLastMetaStrings(int i) {
        String[] newMetaStr = null;
        if (this.metaStr != null && this.metaStr.length > 1) {
            if (i > this.metaStr.length) {
                i = this.metaStr.length;
            }
            newMetaStr = new String[this.metaStr.length - i];
            System.arraycopy(this.metaStr, 0, newMetaStr, 0, newMetaStr.length);
        }
        return this.setMetaString(newMetaStr);
    }

    public FreenetURI pushMetaString(String name) {
        String[] newMetaStr;
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.metaStr == null) {
            newMetaStr = new String[]{name};
        } else {
            newMetaStr = new String[this.metaStr.length + 1];
            System.arraycopy(this.metaStr, 0, newMetaStr, 0, this.metaStr.length);
            newMetaStr[this.metaStr.length] = name.intern();
        }
        return this.setMetaString(newMetaStr);
    }

    public FreenetURI addMetaStrings(String[] strs) {
        if (strs == null) {
            return this;
        }
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] != null) continue;
            throw new NullPointerException("element " + i + " of " + strs.length + " is null");
        }
        if (this.metaStr == null) {
            return this.setMetaString(strs);
        }
        String[] newMetaStr = new String[this.metaStr.length + strs.length];
        if (this.metaStr != null) {
            System.arraycopy(this.metaStr, 0, newMetaStr, 0, this.metaStr.length);
        }
        System.arraycopy(strs, 0, newMetaStr, this.metaStr.length, strs.length);
        return this.setMetaString(strs);
    }

    public FreenetURI addMetaStrings(List<String> metaStrings) {
        return this.addMetaStrings(metaStrings.toArray(new String[metaStrings.size()]));
    }

    public FreenetURI setDocName(String name) {
        return new FreenetURI(this.keyType, name, this.metaStr, this.routingKey, this.cryptoKey, this.extra, this.suggestedEdition);
    }

    public FreenetURI setMetaString(String[] newMetaStr) {
        return new FreenetURI(this.keyType, this.docName, newMetaStr, this.routingKey, this.cryptoKey, this.extra, this.suggestedEdition);
    }

    public String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = this.toString(false, false);
        }
        return this.toStringCache;
    }

    @Deprecated
    public String toACIIString() {
        return this.toASCIIString();
    }

    public String toASCIIString() {
        return this.toString(true, true);
    }

    public String toString(boolean prefix, boolean pureAscii) {
        if (this.keyType == null) {
            if (logMINOR) {
                Logger.minor(this, "Not activated?? in toString(" + prefix + "," + pureAscii + ")");
            }
            return null;
        }
        StringBuilder b = prefix ? new StringBuilder("freenet:") : new StringBuilder();
        b.append(this.keyType).append('@');
        if (!"KSK".equals(this.keyType)) {
            if (this.routingKey != null) {
                b.append(Base64.encode(this.routingKey));
            }
            if (this.cryptoKey != null) {
                b.append(',').append(Base64.encode(this.cryptoKey));
            }
            if (this.extra != null) {
                b.append(',').append(Base64.encode(this.extra));
            }
            if (this.docName != null) {
                b.append('/');
            }
        }
        if (this.docName != null) {
            b.append(URLEncoder.encode(this.docName, "/", pureAscii));
        }
        if (this.keyType.equals("USK")) {
            b.append('/');
            b.append(this.suggestedEdition);
        }
        if (this.metaStr != null) {
            for (int i = 0; i < this.metaStr.length; ++i) {
                b.append('/').append(URLEncoder.encode(this.metaStr[i], "/", pureAscii));
            }
        }
        return b.toString();
    }

    public String toShortString() {
        StringBuilder b = new StringBuilder();
        b.append(this.keyType).append('@');
        if (!"KSK".equals(this.keyType)) {
            b.append("...");
            if (this.docName != null) {
                b.append('/');
            }
        }
        if (this.docName != null) {
            b.append(URLEncoder.encode(this.docName, "/", false));
        }
        if (this.keyType.equals("USK")) {
            b.append('/');
            b.append(this.suggestedEdition);
        }
        if (this.metaStr != null) {
            for (int i = 0; i < this.metaStr.length; ++i) {
                b.append('/').append(URLEncoder.encode(this.metaStr[i], "/", false));
            }
        }
        return b.toString();
    }

    public static void main(String[] args) throws Exception {
        new FreenetURI(args[0]).decompose();
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public ArrayList<String> listMetaStrings() {
        if (this.metaStr != null) {
            ArrayList<String> l = new ArrayList<String>(this.metaStr.length);
            for (int i = 0; i < this.metaStr.length; ++i) {
                l.add(this.metaStr[i]);
            }
            return l;
        }
        return new ArrayList<String>(0);
    }

    public static FreenetURI readFullBinaryKeyWithLength(DataInputStream dis) throws IOException {
        short len = dis.readShort();
        byte[] buf = new byte[len];
        dis.readFully(buf);
        if (logMINOR) {
            Logger.minor(FreenetURI.class, "Read " + len + " bytes for key");
        }
        return FreenetURI.fromFullBinaryKey(buf);
    }

    public static FreenetURI fromFullBinaryKey(byte[] buf) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bais);
        return FreenetURI.readFullBinaryKey(dis);
    }

    public static FreenetURI readFullBinaryKey(DataInputStream dis) throws IOException {
        String keyType;
        byte type = dis.readByte();
        if (type == 1) {
            keyType = "CHK";
        } else if (type == 2) {
            keyType = "SSK";
        } else if (type == 3) {
            keyType = "KSK";
        } else {
            throw new MalformedURLException("Unrecognized type " + type);
        }
        byte[] routingKey = null;
        byte[] cryptoKey = null;
        byte[] extra = null;
        if (type == 1 || type == 2) {
            routingKey = new byte[32];
            dis.readFully(routingKey);
            cryptoKey = new byte[32];
            dis.readFully(cryptoKey);
            int extraLen = type == 1 ? 5 : 5;
            extra = new byte[extraLen];
            dis.readFully(extra);
        }
        String docName = null;
        if (type != 1) {
            docName = dis.readUTF();
        }
        int count = dis.readInt();
        String[] metaStrings = new String[count];
        for (int i = 0; i < metaStrings.length; ++i) {
            metaStrings[i] = dis.readUTF();
        }
        return new FreenetURI(keyType, docName, metaStrings, routingKey, cryptoKey, extra);
    }

    public void writeFullBinaryKeyWithLength(DataOutputStream dos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream ndos = new DataOutputStream(baos);
        this.writeFullBinaryKey(ndos);
        ndos.close();
        byte[] data = baos.toByteArray();
        if (data.length > Short.MAX_VALUE) {
            throw new MalformedURLException("Full key too long: " + data.length + " - " + this);
        }
        dos.writeShort((short)data.length);
        if (logMINOR) {
            Logger.minor(this, "Written " + data.length + " bytes");
        }
        dos.write(data);
    }

    private void writeFullBinaryKey(DataOutputStream dos) throws IOException {
        if (this.keyType.equals("CHK")) {
            dos.writeByte(1);
        } else if (this.keyType.equals("SSK")) {
            dos.writeByte(2);
        } else if (this.keyType.equals("KSK")) {
            dos.writeByte(3);
        } else {
            if (this.keyType.equals("USK")) {
                throw new MalformedURLException("Cannot write USKs as binary keys");
            }
            throw new MalformedURLException("Cannot write key of type " + this.keyType + " - do not know how");
        }
        if (!this.keyType.equals("KSK")) {
            if (this.routingKey.length != 32) {
                throw new MalformedURLException("Routing key must be of length 32");
            }
            dos.write(this.routingKey);
            if (this.cryptoKey.length != 32) {
                throw new MalformedURLException("Crypto key must be of length 32");
            }
            dos.write(this.cryptoKey);
            if (this.keyType.equals("CHK") && this.extra.length != 5) {
                throw new MalformedURLException("Wrong number of extra bytes for CHK");
            }
            if (this.keyType.equals("SSK") && this.extra.length != 5) {
                throw new MalformedURLException("Wrong number of extra bytes for SSK");
            }
            dos.write(this.extra);
        }
        if (!this.keyType.equals("CHK")) {
            dos.writeUTF(this.docName);
        }
        if (this.metaStr != null) {
            dos.writeInt(this.metaStr.length);
            for (int i = 0; i < this.metaStr.length; ++i) {
                dos.writeUTF(this.metaStr[i]);
            }
        } else {
            dos.writeInt(0);
        }
    }

    public long getSuggestedEdition() {
        if (this.keyType.equals("USK")) {
            return this.suggestedEdition;
        }
        throw new IllegalArgumentException("Not a USK requesting suggested edition");
    }

    public String getPreferredFilename() {
        if (logMINOR) {
            Logger.minor(this, "Getting preferred filename for " + this);
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.keyType != null && (this.keyType.equals("KSK") || this.keyType.equals("SSK") || this.keyType.equals("USK"))) {
            if (logMINOR) {
                Logger.minor(this, "Adding docName: " + this.docName);
            }
            names.add(this.docName);
            if (this.keyType.equals("USK")) {
                names.add(Long.toString(this.suggestedEdition));
            }
        }
        if (this.metaStr != null) {
            for (int i = 0; i < this.metaStr.length; ++i) {
                if (logMINOR) {
                    Logger.minor(this, "Adding metaString " + i + ": " + this.metaStr[i]);
                }
                names.add(this.metaStr[i]);
            }
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            String s = (String)names.get(i);
            if (logMINOR) {
                Logger.minor(this, "name " + i + " = " + s);
            }
            s = FileUtil.sanitize(s);
            if (logMINOR) {
                Logger.minor(this, "Sanitized name " + i + " = " + s);
            }
            if (s.length() <= 0) continue;
            if (out.length() > 0) {
                out.append('-');
            }
            out.append(s);
        }
        if (logMINOR) {
            Logger.minor(this, "out = " + out.toString());
        }
        if (out.length() == 0) {
            if (this.routingKey != null) {
                if (logMINOR) {
                    Logger.minor(this, "Returning base64 encoded routing key");
                }
                return Base64.encode(this.routingKey);
            }
            return "unknown";
        }
        return out.toString();
    }

    public FreenetURI setSuggestedEdition(long newEdition) {
        return new FreenetURI(this.keyType, this.docName, this.metaStr, this.routingKey, this.cryptoKey, this.extra, newEdition);
    }

    public FreenetURI setKeyType(String newKeyType) {
        return new FreenetURI(newKeyType, this.docName, this.metaStr, this.routingKey, this.cryptoKey, this.extra, this.suggestedEdition);
    }

    public FreenetURI setRoutingKey(byte[] newRoutingKey) {
        return new FreenetURI(this.keyType, this.docName, this.metaStr, newRoutingKey, this.cryptoKey, this.extra, this.suggestedEdition);
    }

    public void checkInsertURI() throws InsertException {
        if (this.metaStr != null && this.metaStr.length > 0) {
            throw new InsertException(11, this);
        }
    }

    public static void checkInsertURI(FreenetURI uri) throws InsertException {
        uri.checkInsertURI();
    }

    public URI toRelativeURI() throws URISyntaxException {
        return new URI('/' + this.toString(false, false));
    }

    public URI toURI(String basePath) throws URISyntaxException {
        return new URI(basePath + this.toString(false, false));
    }

    public boolean isSSK() {
        return "SSK".equals(this.keyType);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this == EMPTY_CHK_URI) {
            throw new RuntimeException("Storing static CHK@ to database - can't remove it!");
        }
        return true;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (!container.ext().isActive((Object)this)) {
            Logger.error(this, "Updating but not active!", new Exception("error"));
            return false;
        }
        return true;
    }

    public void objectOnDelete(ObjectContainer container) {
        if (Logger.shouldLog(2, this)) {
            Logger.debug(this, "Deleting URI", new Exception("debug"));
        }
    }

    public boolean isUSK() {
        return "USK".equals(this.keyType);
    }

    public boolean isCHK() {
        return "CHK".equals(this.keyType);
    }

    public FreenetURI sskForUSK() {
        if (!this.keyType.equalsIgnoreCase("USK")) {
            throw new IllegalStateException();
        }
        return new FreenetURI("SSK", this.docName + "-" + this.suggestedEdition, this.metaStr, this.routingKey, this.cryptoKey, this.extra, 0L);
    }

    public boolean isSSKForUSK() {
        return this.keyType.equalsIgnoreCase("SSK") && this.docName.matches(".*\\-[0-9]+");
    }

    public FreenetURI uskForSSK() {
        if (!this.keyType.equalsIgnoreCase("SSK")) {
            throw new IllegalStateException();
        }
        if (!this.docName.matches(".*\\-[0-9]+")) {
            throw new IllegalStateException();
        }
        int offset = this.docName.lastIndexOf(45);
        String siteName = this.docName.substring(0, offset);
        long edition = Long.valueOf(this.docName.substring(offset + 1, this.docName.length()));
        return new FreenetURI("USK", siteName, this.metaStr, this.routingKey, this.cryptoKey, this.extra, edition);
    }

    public long getEdition() {
        if (this.keyType.equalsIgnoreCase("USK")) {
            return this.suggestedEdition;
        }
        if (this.keyType.equalsIgnoreCase("SSK")) {
            if (!this.docName.matches(".*\\-[0-9]+")) {
                throw new IllegalStateException();
            }
            return Long.valueOf(this.docName.substring(this.docName.lastIndexOf(45) + 1, this.docName.length()));
        }
        throw new IllegalStateException();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
        VALID_KEY_TYPES = new String[]{"CHK", "SSK", "KSK", "USK"};
        EMPTY_CHK_URI = new FreenetURI("CHK", null, null, null, null, null);
        URI_PREFIX = Pattern.compile("^(http://[^/]+/+)?(freenet:)?");
    }
}

