/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.crypt.PCFBMode;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.Key;
import freenet.keys.KeyDecodeException;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKDecodeException;
import freenet.keys.SSKVerifyException;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.ArrayBucket;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.BucketTools;
import java.io.IOException;

public class ClientSSKBlock
extends SSKBlock
implements ClientKeyBlock {
    static final int DATA_DECRYPT_KEY_LENGTH = 32;
    public static final int MAX_DECOMPRESSED_DATA_LENGTH = 32768;
    private boolean isMetadata;
    private boolean decoded;
    private final ClientSSK key;
    private short compressionAlgorithm = (short)-1;

    public ClientSSKBlock(byte[] data, byte[] headers, ClientSSK key, boolean dontVerify) throws SSKVerifyException {
        super(data, headers, (NodeSSK)key.getNodeKey(), dontVerify);
        this.key = key;
    }

    public static ClientSSKBlock construct(SSKBlock block, ClientSSK key) throws SSKVerifyException {
        if (key.getPubKey() == null) {
            key.setPublicKey(block.getPubKey());
        }
        return new ClientSSKBlock(block.data, block.headers, key, false);
    }

    public Bucket decode(BucketFactory factory, int maxLength, boolean dontDecompress) throws KeyDecodeException, IOException {
        Rijndael aes;
        byte[] decryptedHeaders = new byte[36];
        System.arraycopy(this.headers, this.headersOffset, decryptedHeaders, 0, 36);
        try {
            Logger.minor(this, "cryptoAlgorithm=" + this.key.cryptoAlgorithm + " for " + this.getClientKey().getURI());
            aes = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        aes.initialize(this.key.cryptoKey);
        PCFBMode pcfb = PCFBMode.create(aes);
        pcfb.reset(this.key.ehDocname);
        pcfb.blockDecipher(decryptedHeaders, 0, decryptedHeaders.length);
        byte[] dataDecryptKey = new byte[32];
        System.arraycopy(decryptedHeaders, 0, dataDecryptKey, 0, 32);
        aes.initialize(dataDecryptKey);
        byte[] dataOutput = new byte[this.data.length];
        System.arraycopy(this.data, 0, dataOutput, 0, this.data.length);
        pcfb.reset(dataDecryptKey);
        pcfb.blockDecipher(dataOutput, 0, dataOutput.length);
        int dataLength = ((decryptedHeaders[32] & 0xFF) << 8) + (decryptedHeaders[33] & 0xFF);
        if ((dataLength & 0x8000) != 0) {
            dataLength &= 0xFFFF7FFF;
            this.isMetadata = true;
        }
        if (dataLength > this.data.length) {
            throw new SSKDecodeException("Data length: " + dataLength + " but data.length=" + this.data.length);
        }
        this.compressionAlgorithm = (short)(((decryptedHeaders[34] & 0xFF) << 8) + (decryptedHeaders[35] & 0xFF));
        this.decoded = true;
        if (dontDecompress) {
            return BucketTools.makeImmutableBucket(factory, dataOutput, dataLength);
        }
        Bucket b = Key.decompress(this.compressionAlgorithm >= 0, dataOutput, dataLength, factory, Math.min(32768, maxLength), this.compressionAlgorithm, true);
        return b;
    }

    public boolean isMetadata() {
        if (!this.decoded) {
            throw new IllegalStateException("Cannot read isMetadata before decoded");
        }
        return this.isMetadata;
    }

    public ClientSSK getClientKey() {
        return this.key;
    }

    public short getCompressionCodec() {
        return this.compressionAlgorithm;
    }

    public byte[] memoryDecode() throws KeyDecodeException {
        return this.memoryDecode(false);
    }

    public byte[] memoryDecode(boolean dontDecompress) throws KeyDecodeException {
        try {
            ArrayBucket a = (ArrayBucket)this.decode(new ArrayBucketFactory(), 32768, dontDecompress);
            return BucketTools.toByteArray(a);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public int hashCode() {
        return super.hashCode() ^ this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClientSSKBlock)) {
            return false;
        }
        ClientSSKBlock block = (ClientSSKBlock)o;
        if (!this.key.equals(block.key)) {
            return false;
        }
        return super.equals(o);
    }
}

