/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import com.db4o.ObjectContainer;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.keys.ClientKey;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.NodeSSK;
import freenet.keys.SSKVerifyException;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.Logger;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.Arrays;

public class ClientSSK
extends ClientKey {
    public final byte cryptoAlgorithm;
    public final String docName;
    protected transient DSAPublicKey pubKey;
    public final byte[] pubKeyHash;
    public final byte[] cryptoKey;
    public final byte[] ehDocname;
    private final int hashCode;
    static final int CRYPTO_KEY_LENGTH = 32;
    public static final int EXTRA_LENGTH = 5;

    private ClientSSK(ClientSSK key) {
        this.cryptoAlgorithm = key.cryptoAlgorithm;
        this.docName = new String(key.docName);
        this.pubKey = key.pubKey != null ? key.pubKey.cloneKey() : null;
        this.pubKeyHash = new byte[key.pubKeyHash.length];
        System.arraycopy(key.pubKeyHash, 0, this.pubKeyHash, 0, this.pubKeyHash.length);
        this.cryptoKey = new byte[key.cryptoKey.length];
        System.arraycopy(key.cryptoKey, 0, this.cryptoKey, 0, key.cryptoKey.length);
        this.ehDocname = new byte[key.ehDocname.length];
        System.arraycopy(key.ehDocname, 0, this.ehDocname, 0, key.ehDocname.length);
        this.hashCode = Fields.hashCode(this.pubKeyHash) ^ Fields.hashCode(this.cryptoKey) ^ Fields.hashCode(this.ehDocname) ^ this.docName.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSSK(String docName, byte[] pubKeyHash, byte[] extras, DSAPublicKey pubKey, byte[] cryptoKey) throws MalformedURLException {
        this.docName = docName;
        this.pubKey = pubKey;
        this.pubKeyHash = pubKeyHash;
        if (extras == null) {
            throw new MalformedURLException("No extra bytes in SSK - maybe a 0.5 key?");
        }
        if (extras.length < 5) {
            throw new MalformedURLException("Extra bytes too short: " + extras.length + " bytes");
        }
        this.cryptoAlgorithm = extras[2];
        if (this.cryptoAlgorithm != 2) {
            throw new MalformedURLException("Unknown encryption algorithm " + this.cryptoAlgorithm);
        }
        if (!Arrays.equals(extras, this.getExtraBytes())) {
            throw new MalformedURLException("Wrong extra bytes");
        }
        if (pubKeyHash.length != 32) {
            throw new MalformedURLException("Pubkey hash wrong length: " + pubKeyHash.length + " should be " + 32);
        }
        if (cryptoKey.length != 32) {
            throw new MalformedURLException("Decryption key wrong length: " + cryptoKey.length + " should be " + 32);
        }
        MessageDigest md = SHA256.getMessageDigest();
        try {
            if (pubKey != null) {
                byte[] pubKeyAsBytes = pubKey.asBytes();
                md.update(pubKeyAsBytes);
                byte[] otherPubKeyHash = md.digest();
                if (!Arrays.equals(otherPubKeyHash, pubKeyHash)) {
                    throw new IllegalArgumentException();
                }
            }
            this.cryptoKey = cryptoKey;
            try {
                md.update(docName.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            byte[] buf = md.digest();
            try {
                Rijndael aes = new Rijndael(256, 256);
                aes.initialize(cryptoKey);
                aes.encipher(buf, buf);
                this.ehDocname = buf;
            }
            catch (UnsupportedCipherException e) {
                throw new Error(e);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            SHA256.returnMessageDigest(md);
            throw throwable;
        }
        SHA256.returnMessageDigest(md);
        if (this.ehDocname == null) {
            throw new NullPointerException();
        }
        this.hashCode = Fields.hashCode(pubKeyHash) ^ Fields.hashCode(cryptoKey) ^ Fields.hashCode(this.ehDocname) ^ docName.hashCode();
    }

    public ClientSSK(FreenetURI origURI) throws MalformedURLException {
        this(origURI.getDocName(), origURI.getRoutingKey(), origURI.getExtra(), null, origURI.getCryptoKey());
        if (!origURI.getKeyType().equalsIgnoreCase("SSK")) {
            throw new MalformedURLException();
        }
    }

    public void setPublicKey(DSAPublicKey pubKey) {
        if (this.pubKey != null && this.pubKey != pubKey && !this.pubKey.equals(pubKey)) {
            throw new IllegalArgumentException("Cannot reassign: was " + this.pubKey + " now " + pubKey);
        }
        byte[] newKeyHash = pubKey.asBytesHash();
        if (!Arrays.equals(newKeyHash, this.pubKeyHash)) {
            throw new IllegalArgumentException("New pubKey hash does not match pubKeyHash: " + HexUtil.bytesToHex(newKeyHash) + " ( " + HexUtil.bytesToHex(pubKey.asBytesHash()) + " != " + HexUtil.bytesToHex(this.pubKeyHash) + " for " + pubKey);
        }
        this.pubKey = pubKey;
    }

    public FreenetURI getURI() {
        return new FreenetURI("SSK", this.docName, this.pubKeyHash, this.cryptoKey, this.getExtraBytes());
    }

    protected final byte[] getExtraBytes() {
        return ClientSSK.getExtraBytes(this.cryptoAlgorithm);
    }

    protected static byte[] getExtraBytes(byte cryptoAlgorithm) {
        byte[] extra = new byte[]{1, 0, cryptoAlgorithm, 0, 1};
        return extra;
    }

    public Key getNodeKey() {
        try {
            if (this.ehDocname == null) {
                throw new NullPointerException();
            }
            if (this.pubKeyHash == null) {
                throw new NullPointerException();
            }
            return new NodeSSK(this.pubKeyHash, this.ehDocname, this.pubKey, this.cryptoAlgorithm);
        }
        catch (SSKVerifyException e) {
            IllegalStateException x = new IllegalStateException("Have already verified and yet it fails!: " + e);
            Logger.error(this, "Have already verified and yet it fails!: " + e);
            x.initCause(e);
            throw x;
        }
    }

    public DSAPublicKey getPubKey() {
        return this.pubKey;
    }

    public String toString() {
        return "ClientSSK:" + this.getURI().toString();
    }

    public ClientKey cloneKey() {
        return new ClientSSK(this);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClientSSK)) {
            return false;
        }
        ClientSSK key = (ClientSSK)o;
        if (this.cryptoAlgorithm != key.cryptoAlgorithm) {
            return false;
        }
        if (!this.docName.equals(key.docName)) {
            return false;
        }
        if (!Arrays.equals(this.pubKeyHash, key.pubKeyHash)) {
            return false;
        }
        if (!Arrays.equals(this.cryptoKey, key.cryptoKey)) {
            return false;
        }
        return Arrays.equals(this.ehDocname, key.ehDocname);
    }
}

