/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.Global;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.Random;
import org.spaceroots.mantissa.random.MersenneTwister;

public class ClientKSK
extends InsertableClientSSK {
    final String keyword;

    private ClientKSK(String keyword, byte[] pubKeyHash, DSAPublicKey pubKey, DSAPrivateKey privKey, byte[] keywordHash) throws MalformedURLException {
        super(keyword, pubKeyHash, pubKey, privKey, keywordHash, (byte)2);
        this.keyword = keyword;
    }

    public FreenetURI getURI() {
        return new FreenetURI("KSK", this.keyword);
    }

    public static InsertableClientSSK create(FreenetURI uri) {
        if (!uri.getKeyType().equals("KSK")) {
            throw new IllegalArgumentException();
        }
        return ClientKSK.create(uri.getDocName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientKSK create(String keyword) {
        ClientKSK clientKSK;
        MessageDigest md256 = SHA256.getMessageDigest();
        try {
            byte[] keywordHash;
            try {
                keywordHash = md256.digest(keyword.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            MersenneTwister mt = new MersenneTwister(keywordHash);
            DSAPrivateKey privKey = new DSAPrivateKey(Global.DSAgroupBigA, (Random)mt);
            DSAPublicKey pubKey = new DSAPublicKey(Global.DSAgroupBigA, privKey);
            byte[] pubKeyHash = md256.digest(pubKey.asBytes());
            try {
                clientKSK = new ClientKSK(keyword, pubKeyHash, pubKey, privKey, keywordHash);
            }
            catch (MalformedURLException e) {
                throw new Error(e);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SHA256.returnMessageDigest(md256);
            throw throwable;
        }
        SHA256.returnMessageDigest(md256);
        return clientKSK;
    }
}

