/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import com.db4o.ObjectContainer;
import freenet.crypt.PCFBMode;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.keys.CHKBlock;
import freenet.keys.CHKDecodeException;
import freenet.keys.CHKEncodeException;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientKeyBlock;
import freenet.keys.Key;
import freenet.keys.KeyEncodeException;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.ArrayBucket;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import org.spaceroots.mantissa.random.MersenneTwister;

public class ClientCHKBlock
extends CHKBlock
implements ClientKeyBlock {
    final ClientCHK key;

    public String toString() {
        return super.toString() + ",key=" + this.key;
    }

    public ClientCHKBlock(byte[] data, byte[] header, ClientCHK key2, boolean verify) throws CHKVerifyException {
        super(data, header, key2.getNodeCHK(), verify, key2.cryptoAlgorithm);
        this.key = key2;
    }

    public ClientCHKBlock(CHKBlock block, ClientCHK key2) throws CHKVerifyException {
        this(block.getData(), block.getHeaders(), key2, true);
    }

    public byte[] memoryDecode() throws CHKDecodeException {
        try {
            ArrayBucket a = (ArrayBucket)this.decode(new ArrayBucketFactory(), 32768, false);
            return BucketTools.toByteArray(a);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public Bucket decode(BucketFactory bf, int maxLength, boolean dontCompress) throws CHKDecodeException, IOException {
        Rijndael cipher;
        if (this.key.cryptoAlgorithm != 2) {
            throw new UnsupportedOperationException();
        }
        try {
            cipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        byte[] cryptoKey = this.key.cryptoKey;
        if (cryptoKey.length < 32) {
            throw new CHKDecodeException("Crypto key too short");
        }
        cipher.initialize(this.key.cryptoKey);
        PCFBMode pcfb = PCFBMode.create(cipher);
        byte[] hbuf = new byte[this.headers.length - 2];
        System.arraycopy(this.headers, 2, hbuf, 0, this.headers.length - 2);
        byte[] dbuf = new byte[this.data.length];
        System.arraycopy(this.data, 0, dbuf, 0, this.data.length);
        pcfb.blockDecipher(hbuf, 0, hbuf.length);
        pcfb.blockDecipher(dbuf, 0, dbuf.length);
        MessageDigest md256 = SHA256.getMessageDigest();
        byte[] dkey = md256.digest(dbuf);
        if (!Arrays.equals(dkey, this.key.cryptoKey)) {
            SHA256.returnMessageDigest(md256);
            throw new CHKDecodeException("Check failed: decrypt key == H(data)");
        }
        byte[] predIV = md256.digest(dkey);
        SHA256.returnMessageDigest(md256);
        md256 = null;
        byte[] iv = new byte[32];
        System.arraycopy(hbuf, 0, iv, 0, 32);
        if (!Arrays.equals(iv, predIV)) {
            throw new CHKDecodeException("Check failed: Decrypted IV == H(decryption key)");
        }
        int size = ((hbuf[32] & 0xFF) << 8) + (hbuf[33] & 0xFF);
        if (size > 32768 || size < 0) {
            throw new CHKDecodeException("Invalid size: " + size);
        }
        return Key.decompress(dontCompress ? false : this.key.isCompressed(), dbuf, size, bf, Math.min(maxLength, Integer.MAX_VALUE), this.key.compressionAlgorithm, false);
    }

    public static ClientCHKBlock encode(Bucket sourceData, boolean asMetadata, boolean dontCompress, short alreadyCompressedCodec, long sourceLength) throws CHKEncodeException, IOException {
        Rijndael cipher;
        byte[] data;
        byte[] finalData = null;
        short compressionAlgorithm = -1;
        try {
            Key.Compressed comp = Key.compress(sourceData, dontCompress, alreadyCompressedCodec, sourceLength, Integer.MAX_VALUE, 32768, false);
            finalData = comp.compressedData;
            compressionAlgorithm = comp.compressionAlgorithm;
        }
        catch (KeyEncodeException e2) {
            throw new CHKEncodeException(e2.getMessage(), e2);
        }
        MessageDigest md256 = SHA256.getMessageDigest();
        if (finalData.length != 32768) {
            if (finalData.length != 0) {
                md256.update(finalData);
            }
            byte[] digest = md256.digest();
            MersenneTwister mt = new MersenneTwister(digest);
            data = new byte[32768];
            System.arraycopy(finalData, 0, data, 0, finalData.length);
            byte[] randomBytes = new byte[32768 - finalData.length];
            mt.nextBytes(randomBytes);
            System.arraycopy(randomBytes, 0, data, finalData.length, 32768 - finalData.length);
        } else {
            data = finalData;
        }
        byte[] encKey = md256.digest(data);
        md256.reset();
        byte[] plainIV = md256.digest(encKey);
        byte[] header = new byte[plainIV.length + 2 + 2];
        header[0] = 0;
        header[1] = 1;
        System.arraycopy(plainIV, 0, header, 2, plainIV.length);
        header[plainIV.length + 2] = (byte)(finalData.length >> 8);
        header[plainIV.length + 3] = (byte)(finalData.length & 0xFF);
        try {
            cipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        cipher.initialize(encKey);
        PCFBMode pcfb = PCFBMode.create(cipher);
        pcfb.blockEncipher(header, 2, header.length - 2);
        pcfb.blockEncipher(data, 0, data.length);
        md256.update(header);
        byte[] finalHash = md256.digest(data);
        SHA256.returnMessageDigest(md256);
        ClientCHK key = new ClientCHK(finalHash, encKey, asMetadata, 2, compressionAlgorithm);
        try {
            return new ClientCHKBlock(data, header, key, false);
        }
        catch (CHKVerifyException e3) {
            throw new Error(e3);
        }
    }

    public static ClientCHKBlock encode(byte[] sourceData, boolean asMetadata, boolean dontCompress, short alreadyCompressedCodec, int sourceLength) throws CHKEncodeException {
        try {
            return ClientCHKBlock.encode(new ArrayBucket(sourceData), asMetadata, dontCompress, alreadyCompressedCodec, (long)sourceLength);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public ClientCHK getClientKey() {
        return this.key;
    }

    public boolean isMetadata() {
        return this.key.isMetadata();
    }

    public boolean objectCanNew(ObjectContainer container) {
        throw new UnsupportedOperationException("ClientCHKBlock storage in database not supported");
    }

    public int hashCode() {
        return this.key.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClientCHKBlock)) {
            return false;
        }
        ClientCHKBlock block = (ClientCHKBlock)o;
        if (!this.key.equals(block.key)) {
            return false;
        }
        return super.equals(o);
    }
}

