/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import com.db4o.ObjectContainer;
import freenet.keys.ClientKey;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.NodeCHK;
import freenet.support.Base64;
import freenet.support.Fields;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;

public class ClientCHK
extends ClientKey {
    transient NodeCHK nodeKey;
    final byte[] routingKey;
    final byte[] cryptoKey;
    final boolean controlDocument;
    final byte cryptoAlgorithm;
    final short compressionAlgorithm;
    final int hashCode;
    static final short EXTRA_LENGTH = 5;
    static final short CRYPTO_KEY_LENGTH = 32;
    static byte[] lastExtra;

    private ClientCHK(ClientCHK key) {
        this.routingKey = new byte[key.routingKey.length];
        System.arraycopy(key.routingKey, 0, this.routingKey, 0, key.routingKey.length);
        this.nodeKey = null;
        this.cryptoKey = new byte[key.cryptoKey.length];
        System.arraycopy(key.cryptoKey, 0, this.cryptoKey, 0, key.cryptoKey.length);
        this.controlDocument = key.controlDocument;
        this.cryptoAlgorithm = key.cryptoAlgorithm;
        this.compressionAlgorithm = key.compressionAlgorithm;
        if (this.routingKey == null) {
            throw new NullPointerException();
        }
        this.hashCode = Fields.hashCode(this.routingKey) ^ Fields.hashCode(this.routingKey) ^ this.compressionAlgorithm;
    }

    public ClientCHK(byte[] routingKey, byte[] encKey, boolean isControlDocument, byte algo, short compressionAlgorithm) {
        this.routingKey = routingKey;
        this.cryptoKey = encKey;
        this.controlDocument = isControlDocument;
        this.cryptoAlgorithm = algo;
        this.compressionAlgorithm = compressionAlgorithm;
        if (routingKey == null) {
            throw new NullPointerException();
        }
        this.hashCode = Fields.hashCode(routingKey) ^ Fields.hashCode(encKey) ^ compressionAlgorithm;
    }

    public ClientCHK(FreenetURI uri) throws MalformedURLException {
        if (!uri.getKeyType().equals("CHK")) {
            throw new MalformedURLException("Not CHK");
        }
        this.routingKey = uri.getRoutingKey();
        this.cryptoKey = uri.getCryptoKey();
        byte[] extra = uri.getExtra();
        if (extra == null || extra.length < 5) {
            throw new MalformedURLException("No extra bytes in CHK - maybe a 0.5 key?");
        }
        this.cryptoAlgorithm = extra[1];
        if (this.cryptoAlgorithm != 2) {
            throw new MalformedURLException("Invalid crypto algorithm");
        }
        this.controlDocument = (extra[2] & 2) != 0;
        this.compressionAlgorithm = (short)(((extra[3] & 0xFF) << 8) + (extra[4] & 0xFF));
        this.hashCode = Fields.hashCode(this.routingKey) ^ Fields.hashCode(this.cryptoKey) ^ this.compressionAlgorithm;
    }

    private ClientCHK(DataInputStream dis) throws IOException {
        byte[] extra = new byte[5];
        dis.readFully(extra);
        this.cryptoAlgorithm = extra[1];
        if (this.cryptoAlgorithm != 2) {
            throw new MalformedURLException("Invalid crypto algorithm");
        }
        this.compressionAlgorithm = (short)(((extra[3] & 0xFF) << 8) + (extra[4] & 0xFF));
        this.controlDocument = (extra[2] & 2) != 0;
        this.routingKey = new byte[32];
        dis.readFully(this.routingKey);
        this.cryptoKey = new byte[32];
        dis.readFully(this.cryptoKey);
        this.hashCode = Fields.hashCode(this.routingKey) ^ Fields.hashCode(this.cryptoKey) ^ this.compressionAlgorithm;
    }

    public void writeRawBinaryKey(DataOutputStream dos) throws IOException {
        dos.write(this.getExtra());
        dos.write(this.routingKey);
        dos.write(this.cryptoKey);
    }

    public byte[] getExtra() {
        byte[] extra = new byte[]{(byte)(this.cryptoAlgorithm >> 8), this.cryptoAlgorithm, (byte)(this.controlDocument ? 2 : 0), (byte)(this.compressionAlgorithm >> 8), (byte)this.compressionAlgorithm};
        byte[] last = lastExtra;
        if (Arrays.equals(last, extra)) {
            return last;
        }
        lastExtra = extra;
        return extra;
    }

    public String toString() {
        return super.toString() + ':' + Base64.encode(this.routingKey) + ',' + Base64.encode(this.cryptoKey) + ',' + this.compressionAlgorithm + ',' + this.controlDocument + ',' + this.cryptoAlgorithm;
    }

    public Key getNodeKey() {
        return this.getNodeCHK();
    }

    public NodeCHK getNodeCHK() {
        if (this.nodeKey == null) {
            this.nodeKey = new NodeCHK(this.routingKey, this.cryptoAlgorithm);
        }
        return this.nodeKey;
    }

    public FreenetURI getURI() {
        byte[] extra = this.getExtra();
        return new FreenetURI("CHK", null, this.routingKey, this.cryptoKey, extra);
    }

    public static ClientCHK readRawBinaryKey(DataInputStream dis) throws IOException {
        return new ClientCHK(dis);
    }

    public boolean isMetadata() {
        return this.controlDocument;
    }

    public boolean isCompressed() {
        return this.compressionAlgorithm >= 0;
    }

    public ClientCHK cloneKey() {
        return new ClientCHK(this);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClientCHK)) {
            return false;
        }
        ClientCHK key = (ClientCHK)o;
        if (this.controlDocument != key.controlDocument) {
            return false;
        }
        if (this.cryptoAlgorithm != key.cryptoAlgorithm) {
            return false;
        }
        if (this.compressionAlgorithm != key.compressionAlgorithm) {
            return false;
        }
        if (!Arrays.equals(this.routingKey, key.routingKey)) {
            return false;
        }
        return Arrays.equals(this.cryptoKey, key.cryptoKey);
    }

    public byte[] getRoutingKey() {
        return this.routingKey;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.routingKey == null) {
            throw new NullPointerException("Storing a ClientCHK with no routingKey!: stored=" + container.ext().isStored((Object)this) + " active=" + container.ext().isActive((Object)this));
        }
        if (this.cryptoKey == null) {
            throw new NullPointerException("Storing a ClientCHK with no cryptoKey!");
        }
        return true;
    }
}

