/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.MessageCore;
import freenet.io.xfer.BulkReceiver;
import freenet.io.xfer.BulkTransmitter;
import freenet.support.BitArray;
import freenet.support.Logger;
import freenet.support.io.RandomAccessThing;
import java.io.IOException;

public class PartiallyReceivedBulk {
    final long size;
    final int blockSize;
    private final RandomAccessThing raf;
    private final BitArray blocksReceived;
    final int blocks;
    private BulkTransmitter[] transmitters;
    final MessageCore usm;
    BulkReceiver recv;
    private int blocksReceivedCount;
    boolean _aborted;
    int _abortReason;
    String _abortDescription;

    public PartiallyReceivedBulk(MessageCore usm, long size, int blockSize, RandomAccessThing raf, boolean initialState) {
        this.size = size;
        this.blockSize = blockSize;
        this.raf = raf;
        this.usm = usm;
        long blocks = size / (long)blockSize + (long)(size % (long)blockSize > 0L ? 1 : 0);
        if (blocks > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too big");
        }
        this.blocks = (int)blocks;
        this.blocksReceived = new BitArray(this.blocks);
        if (initialState) {
            this.blocksReceived.setAllOnes();
            this.blocksReceivedCount = this.blocks;
        }
    }

    synchronized BitArray cloneBlocksReceived() {
        return new BitArray(this.blocksReceived);
    }

    synchronized void add(BulkTransmitter bt) {
        if (this.transmitters == null) {
            this.transmitters = new BulkTransmitter[]{bt};
        } else {
            BulkTransmitter[] t = new BulkTransmitter[this.transmitters.length + 1];
            System.arraycopy(this.transmitters, 0, t, 0, this.transmitters.length);
            t[this.transmitters.length] = bt;
            this.transmitters = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void received(int blockNum, byte[] data, int offset, int length) {
        BulkTransmitter[] notifyBTs;
        long fileOffset;
        int bs;
        if (blockNum > this.blocks) {
            Logger.error(this, "Received block " + blockNum + " of " + this.blocks + " !");
            return;
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Received block " + blockNum);
        }
        if (length < (bs = (int)Math.min((long)this.blockSize, this.size - (fileOffset = (long)blockNum * (long)this.blockSize)))) {
            String err = "Data too short! Should be " + bs + " actually " + length;
            Logger.error(this, err + " for " + this);
            this.abort(2, err);
            return;
        }
        PartiallyReceivedBulk err = this;
        synchronized (err) {
            if (this.blocksReceived.bitAt(blockNum)) {
                return;
            }
            this.blocksReceived.setBit(blockNum, true);
            ++this.blocksReceivedCount;
            notifyBTs = this.transmitters;
        }
        try {
            this.raf.pwrite(fileOffset, data, offset, bs);
        }
        catch (Throwable t) {
            Logger.error(this, "Failed to store received block " + blockNum + " on " + this + " : " + t, t);
            this.abort(3, t.toString());
        }
        if (notifyBTs == null) {
            return;
        }
        for (int i = 0; i < notifyBTs.length; ++i) {
            notifyBTs[i].blockReceived(blockNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(int errCode, String why) {
        BulkReceiver notifyBR;
        BulkTransmitter[] notifyBTs;
        if (Logger.shouldLog(8, this)) {
            Logger.normal(this, "Aborting " + this + ": " + errCode + " : " + why, new Exception("debug"));
        }
        PartiallyReceivedBulk partiallyReceivedBulk = this;
        synchronized (partiallyReceivedBulk) {
            this._aborted = true;
            this._abortReason = errCode;
            this._abortDescription = why;
            notifyBTs = this.transmitters;
            notifyBR = this.recv;
        }
        if (notifyBTs != null) {
            for (int i = 0; i < notifyBTs.length; ++i) {
                notifyBTs[i].onAborted();
            }
        }
        if (notifyBR != null) {
            notifyBR.onAborted();
        }
        this.raf.close();
    }

    public synchronized boolean isAborted() {
        return this._aborted;
    }

    public boolean hasWholeFile() {
        return this.blocksReceivedCount >= this.blocks;
    }

    public byte[] getBlockData(int blockNum) {
        long fileOffset = (long)blockNum * (long)this.blockSize;
        int bs = (int)Math.min((long)this.blockSize, this.size - fileOffset);
        byte[] data = new byte[bs];
        try {
            this.raf.pread(fileOffset, data, 0, bs);
        }
        catch (IOException e) {
            Logger.error(this, "Failed to read stored block " + blockNum + " on " + this + " : " + e, e);
            this.abort(3, e.toString());
            return null;
        }
        return data;
    }

    public synchronized void remove(BulkTransmitter remove) {
        boolean found = false;
        for (int i = 0; i < this.transmitters.length; ++i) {
            if (this.transmitters[i] != remove) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        BulkTransmitter[] newTrans = new BulkTransmitter[this.transmitters.length - 1];
        int j = 0;
        for (int i = 0; i < this.transmitters.length; ++i) {
            BulkTransmitter t = this.transmitters[i];
            if (t == remove) continue;
            newTrans[j++] = t;
        }
        this.transmitters = newTrans;
    }

    public int getAbortReason() {
        return this._abortReason;
    }

    public String getAbortDescription() {
        return this._abortDescription;
    }
}

