/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.xfer.AbortedException;
import freenet.support.Buffer;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartiallyReceivedBlock {
    byte[] _data;
    boolean[] _received;
    int _receivedCount;
    int _packets;
    int _packetSize;
    boolean _aborted;
    int _abortReason;
    String _abortDescription;
    LinkedList<PacketReceivedListener> _packetReceivedListeners = new LinkedList();

    public PartiallyReceivedBlock(int packets, int packetSize, byte[] data) {
        if (data.length != packets * packetSize) {
            throw new RuntimeException("Length of data (" + data.length + ") doesn't match packet number and size");
        }
        this._data = data;
        this._received = new boolean[packets];
        for (int x = 0; x < this._received.length; ++x) {
            this._received[x] = true;
        }
        this._receivedCount = packets;
        this._packets = packets;
        this._packetSize = packetSize;
    }

    public PartiallyReceivedBlock(int packets, int packetSize) {
        this._data = new byte[packets * packetSize];
        this._received = new boolean[packets];
        this._packets = packets;
        this._packetSize = packetSize;
    }

    public synchronized LinkedList<Integer> addListener(PacketReceivedListener listener) throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("Adding listener to aborted PRB");
        }
        this._packetReceivedListeners.add(listener);
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (int x = 0; x < this._packets; ++x) {
            if (!this._received[x]) continue;
            ret.addLast(x);
        }
        return ret;
    }

    public synchronized boolean isReceived(int packetNo) throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        return this._received[packetNo];
    }

    public synchronized int getNumPackets() throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        return this._packets;
    }

    public synchronized int getPacketSize() throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        return this._packetSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacket(int position, Buffer packet) throws AbortedException {
        PacketReceivedListener[] prls;
        PartiallyReceivedBlock partiallyReceivedBlock = this;
        synchronized (partiallyReceivedBlock) {
            if (this._aborted) {
                throw new AbortedException("PRB is aborted");
            }
            if (packet.getLength() != this._packetSize) {
                throw new RuntimeException("New packet size " + packet.getLength() + " but expecting packet of size " + this._packetSize);
            }
            if (this._received[position]) {
                return;
            }
            ++this._receivedCount;
            packet.copyTo(this._data, position * this._packetSize);
            this._received[position] = true;
            prls = this._packetReceivedListeners.toArray(new PacketReceivedListener[this._packetReceivedListeners.size()]);
        }
        for (int i = 0; i < prls.length; ++i) {
            PacketReceivedListener prl = prls[i];
            prl.packetReceived(position);
        }
    }

    public synchronized boolean allReceived() throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        return this._receivedCount == this._packets;
    }

    public synchronized byte[] getBlock() throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        if (!this.allReceived()) {
            throw new RuntimeException("Tried to get block before all packets received");
        }
        return this._data;
    }

    public synchronized Buffer getPacket(int x) throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        if (!this._received[x]) {
            throw new IllegalStateException("that packet is not received");
        }
        return new Buffer(this._data, x * this._packetSize, this._packetSize);
    }

    public synchronized void removeListener(PacketReceivedListener listener) {
        this._packetReceivedListeners.remove(listener);
    }

    public synchronized void abort(int reason, String description) {
        this._aborted = true;
        this._abortReason = reason;
        this._abortDescription = description;
        for (PacketReceivedListener prl : this._packetReceivedListeners) {
            prl.receiveAborted(reason, description);
        }
    }

    public synchronized boolean isAborted() {
        return this._aborted;
    }

    public synchronized int getAbortReason() {
        return this._abortReason;
    }

    public synchronized String getAbortDescription() {
        return this._abortDescription;
    }

    public static interface PacketReceivedListener {
        public void packetReceived(int var1);

        public void receiveAborted(int var1, String var2);
    }
}

