/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerContext;
import freenet.io.xfer.ThrottleDeprecatedException;
import freenet.io.xfer.WaitedTooLongException;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class PacketThrottle {
    private static volatile boolean logMINOR;
    protected static final double PACKET_DROP_DECREASE_MULTIPLE = 0.875;
    protected static final double PACKET_TRANSMIT_INCREMENT = 0.3125;
    protected static final double SLOW_START_DIVISOR = 3.0;
    protected static final long MAX_DELAY = 1000L;
    protected static final long MIN_DELAY = 1L;
    public static final String VERSION = "$Id: PacketThrottle.java,v 1.3 2005/08/25 17:28:19 amphibian Exp $";
    public static final long DEFAULT_DELAY = 200L;
    private final Peer _peer;
    private long _roundTripTime = 500L;
    private long _totalPackets;
    private long _droppedPackets;
    private float _simulatedWindowSize = 2.0f;
    private final int PACKET_SIZE;
    private boolean slowStart = true;
    private int _packetsInFlight;
    private long _packetSeq;
    private long _packetSeqWindowFull;
    private long _packetSeqWindowFullChecked;
    private long _packetTicketGenerator;
    private long _abandonedTickets;
    private PacketThrottle _deprecatedFor;

    public PacketThrottle(Peer peer, int packetSize) {
        this._peer = peer;
        this.PACKET_SIZE = packetSize;
    }

    public synchronized void setRoundTripTime(long rtt) {
        this._roundTripTime = Math.max(rtt, 10L);
        if (logMINOR) {
            Logger.minor(this, "Set round trip time to " + rtt + " on " + this);
        }
    }

    public synchronized void notifyOfPacketLost() {
        ++this._droppedPackets;
        ++this._totalPackets;
        this._simulatedWindowSize = (float)((double)this._simulatedWindowSize * 0.875);
        this.slowStart = false;
        if (logMINOR) {
            Logger.minor(this, "notifyOfPacketLost(): " + this);
        }
        this._packetSeqWindowFullChecked = this._packetSeq;
    }

    public synchronized void notifyOfPacketAcknowledged() {
        ++this._totalPackets;
        int windowSize = (int)this.getWindowSize();
        if (this._packetSeqWindowFullChecked + (long)windowSize < this._packetSeq) {
            if (this._packetSeqWindowFull < this._packetSeqWindowFullChecked) {
                this._simulatedWindowSize = (float)((double)this._simulatedWindowSize * 0.875);
                this._packetSeqWindowFullChecked += (long)windowSize;
                if (logMINOR) {
                    Logger.minor(this, "Window not used since we last checked: full=" + this._packetSeqWindowFull + " last checked=" + this._packetSeqWindowFullChecked + " window = " + this._simulatedWindowSize + " for " + this);
                }
                return;
            }
            this._packetSeqWindowFullChecked += (long)windowSize;
        }
        if (this.slowStart) {
            if (logMINOR) {
                Logger.minor(this, "Still in slow start");
            }
            this._simulatedWindowSize = (float)((double)this._simulatedWindowSize + (double)this._simulatedWindowSize / 3.0);
        } else {
            this._simulatedWindowSize = (float)((double)this._simulatedWindowSize + 0.3125 / (double)this._simulatedWindowSize);
        }
        if (this._simulatedWindowSize > (float)(windowSize + 1)) {
            this.notifyAll();
        }
        if (logMINOR) {
            Logger.minor(this, "notifyOfPacketAcked(): " + this);
        }
    }

    public synchronized long getDelay() {
        float winSizeForMinPacketDelay = (float)this._roundTripTime / 1.0f;
        if (this._simulatedWindowSize > winSizeForMinPacketDelay) {
            this._simulatedWindowSize = winSizeForMinPacketDelay;
        }
        if (this._simulatedWindowSize < 1.0f) {
            this._simulatedWindowSize = 1.0f;
        }
        return Math.max(1L, (long)((float)this._roundTripTime / this._simulatedWindowSize));
    }

    public synchronized String toString() {
        return Double.toString((double)this.PACKET_SIZE * 1000.0 / (double)this.getDelay() / 1024.0) + " k/sec, (w: " + this._simulatedWindowSize + ", r:" + this._roundTripTime + ", d:" + (float)this._droppedPackets / (float)this._totalPackets + ") total=" + this._totalPackets + " for " + this._peer + " : " + super.toString();
    }

    public synchronized long getRoundTripTime() {
        return this._roundTripTime;
    }

    public synchronized double getWindowSize() {
        return Math.max(1.0, (double)this._simulatedWindowSize);
    }

    public synchronized double getBandwidth() {
        return (double)this.PACKET_SIZE * 1000.0 / (double)this.getDelay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendThrottledMessage(Message msg, PeerContext peer, int packetSize, ByteCounter ctr, long deadline, boolean blockForSend, AsyncMessageCallback cbForAsyncSend) throws NotConnectedException, ThrottleDeprecatedException, WaitedTooLongException, SyncSendWaitedTooLongException {
        block33: {
            long start = System.currentTimeMillis();
            long bootID = peer.getBootID();
            PacketThrottle packetThrottle = this;
            synchronized (packetThrottle) {
                block32: {
                    long thisTicket = this._packetTicketGenerator++;
                    do {
                        long now;
                        int waitFor;
                        boolean wereNext;
                        int windowSize = (int)this.getWindowSize();
                        boolean bl = wereNext = this._packetSeq >= thisTicket - this._abandonedTickets;
                        if (this._packetsInFlight < windowSize && wereNext) {
                            ++this._packetsInFlight;
                            ++this._packetSeq;
                            if (windowSize == this._packetsInFlight) {
                                this._packetSeqWindowFull = this._packetSeq;
                                if (logMINOR) {
                                    Logger.minor(this, "Window full at " + this._packetSeq + " for " + this);
                                }
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Sending, window size now " + windowSize + " packets in flight " + this._packetsInFlight + " for " + this);
                            }
                            break block32;
                        }
                        long waitingBehind = thisTicket - this._abandonedTickets - this._packetSeq;
                        if (logMINOR) {
                            Logger.minor(this, "Window size: " + windowSize + " packets in flight " + this._packetsInFlight + ", " + waitingBehind + " in front of this thread for " + this);
                        }
                        if ((waitFor = (int)Math.min(Integer.MAX_VALUE, deadline - (now = System.currentTimeMillis()))) <= 0) {
                            if (!peer.isConnected()) {
                                Logger.error(this, "Not notified of disconnection before timeout");
                                ++this._abandonedTickets;
                                throw new NotConnectedException();
                            }
                            if (bootID != peer.getBootID()) {
                                Logger.error(this, "Not notified of reconnection before timeout");
                                ++this._abandonedTickets;
                                throw new NotConnectedException();
                            }
                            Logger.error(this, "Unable to send throttled message, waited " + (now - start) + "ms");
                            ++this._abandonedTickets;
                            throw new WaitedTooLongException();
                        }
                        try {
                            this.wait(waitFor);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (!peer.isConnected()) {
                            ++this._abandonedTickets;
                            throw new NotConnectedException();
                        }
                        if (bootID == peer.getBootID()) continue;
                        ++this._abandonedTickets;
                        throw new NotConnectedException();
                    } while (this._deprecatedFor == null);
                    ++this._abandonedTickets;
                    throw new ThrottleDeprecatedException(this._deprecatedFor);
                }
                this.notifyAll();
            }
            long waitTime = System.currentTimeMillis() - start;
            if (waitTime > 60000L) {
                Logger.error(this, "Congestion control wait time: " + waitTime + " for " + this);
            } else if (logMINOR) {
                Logger.minor(this, "Congestion control wait time: " + waitTime + " for " + this);
            }
            MyCallback callback = new MyCallback(cbForAsyncSend);
            try {
                peer.sendAsync(msg, callback, ctr);
                ctr.sentPayload(packetSize);
                if (!blockForSend) break block33;
                MyCallback windowSize = callback;
                synchronized (windowSize) {
                    long now;
                    long timeout = System.currentTimeMillis() + 60000L;
                    while ((now = System.currentTimeMillis()) < timeout && !callback.finished) {
                        try {
                            callback.wait((int)(timeout - now));
                        }
                        catch (InterruptedException e) {}
                    }
                    if (!callback.finished) {
                        throw new SyncSendWaitedTooLongException();
                    }
                }
            }
            catch (RuntimeException e) {
                callback.fatalError();
                throw e;
            }
            catch (Error e) {
                callback.fatalError();
                throw e;
            }
            catch (NotConnectedException e) {
                PacketThrottle packetThrottle2 = this;
                synchronized (packetThrottle2) {
                    callback.disconnected();
                    this.notifyAll();
                }
                throw e;
            }
        }
    }

    public synchronized void maybeDisconnected() {
        this.notifyAll();
    }

    public synchronized void changedAddress(PacketThrottle newThrottle) {
        this._deprecatedFor = newThrottle;
        this.notifyAll();
    }

    public Peer getPeer() {
        return this._peer;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    private class MyCallback
    implements AsyncMessageCallback {
        private boolean finished = false;
        private AsyncMessageCallback chainCallback;

        public MyCallback(AsyncMessageCallback cbForAsyncSend) {
            this.chainCallback = cbForAsyncSend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acknowledged() {
            PacketThrottle packetThrottle = PacketThrottle.this;
            synchronized (packetThrottle) {
                if (this.finished) {
                    if (logMINOR) {
                        Logger.minor(this, "Already acked, ignoring callback: " + this);
                    }
                    return;
                }
                this.finished = true;
                PacketThrottle.this._packetsInFlight--;
                PacketThrottle.this.notifyAll();
            }
            if (logMINOR) {
                Logger.minor(this, "Removed packet: acked for " + this);
            }
            if (this.chainCallback != null) {
                this.chainCallback.acknowledged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected() {
            PacketThrottle packetThrottle = PacketThrottle.this;
            synchronized (packetThrottle) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                PacketThrottle.this._packetsInFlight--;
                PacketThrottle.this.notifyAll();
            }
            if (logMINOR) {
                Logger.minor(this, "Removed packet: disconnected for " + this);
            }
            if (this.chainCallback != null) {
                this.chainCallback.disconnected();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fatalError() {
            PacketThrottle packetThrottle = PacketThrottle.this;
            synchronized (packetThrottle) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                PacketThrottle.this._packetsInFlight--;
                PacketThrottle.this.notifyAll();
            }
            if (logMINOR) {
                Logger.minor(this, "Removed packet: error for " + this);
            }
            if (this.chainCallback != null) {
                this.chainCallback.fatalError();
            }
        }

        public void sent() {
            if (this.chainCallback != null) {
                this.chainCallback.sent();
            }
        }

        public String toString() {
            return super.toString() + ":" + PacketThrottle.this.toString();
        }
    }
}

