/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.io.xfer.WaitedTooLongException;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.support.BitArray;
import freenet.support.Logger;

public class BulkTransmitter {
    static final int TIMEOUT = 300000;
    static final int FINAL_ACK_TIMEOUT = 10000;
    final PartiallyReceivedBulk prb;
    final PeerContext peer;
    final long uid;
    final BitArray blocksNotSentButPresent;
    private boolean cancelled;
    final long peerBootID;
    private boolean sentCancel;
    private boolean finished;
    final int packetSize;
    final boolean noWait;
    private long finishTime = -1L;
    private String cancelReason;
    private final ByteCounter ctr;
    private int inFlightPackets = 0;
    private boolean failedPacket = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkTransmitter(PartiallyReceivedBulk prb, PeerContext peer, long uid, boolean noWait, ByteCounter ctr) throws DisconnectedException {
        this.prb = prb;
        this.peer = peer;
        this.uid = uid;
        this.noWait = noWait;
        this.ctr = ctr;
        if (ctr == null) {
            throw new NullPointerException();
        }
        this.peerBootID = peer.getBootID();
        PartiallyReceivedBulk partiallyReceivedBulk = prb;
        synchronized (partiallyReceivedBulk) {
            this.blocksNotSentButPresent = prb.cloneBlocksReceived();
            prb.add(this);
        }
        try {
            prb.usm.addAsyncFilter(MessageFilter.create().setNoTimeout().setSource(peer).setType(DMT.FNPBulkReceiveAborted).setField("uid", uid), new AsyncMessageFilterCallback(){

                public void onMatched(Message m) {
                    BulkTransmitter.this.cancel("Other side sent FNPBulkReceiveAborted");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean shouldTimeout() {
                    BulkTransmitter bulkTransmitter = BulkTransmitter.this;
                    synchronized (bulkTransmitter) {
                        if (BulkTransmitter.this.cancelled || BulkTransmitter.this.finished) {
                            return true;
                        }
                    }
                    return BulkTransmitter.this.prb.isAborted();
                }

                public void onTimeout() {
                }

                public void onDisconnect(PeerContext ctx) {
                }

                public void onRestarted(PeerContext ctx) {
                }
            });
            prb.usm.addAsyncFilter(MessageFilter.create().setNoTimeout().setSource(peer).setType(DMT.FNPBulkReceivedAll).setField("uid", uid), new AsyncMessageFilterCallback(){

                public void onMatched(Message m) {
                    BulkTransmitter.this.completed();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean shouldTimeout() {
                    BulkTransmitter bulkTransmitter = BulkTransmitter.this;
                    synchronized (bulkTransmitter) {
                        if (BulkTransmitter.this.cancelled) {
                            return true;
                        }
                        if (BulkTransmitter.this.finished) {
                            return System.currentTimeMillis() - BulkTransmitter.this.finishTime > 10000L;
                        }
                    }
                    return BulkTransmitter.this.prb.isAborted();
                }

                public void onTimeout() {
                }

                public void onDisconnect(PeerContext ctx) {
                }

                public void onRestarted(PeerContext ctx) {
                }
            });
        }
        catch (DisconnectedException e) {
            this.cancel("Disconnected");
            throw e;
        }
        this.packetSize = DMT.bulkPacketTransmitSize(prb.blockSize) + peer.getOutgoingMangler().fullHeadersLengthOneMessage();
    }

    synchronized void blockReceived(int block) {
        this.blocksNotSentButPresent.setBit(block, true);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAborted() {
        this.sendAbortedMessage();
        BulkTransmitter bulkTransmitter = this;
        synchronized (bulkTransmitter) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAbortedMessage() {
        BulkTransmitter bulkTransmitter = this;
        synchronized (bulkTransmitter) {
            if (this.sentCancel) {
                return;
            }
            this.sentCancel = true;
        }
        try {
            this.peer.sendAsync(DMT.createFNPBulkSendAborted(this.uid), null, this.ctr);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String reason) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Cancelling " + this);
        }
        this.sendAbortedMessage();
        BulkTransmitter bulkTransmitter = this;
        synchronized (bulkTransmitter) {
            this.cancelled = true;
            this.cancelReason = reason;
            this.notifyAll();
        }
        this.prb.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed() {
        BulkTransmitter bulkTransmitter = this;
        synchronized (bulkTransmitter) {
            this.finished = true;
            this.finishTime = System.currentTimeMillis();
            this.notifyAll();
        }
        this.prb.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send() {
        boolean logMINOR = Logger.shouldLog(4, this);
        long lastSentPacket = System.currentTimeMillis();
        block20: while (true) {
            int blockNo;
            if (this.prb.isAborted()) {
                if (logMINOR) {
                    Logger.minor(this, "Aborted " + this);
                }
                return false;
            }
            if (this.peer.getBootID() != this.peerBootID) {
                BulkTransmitter bulkTransmitter = this;
                synchronized (bulkTransmitter) {
                    this.cancelled = true;
                    this.notifyAll();
                }
                this.prb.remove(this);
                if (logMINOR) {
                    Logger.minor(this, "Failed to send " + this.uid + ": peer restarted: " + this.peer);
                }
                return false;
            }
            BulkTransmitter bulkTransmitter = this;
            synchronized (bulkTransmitter) {
                if (this.finished) {
                    return true;
                }
                if (this.cancelled) {
                    return false;
                }
                blockNo = this.blocksNotSentButPresent.firstOne();
            }
            if (blockNo < 0) {
                if (this.noWait && this.prb.hasWholeFile()) {
                    this.completed();
                    return true;
                }
                bulkTransmitter = this;
                synchronized (bulkTransmitter) {
                    while (true) {
                        if (this.failedPacket) {
                            this.cancel("Packet send failed");
                            return false;
                        }
                        if (Logger.shouldLog(4, this)) {
                            Logger.minor(this, "Waiting for packets: remaining: " + this.inFlightPackets);
                        }
                        if (this.inFlightPackets == 0) break;
                        try {
                            this.wait();
                            if (this.failedPacket) {
                                this.cancel("Packet send failed");
                                return false;
                            }
                            if (this.inFlightPackets == 0) break;
                            continue block20;
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        break;
                    }
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                long end = System.currentTimeMillis();
                if (end - lastSentPacket <= 300000L) continue;
                Logger.error(this, "Send timed out on " + this);
                this.cancel("Timeout awaiting BulkReceivedAll");
                return false;
            }
            byte[] buf = this.prb.getBlockData(blockNo);
            if (buf == null) {
                if (logMINOR) {
                    Logger.minor(this, "Block " + blockNo + " is null, presumably the send is cancelled: " + this);
                }
                return false;
            }
            try {
                if (logMINOR) {
                    Logger.minor(this, "Sending packet " + blockNo);
                }
                this.peer.sendThrottledMessage(DMT.createFNPBulkPacketSend(this.uid, blockNo, buf), buf.length, this.ctr, 300000, false, new UnsentPacketTag());
                BulkTransmitter e = this;
                synchronized (e) {
                    this.blocksNotSentButPresent.setBit(blockNo, false);
                }
                lastSentPacket = System.currentTimeMillis();
            }
            catch (NotConnectedException e) {
                this.cancel("Disconnected");
                if (logMINOR) {
                    Logger.minor(this, "Canclled: not connected " + this);
                }
                return false;
            }
            catch (WaitedTooLongException e) {
                Logger.error(this, "Failed to send bulk packet " + blockNo + " for " + this);
                return false;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Impossible: Caught " + e, e);
                return false;
            }
        }
    }

    public String toString() {
        return "BulkTransmitter:" + this.uid + ":" + this.peer.shortToString();
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    private class UnsentPacketTag
    implements AsyncMessageCallback {
        private boolean finished;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UnsentPacketTag() {
            BulkTransmitter bulkTransmitter2 = BulkTransmitter.this;
            synchronized (bulkTransmitter2) {
                BulkTransmitter.this.inFlightPackets++;
            }
        }

        public void acknowledged() {
            this.complete(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(boolean failed) {
            Object object = this;
            synchronized (object) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
            }
            object = BulkTransmitter.this;
            synchronized (object) {
                if (failed) {
                    BulkTransmitter.this.failedPacket = true;
                    BulkTransmitter.this.notifyAll();
                    if (Logger.shouldLog(4, this)) {
                        Logger.minor(this, "Packet failed for " + BulkTransmitter.this);
                    }
                } else {
                    BulkTransmitter.this.inFlightPackets--;
                    if (BulkTransmitter.this.inFlightPackets <= 0) {
                        BulkTransmitter.this.notifyAll();
                    }
                    if (Logger.shouldLog(4, this)) {
                        Logger.minor(this, "Packet sent " + BulkTransmitter.this + " remaining in flight: " + BulkTransmitter.this.inFlightPackets);
                    }
                }
            }
        }

        public void disconnected() {
            this.complete(true);
        }

        public void fatalError() {
            this.complete(true);
        }

        public void sent() {
        }
    }
}

