/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageCore;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.PacketThrottle;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.io.xfer.WaitedTooLongException;
import freenet.node.PrioRunnable;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.support.BitArray;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import freenet.support.math.MedianMeanRunningAverage;
import java.util.Iterator;
import java.util.LinkedList;

public class BlockTransmitter {
    private static volatile boolean logMINOR;
    public static final int SEND_TIMEOUT = 60000;
    public static final int PING_EVERY = 8;
    final MessageCore _usm;
    final PeerContext _destination;
    private boolean _sendComplete;
    final long _uid;
    final PartiallyReceivedBlock _prb;
    private LinkedList<Integer> _unsent;
    private Runnable _senderThread;
    private BitArray _sentPackets;
    final PacketThrottle throttle;
    private long timeAllSent = -1L;
    final ByteCounter _ctr;
    final int PACKET_SIZE;
    private boolean asyncExitStatus;
    private boolean asyncExitStatusSet;
    private static MedianMeanRunningAverage avgTimeTaken;

    public BlockTransmitter(MessageCore usm, PeerContext destination, long uid, PartiallyReceivedBlock source, ByteCounter ctr) {
        this._usm = usm;
        this._destination = destination;
        this._uid = uid;
        this._prb = source;
        this._ctr = ctr;
        if (this._ctr == null) {
            throw new NullPointerException();
        }
        this.PACKET_SIZE = DMT.packetTransmitSize(this._prb._packetSize, this._prb._packets) + destination.getOutgoingMangler().fullHeadersLengthOneMessage();
        try {
            this._sentPackets = new BitArray(this._prb.getNumPackets());
        }
        catch (AbortedException e) {
            Logger.error(this, "Aborted during setup");
        }
        this.throttle = this._destination.getThrottle();
        this._senderThread = new PrioRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!BlockTransmitter.this._sendComplete) {
                    int totalPackets;
                    int packetNo;
                    try {
                        Runnable runnable = BlockTransmitter.this._senderThread;
                        synchronized (runnable) {
                            while (BlockTransmitter.this._unsent.size() == 0) {
                                if (BlockTransmitter.this._sendComplete) {
                                    return;
                                }
                                BlockTransmitter.this._senderThread.wait(10000L);
                            }
                            packetNo = (Integer)BlockTransmitter.this._unsent.removeFirst();
                        }
                    }
                    catch (InterruptedException e) {
                        Logger.error(this, "_senderThread interrupted");
                        continue;
                    }
                    try {
                        BlockTransmitter.this._destination.sendThrottledMessage(DMT.createPacketTransmit(BlockTransmitter.this._uid, packetNo, BlockTransmitter.this._sentPackets, BlockTransmitter.this._prb.getPacket(packetNo)), BlockTransmitter.this._prb._packetSize, BlockTransmitter.this._ctr, 60000, false, null);
                        totalPackets = BlockTransmitter.this._prb.getNumPackets();
                    }
                    catch (NotConnectedException e) {
                        Logger.normal(this, "Terminating send: " + e);
                        return;
                    }
                    catch (AbortedException e) {
                        Logger.normal(this, "Terminating send due to abort: " + e);
                        return;
                    }
                    catch (WaitedTooLongException e) {
                        Logger.normal(this, "Waited too long to send packet, aborting");
                        Runnable runnable = BlockTransmitter.this._senderThread;
                        synchronized (runnable) {
                            BlockTransmitter.this._sendComplete = true;
                        }
                        return;
                    }
                    catch (SyncSendWaitedTooLongException e) {
                        Logger.error(this, "Impossible: Caught " + e, e);
                        return;
                    }
                    Runnable runnable = BlockTransmitter.this._senderThread;
                    synchronized (runnable) {
                        BlockTransmitter.this._sentPackets.setBit(packetNo, true);
                        if (BlockTransmitter.this._unsent.size() == 0 && BlockTransmitter.this.getNumSent() == totalPackets) {
                            BlockTransmitter.this.sendAllSentNotification();
                            BlockTransmitter.this.timeAllSent = System.currentTimeMillis();
                            if (logMINOR) {
                                Logger.minor(this, "Sent all blocks, none unsent");
                            }
                            BlockTransmitter.this._senderThread.notifyAll();
                        }
                    }
                }
            }

            public int getPriority() {
                return 7;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortSend(int reason, String desc) throws NotConnectedException {
        BlockTransmitter blockTransmitter = this;
        synchronized (blockTransmitter) {
            if (this._sendComplete) {
                return;
            }
            this._sendComplete = true;
        }
        this.sendAborted(reason, desc);
    }

    public void sendAborted(int reason, String desc) throws NotConnectedException {
        this._usm.send(this._destination, DMT.createSendAborted(this._uid, reason, desc), this._ctr);
    }

    private void sendAllSentNotification() {
        try {
            this._usm.send(this._destination, DMT.createAllSent(this._uid), this._ctr);
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "disconnected for allSent()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean send(Executor executor) {
        boolean endTime2;
        PartiallyReceivedBlock.PacketReceivedListener myListener;
        block46: {
            boolean bl;
            block45: {
                boolean bl2;
                block44: {
                    Runnable runnable;
                    boolean bl3;
                    long startTime = System.currentTimeMillis();
                    myListener = null;
                    try {
                        try {
                            Object object = this._prb;
                            synchronized (object) {
                                myListener = new PartiallyReceivedBlock.PacketReceivedListener(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void packetReceived(int packetNo) {
                                        Runnable runnable = BlockTransmitter.this._senderThread;
                                        synchronized (runnable) {
                                            BlockTransmitter.this._unsent.addLast(packetNo);
                                            BlockTransmitter.this.timeAllSent = -1L;
                                            BlockTransmitter.this._sentPackets.setBit(packetNo, false);
                                            BlockTransmitter.this._senderThread.notifyAll();
                                        }
                                    }

                                    public void receiveAborted(int reason, String description) {
                                    }
                                };
                                this._unsent = this._prb.addListener(myListener);
                            }
                            executor.execute(this._senderThread, this.toString());
                            block27: while (true) {
                                Message msg;
                                object = this._senderThread;
                                synchronized (object) {
                                    if (this._sendComplete) {
                                        bl3 = false;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 42, 27, 14] lbl16 : MonitorExitStatement: MONITOREXIT : var5_4
                                        Object var13_25 = null;
                                        runnable = this._senderThread;
                                        break;
                                    }
                                }
                                try {
                                    MessageFilter mfMissingPacketNotification = MessageFilter.create().setType(DMT.missingPacketNotification).setField("uid", this._uid).setTimeout(60000).setSource(this._destination);
                                    MessageFilter mfAllReceived = MessageFilter.create().setType(DMT.allReceived).setField("uid", this._uid).setTimeout(60000).setSource(this._destination);
                                    MessageFilter mfSendAborted = MessageFilter.create().setType(DMT.sendAborted).setField("uid", this._uid).setTimeout(60000).setSource(this._destination);
                                    msg = this._usm.waitFor(mfMissingPacketNotification.or(mfAllReceived.or(mfSendAborted)), this._ctr);
                                    if (logMINOR) {
                                        Logger.minor(this, "Got " + msg);
                                    }
                                }
                                catch (DisconnectedException e) {
                                    this.throttle.maybeDisconnected();
                                    Logger.normal(this, "Terminating send " + this._uid + " to " + this._destination + " from " + this._destination.getSocketHandler() + " because node disconnected while waiting");
                                    boolean mfAllReceived = false;
                                    Object var13_26 = null;
                                    Runnable runnable2 = this._senderThread;
                                    synchronized (runnable2) {
                                        this._sendComplete = true;
                                        this._senderThread.notifyAll();
                                    }
                                    if (myListener == null) return mfAllReceived;
                                    this._prb.removeListener(myListener);
                                    return mfAllReceived;
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "Got " + msg);
                                }
                                if (msg == null) {
                                    long now = System.currentTimeMillis();
                                    if (this.timeAllSent > 0L && now - this.timeAllSent > 60000L && this.getNumSent() == this._prb.getNumPackets()) {
                                        String timeString = TimeUtil.formatTime(now - this.timeAllSent, 2, true);
                                        Logger.error(this, "Terminating send " + this._uid + " to " + this._destination + " from " + this._destination.getSocketHandler() + " as we haven't heard from receiver in " + timeString + '.');
                                        this.sendAborted(11, "Haven't heard from you (receiver) in " + timeString);
                                        bl2 = false;
                                        break block44;
                                    } else {
                                        if (!logMINOR) continue;
                                        Logger.minor(this, "Ignoring timeout: timeAllSent=" + this.timeAllSent + " (" + (System.currentTimeMillis() - this.timeAllSent) + "), getNumSent=" + this.getNumSent() + '/' + this._prb.getNumPackets());
                                        continue;
                                    }
                                }
                                if (msg.getSpec().equals(DMT.missingPacketNotification)) {
                                    LinkedList missing = (LinkedList)msg.getObject("missing");
                                    Iterator i$ = missing.iterator();
                                    while (true) {
                                        if (!i$.hasNext()) continue block27;
                                        int packetNo = (Integer)i$.next();
                                        if (this._prb.isReceived(packetNo)) {
                                            Runnable runnable3 = this._senderThread;
                                            synchronized (runnable3) {
                                                if (this._unsent.contains(packetNo)) {
                                                    Logger.minor(this, "already to transmit packet #" + packetNo);
                                                } else {
                                                    this._unsent.addFirst(packetNo);
                                                    this.timeAllSent = -1L;
                                                    this._sentPackets.setBit(packetNo, false);
                                                    this._senderThread.notifyAll();
                                                }
                                                continue;
                                            }
                                        }
                                        if (!logMINOR) continue;
                                        Logger.minor(this, "receiver requested block #" + packetNo + " which is not received");
                                    }
                                }
                                if (msg.getSpec().equals(DMT.allReceived)) {
                                    long endTime2 = System.currentTimeMillis();
                                    if (logMINOR) {
                                        long transferTime = endTime2 - startTime;
                                        MedianMeanRunningAverage medianMeanRunningAverage = avgTimeTaken;
                                        synchronized (medianMeanRunningAverage) {
                                            avgTimeTaken.report(transferTime);
                                            Logger.minor(this, "Block send took " + transferTime + " : " + avgTimeTaken);
                                        }
                                    }
                                    bl = true;
                                    break block45;
                                }
                                if (msg.getSpec().equals(DMT.sendAborted)) {
                                    endTime2 = false;
                                    break block46;
                                }
                                Logger.error(this, "Transmitter received unknown message type: " + msg.getSpec().getName());
                            }
                        }
                        catch (NotConnectedException e) {
                            Logger.normal(this, "NotConnectedException in BlockTransfer.send():" + e);
                            boolean endTime2 = false;
                            Object var13_30 = null;
                            Runnable runnable4 = this._senderThread;
                            synchronized (runnable4) {
                                this._sendComplete = true;
                                this._senderThread.notifyAll();
                            }
                            if (myListener == null) return endTime2;
                            this._prb.removeListener(myListener);
                            return endTime2;
                        }
                        catch (AbortedException e) {
                            Logger.normal(this, "AbortedException in BlockTransfer.send():" + e);
                            try {
                                String desc = this._prb.getAbortDescription();
                                if (desc.indexOf("Upstream") < 0) {
                                    desc = "Upstream transfer failed: " + desc;
                                }
                                this.sendAborted(this._prb.getAbortReason(), desc);
                            }
                            catch (NotConnectedException gone) {
                                // empty catch block
                            }
                            boolean bl4 = false;
                            Object var13_31 = null;
                            Runnable runnable5 = this._senderThread;
                            synchronized (runnable5) {
                                this._sendComplete = true;
                                this._senderThread.notifyAll();
                            }
                            if (myListener == null) return bl4;
                            this._prb.removeListener(myListener);
                            return bl4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_32 = null;
                        Runnable runnable6 = this._senderThread;
                        synchronized (runnable6) {
                            this._sendComplete = true;
                            this._senderThread.notifyAll();
                        }
                        if (myListener == null) throw throwable;
                        this._prb.removeListener(myListener);
                        throw throwable;
                    }
                    synchronized (runnable) {
                        this._sendComplete = true;
                        this._senderThread.notifyAll();
                    }
                    if (myListener == null) return bl3;
                    this._prb.removeListener(myListener);
                    return bl3;
                }
                Object var13_27 = null;
                Runnable runnable = this._senderThread;
                synchronized (runnable) {
                    this._sendComplete = true;
                    this._senderThread.notifyAll();
                }
                if (myListener == null) return bl2;
                this._prb.removeListener(myListener);
                return bl2;
            }
            Object var13_28 = null;
            Runnable runnable = this._senderThread;
            synchronized (runnable) {
                this._sendComplete = true;
                this._senderThread.notifyAll();
            }
            if (myListener == null) return bl;
            this._prb.removeListener(myListener);
            return bl;
        }
        Object var13_29 = null;
        Runnable runnable = this._senderThread;
        synchronized (runnable) {
            this._sendComplete = true;
            this._senderThread.notifyAll();
        }
        if (myListener == null) return endTime2;
        this._prb.removeListener(myListener);
        return endTime2;
    }

    public int getNumSent() {
        int ret = 0;
        for (int x = 0; x < this._sentPackets.getSize(); ++x) {
            if (!this._sentPackets.bitAt(x)) continue;
            ++ret;
        }
        return ret;
    }

    public void sendAsync(final Executor executor) {
        executor.execute(new PrioRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BlockTransmitter blockTransmitter;
                try {
                    BlockTransmitter.this.asyncExitStatus = BlockTransmitter.this.send(executor);
                    Object var2_1 = null;
                    blockTransmitter = BlockTransmitter.this;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    BlockTransmitter blockTransmitter2 = BlockTransmitter.this;
                    synchronized (blockTransmitter2) {
                        BlockTransmitter.this.asyncExitStatusSet = true;
                        BlockTransmitter.this.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (blockTransmitter) {
                    BlockTransmitter.this.asyncExitStatusSet = true;
                    BlockTransmitter.this.notifyAll();
                }
            }

            public int getPriority() {
                return 7;
            }
        }, "BlockTransmitter:sendAsync() for " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAsyncExitStatus() {
        long deadline = System.currentTimeMillis() + 3600000L;
        BlockTransmitter blockTransmitter = this;
        synchronized (blockTransmitter) {
            while (!this.asyncExitStatusSet) {
                try {
                    long now = System.currentTimeMillis();
                    if (now >= deadline) {
                        throw new IllegalStateException("Waited more than 1 hour for transfer completion!");
                    }
                    this.wait(deadline - now);
                }
                catch (InterruptedException e) {}
            }
        }
        return this.asyncExitStatus;
    }

    public PeerContext getDestination() {
        return this._destination;
    }

    public String toString() {
        return "BlockTransmitter for " + this._uid + " to " + this._destination.shortToString();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
        avgTimeTaken = new MedianMeanRunningAverage();
    }
}

