/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageCore;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.comm.RetrievalException;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.node.Ticker;
import freenet.support.BitArray;
import freenet.support.Buffer;
import freenet.support.Logger;
import freenet.support.math.MedianMeanRunningAverage;
import java.util.HashMap;
import java.util.LinkedList;

public class BlockReceiver
implements AsyncMessageFilterCallback {
    public static final int RECEIPT_TIMEOUT = 30000;
    public static final int MAX_ROUND_TRIP_TIME = 30000;
    public static final int MAX_CONSECUTIVE_MISSING_PACKET_REPORTS = 4;
    public static final int MAX_SEND_INTERVAL = 500;
    public static final int CLEANUP_TIMEOUT = 5000;
    public static final int TOO_LONG_TIMEOUT = 15000;
    PartiallyReceivedBlock _prb;
    PeerContext _sender;
    long _uid;
    MessageCore _usm;
    HashMap<Integer, Long> _recentlyReportedMissingPackets = new HashMap();
    ByteCounter _ctr;
    Ticker _ticker;
    boolean sentAborted;
    private MessageFilter discardFilter;
    private long discardEndTime;
    private boolean senderAborted;
    boolean logMINOR = Logger.shouldLog(4, this);
    private static MedianMeanRunningAverage avgTimeTaken = new MedianMeanRunningAverage();

    public BlockReceiver(MessageCore usm, PeerContext sender, long uid, PartiallyReceivedBlock prb, ByteCounter ctr, Ticker ticker, boolean doTooLong) {
        this._sender = sender;
        this._prb = prb;
        this._uid = uid;
        this._usm = usm;
        this._ctr = ctr;
        this._ticker = ticker;
    }

    public void sendAborted(int reason, String desc) throws NotConnectedException {
        this._usm.send(this._sender, DMT.createSendAborted(this._uid, reason, desc), this._ctr);
        this.sentAborted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] receive() throws RetrievalException {
        Object object;
        long startTime = System.currentTimeMillis();
        int consecutiveMissingPacketReports = 0;
        try {
            try {
                MessageFilter mfPacketTransmit = MessageFilter.create().setTimeout(30000).setType(DMT.packetTransmit).setField("uid", this._uid).setSource(this._sender);
                MessageFilter mfAllSent = MessageFilter.create().setTimeout(30000).setType(DMT.allSent).setField("uid", this._uid).setSource(this._sender);
                MessageFilter mfSendAborted = MessageFilter.create().setTimeout(30000).setType(DMT.sendAborted).setField("uid", this._uid).setSource(this._sender);
                MessageFilter relevantMessages = mfPacketTransmit.or(mfAllSent.or(mfSendAborted));
                while (!this._prb.allReceived()) {
                    Message m1;
                    try {
                        m1 = this._usm.waitFor(relevantMessages, this._ctr);
                        if (!this._sender.isConnected()) {
                            throw new DisconnectedException();
                        }
                    }
                    catch (DisconnectedException e1) {
                        Logger.normal(this, "Disconnected during receive: " + this._uid + " from " + this._sender);
                        this._prb.abort(7, "Disconnected during receive");
                        throw new RetrievalException(7);
                    }
                    if (this.logMINOR) {
                        Logger.minor(this, "Received " + m1);
                    }
                    if (m1 != null && m1.getSpec().equals(DMT.sendAborted)) {
                        String desc = m1.getString("description");
                        if (desc.indexOf("Upstream") < 0) {
                            desc = "Upstream transmit error: " + desc;
                        }
                        this._prb.abort(m1.getInt("reason"), desc);
                        BlockReceiver blockReceiver = this;
                        synchronized (blockReceiver) {
                            this.senderAborted = true;
                            throw new RetrievalException(m1.getInt("reason"), desc);
                        }
                    }
                    if (m1 != null && m1.getSpec().equals(DMT.packetTransmit)) {
                        consecutiveMissingPacketReports = 0;
                        int packetNo = m1.getInt("packetNo");
                        BitArray sent = (BitArray)m1.getObject("sent");
                        Buffer data = (Buffer)m1.getObject("data");
                        this._prb.addPacket(packetNo, data);
                        this._recentlyReportedMissingPackets.remove(packetNo);
                        LinkedList<Integer> missing = new LinkedList<Integer>();
                        for (int x = 0; x < sent.getSize(); ++x) {
                            Long resendTime;
                            if (!sent.bitAt(x) || this._prb.isReceived(x) || (resendTime = this._recentlyReportedMissingPackets.get(x)) != null && System.currentTimeMillis() <= resendTime) continue;
                            long resendWait = System.currentTimeMillis() + (long)(30000 + this._recentlyReportedMissingPackets.size() * 500);
                            this._recentlyReportedMissingPackets.put(x, resendWait);
                            missing.add(x);
                        }
                        if (this.logMINOR) {
                            Logger.minor(this, "Missing: " + missing.size());
                        }
                        if (missing.size() > 0) {
                            Message mn = DMT.createMissingPacketNotification(this._uid, missing);
                            this._usm.send(this._sender, mn, this._ctr);
                            ++consecutiveMissingPacketReports;
                            if (missing.size() > 50) {
                                Logger.normal(this, "Excessive packet loss : " + mn);
                            }
                        }
                    }
                    if (m1 != null && !m1.getSpec().equals(DMT.allSent)) continue;
                    if (consecutiveMissingPacketReports >= 4) {
                        this._prb.abort(5, "Sender unresponsive to resend requests");
                        throw new RetrievalException(5, "Sender unresponsive to resend requests");
                    }
                    LinkedList<Integer> missing = new LinkedList<Integer>();
                    for (int x = 0; x < this._prb.getNumPackets(); ++x) {
                        if (this._prb.isReceived(x)) continue;
                        missing.add(x);
                    }
                    Message mn = DMT.createMissingPacketNotification(this._uid, missing);
                    this._usm.send(this._sender, mn, this._ctr);
                    ++consecutiveMissingPacketReports;
                    if (missing.size() <= 50) continue;
                    Logger.normal(this, "Sending large missingPacketNotification due to packet receiver timeout after 30000ms");
                }
                this._usm.send(this._sender, DMT.createAllReceived(this._uid), this._ctr);
                this.discardEndTime = System.currentTimeMillis() + 5000L;
                this.discardFilter = relevantMessages;
                this.maybeResetDiscardFilter();
                long endTime = System.currentTimeMillis();
                long transferTime = endTime - startTime;
                if (this.logMINOR) {
                    object = avgTimeTaken;
                    synchronized (object) {
                        avgTimeTaken.report(transferTime);
                        Logger.minor(this, "Block transfer took " + transferTime + "ms - average is " + avgTimeTaken);
                    }
                }
                object = this._prb.getBlock();
                Object var19_25 = null;
            }
            catch (NotConnectedException e) {
                throw new RetrievalException(7);
            }
            catch (AbortedException e) {
                Logger.error(this, "Caught in receive - probably a bug as receive sets it: " + e);
                throw new RetrievalException(0, "Aborted?");
            }
        }
        catch (Throwable throwable) {
            Object var19_26 = null;
            try {
                if (!this._prb.isAborted()) throw throwable;
                if (this.sentAborted) throw throwable;
                this.sendAborted(this._prb.getAbortReason(), this._prb.getAbortDescription());
                throw throwable;
            }
            catch (NotConnectedException e) {
                throw throwable;
            }
        }
        try {}
        catch (NotConnectedException e) {
            // empty catch block
            return object;
        }
        if (!this._prb.isAborted()) return object;
        if (this.sentAborted) return object;
        this.sendAborted(this._prb.getAbortReason(), this._prb.getAbortDescription());
        return object;
    }

    private void maybeResetDiscardFilter() {
        long timeleft = this.discardEndTime - System.currentTimeMillis();
        if (timeleft > 0L) {
            try {
                this.discardFilter.setTimeout((int)timeleft);
                this._usm.addAsyncFilter(this.discardFilter, this);
            }
            catch (DisconnectedException disconnectedException) {
                // empty catch block
            }
        }
    }

    public void onMatched(Message m) {
        if (this.logMINOR) {
            Logger.minor(this, "discarding message post-receive: " + m);
        }
        this.maybeResetDiscardFilter();
    }

    public boolean shouldTimeout() {
        return false;
    }

    public void onTimeout() {
    }

    public void onDisconnect(PeerContext ctx) {
    }

    public void onRestarted(PeerContext ctx) {
    }

    public synchronized boolean senderAborted() {
        return this.senderAborted;
    }
}

