/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.IncorrectTypeException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageType;
import freenet.io.comm.PeerContext;
import freenet.support.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class MessageFilter {
    public static final String VERSION = "$Id: MessageFilter.java,v 1.7 2005/08/25 17:28:19 amphibian Exp $";
    private boolean _matched;
    private PeerContext _droppedConnection;
    private MessageType _type;
    private HashMap<String, Object> _fields = new HashMap();
    private List<String> _fieldList = new LinkedList<String>();
    private PeerContext _source;
    private long _timeout;
    private boolean _timeoutFromWait = true;
    private int _initialTimeout;
    private MessageFilter _or;
    private Message _message;
    private long _oldBootID;
    private AsyncMessageFilterCallback _callback;
    private boolean _setTimeout = false;

    private MessageFilter() {
    }

    public static MessageFilter create() {
        return new MessageFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStartWaiting(boolean waitFor) {
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            if (waitFor && this._callback != null) {
                throw new IllegalStateException("Cannot wait on a MessageFilter with a callback!");
            }
            if (!this._setTimeout) {
                Logger.error(this, "No timeout set on filter " + this, new Exception("error"));
            }
            if (this._initialTimeout > 0 && this._timeoutFromWait) {
                this._timeout = System.currentTimeMillis() + (long)this._initialTimeout;
            }
        }
        if (this._or != null) {
            this._or.onStartWaiting(waitFor);
        }
    }

    public MessageFilter setTimeoutRelativeToCreation(boolean b) {
        this._timeoutFromWait = !b;
        return this;
    }

    public MessageFilter setTimeout(int timeout) {
        this._setTimeout = true;
        this._initialTimeout = timeout;
        this._timeout = System.currentTimeMillis() + (long)timeout;
        return this;
    }

    public MessageFilter setNoTimeout() {
        this._setTimeout = true;
        this._timeout = Long.MAX_VALUE;
        this._initialTimeout = 0;
        return this;
    }

    public MessageFilter setType(MessageType type) {
        this._type = type;
        return this;
    }

    public MessageFilter setSource(PeerContext source) {
        this._source = source;
        if (source != null) {
            this._oldBootID = source.getBootID();
        }
        return this;
    }

    public PeerContext getSource() {
        return this._source;
    }

    public MessageFilter setField(String fieldName, boolean value) {
        return this.setField(fieldName, (Object)value);
    }

    public MessageFilter setField(String fieldName, byte value) {
        return this.setField(fieldName, (Object)value);
    }

    public MessageFilter setField(String fieldName, short value) {
        return this.setField(fieldName, (Object)value);
    }

    public MessageFilter setField(String fieldName, int value) {
        return this.setField(fieldName, (Object)value);
    }

    public MessageFilter setField(String fieldName, long value) {
        return this.setField(fieldName, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageFilter setField(String fieldName, Object fieldValue) {
        if (this._type != null && !this._type.checkType(fieldName, fieldValue)) {
            throw new IncorrectTypeException("Got " + fieldValue.getClass() + ", expected " + this._type.typeOf(fieldName) + " for " + this._type.getName());
        }
        HashMap<String, Object> hashMap = this._fields;
        synchronized (hashMap) {
            if (this._fields.put(fieldName, fieldValue) == null) {
                this._fieldList.add(fieldName);
            }
        }
        return this;
    }

    public MessageFilter or(MessageFilter or) {
        if (or != null && this._or != null && or != this._or) {
            Logger.error(this, "or() replacement: " + this._or + " -> " + or, new Exception("error"));
        }
        this._or = or;
        return this;
    }

    public MessageFilter setAsyncCallback(AsyncMessageFilterCallback cb) {
        this._callback = cb;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(Message m) {
        if (this._or != null && this._or.match(m)) {
            return true;
        }
        if (this._type != null && !this._type.equals(m.getSpec())) {
            return false;
        }
        if (this._source != null && !this._source.equals(m.getSource())) {
            return false;
        }
        HashMap<String, Object> hashMap = this._fields;
        synchronized (hashMap) {
            for (String fieldName : this._fieldList) {
                if (!m.isSet(fieldName)) {
                    return false;
                }
                if (this._fields.get(fieldName).equals(m.getFromPayload(fieldName))) continue;
                return false;
            }
        }
        return !this.reallyTimedOut(System.currentTimeMillis());
    }

    public boolean matched() {
        return this._matched;
    }

    public PeerContext droppedConnection() {
        return this._droppedConnection;
    }

    boolean reallyTimedOut(long time) {
        if (this._callback != null && this._callback.shouldTimeout()) {
            this._timeout = -1L;
        }
        return this._timeout < time;
    }

    boolean timedOut(long time) {
        if (this._matched) {
            Logger.error(this, "Impossible: filter already matched in timedOut(): " + this, new Exception("error"));
            return true;
        }
        return this.reallyTimedOut(time);
    }

    public Message getMessage() {
        return this._message;
    }

    public synchronized void setMessage(Message message) {
        this._message = message;
        this._matched = this._message != null;
        this.notifyAll();
    }

    public int getInitialTimeout() {
        return this._initialTimeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public String toString() {
        return super.toString() + ":" + this._type.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMatched() {
        MessageFilter or;
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            this._matched = false;
            this._message = null;
            or = this._or;
        }
        if (or != null) {
            or.clearMatched();
        }
    }

    public void clearOr() {
        this._or = null;
    }

    public boolean matchesDroppedConnection(PeerContext ctx) {
        if (this._source == ctx) {
            return true;
        }
        if (this._or != null) {
            return this._or.matchesDroppedConnection(ctx);
        }
        return false;
    }

    public boolean matchesRestartedConnection(PeerContext ctx) {
        if (this._source == ctx) {
            return true;
        }
        if (this._or != null) {
            return this._or.matchesRestartedConnection(ctx);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDroppedConnection(PeerContext ctx) {
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            this._droppedConnection = ctx;
            this.notifyAll();
        }
        if (this._callback != null) {
            this._callback.onDisconnect(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRestartedConnection(PeerContext ctx) {
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            this._droppedConnection = ctx;
            this.notifyAll();
        }
        if (this._callback != null) {
            this._callback.onRestarted(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMatched() {
        AsyncMessageFilterCallback cb;
        Message msg;
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            msg = this._message;
            cb = this._callback;
            if (this._callback != null) {
                this.clearMatched();
            }
        }
        if (cb != null) {
            cb.onMatched(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimedOut() {
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            this.notifyAll();
        }
        if (this._callback != null) {
            this._callback.onTimeout();
        }
    }

    public boolean anyConnectionsDropped() {
        if (this._matched) {
            return false;
        }
        if (this._source != null) {
            if (!this._source.isConnected()) {
                return true;
            }
            if (this._source.getBootID() != this._oldBootID) {
                return true;
            }
        }
        if (this._or != null) {
            return this._or.anyConnectionsDropped();
        }
        return false;
    }
}

