/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Dispatcher;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PacketSocketHandler;
import freenet.io.comm.PeerContext;
import freenet.node.PeerNode;
import freenet.node.Ticker;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageCore {
    public static final String VERSION = "$Id: MessageCore.java,v 1.22 2005/08/25 17:28:19 amphibian Exp $";
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private Dispatcher _dispatcher;
    private final LinkedList<MessageFilter> _filters = new LinkedList();
    private final LinkedList<Message> _unclaimed = new LinkedList();
    private static final int MAX_UNMATCHED_FIFO_SIZE = 50000;
    private static final long MAX_UNCLAIMED_FIFO_ITEM_LIFETIME = 600000L;
    private static final int FILTER_REMOVE_TIME = 1000;
    private long startedTime;
    private final Vector<MessageFilter> _timedOutFilters = new Vector(32);

    public synchronized long getStartedTime() {
        return this.startedTime;
    }

    public Message decodeSingleMessage(byte[] data, int offset, int length, PeerContext peer, int overhead) {
        try {
            return Message.decodeMessageFromPacket(data, offset, length, peer, overhead);
        }
        catch (Throwable t) {
            Logger.error(this, "Could not decode packet: " + t, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final Ticker ticker) {
        MessageCore messageCore = this;
        synchronized (messageCore) {
            this.startedTime = System.currentTimeMillis();
        }
        ticker.queueTimedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        MessageCore.this.removeTimedOutFilters();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Failed to remove timed out filters: " + t, t);
                        Object var3_2 = null;
                        ticker.queueTimedJob(this, 1000L);
                    }
                    Object var3_1 = null;
                    ticker.queueTimedJob(this, 1000L);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    ticker.queueTimedJob(this, 1000L);
                    throw throwable;
                }
            }
        }, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimedOutFilters() {
        long tStart = System.currentTimeMillis() + 1L;
        if (logMINOR) {
            Logger.minor(this, "Removing timed out filters");
        }
        LinkedList<MessageFilter> linkedList = this._filters;
        synchronized (linkedList) {
            ListIterator i = this._filters.listIterator();
            while (i.hasNext()) {
                MessageFilter f = (MessageFilter)i.next();
                if (!f.timedOut(tStart)) continue;
                if (logMINOR) {
                    Logger.minor(this, "Removing " + f);
                }
                i.remove();
                this._timedOutFilters.add(f);
            }
        }
        for (MessageFilter f : this._timedOutFilters) {
            f.setMessage(null);
            f.onTimedOut();
        }
        this._timedOutFilters.clear();
        long tEnd = System.currentTimeMillis();
        if (tEnd - tStart > 50L) {
            if (tEnd - tStart > 3000L) {
                Logger.error(this, "removeTimedOutFilters took " + (tEnd - tStart) + "ms");
            } else if (logMINOR) {
                Logger.minor(this, "removeTimedOutFilters took " + (tEnd - tStart) + "ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFilters(Message m, PacketSocketHandler from) {
        long tEnd;
        long dT;
        MessageFilter f;
        ListIterator i;
        long tStart = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "checkFilters: " + m + " from " + m.getSource());
        }
        if (m.getSource() instanceof PeerNode) {
            ((PeerNode)m.getSource()).addToLocalNodeReceivedMessagesFromStatistic(m);
        }
        boolean matched = false;
        if (logMINOR && !m.getSpec().equals(DMT.packetTransmit)) {
            Logger.minor(this, "" + System.currentTimeMillis() % 60000L + ' ' + from + " <- " + m.getSource() + " : " + m);
        }
        MessageFilter match = null;
        LinkedList<MessageFilter> linkedList = this._filters;
        synchronized (linkedList) {
            i = this._filters.listIterator();
            while (i.hasNext()) {
                f = (MessageFilter)i.next();
                if (f.matched()) {
                    Logger.error(this, "removed pre-matched message filter found in _filters: " + f);
                    i.remove();
                    continue;
                }
                if (!f.match(m)) continue;
                matched = true;
                i.remove();
                match = f;
                if (!logMINOR) break;
                Logger.minor(this, "Matched: " + f);
                break;
            }
        }
        if (match != null) {
            match.setMessage(m);
            match.onMatched();
        }
        if (!matched && this._dispatcher != null) {
            try {
                if (logMINOR) {
                    Logger.minor(this, "Feeding to dispatcher: " + m);
                }
                matched = this._dispatcher.handleMessage(m);
            }
            catch (Throwable t) {
                Logger.error(this, "Dispatcher threw " + t, t);
            }
        }
        if (!matched) {
            if (logMINOR) {
                Logger.minor(this, "Unclaimed: " + m);
            }
            LinkedList<MessageFilter> t = this._filters;
            synchronized (t) {
                if (logMINOR) {
                    Logger.minor(this, "Rechecking filters and adding message");
                }
                i = this._filters.listIterator();
                while (i.hasNext()) {
                    f = (MessageFilter)i.next();
                    if (!f.match(m)) continue;
                    matched = true;
                    match = f;
                    i.remove();
                    if (!logMINOR) break;
                    Logger.minor(this, "Matched: " + f);
                    break;
                }
                if (!matched) {
                    while (this._unclaimed.size() > 50000) {
                        Message removed = this._unclaimed.removeFirst();
                        long messageLifeTime = System.currentTimeMillis() - removed.localInstantiationTime;
                        if (removed.getSource() instanceof PeerNode) {
                            Logger.normal(this, "Dropping unclaimed from " + removed.getSource().getPeer() + ", lived " + TimeUtil.formatTime(messageLifeTime, 2, true) + " (quantity)" + ": " + removed);
                            continue;
                        }
                        Logger.normal(this, "Dropping unclaimed, lived " + TimeUtil.formatTime(messageLifeTime, 2, true) + " (quantity)" + ": " + removed);
                    }
                    this._unclaimed.addLast(m);
                    if (logMINOR) {
                        Logger.minor(this, "Done");
                    }
                }
            }
            if (match != null) {
                match.setMessage(m);
                match.onMatched();
            }
        }
        if ((dT = (tEnd = System.currentTimeMillis()) - tStart) > 50L) {
            if (dT > 3000L) {
                Logger.error(this, "checkFilters took " + dT + "ms with unclaimedFIFOSize of " + this._unclaimed.size() + " for matched: " + matched);
            } else if (logMINOR) {
                Logger.minor(this, "checkFilters took " + dT + "ms with unclaimedFIFOSize of " + this._unclaimed.size() + " for matched: " + matched);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnect(PeerContext ctx) {
        ArrayList<MessageFilter> droppedFilters = null;
        LinkedList<MessageFilter> linkedList = this._filters;
        synchronized (linkedList) {
            ListIterator i = this._filters.listIterator();
            while (i.hasNext()) {
                MessageFilter f = (MessageFilter)i.next();
                if (!f.matchesDroppedConnection(ctx)) continue;
                if (droppedFilters == null) {
                    droppedFilters = new ArrayList<MessageFilter>();
                }
                droppedFilters.add(f);
                i.remove();
            }
        }
        if (droppedFilters != null) {
            for (MessageFilter mf : droppedFilters) {
                mf.onDroppedConnection(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRestart(PeerContext ctx) {
        ArrayList<MessageFilter> droppedFilters = null;
        LinkedList<MessageFilter> linkedList = this._filters;
        synchronized (linkedList) {
            ListIterator i = this._filters.listIterator();
            while (i.hasNext()) {
                MessageFilter f = (MessageFilter)i.next();
                if (!f.matchesRestartedConnection(ctx)) continue;
                if (droppedFilters == null) {
                    droppedFilters = new ArrayList<MessageFilter>();
                }
                droppedFilters.add(f);
                i.remove();
            }
        }
        if (droppedFilters != null) {
            for (MessageFilter mf : droppedFilters) {
                mf.onRestartedConnection(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncFilter(MessageFilter filter, AsyncMessageFilterCallback callback) throws DisconnectedException {
        filter.setAsyncCallback(callback);
        if (filter.matched()) {
            Logger.error(this, "addAsyncFilter() on a filter which is already matched: " + filter, new Exception("error"));
            filter.clearMatched();
        }
        filter.onStartWaiting(false);
        if (logMINOR) {
            Logger.minor(this, "Adding async filter " + filter + " for " + callback);
        }
        Message ret = null;
        if (filter.anyConnectionsDropped()) {
            throw new DisconnectedException();
        }
        long now = System.currentTimeMillis();
        long messageDropTime = now - 600000L;
        long messageLifeTime = 0L;
        LinkedList<MessageFilter> linkedList = this._filters;
        synchronized (linkedList) {
            block17: {
                if (filter.anyConnectionsDropped()) {
                    throw new DisconnectedException();
                }
                if (logMINOR) {
                    Logger.minor(this, "Checking _unclaimed");
                }
                ListIterator<MessageFilter> i = this._unclaimed.listIterator();
                while (i.hasNext()) {
                    Message m = (Message)i.next();
                    if (filter.match(m)) {
                        i.remove();
                        ret = m;
                        if (!logMINOR) break;
                        Logger.debug(this, "Matching from _unclaimed");
                        break;
                    }
                    if (m.localInstantiationTime >= messageDropTime) continue;
                    i.remove();
                    messageLifeTime = now - m.localInstantiationTime;
                    if (m.getSource() instanceof PeerNode) {
                        Logger.normal(this, "Dropping unclaimed from " + m.getSource().getPeer() + ", lived " + TimeUtil.formatTime(messageLifeTime, 2, true) + " (age)" + ": " + m);
                        continue;
                    }
                    Logger.normal(this, "Dropping unclaimed, lived " + TimeUtil.formatTime(messageLifeTime, 2, true) + " (age)" + ": " + m);
                }
                if (ret == null) {
                    MessageFilter mf;
                    if (logMINOR) {
                        Logger.minor(this, "Not in _unclaimed");
                    }
                    i = this._filters.listIterator();
                    do {
                        if (i.hasNext()) continue;
                        i.add(filter);
                        if (logMINOR) {
                            Logger.minor(this, "Added at end");
                        }
                        break block17;
                    } while ((mf = (MessageFilter)i.next()).getTimeout() <= filter.getTimeout());
                    i.previous();
                    i.add(filter);
                    if (logMINOR) {
                        Logger.minor(this, "Added in middle - mf timeout=" + mf.getTimeout() + " - my timeout=" + filter.getTimeout());
                    }
                }
            }
        }
        if (ret != null) {
            filter.setMessage(ret);
            filter.onMatched();
            filter.clearMatched();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message waitFor(MessageFilter filter, ByteCounter ctr) throws DisconnectedException {
        Object mf;
        if (logDEBUG) {
            Logger.debug(this, "Waiting for " + filter);
        }
        long startTime = System.currentTimeMillis();
        if (filter.matched()) {
            Logger.error(this, "waitFor() on a filter which is already matched: " + filter, new Exception("error"));
            filter.clearMatched();
        }
        filter.onStartWaiting(true);
        Message ret = null;
        if (filter.anyConnectionsDropped()) {
            filter.onDroppedConnection(filter.droppedConnection());
            throw new DisconnectedException();
        }
        long now = System.currentTimeMillis();
        long messageDropTime = now - 600000L;
        long messageLifeTime = 0L;
        LinkedList<MessageFilter> linkedList = this._filters;
        synchronized (linkedList) {
            block35: {
                if (logMINOR) {
                    Logger.minor(this, "Checking _unclaimed");
                }
                ListIterator<MessageFilter> i = this._unclaimed.listIterator();
                while (i.hasNext()) {
                    Message m = (Message)i.next();
                    if (filter.match(m)) {
                        i.remove();
                        ret = m;
                        if (!logMINOR) break;
                        Logger.minor(this, "Matching from _unclaimed");
                        break;
                    }
                    if (m.localInstantiationTime >= messageDropTime) continue;
                    i.remove();
                    messageLifeTime = now - m.localInstantiationTime;
                    if (m.getSource() instanceof PeerNode) {
                        Logger.normal(this, "Dropping unclaimed from " + m.getSource().getPeer() + ", lived " + TimeUtil.formatTime(messageLifeTime, 2, true) + " (age)" + ": " + m);
                        continue;
                    }
                    Logger.normal(this, "Dropping unclaimed, lived " + TimeUtil.formatTime(messageLifeTime, 2, true) + " (age)" + ": " + m);
                }
                if (ret == null) {
                    if (logMINOR) {
                        Logger.minor(this, "Not in _unclaimed");
                    }
                    i = this._filters.listIterator();
                    do {
                        if (i.hasNext()) continue;
                        i.add(filter);
                        if (logMINOR) {
                            Logger.minor(this, "Added at end");
                        }
                        break block35;
                    } while (((MessageFilter)(mf = (MessageFilter)i.next())).getTimeout() <= filter.getTimeout());
                    i.previous();
                    i.add(filter);
                    if (logMINOR) {
                        Logger.minor(this, "Added in middle - mf timeout=" + ((MessageFilter)mf).getTimeout() + " - my timeout=" + filter.getTimeout());
                    }
                }
            }
        }
        long tEnd = System.currentTimeMillis();
        if (tEnd - now > 50L) {
            if (tEnd - now > 3000L) {
                Logger.error(this, "waitFor _unclaimed iteration took " + (tEnd - now) + "ms with unclaimedFIFOSize of " + this._unclaimed.size() + " for ret of " + ret);
            } else if (logMINOR) {
                Logger.minor(this, "waitFor _unclaimed iteration took " + (tEnd - now) + "ms with unclaimedFIFOSize of " + this._unclaimed.size() + " for ret of " + ret);
            }
        }
        if (ret == null) {
            if (logMINOR) {
                Logger.minor(this, "Waiting...");
            }
            mf = filter;
            synchronized (mf) {
                try {
                    long wait;
                    while (!filter.matched() && filter.droppedConnection() == null && !filter.reallyTimedOut(now = System.currentTimeMillis()) && (wait = filter.getTimeout() - now) > 0L) {
                        filter.wait(wait);
                    }
                    if (filter.droppedConnection() != null) {
                        throw new DisconnectedException();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ret = filter.getMessage();
            }
            if (logDEBUG) {
                Logger.debug(this, "Returning " + ret + " from " + filter);
            }
        }
        if (!filter.matched()) {
            mf = this._filters;
            synchronized (mf) {
                this._filters.remove(filter);
            }
        }
        filter.setMessage(ret);
        filter.onMatched();
        filter.clearMatched();
        long endTime = System.currentTimeMillis();
        if (logDEBUG) {
            Logger.debug(this, "Returning in " + (endTime - startTime) + "ms");
        }
        if (ctr != null && ret != null) {
            ctr.receivedBytes(ret._receivedByteCount);
        }
        return ret;
    }

    public void send(PeerContext destination, Message m, ByteCounter ctr) throws NotConnectedException {
        if (m.getSpec().isInternalOnly()) {
            Logger.error(this, "Trying to send internal-only message " + m + " of spec " + m.getSpec(), new Exception("debug"));
            return;
        }
        destination.sendAsync(m, null, ctr);
    }

    public void setDispatcher(Dispatcher d) {
        this._dispatcher = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnclaimedFIFOSize() {
        LinkedList<MessageFilter> linkedList = this._filters;
        synchronized (linkedList) {
            return this._unclaimed.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getUnclaimedFIFOMessageCounts() {
        HashMap<String, Integer> messageCounts = new HashMap<String, Integer>();
        LinkedList<MessageFilter> linkedList = this._filters;
        synchronized (linkedList) {
            ListIterator i = this._unclaimed.listIterator();
            while (i.hasNext()) {
                Message m = (Message)i.next();
                String messageName = m.getSpec().getName();
                Integer messageCount = (Integer)messageCounts.get(messageName);
                if (messageCount == null) {
                    messageCounts.put(messageName, 1);
                    continue;
                }
                messageCount = messageCount + 1;
                messageCounts.put(messageName, messageCount);
            }
        }
        return messageCounts;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }
}

