/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.io.comm.IncorrectTypeException;
import freenet.io.comm.MessageType;
import freenet.io.comm.PeerContext;
import freenet.support.ByteBufferInputStream;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.Serializer;
import freenet.support.ShortBuffer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Message {
    public static final String VERSION = "$Id: Message.java,v 1.11 2005/09/15 18:16:04 amphibian Exp $";
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final MessageType _spec;
    private final WeakReference<? extends PeerContext> _sourceRef;
    private final boolean _internal;
    private final HashMap<String, Object> _payload = new HashMap(8);
    private List<Message> _subMessages;
    public final long localInstantiationTime = System.currentTimeMillis();
    final int _receivedByteCount;

    public static Message decodeMessageFromPacket(byte[] buf, int offset, int length, PeerContext peer, int overhead) {
        ByteBufferInputStream bb = new ByteBufferInputStream(buf, offset, length);
        return Message.decodeMessage(bb, peer, length + overhead, true, false);
    }

    private static Message decodeMessage(ByteBufferInputStream bb, PeerContext peer, int recvByteCount, boolean mayHaveSubMessages, boolean inSubMessage) {
        Message m;
        block22: {
            MessageType mspec;
            try {
                mspec = MessageType.getSpec(bb.readInt());
            }
            catch (IOException e1) {
                if (logDEBUG) {
                    Logger.debug(Message.class, "Failed to read message type: " + e1, e1);
                }
                return null;
            }
            if (mspec == null) {
                return null;
            }
            if (mspec.isInternalOnly()) {
                return null;
            }
            m = new Message(mspec, peer, recvByteCount);
            try {
                for (String name : mspec.getOrderedFields()) {
                    Class<?> type = mspec.getFields().get(name);
                    if (type.equals(LinkedList.class)) {
                        m.set(name, Serializer.readListFromDataInputStream(mspec.getLinkedListTypes().get(name), bb));
                        continue;
                    }
                    m.set(name, Serializer.readFromDataInputStream(type, bb));
                }
                if (!mayHaveSubMessages) break block22;
                while (bb.remaining() > 2) {
                    ByteBufferInputStream bb2;
                    try {
                        int size = bb.readUnsignedShort();
                        if (bb.remaining() < size) {
                            return m;
                        }
                        bb2 = bb.slice(size);
                    }
                    catch (EOFException e) {
                        if (logMINOR) {
                            Logger.minor(Message.class, "No submessages, returning: " + m);
                        }
                        return m;
                    }
                    try {
                        Message subMessage = Message.decodeMessage(bb2, peer, 0, false, true);
                        if (subMessage == null) {
                            return m;
                        }
                        if (logMINOR) {
                            Logger.minor(Message.class, "Adding submessage: " + subMessage);
                        }
                        m.addSubMessage(subMessage);
                    }
                    catch (Throwable t) {
                        Logger.error(Message.class, "Failed to read sub-message: " + t, t);
                    }
                }
            }
            catch (EOFException e) {
                String msg = peer.getPeer() + " sent a message packet that ends prematurely while deserialising " + mspec.getName();
                if (inSubMessage) {
                    Logger.minor(Message.class, msg + " in sub-message", (Throwable)e);
                } else {
                    Logger.error(Message.class, msg, e);
                }
                return null;
            }
            catch (IOException e) {
                Logger.error(Message.class, "Unexpected IOException: " + e + " reading from buffer stream", e);
                return null;
            }
        }
        if (logMINOR) {
            Logger.minor(Message.class, "Returning message: " + m);
        }
        return m;
    }

    public Message(MessageType spec) {
        this(spec, null, 0);
    }

    private Message(MessageType spec, PeerContext source, int recvByteCount) {
        this._spec = spec;
        if (source == null) {
            this._internal = true;
            this._sourceRef = null;
        } else {
            this._internal = false;
            this._sourceRef = source.getWeakRef();
        }
        this._receivedByteCount = recvByteCount;
    }

    public boolean getBoolean(String key) {
        return (Boolean)this._payload.get(key);
    }

    public byte getByte(String key) {
        return (Byte)this._payload.get(key);
    }

    public short getShort(String key) {
        return (Short)this._payload.get(key);
    }

    public int getInt(String key) {
        return (Integer)this._payload.get(key);
    }

    public long getLong(String key) {
        return (Long)this._payload.get(key);
    }

    public double getDouble(String key) {
        return (Double)this._payload.get(key);
    }

    public String getString(String key) {
        return (String)this._payload.get(key);
    }

    public Object getObject(String key) {
        return this._payload.get(key);
    }

    public void set(String key, boolean b) {
        this.set(key, (Object)b);
    }

    public void set(String key, byte b) {
        this.set(key, (Object)b);
    }

    public void set(String key, short s) {
        this.set(key, (Object)s);
    }

    public void set(String key, int i) {
        this.set(key, (Object)i);
    }

    public void set(String key, long l) {
        this.set(key, (Object)l);
    }

    public void set(String key, double d) {
        this.set(key, new Double(d));
    }

    public void set(String key, Object value) {
        if (!this._spec.checkType(key, value)) {
            if (value == null) {
                throw new IncorrectTypeException("Got null for " + key);
            }
            throw new IncorrectTypeException("Got " + value.getClass() + ", expected " + this._spec.typeOf(key));
        }
        this._payload.put(key, value);
    }

    public byte[] encodeToPacket(PeerContext destination) {
        return this.encodeToPacket(destination, true, false);
    }

    private byte[] encodeToPacket(PeerContext destination, boolean includeSubMessages, boolean isSubMessage) {
        if (logDEBUG) {
            Logger.debug(this, "My spec code: " + this._spec.getName().hashCode() + " for " + this._spec.getName());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(this._spec.getName().hashCode());
            for (String name : this._spec.getOrderedFields()) {
                Serializer.writeToDataOutputStream(this._payload.get(name), dos, destination);
            }
            dos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        if (this._subMessages != null && includeSubMessages) {
            for (int i = 0; i < this._subMessages.size(); ++i) {
                byte[] temp = this._subMessages.get(i).encodeToPacket(destination, false, true);
                try {
                    dos.writeShort(temp.length);
                    dos.write(temp);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalStateException(e.getMessage());
                }
            }
        }
        byte[] buf = baos.toByteArray();
        if (logDEBUG) {
            Logger.debug(this, "Length: " + buf.length + ", hash: " + Fields.hashCode(buf));
        }
        return buf;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(1000);
        String comma = "";
        ret.append(this._spec.getName()).append(" {");
        for (String name : this._spec.getFields().keySet()) {
            ret.append(comma);
            ret.append(name).append('=').append(this._payload.get(name));
            comma = ", ";
        }
        ret.append('}');
        return ret.toString();
    }

    public PeerContext getSource() {
        return this._sourceRef == null ? null : (PeerContext)this._sourceRef.get();
    }

    public boolean isInternal() {
        return this._internal;
    }

    public MessageType getSpec() {
        return this._spec;
    }

    public boolean isSet(String fieldName) {
        return this._payload.containsKey(fieldName);
    }

    public Object getFromPayload(String fieldName) throws FieldNotSetException {
        Object r = this._payload.get(fieldName);
        if (r == null) {
            throw new FieldNotSetException(fieldName + " not set");
        }
        return r;
    }

    public void setRoutedToNodeFields(long uid, double targetLocation, short htl, byte[] nodeIdentity) {
        this.set("uid", uid);
        this.set("targetLocation", targetLocation);
        this.set("hopsToLive", htl);
        this.set("nodeIdentity", new ShortBuffer(nodeIdentity));
    }

    public int receivedByteCount() {
        return this._receivedByteCount;
    }

    public void addSubMessage(Message subMessage) {
        if (this._subMessages == null) {
            this._subMessages = new ArrayList<Message>();
        }
        this._subMessages.add(subMessage);
    }

    public Message getSubMessage(MessageType t) {
        if (this._subMessages == null) {
            return null;
        }
        for (int i = 0; i < this._subMessages.size(); ++i) {
            Message m = this._subMessages.get(i);
            if (m.getSpec() != t) continue;
            return m;
        }
        return null;
    }

    public Message grabSubMessage(MessageType t) {
        if (this._subMessages == null) {
            return null;
        }
        for (int i = 0; i < this._subMessages.size(); ++i) {
            Message m = this._subMessages.get(i);
            if (m.getSpec() != t) continue;
            this._subMessages.remove(i);
            return m;
        }
        return null;
    }

    public long age() {
        return System.currentTimeMillis() - this.localInstantiationTime;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }

    public static class FieldNotSetException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public FieldNotSetException(String message) {
            super(message);
        }
    }
}

