/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.io.AddressIdentifier;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.transport.ip.HostnameSyntaxException;
import freenet.support.transport.ip.HostnameUtil;
import freenet.support.transport.ip.IPUtil;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class FreenetInetAddress {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final String hostname;
    private InetAddress _address;

    public FreenetInetAddress(DataInput dis) throws IOException {
        byte[] ba;
        int firstByte = dis.readUnsignedByte();
        if (firstByte == 255) {
            if (logMINOR) {
                Logger.minor(this, "New format IPv6 address");
            }
            ba = new byte[16];
            dis.readFully(ba);
        } else if (firstByte == 0) {
            if (logMINOR) {
                Logger.minor(this, "New format IPv4 address");
            }
            ba = new byte[4];
            dis.readFully(ba);
        } else {
            throw new IOException("Unknown type byte (old form? corrupt stream? too short/long prev field?): " + firstByte);
        }
        this._address = InetAddress.getByAddress(ba);
        String name = null;
        String s = dis.readUTF();
        if (s.length() > 0) {
            name = s;
        }
        this.hostname = name;
    }

    public FreenetInetAddress(DataInput dis, boolean checkHostnameOrIPSyntax) throws HostnameSyntaxException, IOException {
        byte[] ba;
        int firstByte = dis.readUnsignedByte();
        if (firstByte == 255) {
            if (logMINOR) {
                Logger.minor(this, "New format IPv6 address");
            }
            ba = new byte[16];
            dis.readFully(ba);
        } else if (firstByte == 0) {
            if (logMINOR) {
                Logger.minor(this, "New format IPv4 address");
            }
            ba = new byte[4];
            dis.readFully(ba);
        } else {
            ba = new byte[4];
            ba[0] = (byte)firstByte;
            dis.readFully(ba, 1, 3);
        }
        this._address = InetAddress.getByAddress(ba);
        String name = null;
        String s = dis.readUTF();
        if (s.length() > 0) {
            name = s;
        }
        this.hostname = name;
        if (checkHostnameOrIPSyntax && null != this.hostname && !HostnameUtil.isValidHostname(this.hostname, true)) {
            throw new HostnameSyntaxException();
        }
    }

    public FreenetInetAddress(InetAddress address) {
        this._address = address;
        this.hostname = null;
    }

    public FreenetInetAddress(String host, boolean allowUnknown) throws UnknownHostException {
        InetAddress addr = null;
        if (host != null) {
            if (host.startsWith("/")) {
                host = host.substring(1);
            }
            host = host.trim();
        }
        AddressIdentifier.AddressType addressType = AddressIdentifier.getAddressType(host);
        if (logDEBUG) {
            Logger.debug(this, "Address type of '" + host + "' appears to be '" + (Object)((Object)addressType) + '\'');
        }
        if (addressType != AddressIdentifier.AddressType.OTHER) {
            addr = InetAddress.getByName(host);
            if (logDEBUG) {
                Logger.debug(this, "host is '" + host + "' and addr.getHostAddress() is '" + addr.getHostAddress() + '\'');
            }
            if (addr != null) {
                host = null;
            } else {
                addr = null;
            }
        }
        if (addr == null && logDEBUG) {
            Logger.debug(this, '\'' + host + "' does not look like an IP address");
        }
        this._address = addr;
        this.hostname = host;
    }

    public FreenetInetAddress(String host, boolean allowUnknown, boolean checkHostnameOrIPSyntax) throws HostnameSyntaxException, UnknownHostException {
        InetAddress addr = null;
        if (host != null) {
            if (host.startsWith("/")) {
                host = host.substring(1);
            }
            host = host.trim();
        }
        AddressIdentifier.AddressType addressType = AddressIdentifier.getAddressType(host);
        if (logDEBUG) {
            Logger.debug(this, "Address type of '" + host + "' appears to be '" + (Object)((Object)addressType) + '\'');
        }
        if (addressType != AddressIdentifier.AddressType.OTHER) {
            try {
                addr = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                if (!allowUnknown) {
                    throw e;
                }
                addr = null;
            }
            if (logDEBUG) {
                Logger.debug(this, "host is '" + host + "' and addr.getHostAddress() is '" + (addr != null ? addr.getHostAddress() + '\'' : ""));
            }
            if (addr != null && addr.getHostAddress().equals(host)) {
                if (logDEBUG) {
                    Logger.debug(this, '\'' + host + "' looks like an IP address");
                }
                host = null;
            } else {
                addr = null;
            }
        }
        if (addr == null && logDEBUG) {
            Logger.debug(this, '\'' + host + "' does not look like an IP address");
        }
        this._address = addr;
        this.hostname = host;
        if (checkHostnameOrIPSyntax && null != this.hostname && !HostnameUtil.isValidHostname(this.hostname, true)) {
            throw new HostnameSyntaxException();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof FreenetInetAddress)) {
            return false;
        }
        FreenetInetAddress addr = (FreenetInetAddress)o;
        if (this.hostname != null) {
            if (addr.hostname == null) {
                return false;
            }
            if (!this.hostname.equalsIgnoreCase(addr.hostname)) {
                return false;
            }
            if (this._address != null && addr._address == null) {
                addr._address = this._address;
            }
            if (addr._address != null && this._address == null) {
                this._address = addr._address;
            }
            return addr._address == null || this._address == null || addr._address.equals(this._address);
        }
        if (addr.hostname != null) {
            return false;
        }
        return this._address.equals(addr._address);
    }

    public boolean strictEquals(FreenetInetAddress addr) {
        if (this.hostname != null) {
            if (addr.hostname == null) {
                return false;
            }
            if (!this.hostname.equalsIgnoreCase(addr.hostname)) {
                return false;
            }
            if (this._address != null && addr._address == null) {
                addr._address = this._address;
            }
            if (addr._address != null && this._address == null) {
                this._address = addr._address;
            }
            return addr._address == null || this._address == null || addr._address.equals(this._address);
        }
        return FreenetInetAddress.getHostName(this._address).equalsIgnoreCase(FreenetInetAddress.getHostName(addr._address));
    }

    public InetAddress getAddress() {
        return this.getAddress(true);
    }

    public InetAddress getAddress(boolean doDNSRequest) {
        if (this._address != null) {
            return this._address;
        }
        if (!doDNSRequest) {
            return null;
        }
        InetAddress addr = this.getHandshakeAddress();
        if (addr != null) {
            this._address = addr;
        }
        return addr;
    }

    public InetAddress getHandshakeAddress() {
        if (this._address != null && this.hostname == null) {
            if (logMINOR) {
                Logger.minor(this, "hostname is null, returning " + this._address);
            }
            return this._address;
        }
        if (logMINOR) {
            Logger.minor(this, "Looking up '" + this.hostname + "' in DNS", (Throwable)new Exception("debug"));
        }
        try {
            InetAddress addr = InetAddress.getByName(this.hostname);
            if (logMINOR) {
                Logger.minor(this, "Look up got '" + addr + '\'');
            }
            if (addr != null) {
                this._address = InetAddress.getByAddress(addr.getAddress());
                if (logMINOR) {
                    Logger.minor(this, "Setting address to " + this._address);
                }
            }
            return addr;
        }
        catch (UnknownHostException e) {
            if (logMINOR) {
                Logger.minor(this, "DNS said hostname '" + this.hostname + "' is an unknown host, returning null");
            }
            return null;
        }
    }

    public int hashCode() {
        if (this.hostname != null) {
            return this.hostname.hashCode();
        }
        return this._address.hashCode();
    }

    public String toString() {
        if (this.hostname != null) {
            return this.hostname;
        }
        return this._address.getHostAddress();
    }

    public String toStringPrefNumeric() {
        if (this._address != null) {
            return this._address.getHostAddress();
        }
        return this.hostname;
    }

    public void writeToDataOutputStream(DataOutputStream dos) throws IOException {
        InetAddress addr = this.getAddress();
        if (addr == null) {
            throw new UnknownHostException();
        }
        byte[] data = addr.getAddress();
        if (data.length == 4) {
            dos.write(0);
        } else {
            dos.write(255);
        }
        dos.write(data);
        if (this.hostname != null) {
            dos.writeUTF(this.hostname);
        } else {
            dos.writeUTF("");
        }
    }

    public static String getHostName(InetAddress primaryIPAddress) {
        if (primaryIPAddress == null) {
            return null;
        }
        String s = primaryIPAddress.toString();
        String addr = s.substring(0, s.indexOf(47)).trim();
        if (addr.length() == 0) {
            return primaryIPAddress.getHostAddress();
        }
        return addr;
    }

    public boolean isRealInternetAddress(boolean lookup, boolean defaultVal, boolean allowLocalAddresses) {
        InetAddress a;
        if (this._address != null) {
            return IPUtil.isValidAddress(this._address, allowLocalAddresses);
        }
        if (lookup && (a = this.getAddress()) != null) {
            return IPUtil.isValidAddress(a, allowLocalAddresses);
        }
        return defaultVal;
    }

    public FreenetInetAddress dropHostname() {
        if (this._address == null) {
            Logger.error(this, "Can't dropHostname() if no address!");
            return null;
        }
        if (this.hostname != null) {
            return new FreenetInetAddress(this._address);
        }
        return this;
    }

    public boolean hasHostnameNoIP() {
        return this.hostname != null && this.hostname.length() > 0 && this._address == null;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }
}

