/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.crypt.DSAPublicKey;
import freenet.io.comm.Message;
import freenet.io.comm.MessageType;
import freenet.io.comm.Peer;
import freenet.keys.Key;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.support.BitArray;
import freenet.support.Buffer;
import freenet.support.Fields;
import freenet.support.ShortBuffer;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMT {
    public static final String UID = "uid";
    public static final String SEND_TIME = "sendTime";
    public static final String EXTERNAL_ADDRESS = "externalAddress";
    public static final String BUILD = "build";
    public static final String FIRST_GOOD_BUILD = "firstGoodBuild";
    public static final String JOINER = "joiner";
    public static final String REASON = "reason";
    public static final String DESCRIPTION = "description";
    public static final String TTL = "ttl";
    public static final String PEERS = "peers";
    public static final String URL = "url";
    public static final String FORWARDERS = "forwarders";
    public static final String FILE_LENGTH = "fileLength";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String CHUNK_NO = "chunkNo";
    public static final String DATA_SOURCE = "dataSource";
    public static final String CACHED = "cached";
    public static final String PACKET_NO = "packetNo";
    public static final String DATA = "data";
    public static final String IS_HASH = "isHash";
    public static final String HASH = "hash";
    public static final String SENT = "sent";
    public static final String MISSING = "missing";
    public static final String KEY = "key";
    public static final String CHK_HEADER = "chkHeader";
    public static final String FREENET_URI = "freenetURI";
    public static final String FREENET_ROUTING_KEY = "freenetRoutingKey";
    public static final String TEST_CHK_HEADERS = "testCHKHeaders";
    public static final String HTL = "hopsToLive";
    public static final String SUCCESS = "success";
    public static final String FNP_SOURCE_PEERNODE = "sourcePeerNode";
    public static final String PING_SEQNO = "pingSequenceNumber";
    public static final String LOCATION = "location";
    public static final String NEAREST_LOCATION = "nearestLocation";
    public static final String BEST_LOCATION = "bestLocation";
    public static final String TARGET_LOCATION = "targetLocation";
    public static final String TYPE = "type";
    public static final String PAYLOAD = "payload";
    public static final String COUNTER = "counter";
    public static final String UNIQUE_COUNTER = "uniqueCounter";
    public static final String LINEAR_COUNTER = "linearCounter";
    public static final String RETURN_LOCATION = "returnLocation";
    public static final String BLOCK_HEADERS = "blockHeaders";
    public static final String DATA_INSERT_REJECTED_REASON = "dataInsertRejectedReason";
    public static final String STREAM_SEQNO = "streamSequenceNumber";
    public static final String IS_LOCAL = "isLocal";
    public static final String ANY_TIMED_OUT = "anyTimedOut";
    public static final String PUBKEY_HASH = "pubkeyHash";
    public static final String NEED_PUB_KEY = "needPubKey";
    public static final String PUBKEY_AS_BYTES = "pubkeyAsBytes";
    public static final String SOURCE_NODENAME = "sourceNodename";
    public static final String TARGET_NODENAME = "targetNodename";
    public static final String NODE_TO_NODE_MESSAGE_TYPE = "nodeToNodeMessageType";
    public static final String NODE_TO_NODE_MESSAGE_TEXT = "nodeToNodeMessageText";
    public static final String NODE_TO_NODE_MESSAGE_DATA = "nodeToNodeMessageData";
    public static final String NODE_UIDS = "nodeUIDs";
    public static final String MY_UID = "myUID";
    public static final String PEER_LOCATIONS = "peerLocations";
    public static final String PEER_UIDS = "peerUIDs";
    public static final String BEST_LOCATIONS_NOT_VISITED = "bestLocationsNotVisited";
    public static final String MAIN_JAR_KEY = "mainJarKey";
    public static final String EXTRA_JAR_KEY = "extraJarKey";
    public static final String REVOCATION_KEY = "revocationKey";
    public static final String HAVE_REVOCATION_KEY = "haveRevocationKey";
    public static final String MAIN_JAR_VERSION = "mainJarVersion";
    public static final String EXTRA_JAR_VERSION = "extJarVersion";
    public static final String REVOCATION_KEY_TIME_LAST_TRIED = "revocationKeyTimeLastTried";
    public static final String REVOCATION_KEY_DNF_COUNT = "revocationKeyDNFCount";
    public static final String REVOCATION_KEY_FILE_LENGTH = "revocationKeyFileLength";
    public static final String MAIN_JAR_FILE_LENGTH = "mainJarFileLength";
    public static final String EXTRA_JAR_FILE_LENGTH = "extraJarFileLength";
    public static final String PING_TIME = "pingTime";
    public static final String BWLIMIT_DELAY_TIME = "bwlimitDelayTime";
    public static final String TIME = "time";
    public static final String FORK_COUNT = "forkCount";
    public static final String TIME_LEFT = "timeLeft";
    public static final String PREV_UID = "prevUID";
    public static final String OPENNET_NODEREF = "opennetNoderef";
    public static final String REMOVE = "remove";
    public static final String PURGE = "purge";
    public static final String TRANSFER_UID = "transferUID";
    public static final String NODEREF_LENGTH = "noderefLength";
    public static final String PADDED_LENGTH = "paddedLength";
    public static final String TIME_DELTAS = "timeDeltas";
    public static final String HASHES = "hashes";
    public static final String REJECT_CODE = "rejectCode";
    public static final String ROUTING_ENABLED = "routingEnabled";
    public static final String OFFER_AUTHENTICATOR = "offerAuthenticator";
    public static final String DAWN_HTL = "dawnHtl";
    public static final String SECRET = "secret";
    public static final String NODE_IDENTITY = "nodeIdentity";
    public static final String UPTIME_PERCENT_48H = "uptimePercent48H";
    public static final short PRIORITY_NOW = 0;
    public static final short PRIORITY_HIGH = 1;
    public static final short PRIORITY_UNSPECIFIED = 2;
    public static final short PRIORITY_LOW = 3;
    public static final short PRIORITY_BULK_DATA = 4;
    public static final short NUM_PRIORITIES = 5;
    public static final MessageType packetTransmit = new MessageType("packetTransmit", 4){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.PACKET_NO, Integer.class);
            this.addField(DMT.SENT, BitArray.class);
            this.addField(DMT.DATA, Buffer.class);
        }
    };
    public static final MessageType allSent = new MessageType("allSent", 4){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType missingPacketNotification = new MessageType("missingPacketNotification", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addLinkedListField(DMT.MISSING, Integer.class);
        }
    };
    public static final MessageType allReceived = new MessageType("allReceived", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType sendAborted = new MessageType("sendAborted", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DESCRIPTION, String.class);
            this.addField(DMT.REASON, Integer.class);
        }
    };
    public static final MessageType FNPBulkPacketSend = new MessageType("FNPBulkPacketSend", 4){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.PACKET_NO, Integer.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPBulkSendAborted = new MessageType("FNPBulkSendAborted", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPBulkReceiveAborted = new MessageType("FNPBulkReceiveAborted", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPBulkReceivedAll = new MessageType("FNPBulkReceivedAll", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testTransferSend = new MessageType("testTransferSend", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testTransferSendAck = new MessageType("testTransferSendAck", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testSendCHK = new MessageType("testSendCHK", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FREENET_URI, String.class);
            this.addField(DMT.CHK_HEADER, Buffer.class);
        }
    };
    public static final MessageType testRequest = new MessageType("testRequest", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FREENET_ROUTING_KEY, Key.class);
            this.addField(DMT.HTL, Integer.class);
        }
    };
    public static final MessageType testDataNotFound = new MessageType("testDataNotFound", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testDataReply = new MessageType("testDataReply", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TEST_CHK_HEADERS, Buffer.class);
        }
    };
    public static final MessageType testSendCHKAck = new MessageType("testSendCHKAck", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FREENET_URI, String.class);
        }
    };
    public static final MessageType testDataReplyAck = new MessageType("testDataReplyAck", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testDataNotFoundAck = new MessageType("testDataNotFoundAck", 2){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType testReceiveCompleted = new MessageType("testReceiveCompleted", 2, true){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.SUCCESS, Boolean.class);
            this.addField(DMT.REASON, String.class);
        }
    };
    public static final MessageType testSendCompleted = new MessageType("testSendCompleted", 2, true){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.SUCCESS, Boolean.class);
            this.addField(DMT.REASON, String.class);
        }
    };
    public static final MessageType nodeToNodeMessage = new MessageType("nodeToNodeMessage", 3, false){
        {
            this.addField(DMT.NODE_TO_NODE_MESSAGE_TYPE, Integer.class);
            this.addField(DMT.NODE_TO_NODE_MESSAGE_DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPCHKDataRequest = new MessageType("FNPCHKDataRequest", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.FREENET_ROUTING_KEY, NodeCHK.class);
        }
    };
    public static final MessageType FNPSSKDataRequest = new MessageType("FNPSSKDataRequest", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.FREENET_ROUTING_KEY, NodeSSK.class);
            this.addField(DMT.NEED_PUB_KEY, Boolean.class);
        }
    };
    public static final MessageType FNPRejectedLoop = new MessageType("FNPRejectLoop", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPRejectedOverload = new MessageType("FNPRejectOverload", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.IS_LOCAL, Boolean.class);
        }
    };
    public static final MessageType FNPAccepted = new MessageType("FNPAccepted", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPDataNotFound = new MessageType("FNPDataNotFound", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPRecentlyFailed = new MessageType("FNPRecentlyFailed", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TIME_LEFT, Integer.class);
        }
    };
    public static final MessageType FNPCHKDataFound = new MessageType("FNPCHKDataFound", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPRouteNotFound = new MessageType("FNPRouteNotFound", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
        }
    };
    public static final MessageType FNPInsertRequest = new MessageType("FNPInsertRequest", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.FREENET_ROUTING_KEY, Key.class);
        }
    };
    public static final MessageType FNPInsertReply = new MessageType("FNPInsertReply", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPDataInsert = new MessageType("FNPDataInsert", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPInsertTransfersCompleted = new MessageType("FNPInsertTransfersCompleted", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.ANY_TIMED_OUT, Boolean.class);
        }
    };
    public static final MessageType FNPRejectedTimeout = new MessageType("FNPTooSlow", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPDataInsertRejected = new MessageType("FNPDataInsertRejected", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA_INSERT_REJECTED_REASON, Short.class);
        }
    };
    public static final short DATA_INSERT_REJECTED_VERIFY_FAILED = 1;
    public static final short DATA_INSERT_REJECTED_RECEIVE_FAILED = 2;
    public static final short DATA_INSERT_REJECTED_SSK_ERROR = 3;
    public static final MessageType FNPSSKInsertRequest = new MessageType("FNPSSKInsertRequest", 4){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.FREENET_ROUTING_KEY, NodeSSK.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
            this.addField(DMT.PUBKEY_HASH, ShortBuffer.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKInsertRequestNew = new MessageType("FNPSSKInsertRequestNew", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.FREENET_ROUTING_KEY, NodeSSK.class);
        }
    };
    public static final MessageType FNPSSKInsertRequestHeaders = new MessageType("FNPSSKInsertRequestHeaders", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKInsertRequestData = new MessageType("FNPSSKInsertRequestData", 4){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKDataFoundHeaders = new MessageType("FNPSSKDataFoundHeaders", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.BLOCK_HEADERS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKDataFoundData = new MessageType("FNPSSKDataFoundData", 4){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKAccepted = new MessageType("FNPSSKAccepted", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.NEED_PUB_KEY, Boolean.class);
        }
    };
    public static final MessageType FNPSSKPubKey = new MessageType("FNPSSKPubKey", 4){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.PUBKEY_AS_BYTES, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSSKPubKeyAccepted = new MessageType("FNPSSKPubKeyAccepted", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOpennetCompletedAck = new MessageType("FNPOpennetCompletedAck", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOpennetConnectDestinationNew = new MessageType("FNPConnectDestinationNew", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TRANSFER_UID, Long.class);
            this.addField(DMT.NODEREF_LENGTH, Integer.class);
            this.addField(DMT.PADDED_LENGTH, Integer.class);
        }
    };
    public static final MessageType FNPOpennetConnectReplyNew = new MessageType("FNPConnectReplyNew", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TRANSFER_UID, Long.class);
            this.addField(DMT.NODEREF_LENGTH, Integer.class);
            this.addField(DMT.PADDED_LENGTH, Integer.class);
        }
    };
    public static final MessageType FNPOpennetAnnounceRequest = new MessageType("FNPOpennetAnnounceRequest", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TRANSFER_UID, Long.class);
            this.addField(DMT.NODEREF_LENGTH, Integer.class);
            this.addField(DMT.PADDED_LENGTH, Integer.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.TARGET_LOCATION, Double.class);
        }
    };
    public static final MessageType FNPOpennetAnnounceReply = new MessageType("FNPOpennetAnnounceReply", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TRANSFER_UID, Long.class);
            this.addField(DMT.NODEREF_LENGTH, Integer.class);
            this.addField(DMT.PADDED_LENGTH, Integer.class);
        }
    };
    public static final MessageType FNPOpennetAnnounceCompleted = new MessageType("FNPOpennetAnnounceCompleted", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOpennetDisabled = new MessageType("FNPOpennetDisabled", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOpennetNoderefRejected = new MessageType("FNPOpennetNoderefRejected", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.REJECT_CODE, Integer.class);
        }
    };
    public static final int NODEREF_REJECTED_TOO_BIG = 1;
    public static final int NODEREF_REJECTED_REAL_BIGGER_THAN_PADDED = 2;
    public static final int NODEREF_REJECTED_TRANSFER_FAILED = 3;
    public static final int NODEREF_REJECTED_INVALID = 4;
    public static final MessageType FNPOpennetAnnounceNodeNotWanted = new MessageType("FNPOpennetAnnounceNodeNotWanted", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPOfferKey = new MessageType("FNPOfferKey", 3){
        {
            this.addField(DMT.KEY, Key.class);
            this.addField(DMT.OFFER_AUTHENTICATOR, ShortBuffer.class);
        }
    };
    public static final MessageType FNPGetOfferedKey = new MessageType("FNPGetOfferedKey", 1){
        {
            this.addField(DMT.KEY, Key.class);
            this.addField(DMT.OFFER_AUTHENTICATOR, ShortBuffer.class);
            this.addField(DMT.NEED_PUB_KEY, Boolean.class);
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPGetOfferedKeyInvalid = new MessageType("FNPGetOfferedKeyInvalid", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.REASON, Short.class);
        }
    };
    public static final short GET_OFFERED_KEY_REJECTED_BAD_AUTHENTICATOR = 1;
    public static final short GET_OFFERED_KEY_REJECTED_NO_KEY = 2;
    public static final MessageType FNPPing = new MessageType("FNPPing", 1){
        {
            this.addField(DMT.PING_SEQNO, Integer.class);
        }
    };
    public static final MessageType FNPPong = new MessageType("FNPPong", 1){
        {
            this.addField(DMT.PING_SEQNO, Integer.class);
        }
    };
    public static final MessageType FNPRHProbeReply = new MessageType("FNPRHProbeReply", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BEST_LOCATION, Double.class);
            this.addField(DMT.COUNTER, Short.class);
            this.addField(DMT.UNIQUE_COUNTER, Short.class);
            this.addField(DMT.LINEAR_COUNTER, Short.class);
        }
    };
    public static final MessageType FNPRHProbeRequest = new MessageType("FNPRHProbeRequest", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TARGET_LOCATION, Double.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BEST_LOCATION, Double.class);
            this.addField(DMT.HTL, Short.class);
        }
    };
    public static final MessageType FNPRHReturnSubMessage = new MessageType("FNPRHReturnSubMessage", 1){
        {
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BEST_LOCATION, Double.class);
            this.addField(DMT.COUNTER, Short.class);
            this.addField(DMT.UNIQUE_COUNTER, Short.class);
            this.addField(DMT.LINEAR_COUNTER, Short.class);
            this.addField(DMT.REASON, String.class);
        }
    };
    public static final MessageType FNPRHProbeTrace = new MessageType("FNPRHProbeTrace", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BEST_LOCATION, Double.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.COUNTER, Short.class);
            this.addField(DMT.UNIQUE_COUNTER, Short.class);
            this.addField(DMT.LOCATION, Double.class);
            this.addField(DMT.MY_UID, Long.class);
            this.addField(DMT.PEER_LOCATIONS, ShortBuffer.class);
            this.addField(DMT.PEER_UIDS, ShortBuffer.class);
            this.addField(DMT.FORK_COUNT, Short.class);
            this.addField(DMT.LINEAR_COUNTER, Short.class);
            this.addField(DMT.REASON, String.class);
            this.addField(DMT.PREV_UID, Long.class);
        }
    };
    public static final MessageType FNPProbeRequest = new MessageType("FNPProbeRequest", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TARGET_LOCATION, Double.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BEST_LOCATION, Double.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.COUNTER, Short.class);
            this.addField(DMT.LINEAR_COUNTER, Short.class);
        }
    };
    public static final MessageType FNPProbeTrace = new MessageType("FNPProbeTrace", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TARGET_LOCATION, Double.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BEST_LOCATION, Double.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.COUNTER, Short.class);
            this.addField(DMT.LOCATION, Double.class);
            this.addField(DMT.MY_UID, Long.class);
            this.addField(DMT.PEER_LOCATIONS, ShortBuffer.class);
            this.addField(DMT.PEER_UIDS, ShortBuffer.class);
            this.addField(DMT.FORK_COUNT, Short.class);
            this.addField(DMT.LINEAR_COUNTER, Short.class);
            this.addField(DMT.REASON, String.class);
            this.addField(DMT.PREV_UID, Long.class);
        }
    };
    public static final MessageType FNPProbeReply = new MessageType("FNPProbeReply", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TARGET_LOCATION, Double.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BEST_LOCATION, Double.class);
            this.addField(DMT.COUNTER, Short.class);
            this.addField(DMT.LINEAR_COUNTER, Short.class);
        }
    };
    public static final MessageType FNPProbeRejected = new MessageType("FNPProbeRejected", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.TARGET_LOCATION, Double.class);
            this.addField(DMT.NEAREST_LOCATION, Double.class);
            this.addField(DMT.BEST_LOCATION, Double.class);
            this.addField(DMT.HTL, Short.class);
            this.addField(DMT.COUNTER, Short.class);
            this.addField(DMT.REASON, Short.class);
            this.addField(DMT.LINEAR_COUNTER, Short.class);
        }
    };
    public static final short PROBE_REJECTED_LOOP = 1;
    public static final short PROBE_REJECTED_RNF = 2;
    public static final short PROBE_REJECTED_OVERLOAD = 3;
    public static final MessageType FNPSwapRequest = new MessageType("FNPSwapRequest", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HASH, ShortBuffer.class);
            this.addField(DMT.HTL, Integer.class);
        }
    };
    public static final MessageType FNPSwapRejected = new MessageType("FNPSwapRejected", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType FNPSwapReply = new MessageType("FNPSwapReply", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HASH, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSwapCommit = new MessageType("FNPSwapCommit", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPSwapComplete = new MessageType("FNPSwapComplete", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.DATA, ShortBuffer.class);
        }
    };
    public static final MessageType FNPLocChangeNotificationNew = new MessageType("FNPLocationChangeNotification2", 3){
        {
            this.addField(DMT.LOCATION, Double.class);
            this.addField(DMT.PEER_LOCATIONS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPRoutedPing = new MessageType("FNPRoutedPing", 3){
        {
            this.addRoutedToNodeMessageFields();
            this.addField(DMT.COUNTER, Integer.class);
        }
    };
    public static final MessageType FNPRoutedPong = new MessageType("FNPRoutedPong", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.COUNTER, Integer.class);
        }
    };
    public static final MessageType FNPSecretPing = new MessageType("FNPSecretPing", 3){
        {
            this.addRoutedToNodeMessageFields();
            this.addField(DMT.COUNTER, Integer.class);
            this.addField(DMT.DAWN_HTL, Short.class);
        }
    };
    public static final MessageType FNPSecretPong = new MessageType("FNPSecretPong", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.COUNTER, Integer.class);
            this.addField(DMT.SECRET, Long.class);
        }
    };
    public static final MessageType FNPStoreSecret = new MessageType("FNPStoreSecret", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.SECRET, Long.class);
        }
    };
    public static final MessageType FNPNetworkID = new MessageType("FNPNetworkID", 3){
        {
            this.addField(DMT.UID, Integer.class);
        }
    };
    public static final MessageType FNPRoutedRejected = new MessageType("FNPRoutedRejected", 2){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.HTL, Short.class);
        }
    };
    public static final MessageType FNPDetectedIPAddress = new MessageType("FNPDetectedIPAddress", 1){
        {
            this.addField(DMT.EXTERNAL_ADDRESS, Peer.class);
        }
    };
    public static final MessageType FNPTime = new MessageType("FNPTime", 1){
        {
            this.addField(DMT.TIME, Long.class);
        }
    };
    public static final MessageType FNPUptime = new MessageType("FNPUptime", 3){
        {
            this.addField(DMT.UPTIME_PERCENT_48H, Byte.class);
        }
    };
    public static final MessageType FNPSentPackets = new MessageType("FNPSentPackets", 1){
        {
            this.addField(DMT.TIME_DELTAS, ShortBuffer.class);
            this.addField(DMT.HASHES, ShortBuffer.class);
            this.addField(DMT.TIME, Long.class);
        }
    };
    public static final MessageType FNPVoid = new MessageType("FNPVoid", 3){};
    public static final MessageType FNPDisconnect = new MessageType("FNPDisconnect", 1){
        {
            this.addField(DMT.REMOVE, Boolean.class);
            this.addField(DMT.PURGE, Boolean.class);
            this.addField(DMT.NODE_TO_NODE_MESSAGE_TYPE, Integer.class);
            this.addField(DMT.NODE_TO_NODE_MESSAGE_DATA, ShortBuffer.class);
        }
    };
    public static final MessageType UOMAnnounce = new MessageType("UOMAnnounce", 3){
        {
            this.addField(DMT.MAIN_JAR_KEY, String.class);
            this.addField(DMT.EXTRA_JAR_KEY, String.class);
            this.addField(DMT.REVOCATION_KEY, String.class);
            this.addField(DMT.HAVE_REVOCATION_KEY, Boolean.class);
            this.addField(DMT.MAIN_JAR_VERSION, Long.class);
            this.addField(DMT.EXTRA_JAR_VERSION, Long.class);
            this.addField(DMT.REVOCATION_KEY_TIME_LAST_TRIED, Long.class);
            this.addField(DMT.REVOCATION_KEY_DNF_COUNT, Integer.class);
            this.addField(DMT.REVOCATION_KEY_FILE_LENGTH, Long.class);
            this.addField(DMT.MAIN_JAR_FILE_LENGTH, Long.class);
            this.addField(DMT.EXTRA_JAR_FILE_LENGTH, Long.class);
            this.addField(DMT.PING_TIME, Integer.class);
            this.addField(DMT.BWLIMIT_DELAY_TIME, Integer.class);
        }
    };
    public static final MessageType UOMRequestRevocation = new MessageType("UOMRequestRevocation", 1){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType UOMRequestMain = new MessageType("UOMRequestMain", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType UOMRequestExtra = new MessageType("UOMRequestExtra", 3){
        {
            this.addField(DMT.UID, Long.class);
        }
    };
    public static final MessageType UOMSendingRevocation = new MessageType("UOMSendingRevocation", 1){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FILE_LENGTH, Long.class);
            this.addField(DMT.REVOCATION_KEY, String.class);
        }
    };
    public static final MessageType UOMSendingMain = new MessageType("UOMSendingMain", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FILE_LENGTH, Long.class);
            this.addField(DMT.MAIN_JAR_KEY, String.class);
            this.addField(DMT.MAIN_JAR_VERSION, Integer.class);
        }
    };
    public static final MessageType UOMSendingExtra = new MessageType("UOMSendingExtra", 3){
        {
            this.addField(DMT.UID, Long.class);
            this.addField(DMT.FILE_LENGTH, Long.class);
            this.addField(DMT.EXTRA_JAR_KEY, String.class);
            this.addField(DMT.EXTRA_JAR_VERSION, Integer.class);
        }
    };
    public static final MessageType FNPSwapNodeUIDs = new MessageType("FNPSwapNodeUIDs", 2){
        {
            this.addField(DMT.NODE_UIDS, ShortBuffer.class);
        }
    };
    public static final MessageType FNPBestRoutesNotTaken = new MessageType("FNPBestRoutesNotTaken", 2){
        {
            this.addField(DMT.BEST_LOCATIONS_NOT_VISITED, ShortBuffer.class);
        }
    };
    public static final MessageType FNPRoutingStatus = new MessageType("FNPRoutingStatus", 1){
        {
            this.addField(DMT.ROUTING_ENABLED, Boolean.class);
        }
    };

    public static final Message createPacketTransmit(long uid, int packetNo, BitArray sent, Buffer data) {
        Message msg = new Message(packetTransmit);
        msg.set(UID, uid);
        msg.set(PACKET_NO, packetNo);
        msg.set(SENT, sent);
        msg.set(DATA, data);
        return msg;
    }

    public static int packetTransmitSize(int size, int _packets) {
        return size + 8 + 4 + BitArray.serializedLength(_packets) + 4;
    }

    public static int bulkPacketTransmitSize(int size) {
        return size + 8 + 4 + 4;
    }

    public static final Message createAllSent(long uid) {
        Message msg = new Message(allSent);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createMissingPacketNotification(long uid, LinkedList<Integer> missing) {
        Message msg = new Message(missingPacketNotification);
        msg.set(UID, uid);
        msg.set(MISSING, missing);
        return msg;
    }

    public static final Message createAllReceived(long uid) {
        Message msg = new Message(allReceived);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createSendAborted(long uid, int reason, String description) {
        Message msg = new Message(sendAborted);
        msg.set(UID, uid);
        msg.set(REASON, reason);
        msg.set(DESCRIPTION, description);
        return msg;
    }

    public static final Message createFNPBulkPacketSend(long uid, int packetNo, ShortBuffer data) {
        Message msg = new Message(FNPBulkPacketSend);
        msg.set(UID, uid);
        msg.set(PACKET_NO, packetNo);
        msg.set(DATA, data);
        return msg;
    }

    public static final Message createFNPBulkPacketSend(long uid, int packetNo, byte[] data) {
        return DMT.createFNPBulkPacketSend(uid, packetNo, new ShortBuffer(data));
    }

    public static final Message createFNPBulkSendAborted(long uid) {
        Message msg = new Message(FNPBulkSendAborted);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createFNPBulkReceiveAborted(long uid) {
        Message msg = new Message(FNPBulkReceiveAborted);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createFNPBulkReceivedAll(long uid) {
        Message msg = new Message(FNPBulkReceivedAll);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createTestTransferSend(long uid) {
        Message msg = new Message(testTransferSend);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createTestTransferSendAck(long uid) {
        Message msg = new Message(testTransferSendAck);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createTestSendCHK(long uid, String uri, Buffer header) {
        Message msg = new Message(testSendCHK);
        msg.set(UID, uid);
        msg.set(FREENET_URI, uri);
        msg.set(CHK_HEADER, header);
        return msg;
    }

    public static final Message createTestRequest(Key Key2, long id, int htl) {
        Message msg = new Message(testRequest);
        msg.set(UID, id);
        msg.set(FREENET_ROUTING_KEY, Key2);
        msg.set(HTL, htl);
        return msg;
    }

    public static final Message createTestDataNotFound(long uid) {
        Message msg = new Message(testDataNotFound);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createTestDataReply(long uid, byte[] headers) {
        Message msg = new Message(testDataReply);
        msg.set(UID, uid);
        msg.set(TEST_CHK_HEADERS, new Buffer(headers));
        return msg;
    }

    public static final Message createTestSendCHKAck(long uid, String key) {
        Message msg = new Message(testSendCHKAck);
        msg.set(UID, uid);
        msg.set(FREENET_URI, key);
        return msg;
    }

    public static final Message createTestDataReplyAck(long id) {
        Message msg = new Message(testDataReplyAck);
        msg.set(UID, id);
        return msg;
    }

    public static final Message createTestDataNotFoundAck(long id) {
        Message msg = new Message(testDataNotFoundAck);
        msg.set(UID, id);
        return msg;
    }

    public static final Message createTestReceiveCompleted(long id, boolean success, String reason) {
        Message msg = new Message(testReceiveCompleted);
        msg.set(UID, id);
        msg.set(SUCCESS, success);
        msg.set(REASON, reason);
        return msg;
    }

    public static final Message createTestSendCompleted(long id, boolean success, String reason) {
        Message msg = new Message(testSendCompleted);
        msg.set(UID, id);
        msg.set(SUCCESS, success);
        msg.set(REASON, reason);
        return msg;
    }

    public static final Message createNodeToNodeMessage(int type, byte[] data) {
        Message msg = new Message(nodeToNodeMessage);
        msg.set(NODE_TO_NODE_MESSAGE_TYPE, type);
        msg.set(NODE_TO_NODE_MESSAGE_DATA, new ShortBuffer(data));
        return msg;
    }

    public static final Message createFNPCHKDataRequest(long id, short htl, NodeCHK key) {
        Message msg = new Message(FNPCHKDataRequest);
        msg.set(UID, id);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, key);
        msg.set(NEAREST_LOCATION, 0.0);
        return msg;
    }

    public static final Message createFNPSSKDataRequest(long id, short htl, NodeSSK key, boolean needPubKey) {
        Message msg = new Message(FNPSSKDataRequest);
        msg.set(UID, id);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, key);
        msg.set(NEAREST_LOCATION, 0.0);
        msg.set(NEED_PUB_KEY, needPubKey);
        return msg;
    }

    public static final Message createFNPRejectedLoop(long id) {
        Message msg = new Message(FNPRejectedLoop);
        msg.set(UID, id);
        return msg;
    }

    public static final Message createFNPRejectedOverload(long id, boolean isLocal) {
        Message msg = new Message(FNPRejectedOverload);
        msg.set(UID, id);
        msg.set(IS_LOCAL, isLocal);
        return msg;
    }

    public static final Message createFNPAccepted(long id) {
        Message msg = new Message(FNPAccepted);
        msg.set(UID, id);
        return msg;
    }

    public static final Message createFNPDataNotFound(long id) {
        Message msg = new Message(FNPDataNotFound);
        msg.set(UID, id);
        return msg;
    }

    public static final Message createFNPRecentlyFailed(long id, int timeLeft) {
        Message msg = new Message(FNPRecentlyFailed);
        msg.set(UID, id);
        msg.set(TIME_LEFT, timeLeft);
        return msg;
    }

    public static final Message createFNPCHKDataFound(long id, byte[] buf) {
        Message msg = new Message(FNPCHKDataFound);
        msg.set(UID, id);
        msg.set(BLOCK_HEADERS, new ShortBuffer(buf));
        return msg;
    }

    public static final Message createFNPRouteNotFound(long id, short htl) {
        Message msg = new Message(FNPRouteNotFound);
        msg.set(UID, id);
        msg.set(HTL, htl);
        return msg;
    }

    public static final Message createFNPInsertRequest(long id, short htl, Key key) {
        Message msg = new Message(FNPInsertRequest);
        msg.set(UID, id);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, key);
        msg.set(NEAREST_LOCATION, 0.0);
        return msg;
    }

    public static final Message createFNPInsertReply(long id) {
        Message msg = new Message(FNPInsertReply);
        msg.set(UID, id);
        return msg;
    }

    public static final Message createFNPDataInsert(long uid, byte[] headers) {
        Message msg = new Message(FNPDataInsert);
        msg.set(UID, uid);
        msg.set(BLOCK_HEADERS, new ShortBuffer(headers));
        return msg;
    }

    public static final Message createFNPInsertTransfersCompleted(long uid, boolean anyTimedOut) {
        Message msg = new Message(FNPInsertTransfersCompleted);
        msg.set(UID, uid);
        msg.set(ANY_TIMED_OUT, anyTimedOut);
        return msg;
    }

    public static final Message createFNPRejectedTimeout(long uid) {
        Message msg = new Message(FNPRejectedTimeout);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createFNPDataInsertRejected(long uid, short reason) {
        Message msg = new Message(FNPDataInsertRejected);
        msg.set(UID, uid);
        msg.set(DATA_INSERT_REJECTED_REASON, reason);
        return msg;
    }

    public static final String getDataInsertRejectedReason(short reason) {
        if (reason == 1) {
            return "Verify failed";
        }
        if (reason == 2) {
            return "Receive failed";
        }
        if (reason == 3) {
            return "SSK error";
        }
        return "Unknown reason code: " + reason;
    }

    public static Message createFNPSSKInsertRequest(long uid, short htl, NodeSSK myKey, byte[] headers, byte[] data, byte[] pubKeyHash) {
        Message msg = new Message(FNPSSKInsertRequest);
        msg.set(UID, uid);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, myKey);
        msg.set(NEAREST_LOCATION, 0.0);
        msg.set(BLOCK_HEADERS, new ShortBuffer(headers));
        msg.set(PUBKEY_HASH, new ShortBuffer(pubKeyHash));
        msg.set(DATA, new ShortBuffer(data));
        return msg;
    }

    public static Message createFNPSSKInsertRequestNew(long uid, short htl, NodeSSK myKey) {
        Message msg = new Message(FNPSSKInsertRequestNew);
        msg.set(UID, uid);
        msg.set(HTL, htl);
        msg.set(FREENET_ROUTING_KEY, myKey);
        return msg;
    }

    public static final Message createFNPSSKInsertRequestHeaders(long uid, byte[] headers) {
        Message msg = new Message(FNPSSKInsertRequestHeaders);
        msg.set(UID, uid);
        msg.set(BLOCK_HEADERS, new ShortBuffer(headers));
        return msg;
    }

    public static final Message createFNPSSKInsertRequestData(long uid, byte[] data) {
        Message msg = new Message(FNPSSKInsertRequestData);
        msg.set(UID, uid);
        msg.set(DATA, new ShortBuffer(data));
        return msg;
    }

    public static Message createFNPSSKDataFoundHeaders(long uid, byte[] headers) {
        Message msg = new Message(FNPSSKDataFoundHeaders);
        msg.set(UID, uid);
        msg.set(BLOCK_HEADERS, new ShortBuffer(headers));
        return msg;
    }

    public static Message createFNPSSKDataFoundData(long uid, byte[] data) {
        Message msg = new Message(FNPSSKDataFoundData);
        msg.set(UID, uid);
        msg.set(DATA, new ShortBuffer(data));
        return msg;
    }

    public static final Message createFNPSSKAccepted(long uid, boolean needPubKey) {
        Message msg = new Message(FNPSSKAccepted);
        msg.set(UID, uid);
        msg.set(NEED_PUB_KEY, needPubKey);
        return msg;
    }

    public static Message createFNPSSKPubKey(long uid, DSAPublicKey pubkey) {
        Message msg = new Message(FNPSSKPubKey);
        msg.set(UID, uid);
        msg.set(PUBKEY_AS_BYTES, new ShortBuffer(pubkey.asPaddedBytes()));
        return msg;
    }

    public static Message createFNPSSKPubKeyAccepted(long uid) {
        Message msg = new Message(FNPSSKPubKeyAccepted);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOpennetCompletedAck(long uid) {
        Message msg = new Message(FNPOpennetCompletedAck);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOpennetConnectDestinationNew(long uid, long transferUID, int noderefLength, int paddedLength) {
        Message msg = new Message(FNPOpennetConnectDestinationNew);
        msg.set(UID, uid);
        msg.set(TRANSFER_UID, transferUID);
        msg.set(NODEREF_LENGTH, noderefLength);
        msg.set(PADDED_LENGTH, paddedLength);
        return msg;
    }

    public static Message createFNPOpennetConnectReplyNew(long uid, long transferUID, int noderefLength, int paddedLength) {
        Message msg = new Message(FNPOpennetConnectReplyNew);
        msg.set(UID, uid);
        msg.set(TRANSFER_UID, transferUID);
        msg.set(NODEREF_LENGTH, noderefLength);
        msg.set(PADDED_LENGTH, paddedLength);
        return msg;
    }

    public static Message createFNPOpennetAnnounceRequest(long uid, long transferUID, int noderefLength, int paddedLength, double target, short htl) {
        Message msg = new Message(FNPOpennetAnnounceRequest);
        msg.set(UID, uid);
        msg.set(TRANSFER_UID, transferUID);
        msg.set(NODEREF_LENGTH, noderefLength);
        msg.set(PADDED_LENGTH, paddedLength);
        msg.set(HTL, htl);
        msg.set(NEAREST_LOCATION, 0.0);
        msg.set(TARGET_LOCATION, target);
        return msg;
    }

    public static Message createFNPOpennetAnnounceReply(long uid, long transferUID, int noderefLength, int paddedLength) {
        Message msg = new Message(FNPOpennetAnnounceReply);
        msg.set(UID, uid);
        msg.set(TRANSFER_UID, transferUID);
        msg.set(NODEREF_LENGTH, noderefLength);
        msg.set(PADDED_LENGTH, paddedLength);
        return msg;
    }

    public static Message createFNPOpennetAnnounceCompleted(long uid) {
        Message msg = new Message(FNPOpennetAnnounceCompleted);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOpennetDisabled(long uid) {
        Message msg = new Message(FNPOpennetDisabled);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOpennetNoderefRejected(long uid, int rejectCode) {
        Message msg = new Message(FNPOpennetNoderefRejected);
        msg.set(UID, uid);
        msg.set(REJECT_CODE, rejectCode);
        return msg;
    }

    public static String getOpennetRejectedCode(int x) {
        switch (x) {
            case 1: {
                return "Too big";
            }
            case 2: {
                return "Real length bigger than padded length";
            }
            case 3: {
                return "Transfer failed";
            }
            case 4: {
                return "Invalid noderef";
            }
        }
        return "Unknown rejection code " + x;
    }

    public static Message createFNPOpennetAnnounceNodeNotWanted(long uid) {
        Message msg = new Message(FNPOpennetAnnounceNodeNotWanted);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPOfferKey(Key key, byte[] authenticator) {
        Message msg = new Message(FNPOfferKey);
        msg.set(KEY, key);
        msg.set(OFFER_AUTHENTICATOR, new ShortBuffer(authenticator));
        return msg;
    }

    public static Message createFNPGetOfferedKey(Key key, byte[] authenticator, boolean needPubkey, long uid) {
        Message msg = new Message(FNPGetOfferedKey);
        msg.set(KEY, key);
        msg.set(OFFER_AUTHENTICATOR, new ShortBuffer(authenticator));
        msg.set(NEED_PUB_KEY, needPubkey);
        msg.set(UID, uid);
        return msg;
    }

    public static Message createFNPGetOfferedKeyInvalid(long uid, short reason) {
        Message msg = new Message(FNPGetOfferedKeyInvalid);
        msg.set(UID, uid);
        msg.set(REASON, reason);
        return msg;
    }

    public static final Message createFNPPing(int seqNo) {
        Message msg = new Message(FNPPing);
        msg.set(PING_SEQNO, seqNo);
        return msg;
    }

    public static final Message createFNPPong(int seqNo) {
        Message msg = new Message(FNPPong);
        msg.set(PING_SEQNO, seqNo);
        return msg;
    }

    public static final Message createFNPRHProbeReply(long uid, double nearest, double best, short counter, short uniqueCounter, short linearCounter) {
        Message msg = new Message(FNPRHProbeReply);
        msg.set(UID, uid);
        msg.set(NEAREST_LOCATION, nearest);
        msg.set(BEST_LOCATION, best);
        msg.set(COUNTER, counter);
        msg.set(UNIQUE_COUNTER, uniqueCounter);
        msg.set(LINEAR_COUNTER, linearCounter);
        return msg;
    }

    public static final Message createFNPRHProbeRequest(long uid, double target, double nearest, double best, short htl) {
        Message msg = new Message(FNPRHProbeRequest);
        msg.set(UID, uid);
        msg.set(TARGET_LOCATION, target);
        msg.set(NEAREST_LOCATION, nearest);
        msg.set(BEST_LOCATION, best);
        msg.set(HTL, htl);
        return msg;
    }

    public static final Message createFNPRHReturnSubMessage(double nearest, double best, short counter, short uniqueCounter, short linearCounter, String reason) {
        Message msg = new Message(FNPRHReturnSubMessage);
        msg.set(NEAREST_LOCATION, nearest);
        msg.set(BEST_LOCATION, best);
        msg.set(COUNTER, counter);
        msg.set(UNIQUE_COUNTER, uniqueCounter);
        msg.set(LINEAR_COUNTER, linearCounter);
        msg.set(REASON, reason);
        return msg;
    }

    public static Message createFNPRHProbeTrace(long uid, double nearest, double best, short htl, short counter, short uniqueCounter, double myLoc, long swapIdentifier, double[] peerLocs, long[] peerUIDs, short forkCount, short linearCounter, String reason, long prevUID) {
        return DMT.createFNPRHProbeTrace(uid, nearest, best, htl, counter, uniqueCounter, myLoc, swapIdentifier, new ShortBuffer(Fields.doublesToBytes(peerLocs)), new ShortBuffer(Fields.longsToBytes(peerUIDs)), forkCount, linearCounter, reason, prevUID);
    }

    public static Message createFNPRHProbeTrace(long uid, double nearest, double best, short htl, short counter, short uniqueCounter, double myLoc, long swapIdentifier, ShortBuffer peerLocs, ShortBuffer peerUIDs, short forkCount, short linearCounter, String reason, long prevUID) {
        Message msg = new Message(FNPRHProbeTrace);
        msg.set(UID, uid);
        msg.set(NEAREST_LOCATION, nearest);
        msg.set(BEST_LOCATION, best);
        msg.set(HTL, htl);
        msg.set(COUNTER, counter);
        msg.set(UNIQUE_COUNTER, uniqueCounter);
        msg.set(LOCATION, myLoc);
        msg.set(MY_UID, swapIdentifier);
        msg.set(PEER_LOCATIONS, peerLocs);
        msg.set(PEER_UIDS, peerUIDs);
        msg.set(FORK_COUNT, forkCount);
        msg.set(LINEAR_COUNTER, linearCounter);
        msg.set(REASON, reason);
        msg.set(PREV_UID, prevUID);
        return msg;
    }

    public static final Message createFNPSwapRequest(long uid, byte[] buf, int htl) {
        Message msg = new Message(FNPSwapRequest);
        msg.set(UID, uid);
        msg.set(HASH, new ShortBuffer(buf));
        msg.set(HTL, htl);
        return msg;
    }

    public static final Message createFNPSwapRejected(long uid) {
        Message msg = new Message(FNPSwapRejected);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createFNPSwapReply(long uid, byte[] buf) {
        Message msg = new Message(FNPSwapReply);
        msg.set(UID, uid);
        msg.set(HASH, new ShortBuffer(buf));
        return msg;
    }

    public static final Message createFNPSwapCommit(long uid, byte[] buf) {
        Message msg = new Message(FNPSwapCommit);
        msg.set(UID, uid);
        msg.set(DATA, new ShortBuffer(buf));
        return msg;
    }

    public static final Message createFNPSwapComplete(long uid, byte[] buf) {
        Message msg = new Message(FNPSwapComplete);
        msg.set(UID, uid);
        msg.set(DATA, new ShortBuffer(buf));
        return msg;
    }

    public static final Message createFNPLocChangeNotificationNew(double myLocation, double[] locations) {
        Message msg = new Message(FNPLocChangeNotificationNew);
        ShortBuffer dst = new ShortBuffer(Fields.doublesToBytes(locations));
        msg.set(LOCATION, myLocation);
        msg.set(PEER_LOCATIONS, dst);
        return msg;
    }

    public static final Message createFNPRoutedPing(long uid, double targetLocation, short htl, int counter, byte[] nodeIdentity) {
        Message msg = new Message(FNPRoutedPing);
        msg.setRoutedToNodeFields(uid, targetLocation, htl, nodeIdentity);
        msg.set(COUNTER, counter);
        return msg;
    }

    public static final Message createFNPRoutedPong(long uid, int counter) {
        Message msg = new Message(FNPRoutedPong);
        msg.set(UID, uid);
        msg.set(COUNTER, counter);
        return msg;
    }

    public static final Message createFNPSecretPing(long uid, double targetLocation, short htl, short dawnHtl, int counter, byte[] nodeIdentity) {
        Message msg = new Message(FNPSecretPing);
        msg.setRoutedToNodeFields(uid, targetLocation, htl, nodeIdentity);
        msg.set(COUNTER, counter);
        msg.set(DAWN_HTL, dawnHtl);
        return msg;
    }

    public static final Message createFNPSecretPong(long uid, int counter, long secret) {
        Message msg = new Message(FNPSecretPong);
        msg.set(UID, uid);
        msg.set(COUNTER, counter);
        msg.set(SECRET, secret);
        return msg;
    }

    public static final Message createFNPStoreSecret(long uid, long secret) {
        Message msg = new Message(FNPStoreSecret);
        msg.set(UID, uid);
        msg.set(SECRET, secret);
        return msg;
    }

    public static final Message createFNPNetworkID(int id) {
        Message msg = new Message(FNPNetworkID);
        msg.set(UID, id);
        return msg;
    }

    public static final Message createFNPRoutedRejected(long uid, short htl) {
        Message msg = new Message(FNPRoutedRejected);
        msg.set(UID, uid);
        msg.set(HTL, htl);
        return msg;
    }

    public static final Message createFNPDetectedIPAddress(Peer peer) {
        Message msg = new Message(FNPDetectedIPAddress);
        msg.set(EXTERNAL_ADDRESS, peer);
        return msg;
    }

    public static final Message createFNPTime(long time) {
        Message msg = new Message(FNPTime);
        msg.set(TIME, time);
        return msg;
    }

    public static final Message createFNPUptime(byte uptimePercent) {
        Message msg = new Message(FNPUptime);
        msg.set(UPTIME_PERCENT_48H, uptimePercent);
        return msg;
    }

    public static final Message createFNPSentPackets(int[] timeDeltas, long[] hashes, long baseTime) {
        Message msg = new Message(FNPSentPackets);
        msg.set(TIME_DELTAS, new ShortBuffer(Fields.intsToBytes(timeDeltas)));
        msg.set(HASHES, new ShortBuffer(Fields.longsToBytes(hashes)));
        msg.set(TIME, baseTime);
        return msg;
    }

    public static final Message createFNPVoid() {
        Message msg = new Message(FNPVoid);
        return msg;
    }

    public static final Message createFNPDisconnect(boolean remove, boolean purge, int messageType, ShortBuffer messageData) {
        Message msg = new Message(FNPDisconnect);
        msg.set(REMOVE, remove);
        msg.set(PURGE, purge);
        msg.set(NODE_TO_NODE_MESSAGE_TYPE, messageType);
        msg.set(NODE_TO_NODE_MESSAGE_DATA, messageData);
        return msg;
    }

    public static final Message createUOMAnnounce(String mainKey, String extraKey, String revocationKey, boolean haveRevocation, long mainJarVersion, long extraJarVersion, long timeLastTriedRevocationFetch, int revocationDNFCount, long revocationKeyLength, long mainJarLength, long extraJarLength, int pingTime, int bwlimitDelayTime) {
        Message msg = new Message(UOMAnnounce);
        msg.set(MAIN_JAR_KEY, mainKey);
        msg.set(EXTRA_JAR_KEY, extraKey);
        msg.set(REVOCATION_KEY, revocationKey);
        msg.set(HAVE_REVOCATION_KEY, haveRevocation);
        msg.set(MAIN_JAR_VERSION, mainJarVersion);
        msg.set(EXTRA_JAR_VERSION, extraJarVersion);
        msg.set(REVOCATION_KEY_TIME_LAST_TRIED, timeLastTriedRevocationFetch);
        msg.set(REVOCATION_KEY_DNF_COUNT, revocationDNFCount);
        msg.set(REVOCATION_KEY_FILE_LENGTH, revocationKeyLength);
        msg.set(MAIN_JAR_FILE_LENGTH, mainJarLength);
        msg.set(EXTRA_JAR_FILE_LENGTH, extraJarLength);
        msg.set(PING_TIME, pingTime);
        msg.set(BWLIMIT_DELAY_TIME, bwlimitDelayTime);
        return msg;
    }

    public static final Message createUOMRequestRevocation(long uid) {
        Message msg = new Message(UOMRequestRevocation);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createUOMRequestMain(long uid) {
        Message msg = new Message(UOMRequestMain);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createUOMRequestExtra(long uid) {
        Message msg = new Message(UOMRequestExtra);
        msg.set(UID, uid);
        return msg;
    }

    public static final Message createUOMSendingRevocation(long uid, long length, String key) {
        Message msg = new Message(UOMSendingRevocation);
        msg.set(UID, uid);
        msg.set(FILE_LENGTH, length);
        msg.set(REVOCATION_KEY, key);
        return msg;
    }

    public static final Message createUOMSendingMain(long uid, long length, String key, int version) {
        Message msg = new Message(UOMSendingMain);
        msg.set(UID, uid);
        msg.set(FILE_LENGTH, length);
        msg.set(MAIN_JAR_KEY, key);
        msg.set(MAIN_JAR_VERSION, version);
        return msg;
    }

    public static final Message createUOMSendingExtra(long uid, long length, String key, int version) {
        Message msg = new Message(UOMSendingExtra);
        msg.set(UID, uid);
        msg.set(FILE_LENGTH, length);
        msg.set(EXTRA_JAR_KEY, key);
        msg.set(EXTRA_JAR_VERSION, version);
        return msg;
    }

    public static final Message createFNPSwapLocations(long[] uids) {
        Message msg = new Message(FNPSwapNodeUIDs);
        msg.set(NODE_UIDS, new ShortBuffer(Fields.longsToBytes(uids)));
        return msg;
    }

    public static final Message createFNPBestRoutesNotTaken(byte[] locs) {
        Message msg = new Message(FNPBestRoutesNotTaken);
        msg.set(BEST_LOCATIONS_NOT_VISITED, new ShortBuffer(locs));
        return msg;
    }

    public static final Message createFNPBestRoutesNotTaken(double[] locs) {
        return DMT.createFNPBestRoutesNotTaken(Fields.doublesToBytes(locs));
    }

    public static Message createFNPBestRoutesNotTaken(Double[] doubles) {
        double[] locs = new double[doubles.length];
        for (int i = 0; i < locs.length; ++i) {
            locs[i] = doubles[i];
        }
        return DMT.createFNPBestRoutesNotTaken(locs);
    }

    public static final Message createRoutingStatus(boolean routeRequests) {
        Message msg = new Message(FNPRoutingStatus);
        msg.set(ROUTING_ENABLED, routeRequests);
        return msg;
    }
}

