/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.crypt.SSL;
import freenet.io.NetworkInterface;
import freenet.support.Executor;
import freenet.support.Logger;
import java.io.IOException;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;

public class SSLNetworkInterface
extends NetworkInterface {
    private boolean requireClientAuthentication;

    public static NetworkInterface create(int port, String bindTo, String allowedHosts, Executor executor, boolean ignoreUnbindableIP6) throws IOException {
        SSLNetworkInterface iface = new SSLNetworkInterface(port, allowedHosts, executor);
        try {
            iface.setBindTo(bindTo, ignoreUnbindableIP6);
        }
        catch (IOException e) {
            try {
                iface.close();
            }
            catch (IOException e1) {
                Logger.error(NetworkInterface.class, "Caught " + e1 + " closing after catching " + e + " binding while constructing", e1);
            }
            throw e;
        }
        return iface;
    }

    protected SSLNetworkInterface(int port, String allowedHosts, Executor executor) throws IOException {
        super(port, allowedHosts, executor);
    }

    protected ServerSocket createServerSocket() throws IOException {
        ServerSocket serverSocket = SSL.createServerSocket();
        ((SSLServerSocket)serverSocket).setNeedClientAuth(this.requireClientAuthentication);
        return serverSocket;
    }

    public void setRequireClientAuthentication(boolean value) {
        this.requireClientAuthentication = value;
    }
}

