/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.AddressIdentifier;
import freenet.io.AllowedHosts;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.WrapperManager;

public class NetworkInterface
implements Closeable {
    private static volatile boolean logMINOR;
    public static final String DEFAULT_BIND_TO = "127.0.0.1,0:0:0:0:0:0:0:1";
    protected final Object syncObject = new Object();
    private final List<Acceptor> acceptors = new ArrayList<Acceptor>();
    protected final List<Socket> acceptedSockets = new ArrayList<Socket>();
    protected final AllowedHosts allowedHosts;
    private int timeout = 0;
    private final int port;
    private int runningAcceptors = 0;
    private volatile boolean shutdown = false;
    private final Executor executor;

    public static NetworkInterface create(int port, String bindTo, String allowedHosts, Executor executor, boolean ignoreUnbindableIP6) throws IOException {
        NetworkInterface iface = new NetworkInterface(port, allowedHosts, executor);
        try {
            iface.setBindTo(bindTo, ignoreUnbindableIP6);
        }
        catch (IOException e) {
            try {
                iface.close();
            }
            catch (IOException e1) {
                Logger.error(NetworkInterface.class, "Caught " + e1 + " closing after catching " + e + " binding while constructing", e1);
            }
            throw e;
        }
        return iface;
    }

    protected NetworkInterface(int port, String allowedHosts, Executor executor) throws IOException {
        this.port = port;
        this.allowedHosts = new AllowedHosts(allowedHosts);
        this.executor = executor;
    }

    protected ServerSocket createServerSocket() throws IOException {
        return new ServerSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBindTo(String bindTo, boolean ignoreUnbindableIP6) throws IOException {
        if (bindTo == null || bindTo.equals("")) {
            bindTo = DEFAULT_BIND_TO;
        }
        StringTokenizer bindToTokens = new StringTokenizer(bindTo, ",");
        ArrayList<String> bindToTokenList = new ArrayList<String>();
        while (bindToTokens.hasMoreTokens()) {
            bindToTokenList.add(bindToTokens.nextToken().trim());
        }
        int acceptorCount = this.acceptors.size();
        for (int acceptorIndex = 0; acceptorIndex < acceptorCount; ++acceptorIndex) {
            Acceptor acceptor = this.acceptors.get(acceptorIndex);
            try {
                acceptor.close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Object acceptorIndex = this.syncObject;
        synchronized (acceptorIndex) {
            while (this.runningAcceptors > 0) {
                try {
                    this.syncObject.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        this.acceptors.clear();
        for (int serverSocketIndex = 0; serverSocketIndex < bindToTokenList.size(); ++serverSocketIndex) {
            ServerSocket serverSocket = this.createServerSocket();
            InetSocketAddress addr = null;
            try {
                addr = new InetSocketAddress((String)bindToTokenList.get(serverSocketIndex), this.port);
                serverSocket.setReuseAddress(true);
                serverSocket.bind(addr);
            }
            catch (SocketException e) {
                if (ignoreUnbindableIP6 && addr != null && addr.getAddress() instanceof Inet6Address) continue;
                throw e;
            }
            Acceptor acceptor = new Acceptor(serverSocket);
            this.acceptors.add(acceptor);
        }
        this.setSoTimeout(this.timeout);
        Object object = this.syncObject;
        synchronized (object) {
            for (Acceptor acceptor : this.acceptors) {
                this.executor.execute(acceptor, "Network Interface Acceptor for " + acceptor.serverSocket);
            }
        }
    }

    public void setAllowedHosts(String allowedHosts) {
        this.allowedHosts.setAllowedHosts(allowedHosts);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        for (Acceptor acceptor : this.acceptors) {
            acceptor.setSoTimeout(timeout);
        }
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() {
        Object object = this.syncObject;
        synchronized (object) {
            while (this.acceptedSockets.size() == 0) {
                if (this.shutdown) {
                    return null;
                }
                if (WrapperManager.hasShutdownHookBeenTriggered()) {
                    return null;
                }
                if (this.acceptors.size() == 0) {
                    return null;
                }
                try {
                    this.syncObject.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.timeout <= 0 || this.acceptedSockets.size() != 0) continue;
                return null;
            }
            return this.acceptedSockets.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        IOException exception = null;
        this.shutdown = true;
        for (Acceptor acceptor : this.acceptors) {
            try {
                acceptor.close();
            }
            catch (IOException ioe1) {
                exception = ioe1;
            }
        }
        Object object = this.syncObject;
        synchronized (object) {
            this.syncObject.notifyAll();
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptorStopped() {
        Object object = this.syncObject;
        synchronized (object) {
            --this.runningAcceptors;
            this.syncObject.notifyAll();
        }
    }

    public String getAllowedHosts() {
        return this.allowedHosts.getAllowedHosts();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    private class Acceptor
    implements Runnable {
        private final ServerSocket serverSocket;
        private boolean closed = false;

        public Acceptor(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void setSoTimeout(int timeout) throws SocketException {
            this.serverSocket.setSoTimeout(timeout);
        }

        public void close() throws IOException {
            this.closed = true;
            this.serverSocket.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger.OSThread.logPID(this);
            while (!this.closed) {
                try {
                    AddressIdentifier.AddressType clientAddressType;
                    Socket clientSocket = this.serverSocket.accept();
                    InetAddress clientAddress = clientSocket.getInetAddress();
                    if (logMINOR) {
                        Logger.minor(Acceptor.class, "Connection from " + clientAddress);
                    }
                    if (NetworkInterface.this.allowedHosts.allowed(clientAddressType = AddressIdentifier.getAddressType(clientAddress.getHostAddress()), clientAddress)) {
                        Object object = NetworkInterface.this.syncObject;
                        synchronized (object) {
                            NetworkInterface.this.acceptedSockets.add(clientSocket);
                            NetworkInterface.this.syncObject.notifyAll();
                            continue;
                        }
                    }
                    try {
                        clientSocket.close();
                    }
                    catch (IOException ioe1) {
                        // empty catch block
                    }
                    Logger.normal(Acceptor.class, "Denied connection to " + clientAddress);
                }
                catch (SocketTimeoutException ste1) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Timeout");
                }
                catch (IOException ioe1) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Caught " + ioe1);
                }
            }
            NetworkInterface.this.acceptorStopped();
        }
    }
}

