/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.node.FSParseException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;

public class AddressTrackerItem {
    private long timeFirstReceivedPacket;
    private long timeFirstSentPacket;
    private long timeDefinitelyNoPacketsReceived;
    private long timeDefinitelyNoPacketsSent;
    private long timeLastReceivedPacket;
    private long timeLastSentPacket;
    private long packetsSent;
    private long packetsReceived;
    public static final int TRACK_GAPS = 5;
    private long[] gapLengths;
    private long[] gapLengthRecvTimes;
    private static final long GAP_THRESHOLD = 301000L;
    static final boolean INCLUDE_RECEIVED_PACKETS = true;

    public AddressTrackerItem(long timeDefinitelyNoPacketsReceived, long timeDefinitelyNoPacketsSent) {
        this.timeFirstReceivedPacket = -1L;
        this.timeFirstSentPacket = -1L;
        this.timeLastReceivedPacket = -1L;
        this.timeLastSentPacket = -1L;
        this.packetsSent = 0L;
        this.packetsReceived = 0L;
        this.timeDefinitelyNoPacketsReceived = timeDefinitelyNoPacketsReceived;
        this.timeDefinitelyNoPacketsSent = timeDefinitelyNoPacketsSent;
        this.gapLengths = new long[5];
        this.gapLengthRecvTimes = new long[5];
    }

    public AddressTrackerItem(SimpleFieldSet fs) throws FSParseException {
        this.timeFirstReceivedPacket = fs.getLong("TimeFirstReceivedPacket");
        this.timeFirstSentPacket = fs.getLong("TimeFirstSentPacket");
        this.timeDefinitelyNoPacketsSent = fs.getLong("TimeDefinitelyNoPacketsSent");
        this.timeDefinitelyNoPacketsReceived = fs.getLong("TimeDefinitelyNoPacketsReceived");
        this.timeLastReceivedPacket = fs.getLong("TimeLastReceivedPacket");
        this.timeLastSentPacket = fs.getLong("TimeLastSentPacket");
        this.packetsSent = fs.getLong("PacketsSent");
        this.packetsReceived = fs.getLong("PacketsReceived");
        SimpleFieldSet gaps = fs.getSubset("Gaps");
        this.gapLengths = new long[5];
        this.gapLengthRecvTimes = new long[5];
        for (int i = 0; i < 5; ++i) {
            SimpleFieldSet gap = gaps.subset(Integer.toString(i));
            if (gap == null) {
                Logger.normal(this, "No more gaps at i=" + i + " - TRACK_GAPS changed??");
                break;
            }
            this.gapLengths[i] = gap.getLong("Length");
            this.gapLengthRecvTimes[i] = gap.getLong("Received");
        }
    }

    public synchronized void sentPacket(long now) {
        ++this.packetsSent;
        if (this.timeFirstSentPacket < 0L) {
            this.timeFirstSentPacket = now;
        }
        this.timeLastSentPacket = now;
    }

    public synchronized void receivedPacket(long now) {
        ++this.packetsReceived;
        if (this.timeFirstReceivedPacket < 0L) {
            this.timeFirstReceivedPacket = now;
        }
        long oldTimeLastReceivedPacket = this.timeLastReceivedPacket;
        this.timeLastReceivedPacket = now;
        long startTime = this.timeLastSentPacket;
        startTime = Math.max(startTime, this.timeDefinitelyNoPacketsSent);
        startTime = Math.max(startTime, oldTimeLastReceivedPacket);
        if ((startTime = Math.max(startTime, this.timeDefinitelyNoPacketsReceived)) <= 0L) {
            return;
        }
        if (now - startTime > 301000L) {
            if (this.timeLastSentPacket >= this.gapLengthRecvTimes[0]) {
                for (int i = 4; i >= 1; --i) {
                    this.gapLengths[i] = this.gapLengths[i - 1];
                    this.gapLengthRecvTimes[i] = this.gapLengthRecvTimes[i - 1];
                }
            }
            this.gapLengths[0] = now - startTime;
            this.gapLengthRecvTimes[0] = now;
        }
    }

    public synchronized boolean hasLongTunnel(long horizon) {
        return this.gapLengthRecvTimes[0] > System.currentTimeMillis() - horizon;
    }

    public long longestGap(long horizon, long now) {
        long longestGap = 0L;
        for (int i = 0; i < 5; ++i) {
            if (this.gapLengthRecvTimes[0] < now - horizon) continue;
            longestGap = Math.max(longestGap, this.gapLengths[i]);
        }
        return longestGap;
    }

    public synchronized Gap[] getGaps() {
        Gap[] gaps = new Gap[5];
        for (int i = 0; i < 5; ++i) {
            gaps[i] = new Gap(this.gapLengths[i], this.gapLengthRecvTimes[i]);
        }
        return gaps;
    }

    public synchronized long firstReceivedPacket() {
        return this.timeFirstReceivedPacket;
    }

    public synchronized long firstSentPacket() {
        return this.timeFirstSentPacket;
    }

    public synchronized long lastReceivedPacket() {
        return this.timeLastReceivedPacket;
    }

    public synchronized long lastSentPacket() {
        return this.timeLastSentPacket;
    }

    public synchronized long timeDefinitelyNoPacketsSent() {
        return this.timeDefinitelyNoPacketsSent;
    }

    public synchronized long timeDefinitelyNoPacketsReceived() {
        return this.timeDefinitelyNoPacketsReceived;
    }

    public synchronized long packetsSent() {
        return this.packetsSent;
    }

    public synchronized long packetsReceived() {
        return this.packetsReceived;
    }

    public synchronized boolean weSentFirst() {
        if (this.timeFirstReceivedPacket == -1L) {
            return true;
        }
        if (this.timeFirstSentPacket == -1L) {
            return false;
        }
        return this.timeFirstSentPacket < this.timeFirstReceivedPacket;
    }

    public synchronized long timeFromStartupToFirstSentPacket() {
        if (this.packetsSent == 0L) {
            return -1L;
        }
        return this.timeFirstSentPacket - this.timeDefinitelyNoPacketsSent;
    }

    public synchronized long timeFromStartupToFirstReceivedPacket() {
        if (this.packetsReceived == 0L) {
            return -1L;
        }
        return this.timeFirstReceivedPacket - this.timeDefinitelyNoPacketsReceived;
    }

    public SimpleFieldSet toFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("TimeFirstReceivedPacket", this.timeFirstReceivedPacket);
        fs.put("TimeFirstSentPacket", this.timeFirstSentPacket);
        fs.put("TimeDefinitelyNoPacketsSent", this.timeDefinitelyNoPacketsSent);
        fs.put("TimeDefinitelyNoPacketsReceived", this.timeDefinitelyNoPacketsReceived);
        fs.put("TimeLastReceivedPacket", this.timeLastReceivedPacket);
        fs.put("TimeLastSentPacket", this.timeLastSentPacket);
        fs.put("PacketsSent", this.packetsSent);
        fs.put("PacketsReceived", this.packetsReceived);
        SimpleFieldSet gaps = new SimpleFieldSet(true);
        for (int i = 0; i < 5; ++i) {
            SimpleFieldSet gap = new SimpleFieldSet(true);
            gap.put("Length", this.gapLengths[i]);
            gap.put("Received", this.gapLengthRecvTimes[i]);
            gaps.put(Integer.toString(i), gap);
        }
        fs.put("Gaps", gaps);
        return fs;
    }

    public static class Gap {
        public final long gapLength;
        public final long receivedPacketAt;

        Gap(long gapLength, long receivedPacketAt) {
            this.gapLength = gapLength;
            this.receivedPacketAt = receivedPacketAt;
        }
    }
}

