/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.InetAddressAddressTrackerItem;
import freenet.io.PeerAddressTrackerItem;
import freenet.io.comm.Peer;
import freenet.node.FSParseException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;

public class AddressTracker {
    private final HashMap<Peer, PeerAddressTrackerItem> peerTrackers;
    private final HashMap<InetAddress, InetAddressAddressTrackerItem> ipTrackers;
    static final int MAX_ITEMS = 1000;
    private long timeDefinitelyNoPacketsReceived;
    private long timeDefinitelyNoPacketsSent;
    private long brokenTime;
    public static final int DEFINITELY_PORT_FORWARDED = 2;
    public static final int MAYBE_PORT_FORWARDED = 1;
    public static final int MAYBE_NATED = -1;
    public static final int DEFINITELY_NATED = -2;
    public static final int DONT_KNOW = 0;
    public static final long MAYBE_TUNNEL_LENGTH = 301000L;
    public static final long DEFINITELY_TUNNEL_LENGTH = 43260000L;
    public static final long HORIZON = 86400000L;
    private long timePresumeGuilty = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AddressTracker create(long lastBootID, File nodeDir, int port) {
        data = new File(nodeDir, "packets-" + port + ".dat");
        dataBak = new File(nodeDir, "packets-" + port + ".bak");
        dataBak.delete();
        fis = null;
        try {
            try {
                fis = new FileInputStream(data);
                bis = new BufferedInputStream(fis);
                ir = new InputStreamReader((InputStream)bis, "UTF-8");
                br = new BufferedReader(ir);
                fs = new SimpleFieldSet(br, false, true);
                var11_12 = new AddressTracker(fs, lastBootID);
                var13_13 = null;
                if (fis == null) return var11_12;
            }
            catch (IOException e) {
                var13_14 = null;
                if (fis == null) return new AddressTracker();
                try {
                    fis.close();
                    return new AddressTracker();
                }
                catch (IOException e) {
                    return new AddressTracker();
                }
            }
            catch (FSParseException e) {
                Logger.error(AddressTracker.class, "Failed to load from disk for port " + port + ": " + e, e);
                var13_15 = null;
                if (fis == null) return new AddressTracker();
                try {}
                catch (IOException e) {
                    return new AddressTracker();
                }
                fis.close();
                return new AddressTracker();
            }
        }
        catch (Throwable var12_21) {
            var13_16 = null;
            if (fis == null) throw var12_21;
            ** try [egrp 2[TRYBLOCK] [6 : 222->230)] { 
lbl42:
            // 1 sources

            fis.close();
            throw var12_21;
lbl44:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            throw var12_21;
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return var11_12;
        }
        fis.close();
        return var11_12;
    }

    private AddressTracker() {
        this.timeDefinitelyNoPacketsReceived = System.currentTimeMillis();
        this.timeDefinitelyNoPacketsSent = System.currentTimeMillis();
        this.peerTrackers = new HashMap();
        this.ipTrackers = new HashMap();
    }

    private AddressTracker(SimpleFieldSet fs, long lastBootID) throws FSParseException {
        Iterator<String> i;
        Iterator<String> i2;
        int version = fs.getInt("Version");
        if (version != 1) {
            throw new FSParseException("Unknown Version " + version);
        }
        long savedBootID = fs.getLong("BootID");
        if (savedBootID != lastBootID) {
            throw new FSParseException("Wrong boot ID - maybe unclean shutdown? Last was " + lastBootID + " stored " + savedBootID);
        }
        this.timeDefinitelyNoPacketsReceived = System.currentTimeMillis();
        this.timeDefinitelyNoPacketsSent = fs.getLong("TimeDefinitelyNoPacketsSent");
        this.peerTrackers = new HashMap();
        SimpleFieldSet peers = fs.subset("Peers");
        if (peers != null && (i2 = peers.directSubsetNameIterator()) != null) {
            while (i2.hasNext()) {
                SimpleFieldSet peer = peers.subset(i2.next());
                PeerAddressTrackerItem item = new PeerAddressTrackerItem(peer);
                this.peerTrackers.put(item.peer, item);
            }
        }
        this.ipTrackers = new HashMap();
        SimpleFieldSet ips = fs.subset("IPs");
        if (ips != null && (i = ips.directSubsetNameIterator()) != null) {
            while (i.hasNext()) {
                SimpleFieldSet peer = ips.subset(i.next());
                InetAddressAddressTrackerItem item = new InetAddressAddressTrackerItem(peer);
                this.ipTrackers.put(item.addr, item);
            }
        }
    }

    public void sentPacketTo(Peer peer) {
        this.packetTo(peer, true);
    }

    public void receivedPacketFrom(Peer peer) {
        this.packetTo(peer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packetTo(Peer peer, boolean sent) {
        Peer peer2 = peer.dropHostName();
        if (peer2 == null) {
            Logger.error(this, "Impossible: No host name in AddressTracker.packetTo for " + peer);
            return;
        }
        peer = peer2;
        InetAddress ip = peer.getAddress();
        long now = System.currentTimeMillis();
        AddressTracker addressTracker = this;
        synchronized (addressTracker) {
            PeerAddressTrackerItem peerItem = this.peerTrackers.get(peer);
            if (peerItem == null) {
                peerItem = new PeerAddressTrackerItem(this.timeDefinitelyNoPacketsReceived, this.timeDefinitelyNoPacketsSent, peer);
                if (this.peerTrackers.size() > 1000) {
                    this.peerTrackers.clear();
                    this.ipTrackers.clear();
                    this.timeDefinitelyNoPacketsReceived = now;
                    this.timeDefinitelyNoPacketsSent = now;
                }
                this.peerTrackers.put(peer, peerItem);
            }
            if (sent) {
                peerItem.sentPacket(now);
            } else {
                peerItem.receivedPacket(now);
            }
            InetAddressAddressTrackerItem ipItem = this.ipTrackers.get(ip);
            if (ipItem == null) {
                ipItem = new InetAddressAddressTrackerItem(this.timeDefinitelyNoPacketsReceived, this.timeDefinitelyNoPacketsSent, ip);
                if (this.ipTrackers.size() > 1000) {
                    this.peerTrackers.clear();
                    this.ipTrackers.clear();
                    this.timeDefinitelyNoPacketsReceived = now;
                    this.timeDefinitelyNoPacketsSent = now;
                }
                this.ipTrackers.put(ip, ipItem);
            }
            if (sent) {
                ipItem.sentPacket(now);
            } else {
                ipItem.receivedPacket(now);
            }
        }
    }

    public synchronized void startReceive(long now) {
        this.timeDefinitelyNoPacketsReceived = now;
    }

    public synchronized void startSend(long now) {
        this.timeDefinitelyNoPacketsSent = now;
    }

    public synchronized PeerAddressTrackerItem[] getPeerAddressTrackerItems() {
        PeerAddressTrackerItem[] items = new PeerAddressTrackerItem[this.peerTrackers.size()];
        return this.peerTrackers.values().toArray(items);
    }

    public synchronized InetAddressAddressTrackerItem[] getInetAddressTrackerItems() {
        InetAddressAddressTrackerItem[] items = new InetAddressAddressTrackerItem[this.ipTrackers.size()];
        return this.ipTrackers.values().toArray(items);
    }

    public long getLongestSendReceiveGap() {
        return this.getLongestSendReceiveGap(86400000L);
    }

    public long getLongestSendReceiveGap(long horizon) {
        long longestGap = -1L;
        long now = System.currentTimeMillis();
        PeerAddressTrackerItem[] items = this.getPeerAddressTrackerItems();
        for (int i = 0; i < items.length; ++i) {
            PeerAddressTrackerItem item = items[i];
            if (item.packetsReceived() <= 0L || !item.peer.isRealInternetAddress(false, false, false)) continue;
            longestGap = Math.max(longestGap, item.longestGap(horizon, now));
        }
        return longestGap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPortForwardStatus() {
        long minGap = this.getLongestSendReceiveGap(86400000L);
        if (minGap > 43260000L) {
            return 2;
        }
        if (minGap > 301000L) {
            return 1;
        }
        AddressTracker addressTracker = this;
        synchronized (addressTracker) {
            if (this.isBroken()) {
                return -2;
            }
            if (minGap == 0L && this.timePresumeGuilty > 0L && System.currentTimeMillis() > this.timePresumeGuilty) {
                return -1;
            }
        }
        return 0;
    }

    private boolean isBroken() {
        return System.currentTimeMillis() - this.brokenTime < 86400000L;
    }

    public static String statusString(int status) {
        switch (status) {
            case 2: {
                return "Port forwarded";
            }
            case 1: {
                return "Maybe port forwarded";
            }
            case -1: {
                return "Maybe behind NAT";
            }
            case -2: {
                return "Behind NAT";
            }
            case 0: {
                return "Status unknown";
            }
        }
        return "Error";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeData(long bootID, File nodeDir, int port) {
        if (this.isBroken()) {
            return;
        }
        File data = new File(nodeDir, "packets-" + port + ".dat");
        File dataBak = new File(nodeDir, "packets-" + port + ".bak");
        data.delete();
        dataBak.delete();
        FileOutputStream fos = null;
        fos = new FileOutputStream(dataBak);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        SimpleFieldSet fs = this.getFieldset(bootID);
        fs.writeTo(bw);
        bw.flush();
        bw.close();
        fos = null;
        dataBak.renameTo(data);
        Object var13_12 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                Logger.error(this, "Cannot store packet tracker to disk");
                Object var13_13 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private synchronized SimpleFieldSet getFieldset(long bootID) {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.put("Version", 1);
        sfs.put("BootID", bootID);
        sfs.put("TimeDefinitelyNoPacketsReceived", this.timeDefinitelyNoPacketsReceived);
        sfs.put("TimeDefinitelyNoPacketsSent", this.timeDefinitelyNoPacketsSent);
        PeerAddressTrackerItem[] peerItems = this.getPeerAddressTrackerItems();
        SimpleFieldSet items = new SimpleFieldSet(true);
        if (peerItems.length > 0) {
            for (int i = 0; i < peerItems.length; ++i) {
                items.put(Integer.toString(i), peerItems[i].toFieldSet());
            }
            sfs.put("Peers", items);
        }
        InetAddressAddressTrackerItem[] inetItems = this.getInetAddressTrackerItems();
        items = new SimpleFieldSet(true);
        if (inetItems.length > 0) {
            for (int i = 0; i < inetItems.length; ++i) {
                items.put(Integer.toString(i), inetItems[i].toFieldSet());
            }
            sfs.put("IPs", items);
        }
        return sfs;
    }

    public void rescan() {
    }

    public synchronized void setBroken() {
        this.brokenTime = System.currentTimeMillis();
    }

    public synchronized void setPresumedGuiltyAt(long l) {
        if (this.timePresumeGuilty <= 0L) {
            this.timePresumeGuilty = l;
        }
    }

    public synchronized void setPresumedInnocent() {
        this.timePresumeGuilty = -1L;
    }
}

