/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import java.util.regex.Pattern;

public class AddressIdentifier {
    public static final Pattern ipv4Pattern;
    public static final Pattern ipv6Pattern;
    public static final Pattern ipv6PatternWithPercentScopeID;
    public static final Pattern ipv6ISATAPPattern;

    public static AddressType getAddressType(String address) {
        return AddressIdentifier.getAddressType(address, false);
    }

    public static AddressType getAddressType(String address, boolean allowIPv6PercentScopeID) {
        if (ipv4Pattern.matcher(address).matches()) {
            return AddressType.IPv4;
        }
        if ((allowIPv6PercentScopeID ? ipv6PatternWithPercentScopeID : ipv6Pattern).matcher(address).matches()) {
            return AddressType.IPv6;
        }
        return AddressType.OTHER;
    }

    public static boolean isAnISATAPIPv6Address(String address) {
        return ipv6ISATAPPattern.matcher(address).matches();
    }

    static {
        String byteRegex = "([01]?[0-9]?[0-9]?|2[0-4][0-9]|25[0-5])";
        String ipv4AddressRegex = byteRegex + "\\.(" + byteRegex + "\\.)?(" + byteRegex + "\\.)?" + byteRegex;
        ipv4Pattern = Pattern.compile(ipv4AddressRegex);
        String wordRegex = "([0-9a-fA-F]{1,4})";
        String percentScopeIDRegex = "(?:%[0-9]{1,3})?";
        String ipv6AddressRegex = wordRegex + "?:" + wordRegex + ':' + wordRegex + ':' + wordRegex + ':' + wordRegex + ':' + wordRegex + ':' + wordRegex + ':' + wordRegex;
        String ipv6ISATAPAddressRegex = wordRegex + "?:" + wordRegex + ':' + wordRegex + ':' + wordRegex + ":(0){1,4}:5(efe|EFE):" + wordRegex + ':' + wordRegex + percentScopeIDRegex;
        ipv6Pattern = Pattern.compile(ipv6AddressRegex);
        ipv6PatternWithPercentScopeID = Pattern.compile(ipv6AddressRegex + percentScopeIDRegex);
        ipv6ISATAPPattern = Pattern.compile(ipv6ISATAPAddressRegex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddressType {
        OTHER,
        IPv4,
        IPv6;

    }
}

