/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt.ciphers;

import freenet.crypt.BlockCipher;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael_Algorithm;
import freenet.support.Logger;
import java.security.InvalidKeyException;

public class Rijndael
implements BlockCipher {
    private Object sessionKey;
    private final int keysize;
    private final int blocksize;

    public Rijndael(int keysize, int blocksize) throws UnsupportedCipherException {
        if (keysize != 128 && keysize != 192 && keysize != 256) {
            throw new UnsupportedCipherException("Invalid keysize");
        }
        if (blocksize != 128 && blocksize != 192 && blocksize != 256) {
            throw new UnsupportedCipherException("Invalid blocksize");
        }
        this.keysize = keysize;
        this.blocksize = blocksize;
    }

    public Rijndael() {
        this.keysize = 128;
        this.blocksize = 128;
    }

    public final int getBlockSize() {
        return this.blocksize;
    }

    public final int getKeySize() {
        return this.keysize;
    }

    public final void initialize(byte[] key) {
        try {
            byte[] nkey = new byte[this.keysize >> 3];
            System.arraycopy(key, 0, nkey, 0, nkey.length);
            this.sessionKey = Rijndael_Algorithm.makeKey(nkey, this.blocksize / 8);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            Logger.error(this, "Invalid key");
        }
    }

    public final synchronized void encipher(byte[] block, byte[] result) {
        if (block.length != this.blocksize / 8) {
            throw new IllegalArgumentException();
        }
        Rijndael_Algorithm.blockEncrypt(block, result, 0, this.sessionKey, this.blocksize / 8);
    }

    public final synchronized int getTempArraySize() {
        return this.blocksize / 32;
    }

    public final synchronized void encipher(byte[] block, byte[] result, int[] a, int[] t) {
        if (block.length != this.blocksize / 8) {
            throw new IllegalArgumentException();
        }
        if (a.length != t.length || t.length != this.blocksize / 32) {
            throw new IllegalArgumentException();
        }
        Rijndael_Algorithm.blockEncrypt(block, result, 0, this.sessionKey, this.blocksize / 8, a, t);
    }

    public final synchronized void decipher(byte[] block, byte[] result) {
        if (block.length != this.blocksize / 8) {
            throw new IllegalArgumentException();
        }
        Rijndael_Algorithm.blockDecrypt(block, result, 0, this.sessionKey, this.blocksize / 8);
    }
}

