/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.Digest;
import freenet.crypt.JavaSHA1;
import freenet.crypt.SHA1;
import freenet.crypt.ciphers.Rijndael;
import freenet.support.HexUtil;
import freenet.support.Loader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;
import net.i2p.util.NativeBigInteger;

public class Util {
    protected static final int BUFFER_SIZE = 32768;
    public static final NativeBigInteger TWO;
    private static Digest ctx;

    public static void fillByteArrayFromInts(int[] ints, byte[] bytes) {
        int ic = 0;
        for (int i = 0; i < ints.length; ++i) {
            bytes[ic++] = (byte)(ints[i] >> 24);
            bytes[ic++] = (byte)(ints[i] >> 16);
            bytes[ic++] = (byte)(ints[i] >> 8);
            bytes[ic++] = (byte)ints[i];
        }
    }

    public static void fillByteArrayFromLongs(long[] ints, byte[] bytes) {
        int ic = 0;
        for (int i = 0; i < ints.length; ++i) {
            bytes[ic++] = (byte)(ints[i] >> 56);
            bytes[ic++] = (byte)(ints[i] >> 48);
            bytes[ic++] = (byte)(ints[i] >> 40);
            bytes[ic++] = (byte)(ints[i] >> 32);
            bytes[ic++] = (byte)(ints[i] >> 24);
            bytes[ic++] = (byte)(ints[i] >> 16);
            bytes[ic++] = (byte)(ints[i] >> 8);
            bytes[ic++] = (byte)ints[i];
        }
    }

    public static void fillIntArrayFromBytes(byte[] bytes, int[] ints) {
        int ic = 0;
        for (int i = 0; i < ints.length << 2; i += 4) {
            ints[ic++] = bytes[i] + (bytes[i + 1] << 8) + (bytes[i + 2] << 16) + (bytes[i + 3] << 24);
        }
    }

    public static void fillLongArrayFromBytes(byte[] bytes, long[] longs) {
        int ic = 0;
        for (int i = 0; i < longs.length << 3; i += 8) {
            longs[ic++] = (long)bytes[i] + ((long)bytes[i + 1] << 8) + ((long)bytes[i + 2] << 16) + ((long)bytes[i + 3] << 24) + ((long)bytes[i + 4] << 32) + ((long)bytes[i + 5] << 40) + ((long)bytes[i + 6] << 48) + ((long)bytes[i + 7] << 56);
        }
    }

    public static byte[] MPIbytes(BigInteger num) {
        int len = num.bitLength();
        byte[] bytes = new byte[2 + (len + 8 >> 3)];
        System.arraycopy(num.toByteArray(), 0, bytes, 2, bytes.length - 2);
        bytes[0] = (byte)(len >> 8);
        bytes[1] = (byte)len;
        return bytes;
    }

    public static void writeMPI(BigInteger num, OutputStream out) throws IOException {
        out.write(Util.MPIbytes(num));
    }

    public static BigInteger readMPI(InputStream in) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        if (b1 == -1 || b2 == -1) {
            throw new EOFException();
        }
        byte[] data = new byte[(b1 << 8) + b2 + 8 >> 3];
        Util.readFully(in, data, 0, data.length);
        return new NativeBigInteger(1, data);
    }

    public static BigInteger generateLargeRandom(int lowerBound, int upperBound, Random r) {
        int bl;
        if (lowerBound == upperBound) {
            return new NativeBigInteger(lowerBound, r);
        }
        while ((bl = (r.nextInt() & Integer.MAX_VALUE) % upperBound) < lowerBound) {
        }
        return new NativeBigInteger(bl, r);
    }

    public static byte[] hashBytes(MessageDigest d, byte[] b) {
        return Util.hashBytes(d, b, 0, b.length);
    }

    public static byte[] hashBytes(MessageDigest d, byte[] b, int offset, int length) {
        d.update(b, offset, length);
        return d.digest();
    }

    public static byte[] hashString(Digest d, String s) {
        try {
            byte[] sbytes = s.getBytes("UTF-8");
            d.update(sbytes, 0, sbytes.length);
            return d.digest();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] xor(byte[] b1, byte[] b2) {
        int maxl = Math.max(b1.length, b2.length);
        byte[] rv = new byte[maxl];
        int minl = Math.min(b1.length, b2.length);
        for (int i = 0; i < minl; ++i) {
            rv[i] = (byte)(b1[i] ^ b2[i]);
        }
        return rv;
    }

    public static boolean byteArrayEqual(byte[] a, byte[] b, int offset, int length) {
        int lim = offset + length;
        if (a.length < lim || b.length < lim) {
            return false;
        }
        for (int i = offset; i < lim; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeKey(byte[] entropy, byte[] key, int offset, int len) {
        Digest digest = ctx;
        synchronized (digest) {
            ctx.digest();
            int ic = 0;
            while (len > 0) {
                int bc;
                ++ic;
                for (int i = 0; i < ic; ++i) {
                    ctx.update((byte)0);
                }
                ctx.update(entropy, 0, entropy.length);
                if (len > 20) {
                    ctx.digest(true, key, offset);
                    bc = 20;
                } else {
                    byte[] hash = ctx.digest();
                    bc = Math.min(len, hash.length);
                    System.arraycopy(hash, 0, key, offset, bc);
                }
                offset += bc;
                len -= bc;
            }
        }
        Arrays.fill(entropy, (byte)0);
    }

    public static BlockCipher getCipherByName(String name) {
        try {
            return (BlockCipher)Loader.getInstance("freenet.crypt.ciphers." + name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BlockCipher getCipherByName(String name, int keySize) {
        try {
            return (BlockCipher)Loader.getInstance("freenet.crypt.ciphers." + name, new Class[]{Integer.class}, new Object[]{keySize});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Digest getDigestByName(String name) {
        try {
            return (Digest)Loader.getInstance("freenet.crypt." + name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("write")) {
            Util.writeMPI(new BigInteger("9"), System.out);
            Util.writeMPI(new BigInteger("1234567890123456789"), System.out);
            Util.writeMPI(new BigInteger("100200300400500600700800900"), System.out);
        } else if (args[0].equals("read")) {
            System.out.println("9");
            System.out.println(Util.readMPI(System.in));
            System.out.println("1234567890123456789");
            System.out.println(Util.readMPI(System.in));
            System.out.println("100200300400500600700800900");
            System.out.println(Util.readMPI(System.in));
        } else if (args[0].equals("write-mpi")) {
            Util.writeMPI(new BigInteger(args[1]), System.out);
        } else if (args[0].equals("read-mpi")) {
            System.err.println(Util.readMPI(System.in));
        } else if (args[0].equals("keygen")) {
            byte[] entropy = Util.readMPI(System.in).toByteArray();
            byte[] key = new byte[args.length > 1 ? Integer.parseInt(args[1]) : 16];
            Util.makeKey(entropy, key, 0, key.length);
            System.err.println(HexUtil.bytesToHex(key, 0, key.length));
        } else if (args[0].equals("shatest")) {
            Digest digest = ctx;
            synchronized (digest) {
                ctx.digest();
                ctx.update((byte)97);
                ctx.update((byte)98);
                ctx.update((byte)99);
                System.err.println(HexUtil.bytesToHex(ctx.digest()));
            }
        }
    }

    public static int log2(long n) {
        int log2;
        for (log2 = 0; log2 < 63 && 1L << log2 < n; ++log2) {
        }
        return log2;
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        Util.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int length) throws IOException {
        int got;
        for (int total = 0; total < length; total += got) {
            got = in.read(b, off + total, length - total);
            if (got != -1) continue;
            throw new EOFException();
        }
    }

    static {
        SHA1.class.toString();
        JavaSHA1.class.toString();
        Rijndael.class.toString();
        TWO = new NativeBigInteger(BigInteger.valueOf(2L));
        ctx = SHA1.getInstance();
    }
}

