/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.support.Logger;
import freenet.support.api.BooleanCallback;
import freenet.support.api.StringCallback;
import freenet.support.io.Closer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class SSL {
    private static boolean enable;
    private static KeyStore keystore;
    private static ServerSocketFactory ssf;
    private static String keyStore;
    private static String keyStorePass;
    private static String keyPass;
    private static String version;

    public static boolean available() {
        return ssf != null;
    }

    public static void init(SubConfig sslConfig) {
        int configItemOrder = 0;
        sslConfig.register("sslEnable", false, configItemOrder++, true, true, "SSL.enable", "SSL.enableLong", new BooleanCallback(){

            public Boolean get() {
                return enable;
            }

            public void set(Boolean newValue) throws InvalidConfigValueException {
                if (!this.get().equals(newValue)) {
                    enable = newValue;
                    if (enable) {
                        try {
                            SSL.loadKeyStore();
                            SSL.createSSLContext();
                        }
                        catch (Exception e) {
                            enable = false;
                            e.printStackTrace(System.out);
                            throw new InvalidConfigValueException("Cannot enabled ssl, config error");
                        }
                    } else {
                        ssf = null;
                        keyStore = null;
                    }
                }
            }
        });
        sslConfig.register("sslKeyStore", "datastore/certs", configItemOrder++, true, true, "SSL.keyStore", "SSL.keyStoreLong", new StringCallback(){

            public String get() {
                return keyStore;
            }

            public void set(String newKeyStore) throws InvalidConfigValueException {
                if (!newKeyStore.equals(this.get())) {
                    String oldKeyStore = keyStore;
                    keyStore = newKeyStore;
                    try {
                        SSL.loadKeyStore();
                    }
                    catch (Exception e) {
                        keyStore = oldKeyStore;
                        e.printStackTrace(System.out);
                        throw new InvalidConfigValueException("Cannot change keystore file");
                    }
                }
            }
        });
        sslConfig.register("sslKeyStorePass", "freenet", configItemOrder++, true, true, "SSL.keyStorePass", "SSL.keyStorePassLong", new StringCallback(){

            public String get() {
                return keyStorePass;
            }

            public void set(String newKeyStorePass) throws InvalidConfigValueException {
                if (!newKeyStorePass.equals(this.get())) {
                    String oldKeyStorePass = keyStorePass;
                    keyStorePass = newKeyStorePass;
                    try {
                        SSL.storeKeyStore();
                    }
                    catch (Exception e) {
                        keyStorePass = oldKeyStorePass;
                        e.printStackTrace(System.out);
                        throw new InvalidConfigValueException("Cannot change keystore password");
                    }
                }
            }
        });
        sslConfig.register("sslKeyPass", "freenet", configItemOrder++, true, true, "SSL.keyPass", "SSL.keyPassLong", new StringCallback(){

            public String get() {
                return keyPass;
            }

            public void set(String newKeyPass) throws InvalidConfigValueException {
                if (!newKeyPass.equals(this.get())) {
                    String oldKeyPass = keyPass;
                    keyPass = newKeyPass;
                    try {
                        Certificate[] chain = keystore.getCertificateChain("freenet");
                        Key privKey = keystore.getKey("freenet", oldKeyPass.toCharArray());
                        keystore.setKeyEntry("freenet", privKey, keyPass.toCharArray(), chain);
                        SSL.createSSLContext();
                    }
                    catch (Exception e) {
                        keyPass = oldKeyPass;
                        e.printStackTrace(System.out);
                        throw new InvalidConfigValueException("Cannot change private key password");
                    }
                }
            }
        });
        sslConfig.register("sslVersion", "SSLv3", configItemOrder++, true, true, "SSL.version", "SSL.versionLong", new StringCallback(){

            public String get() {
                return version;
            }

            public void set(String newVersion) throws InvalidConfigValueException {
                if (!newVersion.equals(this.get())) {
                    String oldVersion = version;
                    version = newVersion;
                    try {
                        SSL.createSSLContext();
                    }
                    catch (Exception e) {
                        version = oldVersion;
                        e.printStackTrace(System.out);
                        throw new InvalidConfigValueException("Cannot change ssl version, wrong value");
                    }
                }
            }
        });
        enable = sslConfig.getBoolean("sslEnable");
        keyStore = sslConfig.getString("sslKeyStore");
        keyStorePass = sslConfig.getString("sslKeyStorePass");
        keyPass = sslConfig.getString("sslKeyPass");
        version = sslConfig.getString("sslVersion");
        try {
            keystore = KeyStore.getInstance("PKCS12");
            SSL.loadKeyStore();
            SSL.createSSLContext();
        }
        catch (Exception e) {
            Logger.error(SSL.class, "Cannot load keystore, ssl is disable", e);
        }
    }

    public static ServerSocket createServerSocket() throws IOException {
        if (ssf == null) {
            throw new IOException("SSL not initialized");
        }
        return ssf.createServerSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadKeyStore() throws Exception {
        if (!enable) return;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(keyStore);
                keystore.load(fis, keyStorePass.toCharArray());
            }
            catch (FileNotFoundException fnfe) {
                keystore.load(null, keyStorePass.toCharArray());
                try {
                    Class<?> certAndKeyGenClazz = Class.forName("sun.security.x509.CertAndKeyGen");
                    Constructor<?> certAndKeyGenCtor = certAndKeyGenClazz.getConstructor(String.class, String.class);
                    Object keypair = certAndKeyGenCtor.newInstance("DSA", "SHA1WithDSA");
                    Class<?> x500NameClazz = Class.forName("sun.security.x509.X500Name");
                    Constructor<?> x500NameCtor = x500NameClazz.getConstructor(String.class, String.class, String.class, String.class, String.class, String.class);
                    Object x500Name = x500NameCtor.newInstance("Freenet", "Freenet", "Freenet", "", "", "");
                    Method certAndKeyGenGenerate = certAndKeyGenClazz.getMethod("generate", Integer.TYPE);
                    certAndKeyGenGenerate.invoke(keypair, 1024);
                    Method certAndKeyGetPrivateKey = certAndKeyGenClazz.getMethod("getPrivateKey", new Class[0]);
                    PrivateKey privKey = (PrivateKey)certAndKeyGetPrivateKey.invoke(keypair, new Object[0]);
                    Certificate[] chain = new Certificate[1];
                    Method certAndKeyGenGetSelfCertificate = certAndKeyGenClazz.getMethod("getSelfCertificate", x500NameClazz, Long.TYPE);
                    chain[0] = (Certificate)certAndKeyGenGetSelfCertificate.invoke(keypair, x500Name, 31536000L);
                    keystore.setKeyEntry("freenet", privKey, keyPass.toCharArray(), chain);
                    SSL.storeKeyStore();
                    SSL.createSSLContext();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new UnsupportedOperationException("The JVM you are using is not supported!", cnfe);
                }
                catch (NoSuchMethodException nsme) {
                    throw new UnsupportedOperationException("The JVM you are using is not supported!", nsme);
                }
                Object var14_2 = null;
                Closer.close(fis);
                return;
            }
            Object var14_1 = null;
        }
        catch (Throwable throwable) {
            Object var14_3 = null;
            Closer.close(fis);
            throw throwable;
        }
        Closer.close(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeKeyStore() throws Exception {
        if (enable) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(keyStore);
                keystore.store(fos, keyStorePass.toCharArray());
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Closer.close(fos);
                throw throwable;
            }
            Closer.close(fos);
            {
            }
        }
    }

    private static void createSSLContext() throws Exception {
        if (enable) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keystore, keyPass.toCharArray());
            SSLContext sslc = SSLContext.getInstance(version);
            sslc.init(kmf.getKeyManagers(), null, null);
            ssf = sslc.getServerSocketFactory();
        }
    }
}

