/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.RandomSource;
import freenet.crypt.RijndaelPCFBMode;
import freenet.crypt.Util;
import freenet.crypt.ciphers.Rijndael;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PCFBMode {
    protected BlockCipher c;
    protected byte[] feedback_register;
    protected int registerPointer;

    public static PCFBMode create(BlockCipher c) {
        if (c instanceof Rijndael) {
            return new RijndaelPCFBMode((Rijndael)c);
        }
        return new PCFBMode(c);
    }

    public static PCFBMode create(BlockCipher c, byte[] iv) {
        if (c instanceof Rijndael) {
            return new RijndaelPCFBMode((Rijndael)c, iv);
        }
        return new PCFBMode(c, iv);
    }

    protected PCFBMode(BlockCipher c) {
        this.c = c;
        this.feedback_register = new byte[c.getBlockSize() >> 3];
        this.registerPointer = this.feedback_register.length;
    }

    protected PCFBMode(BlockCipher c, byte[] iv) {
        this(c);
        System.arraycopy(iv, 0, this.feedback_register, 0, this.feedback_register.length);
    }

    public final void reset(byte[] iv) {
        System.arraycopy(iv, 0, this.feedback_register, 0, this.feedback_register.length);
        this.registerPointer = this.feedback_register.length;
    }

    public final void reset(byte[] iv, int offset) {
        System.arraycopy(iv, offset, this.feedback_register, 0, this.feedback_register.length);
        this.registerPointer = this.feedback_register.length;
    }

    public void writeIV(RandomSource rs, OutputStream out) throws IOException {
        rs.nextBytes(this.feedback_register);
        out.write(this.feedback_register);
    }

    public void readIV(InputStream in) throws IOException {
        Util.readFully(in, this.feedback_register);
    }

    public int lengthIV() {
        return this.feedback_register.length;
    }

    public int decipher(int b) {
        if (this.registerPointer == this.feedback_register.length) {
            this.refillBuffer();
        }
        int rv = (this.feedback_register[this.registerPointer] ^ (byte)b) & 0xFF;
        this.feedback_register[this.registerPointer++] = (byte)b;
        return rv;
    }

    public byte[] blockDecipher(byte[] buf, int off, int len) {
        while (len > 0) {
            if (this.registerPointer == this.feedback_register.length) {
                this.refillBuffer();
            }
            int n = Math.min(len, this.feedback_register.length - this.registerPointer);
            int i = off;
            while (i < off + n) {
                byte b = buf[i];
                int n2 = i++;
                buf[n2] = (byte)(buf[n2] ^ this.feedback_register[this.registerPointer]);
                this.feedback_register[this.registerPointer++] = b;
            }
            off += n;
            len -= n;
        }
        return buf;
    }

    public int encipher(int b) {
        if (this.registerPointer == this.feedback_register.length) {
            this.refillBuffer();
        }
        int n = this.registerPointer;
        this.feedback_register[n] = (byte)(this.feedback_register[n] ^ (byte)b);
        return this.feedback_register[this.registerPointer++] & 0xFF;
    }

    public byte[] blockEncipher(byte[] buf, int off, int len) {
        while (len > 0) {
            if (this.registerPointer == this.feedback_register.length) {
                this.refillBuffer();
            }
            int n = Math.min(len, this.feedback_register.length - this.registerPointer);
            for (int i = off; i < off + n; ++i) {
                int n2 = this.registerPointer++;
                byte by = (byte)(this.feedback_register[n2] ^ buf[i]);
                this.feedback_register[n2] = by;
                buf[i] = by;
            }
            off += n;
            len -= n;
        }
        return buf;
    }

    protected void refillBuffer() {
        this.c.encipher(this.feedback_register, this.feedback_register);
        this.registerPointer = 0;
    }
}

