/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.SHA256;
import freenet.crypt.Util;
import freenet.support.HexUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class HMAC {
    protected static final int B = 64;
    protected static byte[] ipad = new byte[64];
    protected static byte[] opad = new byte[64];
    protected MessageDigest d;

    public HMAC(MessageDigest md) {
        this.d = md;
    }

    public boolean verify(byte[] K, byte[] text, byte[] mac) {
        byte[] mac2 = this.mac(K, text, mac.length);
        return Arrays.equals(mac, mac2);
    }

    public byte[] mac(byte[] K, byte[] text, int macbytes) {
        byte[] K0 = null;
        if (K.length == 64) {
            K0 = K;
        } else {
            if (K.length > 64) {
                K0 = K = Util.hashBytes(this.d, K);
            }
            if (K.length < 64) {
                K0 = new byte[64];
                System.arraycopy(K, 0, K0, 0, K.length);
            }
        }
        byte[] IS1 = Util.xor(K0, ipad);
        this.d.update(IS1);
        this.d.update(text);
        IS1 = this.d.digest();
        byte[] IS2 = Util.xor(K0, opad);
        this.d.update(IS2);
        this.d.update(IS1);
        IS1 = this.d.digest();
        if (macbytes == IS1.length) {
            return IS1;
        }
        byte[] rv = new byte[macbytes];
        System.arraycopy(IS1, 0, rv, 0, Math.min(rv.length, IS1.length));
        return rv;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        int i;
        HMAC s = null;
        try {
            s = new HMAC(MessageDigest.getInstance("SHA1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] key = new byte[20];
        System.err.println("20x0b, 'Hi There':");
        byte[] text = "Hi There".getBytes("UTF-8");
        for (int i2 = 0; i2 < key.length; ++i2) {
            key[i2] = 11;
        }
        byte[] mv = s.mac(key, text, 20);
        System.out.println(HexUtil.bytesToHex(mv, 0, mv.length));
        System.err.println("20xaa, 50xdd:");
        for (i = 0; i < key.length; ++i) {
            key[i] = -86;
        }
        text = new byte[50];
        for (i = 0; i < text.length; ++i) {
            text[i] = -35;
        }
        mv = s.mac(key, text, 20);
        System.out.println(HexUtil.bytesToHex(mv, 0, mv.length));
        key = new byte[25];
        System.err.println("25x[i+1], 50xcd:");
        for (i = 0; i < key.length; ++i) {
            key[i] = (byte)(i + 1);
        }
        for (i = 0; i < text.length; ++i) {
            text[i] = -51;
        }
        mv = s.mac(key, text, 20);
        System.out.println(HexUtil.bytesToHex(mv, 0, mv.length));
        key = new byte[20];
        System.err.println("20x0c, 'Test With Truncation':");
        for (i = 0; i < key.length; ++i) {
            key[i] = 12;
        }
        text = "Test With Truncation".getBytes("UTF-8");
        mv = s.mac(key, text, 20);
        System.out.println(HexUtil.bytesToHex(mv, 0, mv.length));
        mv = s.mac(key, text, 12);
        System.out.println(HexUtil.bytesToHex(mv, 0, mv.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] macWithSHA256(byte[] K, byte[] text, int macbytes) {
        byte[] byArray;
        block2: {
            MessageDigest sha256 = null;
            try {
                sha256 = SHA256.getMessageDigest();
                HMAC hash = new HMAC(sha256);
                byArray = hash.mac(K, text, macbytes);
                Object var7_6 = null;
                if (sha256 == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (sha256 == null) break block3;
                    SHA256.returnMessageDigest(sha256);
                }
                throw throwable;
            }
            SHA256.returnMessageDigest(sha256);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyWithSHA256(byte[] K, byte[] text, byte[] mac) {
        boolean bl;
        block2: {
            MessageDigest sha256 = null;
            try {
                sha256 = SHA256.getMessageDigest();
                HMAC hash = new HMAC(sha256);
                bl = hash.verify(K, text, mac);
                Object var7_6 = null;
                if (sha256 == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (sha256 == null) break block3;
                    SHA256.returnMessageDigest(sha256);
                }
                throw throwable;
            }
            SHA256.returnMessageDigest(sha256);
        }
        return bl;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            HMAC.ipad[i] = 54;
            HMAC.opad[i] = 92;
        }
    }
}

