/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.DHGroup;
import freenet.crypt.DSASignature;
import freenet.crypt.KeyAgreementSchemeContext;
import freenet.support.HexUtil;
import freenet.support.Logger;
import java.math.BigInteger;
import net.i2p.util.NativeBigInteger;

public class DiffieHellmanLightContext
extends KeyAgreementSchemeContext {
    public final NativeBigInteger myExponent;
    public final NativeBigInteger myExponential;
    public DSASignature signature = null;
    public final long lifetime = System.currentTimeMillis();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(": myExponent=");
        sb.append(this.myExponent.toHexString());
        sb.append(", myExponential=");
        sb.append(this.myExponential.toHexString());
        return sb.toString();
    }

    public DiffieHellmanLightContext(NativeBigInteger myExponent, NativeBigInteger myExponential) {
        this.myExponent = myExponent;
        this.myExponential = myExponential;
        this.lastUsedTime = System.currentTimeMillis();
        this.logMINOR = Logger.shouldLog(4, this);
    }

    public void setSignature(DSASignature sig) {
        this.signature = sig;
    }

    public NativeBigInteger getHMACKey(NativeBigInteger peerExponential, DHGroup group) {
        this.lastUsedTime = System.currentTimeMillis();
        BigInteger P = group.getP();
        NativeBigInteger sharedSecret = (NativeBigInteger)peerExponential.modPow(this.myExponent, P);
        if (this.logMINOR) {
            Logger.minor(this, "P: " + HexUtil.biToHex(P));
            Logger.minor(this, "My exponent: " + this.myExponent.toHexString());
            Logger.minor(this, "My exponential: " + this.myExponential.toHexString());
            Logger.minor(this, "Peer's exponential: " + peerExponential.toHexString());
            Logger.minor(this, "g^ir mod p = " + sharedSecret.toHexString());
        }
        return sharedSecret;
    }
}

