/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import com.db4o.ObjectContainer;
import freenet.crypt.CryptFormatException;
import freenet.crypt.CryptoKey;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.SHA256;
import freenet.crypt.Util;
import freenet.store.StorableBlock;
import freenet.support.Base64;
import freenet.support.HexUtil;
import freenet.support.IllegalBase64Exception;
import freenet.support.SimpleFieldSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import net.i2p.util.NativeBigInteger;

public class DSAPublicKey
extends CryptoKey
implements StorableBlock {
    private static final long serialVersionUID = -1L;
    private final BigInteger y;
    public static final int PADDED_SIZE = 1024;
    public static final int HASH_LENGTH = 32;
    private final DSAGroup group;
    private byte[] fingerprint = null;

    public DSAPublicKey(DSAGroup g, BigInteger y) {
        if (y.signum() != 1) {
            throw new IllegalArgumentException();
        }
        this.y = y;
        this.group = g;
        if (y.compareTo(g.getP()) > 0) {
            throw new IllegalArgumentException("y must be < p but y=" + y + " p=" + g.getP());
        }
    }

    public DSAPublicKey(DSAGroup g, String yAsHexString) throws NumberFormatException {
        this.y = new NativeBigInteger(yAsHexString, 16);
        if (this.y.signum() != 1) {
            throw new IllegalArgumentException();
        }
        this.group = g;
        if (g == null) {
            throw new NullPointerException();
        }
    }

    public DSAPublicKey(DSAGroup g, DSAPrivateKey p) {
        this(g, g.getG().modPow(p.getX(), g.getP()));
    }

    public DSAPublicKey(InputStream is) throws IOException, CryptFormatException {
        this.group = (DSAGroup)DSAGroup.read(is);
        this.y = Util.readMPI(is);
        if (this.y.compareTo(this.group.getP()) > 0) {
            throw new IllegalArgumentException("y must be < p but y=" + this.y + " p=" + this.group.getP());
        }
    }

    public DSAPublicKey(byte[] pubkeyBytes) throws IOException, CryptFormatException {
        this(new ByteArrayInputStream(pubkeyBytes));
    }

    private DSAPublicKey(DSAPublicKey key) {
        this.fingerprint = null;
        this.y = new NativeBigInteger(1, key.y.toByteArray());
        this.group = key.group.cloneKey();
    }

    public static DSAPublicKey create(byte[] pubkeyAsBytes) throws CryptFormatException {
        try {
            return new DSAPublicKey(new ByteArrayInputStream(pubkeyAsBytes));
        }
        catch (IOException e) {
            throw new CryptFormatException(e);
        }
    }

    public BigInteger getY() {
        return this.y;
    }

    public BigInteger getP() {
        return this.group.getP();
    }

    public BigInteger getQ() {
        return this.group.getQ();
    }

    public BigInteger getG() {
        return this.group.getG();
    }

    public String keyType() {
        return "DSA.p";
    }

    public DSAGroup getGroup() {
        return this.group;
    }

    public static CryptoKey read(InputStream i) throws IOException, CryptFormatException {
        return new DSAPublicKey(i);
    }

    public int keyId() {
        return this.y.intValue();
    }

    public String toLongString() {
        return "y=" + HexUtil.biToHex(this.y);
    }

    public byte[] asBytes() {
        byte[] groupBytes = this.group.asBytes();
        byte[] ybytes = Util.MPIbytes(this.y);
        byte[] bytes = new byte[groupBytes.length + ybytes.length];
        System.arraycopy(groupBytes, 0, bytes, 0, groupBytes.length);
        System.arraycopy(ybytes, 0, bytes, groupBytes.length, ybytes.length);
        return bytes;
    }

    public byte[] asBytesHash() {
        byte[] hash = SHA256.digest(this.asBytes());
        return hash;
    }

    public byte[] asPaddedBytes() {
        byte[] asBytes = this.asBytes();
        if (asBytes.length == 1024) {
            return asBytes;
        }
        if (asBytes.length > 1024) {
            throw new Error("Cannot fit key in 1024 - real size is " + asBytes.length);
        }
        byte[] padded = new byte[1024];
        System.arraycopy(asBytes, 0, padded, 0, asBytes.length);
        return padded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fingerprint() {
        DSAPublicKey dSAPublicKey = this;
        synchronized (dSAPublicKey) {
            if (this.fingerprint == null) {
                this.fingerprint = this.fingerprint(new BigInteger[]{this.y});
            }
            return this.fingerprint;
        }
    }

    public boolean equals(DSAPublicKey o) {
        if (this == o) {
            return true;
        }
        return this.y.equals(o.y) && this.group.equals(o.group);
    }

    public int hashCode() {
        return this.y.hashCode() ^ this.group.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.y.equals(((DSAPublicKey)o).y) && this.group.equals(((DSAPublicKey)o).group);
    }

    public int compareTo(Object other) {
        if (other instanceof DSAPublicKey) {
            return this.getY().compareTo(((DSAPublicKey)other).getY());
        }
        return -1;
    }

    public SimpleFieldSet asFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("y", Base64.encode(this.y.toByteArray()));
        return fs;
    }

    public static DSAPublicKey create(SimpleFieldSet set, DSAGroup group) throws IllegalBase64Exception {
        NativeBigInteger x = new NativeBigInteger(1, Base64.decode(set.get("y")));
        return new DSAPublicKey(group, x);
    }

    public byte[] getFullKey() {
        return this.asBytesHash();
    }

    public byte[] getRoutingKey() {
        return this.asBytesHash();
    }

    public DSAPublicKey cloneKey() {
        return new DSAPublicKey(this);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this.y);
        this.group.removeFrom(container);
        container.delete((Object)this);
    }
}

