/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import com.db4o.ObjectContainer;
import freenet.crypt.CryptoKey;
import freenet.crypt.DSAGroup;
import freenet.crypt.Util;
import freenet.support.Base64;
import freenet.support.HexUtil;
import freenet.support.IllegalBase64Exception;
import freenet.support.SimpleFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Random;
import net.i2p.util.NativeBigInteger;

public class DSAPrivateKey
extends CryptoKey {
    private static final long serialVersionUID = -1L;
    private final BigInteger x;

    public DSAPrivateKey(BigInteger x, DSAGroup g) {
        this.x = x;
        if (x.signum() != 1 || x.compareTo(g.getQ()) > -1 || x.compareTo(BigInteger.ZERO) < 1) {
            throw new IllegalArgumentException();
        }
    }

    public DSAPrivateKey(DSAGroup g, Random r) {
        NativeBigInteger tempX;
        while ((tempX = new NativeBigInteger(256, r)).compareTo(g.getQ()) > -1 || tempX.compareTo(BigInteger.ZERO) < 1) {
        }
        this.x = tempX;
    }

    public String keyType() {
        return "DSA.s";
    }

    public BigInteger getX() {
        return this.x;
    }

    public static CryptoKey read(InputStream i, DSAGroup g) throws IOException {
        return new DSAPrivateKey(Util.readMPI(i), g);
    }

    public String toLongString() {
        return "x=" + HexUtil.biToHex(this.x);
    }

    public byte[] asBytes() {
        return Util.MPIbytes(this.x);
    }

    public byte[] fingerprint() {
        return this.fingerprint(new BigInteger[]{this.x});
    }

    public SimpleFieldSet asFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("x", Base64.encode(this.x.toByteArray()));
        return fs;
    }

    public static DSAPrivateKey create(SimpleFieldSet fs, DSAGroup group) throws IllegalBase64Exception {
        NativeBigInteger y = new NativeBigInteger(1, Base64.decode(fs.get("x")));
        if (y.bitLength() > 512) {
            throw new IllegalBase64Exception("Probably a pubkey");
        }
        return new DSAPrivateKey(y, group);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this.x);
        container.delete((Object)this);
    }
}

