/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.DSASignature;
import freenet.crypt.DummyRandomSource;
import freenet.crypt.Global;
import freenet.crypt.RandomSource;
import freenet.crypt.Util;
import freenet.support.Logger;
import java.math.BigInteger;
import java.util.Random;
import net.i2p.util.NativeBigInteger;

public class DSA {
    static final BigInteger SIGNATURE_MASK = Util.TWO.pow(255).subtract(BigInteger.ONE);

    static DSASignature sign(DSAGroup g, DSAPrivateKey x, BigInteger k, BigInteger m, RandomSource random) {
        if (k.signum() == -1) {
            throw new IllegalArgumentException();
        }
        if (m.signum() == -1) {
            throw new IllegalArgumentException();
        }
        if (g.getQ().bitLength() == 256) {
            m = m.and(SIGNATURE_MASK);
        }
        if (m.compareTo(g.getQ()) != -1) {
            throw new IllegalArgumentException();
        }
        BigInteger r = g.getG().modPow(k, g.getP()).mod(g.getQ());
        BigInteger kInv = k.modInverse(g.getQ());
        return DSA.sign(g, x, r, kInv, m, random);
    }

    public static DSASignature sign(DSAGroup g, DSAPrivateKey x, BigInteger m, RandomSource r) {
        BigInteger k = DSA.generateK(g, r);
        return DSA.sign(g, x, k, m, r);
    }

    static DSASignature sign(DSAGroup g, DSAPrivateKey x, BigInteger r, BigInteger kInv, BigInteger m, RandomSource random) {
        BigInteger s1 = m.add(x.getX().multiply(r)).mod(g.getQ());
        BigInteger s = kInv.multiply(s1).mod(g.getQ());
        if (r.compareTo(BigInteger.ZERO) == 0 || s.compareTo(BigInteger.ZERO) == 0) {
            Logger.normal(DSA.class, "R or S equals 0 : Weird behaviour detected, please report if seen too often.");
            return DSA.sign(g, x, r, DSA.generateK(g, random), m, random);
        }
        return new DSASignature(r, s);
    }

    private static BigInteger generateK(DSAGroup g, Random r) {
        NativeBigInteger k;
        if (g.getQ().bitLength() < 256) {
            throw new IllegalArgumentException("Q is too short! (" + g.getQ().bitLength() + '<' + 256 + ')');
        }
        do {
            k = new NativeBigInteger(256, r);
        } while (g.getQ().compareTo(k) < 1 || k.compareTo(BigInteger.ZERO) < 1);
        return k;
    }

    public static boolean verify(DSAPublicKey kp, DSASignature sig, BigInteger m, boolean forceMod) {
        if (m.signum() == -1) {
            throw new IllegalArgumentException();
        }
        if (kp.getGroup().getQ().bitLength() == 256 && !forceMod) {
            m = m.and(SIGNATURE_MASK);
        }
        try {
            if (sig.getR().compareTo(BigInteger.ZERO) < 1 || kp.getQ().compareTo(sig.getR()) < 1) {
                if (Logger.shouldLog(4, DSA.class)) {
                    Logger.minor(DSA.class, "r < 0 || r > q: r=" + sig.getR() + " q=" + kp.getQ());
                }
                return false;
            }
            if (sig.getS().compareTo(BigInteger.ZERO) < 1 || kp.getQ().compareTo(sig.getS()) < 1) {
                if (Logger.shouldLog(4, DSA.class)) {
                    Logger.minor(DSA.class, "s < 0 || s > q: s=" + sig.getS() + " q=" + kp.getQ());
                }
                return false;
            }
            BigInteger w = sig.getS().modInverse(kp.getQ());
            BigInteger u1 = m.multiply(w).mod(kp.getQ());
            BigInteger u2 = sig.getR().multiply(w).mod(kp.getQ());
            BigInteger v1 = kp.getG().modPow(u1, kp.getP());
            BigInteger v2 = kp.getY().modPow(u2, kp.getP());
            BigInteger v = v1.multiply(v2).mod(kp.getP()).mod(kp.getQ());
            return v.equals(sig.getR());
        }
        catch (ArithmeticException e) {
            if (Logger.shouldLog(4, DSA.class)) {
                Logger.minor(DSA.class, "Verify failed: " + e, (Throwable)e);
            }
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        DSAGroup g = Global.DSAgroupBigA;
        DummyRandomSource y = new DummyRandomSource();
        DSAPrivateKey pk = new DSAPrivateKey(g, y);
        DSAPublicKey pub = new DSAPublicKey(g, pk);
        DSASignature sig = DSA.sign(g, pk, BigInteger.ZERO, y);
        System.err.println(DSA.verify(pub, sig, BigInteger.ZERO, false));
        while (true) {
            long totalTimeSigning = 0L;
            long totalTimeVerifying = 0L;
            long totalRSize = 0L;
            long totalSSize = 0L;
            long totalPubKeySize = 0L;
            long totalPrivKeySize = 0L;
            int maxPrivKeySize = 0;
            int maxPubKeySize = 0;
            int maxRSize = 0;
            int maxSSize = 0;
            int totalRUnsignedBitSize = 0;
            int maxRUnsignedBitSize = 0;
            Random r = new Random(y.nextLong());
            byte[] msg = new byte[32];
            for (int i = 0; i < 1000; ++i) {
                r.nextBytes(msg);
                BigInteger m = new BigInteger(1, msg);
                pk = new DSAPrivateKey(g, r);
                int privKeySize = pk.asBytes().length;
                totalPrivKeySize += (long)privKeySize;
                if (privKeySize > maxPrivKeySize) {
                    maxPrivKeySize = privKeySize;
                }
                pub = new DSAPublicKey(g, pk);
                int pubKeySize = pub.asBytes().length;
                totalPubKeySize += (long)pubKeySize;
                if (pubKeySize > maxPubKeySize) {
                    maxPubKeySize = pubKeySize;
                }
                long t1 = System.currentTimeMillis();
                sig = DSA.sign(g, pk, m, y);
                long t2 = System.currentTimeMillis();
                if (!DSA.verify(pub, sig, m, false)) {
                    System.err.println("Failed to verify!");
                }
                long t3 = System.currentTimeMillis();
                totalTimeSigning += t2 - t1;
                totalTimeVerifying += t3 - t2;
                int rSize = sig.getR().bitLength();
                rSize = rSize / 8 + (rSize % 8 == 0 ? 0 : 1);
                totalRSize += (long)rSize;
                if (rSize > maxRSize) {
                    maxRSize = rSize;
                }
                int rUnsignedBitSize = sig.getR().bitLength();
                totalRUnsignedBitSize += rUnsignedBitSize;
                maxRUnsignedBitSize = Math.max(maxRUnsignedBitSize, rUnsignedBitSize);
                int sSize = sig.getS().bitLength();
                sSize = sSize / 8 + (sSize % 8 == 0 ? 0 : 1);
                totalSSize += (long)sSize;
                if (sSize <= maxSSize) continue;
                maxSSize = sSize;
            }
            System.out.println("Total time signing: " + totalTimeSigning);
            System.out.println("Total time verifying: " + totalTimeVerifying);
            System.out.println("Total R size: " + totalRSize + " (max " + maxRSize + ')');
            System.out.println("Total S size: " + totalSSize + " (max " + maxSSize + ')');
            System.out.println("Total R unsigned bitsize: " + totalRUnsignedBitSize);
            System.out.println("Total pub key size: " + totalPubKeySize + " (max " + maxPubKeySize + ')');
            System.out.println("Total priv key size: " + totalPrivKeySize + " (max " + maxPrivKeySize + ')');
        }
    }
}

