/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.BooleanOption;
import freenet.config.Config;
import freenet.config.IntOption;
import freenet.config.InvalidConfigValueException;
import freenet.config.LongOption;
import freenet.config.NodeNeedRestartException;
import freenet.config.NullBooleanCallback;
import freenet.config.NullIntCallback;
import freenet.config.NullLongCallback;
import freenet.config.NullShortCallback;
import freenet.config.NullStringCallback;
import freenet.config.Option;
import freenet.config.PersistentConfig;
import freenet.config.ShortOption;
import freenet.config.StringArrOption;
import freenet.config.StringOption;
import freenet.l10n.L10n;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.LongCallback;
import freenet.support.api.ShortCallback;
import freenet.support.api.StringArrCallback;
import freenet.support.api.StringCallback;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubConfig
implements Comparable<SubConfig> {
    private final LinkedHashMap<String, Option<?>> map;
    public final Config config;
    final String prefix;
    private boolean hasInitialized;

    public SubConfig(String prefix, Config config) {
        this.config = config;
        this.prefix = prefix;
        this.map = new LinkedHashMap();
        this.hasInitialized = false;
        config.register(this);
    }

    public synchronized Option<?>[] getOptions() {
        return this.map.values().toArray(new Option[this.map.size()]);
    }

    public synchronized Option<?> getOption(String option) {
        return this.map.get(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Option<?> o) {
        SubConfig subConfig = this;
        synchronized (subConfig) {
            if (o.name.indexOf(46) != -1) {
                throw new IllegalArgumentException("Option names must not contain .");
            }
            if (this.map.containsKey(o.name)) {
                throw new IllegalArgumentException("Already registered: " + o.name + " on " + this);
            }
            this.map.put(o.name, o);
        }
        this.config.onRegister(this, o);
    }

    public void register(String optionName, int defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, IntCallback cb, boolean isSize) {
        if (cb == null) {
            cb = new NullIntCallback();
        }
        this.register(new IntOption(this, optionName, defaultValue, sortOrder, expert, forceWrite, shortDesc, longDesc, cb, isSize));
    }

    public void register(String optionName, long defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, LongCallback cb, boolean isSize) {
        if (cb == null) {
            cb = new NullLongCallback();
        }
        this.register(new LongOption(this, optionName, defaultValue, sortOrder, expert, forceWrite, shortDesc, longDesc, cb, isSize));
    }

    public void register(String optionName, String defaultValueString, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, IntCallback cb, boolean isSize) {
        if (cb == null) {
            cb = new NullIntCallback();
        }
        this.register(new IntOption(this, optionName, defaultValueString, sortOrder, expert, forceWrite, shortDesc, longDesc, cb, isSize));
    }

    public void register(String optionName, String defaultValueString, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, LongCallback cb, boolean isSize) {
        if (cb == null) {
            cb = new NullLongCallback();
        }
        this.register(new LongOption(this, optionName, defaultValueString, sortOrder, expert, forceWrite, shortDesc, longDesc, cb, isSize));
    }

    public void register(String optionName, boolean defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, BooleanCallback cb) {
        if (cb == null) {
            cb = new NullBooleanCallback();
        }
        this.register(new BooleanOption(this, optionName, defaultValue, sortOrder, expert, forceWrite, shortDesc, longDesc, cb));
    }

    public void register(String optionName, String defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, StringCallback cb) {
        if (cb == null) {
            cb = new NullStringCallback();
        }
        this.register(new StringOption(this, optionName, defaultValue, sortOrder, expert, forceWrite, shortDesc, longDesc, cb));
    }

    public void register(String optionName, short defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, ShortCallback cb, boolean isSize) {
        if (cb == null) {
            cb = new NullShortCallback();
        }
        this.register(new ShortOption(this, optionName, defaultValue, sortOrder, expert, forceWrite, shortDesc, longDesc, cb, isSize));
    }

    public void register(String optionName, String[] defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, StringArrCallback cb) {
        this.register(new StringArrOption(this, optionName, defaultValue, sortOrder, expert, forceWrite, shortDesc, longDesc, cb));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String optionName) {
        IntOption o;
        SubConfig subConfig = this;
        synchronized (subConfig) {
            o = (IntOption)this.map.get(optionName);
        }
        return (Integer)o.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String optionName) {
        LongOption o;
        SubConfig subConfig = this;
        synchronized (subConfig) {
            o = (LongOption)this.map.get(optionName);
        }
        return (Long)o.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String optionName) {
        BooleanOption o;
        SubConfig subConfig = this;
        synchronized (subConfig) {
            o = (BooleanOption)this.map.get(optionName);
        }
        return (Boolean)o.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String optionName) {
        StringOption o;
        SubConfig subConfig = this;
        synchronized (subConfig) {
            o = (StringOption)this.map.get(optionName);
        }
        return ((String)o.getValue()).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStringArr(String optionName) {
        StringArrOption o;
        SubConfig subConfig = this;
        synchronized (subConfig) {
            o = (StringArrOption)this.map.get(optionName);
        }
        return (String[])o.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(String optionName) {
        ShortOption o;
        SubConfig subConfig = this;
        synchronized (subConfig) {
            o = (ShortOption)this.map.get(optionName);
        }
        return (Short)o.getValue();
    }

    public boolean hasFinishedInitialization() {
        return this.hasInitialized;
    }

    public void finishedInitialization() {
        this.hasInitialized = true;
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Finished initialization on " + this + " (" + this.prefix + ')');
        }
    }

    public void setOptions(SimpleFieldSet sfs) {
        Set<Map.Entry<String, Option<?>>> entrySet = this.map.entrySet();
        for (Map.Entry<String, Option<?>> entry : entrySet) {
            String msg;
            String key = entry.getKey();
            Option<?> o = entry.getValue();
            String val = sfs.get(key);
            if (val == null) continue;
            try {
                o.setValue(val);
            }
            catch (InvalidConfigValueException e) {
                msg = "Invalid config value: " + this.prefix + '.' + key + " = " + val + " : error: " + e;
                Logger.error(this, msg, e);
                System.err.println(msg);
            }
            catch (NodeNeedRestartException e) {
                msg = "Impossible: " + this.prefix + '.' + key + " = " + val + " : error: " + e;
                Logger.error(this, msg, e);
            }
        }
    }

    public SimpleFieldSet exportFieldSet() {
        return this.exportFieldSet(false);
    }

    public SimpleFieldSet exportFieldSet(boolean withDefaults) {
        return this.exportFieldSet(Config.RequestType.CURRENT_SETTINGS, withDefaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFieldSet exportFieldSet(Config.RequestType configRequestType, boolean withDefaults) {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        Map.Entry[] entries = new Map.Entry[this.map.size()];
        SubConfig subConfig = this;
        synchronized (subConfig) {
            entries = this.map.entrySet().toArray(entries);
        }
        boolean logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "Prefix=" + this.prefix);
        }
        for (int i = 0; i < entries.length; ++i) {
            Map.Entry entry = entries[i];
            String key = (String)entry.getKey();
            Option o = (Option)entry.getValue();
            if (logMINOR) {
                Logger.minor(this, "Key=" + key + " value=" + o.getValueString() + " default=" + o.isDefault());
            }
            if (configRequestType == Config.RequestType.CURRENT_SETTINGS && !withDefaults && o.isDefault() && !o.forceWrite) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping " + key + " - " + o.isDefault());
                continue;
            }
            switch (configRequestType) {
                case CURRENT_SETTINGS: {
                    fs.putSingle(key, o.getValueString());
                    break;
                }
                case DEFAULT_SETTINGS: {
                    fs.putSingle(key, o.getDefault());
                    break;
                }
                case SORT_ORDER: {
                    fs.put(key, o.getSortOrder());
                    break;
                }
                case EXPERT_FLAG: {
                    fs.put(key, o.isExpert());
                    break;
                }
                case FORCE_WRITE_FLAG: {
                    fs.put(key, o.isForcedWrite());
                    break;
                }
                case SHORT_DESCRIPTION: {
                    fs.putSingle(key, L10n.getString(o.getShortDesc()));
                    break;
                }
                case LONG_DESCRIPTION: {
                    fs.putSingle(key, L10n.getString(o.getLongDesc()));
                    break;
                }
                case DATA_TYPE: {
                    fs.putSingle(key, o.getDataTypeStr());
                    break;
                }
                default: {
                    Logger.error(this, "Unknown config request type value: " + (Object)((Object)configRequestType));
                }
            }
            if (!logMINOR) continue;
            Logger.minor(this, "Key=" + this.prefix + '.' + key + " value=" + o.getValueString());
        }
        return fs;
    }

    public void forceUpdate(String optionName) throws InvalidConfigValueException, NodeNeedRestartException {
        Option<?> o = this.map.get(optionName);
        o.forceUpdate();
    }

    public void set(String name, String value) throws InvalidConfigValueException, NodeNeedRestartException {
        Option<?> o = this.map.get(name);
        o.setValue(value);
    }

    public void set(String name, boolean value) throws InvalidConfigValueException, NodeNeedRestartException {
        BooleanOption o = (BooleanOption)this.map.get(name);
        o.set(value);
    }

    public void fixOldDefault(String name, String value) {
        Option<?> o = this.map.get(name);
        if (o.getValueString().equals(value)) {
            o.setDefault();
        }
    }

    public void fixOldDefaultRegex(String name, String value) {
        Option<?> o = this.map.get(name);
        if (o.getValueString().matches(value)) {
            o.setDefault();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public int compareTo(SubConfig second) {
        if (this.getPrefix().compareTo(second.getPrefix()) > 0) {
            return 1;
        }
        return -1;
    }

    public String getRawOption(String name) {
        if (this.config instanceof PersistentConfig) {
            PersistentConfig pc = (PersistentConfig)this.config;
            if (pc.finishedInit) {
                throw new IllegalStateException("getRawOption(" + name + ") on " + this + " but persistent config has been finishedInit() already!");
            }
            SimpleFieldSet fs = pc.origConfigFileContents;
            if (fs == null) {
                return null;
            }
            return fs.get(this.prefix + '.' + name);
        }
        return null;
    }
}

