/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.InvalidConfigValueException;
import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.l10n.L10n;
import freenet.support.Fields;
import freenet.support.api.LongCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongOption
extends Option<Long> {
    protected final boolean isSize;

    public LongOption(SubConfig conf, String optionName, String defaultValueString, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, LongCallback cb, boolean isSize) {
        this(conf, optionName, Fields.parseLong(defaultValueString), sortOrder, expert, forceWrite, shortDesc, longDesc, cb, isSize);
    }

    public LongOption(SubConfig conf, String optionName, Long defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, LongCallback cb, boolean isSize) {
        super(conf, optionName, cb, sortOrder, expert, forceWrite, shortDesc, longDesc, Option.DataType.NUMBER);
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.isSize = isSize;
    }

    @Override
    protected Long parseString(String val) throws InvalidConfigValueException {
        Long x;
        try {
            x = Fields.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigValueException(this.l10n("parseError", "val", val));
        }
        return x;
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("LongOption." + key, pattern, value);
    }

    @Override
    protected String toString(Long val) {
        return Fields.longToString(val, this.isSize);
    }
}

