/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.FilePersistentConfig;
import freenet.node.Ticker;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.io.File;
import java.io.IOException;

public class FreenetFilePersistentConfig
extends FilePersistentConfig {
    private volatile boolean isWritingConfig = false;
    private volatile boolean hasNodeStarted = false;
    private Ticker ticker;
    public final Runnable thread = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                while (!FreenetFilePersistentConfig.this.hasNodeStarted) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            try {
                FreenetFilePersistentConfig.this.innerStore();
            }
            catch (IOException e) {
                String err = "Cannot store config: " + e;
                Logger.error(this, err, e);
                System.err.println(err);
                e.printStackTrace();
            }
            object = FreenetFilePersistentConfig.this.storeSync;
            synchronized (object) {
                FreenetFilePersistentConfig.this.isWritingConfig = false;
            }
        }
    };

    public FreenetFilePersistentConfig(SimpleFieldSet set, File filename, File tempFilename) throws IOException {
        super(set, filename, tempFilename);
    }

    public static FreenetFilePersistentConfig constructFreenetFilePersistentConfig(File f) throws IOException {
        File filename = f;
        File tempFilename = new File(f.getPath() + ".tmp");
        return new FreenetFilePersistentConfig(FreenetFilePersistentConfig.load(filename, tempFilename), filename, tempFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        Object object = this;
        synchronized (object) {
            if (!this.finishedInit) {
                Logger.minor(this, "Initialization not finished, refusing to write config", (Throwable)new Exception("error"));
                return;
            }
        }
        object = this.storeSync;
        synchronized (object) {
            if (this.isWritingConfig || this.ticker == null) {
                Logger.normal(this, "Already writing the config file to disk or the node object hasn't been set : refusing to proceed");
                return;
            }
            this.isWritingConfig = true;
            this.ticker.queueTimedJob(this.thread, 0L);
        }
    }

    public void finishedInit(Ticker ticker) {
        super.finishedInit();
        this.ticker = ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasNodeStarted() {
        FreenetFilePersistentConfig freenetFilePersistentConfig = this;
        synchronized (freenetFilePersistentConfig) {
            if (this.hasNodeStarted) {
                Logger.error(this, "It has already been called! that shouldn't happen!");
            }
            this.hasNodeStarted = true;
            this.notifyAll();
        }
    }
}

