/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.UnsafeContentTypeException;
import freenet.l10n.L10n;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;

public class UnknownContentTypeException
extends UnsafeContentTypeException {
    private static final long serialVersionUID = -1L;
    final String type;
    final String encodedType;

    public UnknownContentTypeException(String typeName) {
        this.type = typeName;
        this.encodedType = HTMLEncoder.encode(this.type);
    }

    public String getType() {
        return this.type;
    }

    public String getHTMLEncodedTitle() {
        return UnknownContentTypeException.l10n("title", "type", this.encodedType);
    }

    public String getRawTitle() {
        return UnknownContentTypeException.l10n("title", "type", this.type);
    }

    public String getExplanation() {
        return UnknownContentTypeException.l10n("explanation");
    }

    public HTMLNode getHTMLExplanation() {
        return new HTMLNode("div", UnknownContentTypeException.l10n("explanation"));
    }

    private static String l10n(String key) {
        return L10n.getString("UnknownContentTypeException." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return L10n.getString("UnknownContentTypeException." + key, pattern, value);
    }
}

