/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.ContentDataFilter;
import freenet.clients.http.filter.ContentFilter;
import freenet.clients.http.filter.DataFilterException;
import freenet.clients.http.filter.FilterCallback;
import freenet.l10n.L10n;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PNGFilter
implements ContentDataFilter {
    private final boolean deleteText;
    private final boolean deleteTimestamp;
    private final boolean checkCRCs;
    static final byte[] pngHeader = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static final String[] HARMLESS_CHUNK_TYPES = new String[]{"tRNS", "cHRM", "gAMA", "iCCP", "sBIT", "sRGB", "bKGD", "hIST", "pHYs", "sPLT", "acTL", "fcTL", "fdAT"};

    PNGFilter(boolean deleteText, boolean deleteTimestamp, boolean checkCRCs) {
        this.deleteText = deleteText;
        this.deleteTimestamp = deleteTimestamp;
        this.checkCRCs = checkCRCs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket readFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        Bucket output = this.readFilter(data, bf, charset, otherParams, cb, this.deleteText, this.deleteTimestamp, this.checkCRCs, null);
        if (output != null) {
            return output;
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Need to modify PNG...");
        }
        Bucket filtered = bf.makeBucket(-1L);
        BufferedOutputStream os = new BufferedOutputStream(filtered.getOutputStream());
        try {
            this.readFilter(data, bf, charset, otherParams, cb, this.deleteText, this.deleteTimestamp, this.checkCRCs, os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            os = null;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            Closer.close(os);
            throw throwable;
        }
        Closer.close(os);
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bucket readFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb, boolean deleteText, boolean deleteTimestamp, boolean checkCRCs, OutputStream output) throws DataFilterException, IOException {
        boolean logMINOR = Logger.shouldLog(4, this);
        boolean logDEBUG = Logger.shouldLog(2, this);
        InputStream is = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        try {
            try {
                is = data.getInputStream();
                bis = new BufferedInputStream(is);
                dis = new DataInputStream(bis);
                byte[] headerCheck = new byte[pngHeader.length];
                dis.readFully(headerCheck);
                if (!Arrays.equals(headerCheck, pngHeader)) {
                    String message = this.l10n("invalidHeader");
                    String title = this.l10n("invalidHeaderTitle");
                    throw new DataFilterException(title, title, "<p>" + message + "</p>", new HTMLNode("p").addChild("#", message));
                }
                ByteArrayOutputStream baos = null;
                DataOutputStream dos = null;
                if (output != null) {
                    baos = new ByteArrayOutputStream();
                    dos = new DataOutputStream(baos);
                    output.write(pngHeader);
                    if (logMINOR) {
                        Logger.minor(this, "Writing the PNG header to the output bucket");
                    }
                }
                boolean finished = false;
                boolean hasSeenIHDR = false;
                boolean hasSeenIEND = false;
                boolean hasSeenIDAT = false;
                String lastChunkType = "";
                while (!finished) {
                    boolean skip = false;
                    if (baos != null) {
                        baos.reset();
                    }
                    String chunkTypeString = null;
                    byte[] lengthBytes = new byte[4];
                    dis.readFully(lengthBytes);
                    int length = ((lengthBytes[0] & 0xFF) << 24) + ((lengthBytes[1] & 0xFF) << 16) + ((lengthBytes[2] & 0xFF) << 8) + (lengthBytes[3] & 0xFF);
                    if (logMINOR) {
                        Logger.minor(this, "length " + length);
                    }
                    if (dos != null) {
                        dos.write(lengthBytes);
                    }
                    dis.readFully(lengthBytes);
                    StringBuilder sb = new StringBuilder();
                    byte[] chunkTypeBytes = new byte[4];
                    for (int i = 0; i < 4; ++i) {
                        char val = (char)lengthBytes[i];
                        if (val >= 'A' && val <= 'c' || val >= 'a' && val <= 'z') {
                            chunkTypeBytes[i] = lengthBytes[i];
                            sb.append(val);
                            continue;
                        }
                        String chunkName = HexUtil.bytesToHex(lengthBytes, 0, 4);
                        this.throwError("Unknown Chunk", "The name of the chunk is invalid! (" + chunkName + ")");
                    }
                    chunkTypeString = sb.toString();
                    if (logMINOR) {
                        Logger.minor(this, "name " + chunkTypeString);
                    }
                    byte[] chunkData = new byte[length];
                    dis.readFully(chunkData, 0, length);
                    if (logMINOR) {
                        if (logDEBUG) {
                            Logger.minor(this, "data " + (chunkData.length == 0 ? "null" : HexUtil.bytesToHex(chunkData)));
                        } else {
                            Logger.minor(this, "data " + chunkData.length);
                        }
                    }
                    if (dos != null) {
                        dos.write(chunkTypeBytes);
                    }
                    if (dos != null) {
                        dos.write(chunkData);
                    }
                    byte[] crcLengthBytes = new byte[4];
                    dis.readFully(crcLengthBytes);
                    if (dos != null) {
                        dos.write(crcLengthBytes);
                    }
                    if (checkCRCs) {
                        long readCRC = (long)(((crcLengthBytes[0] & 0xFF) << 24) + ((crcLengthBytes[1] & 0xFF) << 16) + ((crcLengthBytes[2] & 0xFF) << 8) + (crcLengthBytes[3] & 0xFF)) & 0xFFFFFFFFL;
                        CRC32 crc = new CRC32();
                        crc.update(chunkTypeBytes);
                        crc.update(chunkData);
                        long computedCRC = crc.getValue();
                        if (readCRC != computedCRC) {
                            skip = true;
                            if (logMINOR) {
                                Logger.minor(this, "CRC of the chunk " + chunkTypeString + " doesn't match (" + Long.toHexString(readCRC) + " but should be " + Long.toHexString(computedCRC) + ")!");
                            }
                        }
                    }
                    boolean validChunkType = false;
                    if (!skip && "IHDR".equals(chunkTypeString)) {
                        if (hasSeenIHDR) {
                            this.throwError("Duplicate IHDR", "Two IHDR chunks detected!!");
                        }
                        hasSeenIHDR = true;
                        validChunkType = true;
                    }
                    if (!hasSeenIHDR) {
                        this.throwError("No IHDR chunk!", "No IHDR chunk!");
                    }
                    if (!skip && "IEND".equals(chunkTypeString)) {
                        if (hasSeenIEND) {
                            this.throwError("Two IEND chunks detected!!", "Two IEND chunks detected!!");
                        }
                        hasSeenIEND = true;
                        validChunkType = true;
                    }
                    if (!skip && "PLTE".equalsIgnoreCase(chunkTypeString)) {
                        if (hasSeenIDAT) {
                            this.throwError("PLTE must be before IDAT", "PLTE must be before IDAT");
                        }
                        validChunkType = true;
                    }
                    if (!skip && "IDAT".equalsIgnoreCase(chunkTypeString)) {
                        if (hasSeenIDAT && !"IDAT".equalsIgnoreCase(lastChunkType)) {
                            this.throwError("Multiple IDAT chunks must be consecutive!", "Multiple IDAT chunks must be consecutive!");
                        }
                        hasSeenIDAT = true;
                        validChunkType = true;
                    }
                    if (!validChunkType) {
                        for (int i = 0; i < HARMLESS_CHUNK_TYPES.length; ++i) {
                            if (!HARMLESS_CHUNK_TYPES[i].equals(chunkTypeString)) continue;
                            validChunkType = true;
                        }
                    }
                    if (dis.available() < 1) {
                        if (!hasSeenIEND || !hasSeenIHDR) {
                            this.throwError("Missing IEND or IHDR!", "Missing IEND or IHDR!");
                        }
                        finished = true;
                    }
                    if ("text".equalsIgnoreCase(chunkTypeString) || "itxt".equalsIgnoreCase(chunkTypeString) || "ztxt".equalsIgnoreCase(chunkTypeString)) {
                        if (deleteText) {
                            skip = true;
                        } else {
                            validChunkType = true;
                        }
                    } else if (deleteTimestamp && "time".equalsIgnoreCase(chunkTypeString)) {
                        if (deleteTimestamp) {
                            skip = true;
                        } else {
                            validChunkType = true;
                        }
                    }
                    if (!validChunkType) {
                        if (logMINOR) {
                            Logger.minor(this, "Skipping unknown chunk type " + chunkTypeString);
                        }
                        if (output == null) {
                            Bucket bucket = null;
                            Object var37_46 = null;
                            Closer.close(dis);
                            Closer.close(bis);
                            Closer.close(is);
                            return bucket;
                        }
                        skip = true;
                    }
                    if (skip && output == null) {
                        Bucket bucket = null;
                        Object var37_47 = null;
                        Closer.close(dis);
                        Closer.close(bis);
                        Closer.close(is);
                        return bucket;
                    }
                    if (!skip && output != null) {
                        if (logMINOR) {
                            Logger.minor(this, "Writing " + chunkTypeString + " (" + baos.size() + ") to the output bucket");
                        }
                        baos.writeTo(output);
                        baos.flush();
                    }
                    lastChunkType = chunkTypeString;
                }
                if (hasSeenIEND && dis.available() > 0) {
                    this.throwError("IEND not last chunk", "IEND not last chunk");
                }
                dis.close();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.throwError("ArrayIndexOutOfBoundsException while filtering", "ArrayIndexOutOfBoundsException while filtering");
                Object var37_49 = null;
                Closer.close(dis);
                Closer.close(bis);
                Closer.close(is);
                return data;
            }
            catch (NegativeArraySizeException e) {
                this.throwError("NegativeArraySizeException while filtering", "NegativeArraySizeException while filtering");
                Object var37_50 = null;
                Closer.close(dis);
                Closer.close(bis);
                Closer.close(is);
                return data;
            }
            catch (EOFException e) {
                this.throwError("EOF Exception while filtering", "EOF Exception while filtering");
                Object var37_51 = null;
                Closer.close(dis);
                Closer.close(bis);
                Closer.close(is);
                return data;
            }
        }
        catch (Throwable throwable) {
            Object var37_52 = null;
            Closer.close(dis);
            Closer.close(bis);
            Closer.close(is);
            throw throwable;
        }
        Object var37_48 = null;
        Closer.close(dis);
        Closer.close(bis);
        Closer.close(is);
        return data;
    }

    private String l10n(String key) {
        return L10n.getString("PNGFilter." + key);
    }

    @Override
    public Bucket writeFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) {
        block6: {
            File fin = new File("/tmp/test.png");
            File fout = new File("/tmp/test2.png");
            fout.delete();
            FileBucket data = new FileBucket(fin, true, false, false, false, false);
            FileBucket out = new FileBucket(fout, false, true, false, false, false);
            try {
                try {
                    Logger.setupStdoutLogging(4, "");
                    ContentFilter.FilterOutput output = ContentFilter.filter(data, new ArrayBucketFactory(), "image/png", new URI("http://127.0.0.1:8888/"), null);
                    BucketTools.copy(output.data, out);
                }
                catch (IOException e) {
                    System.out.println("Bucket error?: " + e.getMessage());
                    Object var7_10 = null;
                    data.free();
                    break block6;
                }
                catch (URISyntaxException e) {
                    System.out.println("Internal error: " + e.getMessage());
                    Object var7_11 = null;
                    data.free();
                    break block6;
                }
                catch (LoggerHook.InvalidThresholdException e) {
                    Object var7_12 = null;
                    data.free();
                }
                Object var7_9 = null;
                data.free();
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                data.free();
                throw throwable;
            }
        }
    }

    private void throwError(String shortReason, String reason) throws DataFilterException {
        String message = "Invalid PNG";
        if (reason != null) {
            message = message + ' ' + reason;
        }
        if (shortReason != null) {
            message = message + " - " + shortReason;
        }
        DataFilterException e = new DataFilterException(shortReason, shortReason, "<p>" + message + "</p>", new HTMLNode("p").addChild("#", message));
        if (Logger.shouldLog(8, this)) {
            Logger.normal(this, "Throwing " + e, e);
        }
        throw e;
    }
}

