/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.MIMEType;
import freenet.clients.http.filter.UnsafeContentTypeException;
import freenet.l10n.L10n;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;

public class KnownUnsafeContentTypeException
extends UnsafeContentTypeException {
    private static final long serialVersionUID = -1L;
    MIMEType type;

    public KnownUnsafeContentTypeException(MIMEType type) {
        this.type = type;
    }

    public String getExplanation() {
        StringBuilder sb = new StringBuilder();
        sb.append("<p><b>");
        sb.append(this.type.readDescription);
        sb.append("</b></p>\n<p>" + KnownUnsafeContentTypeException.l10n("knownUnsafe") + "<ul>");
        if (this.type.dangerousInlines) {
            sb.append("<li><font color=\"red\"><b>" + KnownUnsafeContentTypeException.l10n("dangerousInlinesLabel") + "</b></font> " + KnownUnsafeContentTypeException.l10n("dangerousInline") + "</li>");
        }
        if (this.type.dangerousLinks) {
            sb.append("<li><font color=\"red\"><b>" + KnownUnsafeContentTypeException.l10n("dangerousLinksLabel") + "</b></font> " + KnownUnsafeContentTypeException.l10n("dangerousLinks") + "</li>");
        }
        if (this.type.dangerousScripting) {
            sb.append("<li><font color=\"red\"><b>" + KnownUnsafeContentTypeException.l10n("dangerousScriptsLabel") + "</b></font> " + KnownUnsafeContentTypeException.l10n("dangerousScripts") + "</li>");
        }
        if (this.type.dangerousReadMetadata) {
            sb.append("<li><font color=\"red\"><b>" + KnownUnsafeContentTypeException.l10n("dangerousMetadataLabel") + "</b></font> " + KnownUnsafeContentTypeException.l10n("dangerousMetadata") + "</li>");
        }
        sb.append("</ul>" + KnownUnsafeContentTypeException.l10n("noFilter"));
        return sb.toString();
    }

    public HTMLNode getHTMLExplanation() {
        HTMLNode explanation = new HTMLNode("div");
        explanation.addChild("p").addChild("b", this.type.readDescription);
        explanation.addChild("p", KnownUnsafeContentTypeException.l10n("knownUnsafe"));
        HTMLNode list = explanation.addChild("ul");
        HTMLNode reason = list.addChild("li");
        reason.addChild("span", "class", "warning", KnownUnsafeContentTypeException.l10n("dangerousInlinesLabel"));
        reason.addChild("#", " " + KnownUnsafeContentTypeException.l10n("dangerousInlines"));
        reason = list.addChild("li");
        reason.addChild("span", "class", "warning", KnownUnsafeContentTypeException.l10n("dangerousLinksLabel"));
        reason.addChild("#", " " + KnownUnsafeContentTypeException.l10n("dangerousLinks"));
        reason = list.addChild("li");
        reason.addChild("span", "class", "warning", KnownUnsafeContentTypeException.l10n("dangerousScriptsLabel"));
        reason.addChild("#", " " + KnownUnsafeContentTypeException.l10n("dangerousScripts"));
        reason = list.addChild("li");
        reason.addChild("span", "class", "warning", KnownUnsafeContentTypeException.l10n("dangerousMetadataLabel"));
        reason.addChild("#", " " + KnownUnsafeContentTypeException.l10n("dangerousMetadata"));
        explanation.addChild("p", KnownUnsafeContentTypeException.l10n("noFilter"));
        return explanation;
    }

    public String getHTMLEncodedTitle() {
        return KnownUnsafeContentTypeException.l10n("title", "type", HTMLEncoder.encode(this.type.primaryMimeType));
    }

    public String getRawTitle() {
        return KnownUnsafeContentTypeException.l10n("title", "type", this.type.primaryMimeType);
    }

    private static String l10n(String key) {
        return L10n.getString("KnownUnsafeContentTypeException." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return L10n.getString("KnownUnsafeContentTypeException." + key, pattern, value);
    }
}

