/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.ContentDataFilter;
import freenet.clients.http.filter.DataFilterException;
import freenet.clients.http.filter.FilterCallback;
import freenet.l10n.L10n;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import freenet.support.io.CountedInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPEGFilter
implements ContentDataFilter {
    private final boolean deleteComments;
    private final boolean deleteExif;
    private static final int MARKER_EOI = 217;
    private static final int MARKER_RST0 = 208;
    private static final int MARKER_RST7 = 215;
    static final byte[] soi = new byte[]{-1, -40};
    static final byte[] identifier = new byte[]{74, 70, 73, 70, 0};
    static final byte[] extensionIdentifier = new byte[]{74, 70, 88, 88, 0};

    JPEGFilter(boolean deleteComments, boolean deleteExif) {
        this.deleteComments = deleteComments;
        this.deleteExif = deleteExif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket readFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        Bucket output = this.readFilter(data, bf, charset, otherParams, cb, this.deleteComments, this.deleteExif, null);
        if (output != null) {
            return output;
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Need to modify JPEG...");
        }
        Bucket filtered = bf.makeBucket(-1L);
        BufferedOutputStream os = new BufferedOutputStream(filtered.getOutputStream());
        try {
            this.readFilter(data, bf, charset, otherParams, cb, this.deleteComments, this.deleteExif, os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            os = null;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            Closer.close(os);
            throw throwable;
        }
        Closer.close(os);
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bucket readFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb, boolean deleteComments, boolean deleteExif, OutputStream output) throws DataFilterException, IOException {
        DataInputStream dis;
        block80: {
            Bucket type22;
            block79: {
                Bucket type22;
                block78: {
                    Bucket extensionCode2;
                    block77: {
                        Bucket bucket;
                        block75: {
                            boolean logMINOR = Logger.shouldLog(4, this);
                            long length = data.size();
                            if (length < 6L) {
                                this.throwError(JPEGFilter.l10n("tooShortTitle"), JPEGFilter.l10n("tooShort"));
                            }
                            InputStream is = data.getInputStream();
                            BufferedInputStream bis = new BufferedInputStream(is);
                            CountedInputStream cis = new CountedInputStream(bis);
                            dis = new DataInputStream(cis);
                            try {
                                this.assertHeader(dis, soi);
                                if (output != null) {
                                    output.write(soi);
                                }
                                ByteArrayOutputStream baos = null;
                                DataOutputStream dos = null;
                                if (output != null) {
                                    baos = new ByteArrayOutputStream();
                                    dos = new DataOutputStream(baos);
                                }
                                boolean finished = false;
                                int forceMarkerType = -1;
                                block5: while (dos == null || !finished) {
                                    int blockLength;
                                    long countAtStart;
                                    int markerType;
                                    block76: {
                                        block81: {
                                            String type22;
                                            block82: {
                                                int thumbLen;
                                                int units;
                                                int minorVersion;
                                                if (baos != null) {
                                                    baos.reset();
                                                }
                                                if (forceMarkerType != -1) {
                                                    markerType = forceMarkerType;
                                                    forceMarkerType = -1;
                                                } else {
                                                    int markerStart = dis.read();
                                                    if (markerStart == -1) break;
                                                    if (finished) {
                                                        if (logMINOR) {
                                                            Logger.minor(this, "More data after EOI, copying to truncate");
                                                        }
                                                        bucket = null;
                                                        Object var33_39 = null;
                                                        break block75;
                                                    }
                                                    if (markerStart != 255) {
                                                        this.throwError("Invalid marker", "The file includes an invalid marker start " + Integer.toHexString(markerStart) + " and cannot be parsed further.");
                                                    }
                                                    if (baos != null) {
                                                        baos.write(255);
                                                    }
                                                    markerType = dis.readUnsignedByte();
                                                    if (baos != null) {
                                                        baos.write(markerType);
                                                    }
                                                }
                                                if (logMINOR) {
                                                    Logger.minor(this, "Marker type: " + Integer.toHexString(markerType));
                                                }
                                                countAtStart = cis.count();
                                                if (markerType == 217 || markerType >= 208 && markerType <= 215) {
                                                    blockLength = 0;
                                                } else {
                                                    blockLength = dis.readUnsignedShort();
                                                    if (dos != null) {
                                                        dos.writeShort(blockLength);
                                                    }
                                                }
                                                if (markerType == 218) {
                                                    if (blockLength < 2) {
                                                        this.throwError("Invalid frame length", "The file includes an invalid frame (length " + blockLength + ").");
                                                    }
                                                    if (dos != null) {
                                                        byte[] buf = new byte[blockLength - 2];
                                                        dis.readFully(buf);
                                                        dos.write(buf);
                                                    } else {
                                                        this.skipBytes(dis, blockLength - 2);
                                                    }
                                                    Logger.minor(this, "Copied start-of-frame marker length " + (blockLength - 2));
                                                    if (baos != null) {
                                                        baos.writeTo(output);
                                                    }
                                                    int prevChar = -1;
                                                    while (true) {
                                                        int x = dis.read();
                                                        if (prevChar != -1 && output != null) {
                                                            output.write(prevChar);
                                                        }
                                                        if (x == -1) continue block5;
                                                        if (prevChar == 255 && x != 0 && (x < 208 || x > 215)) {
                                                            forceMarkerType = x;
                                                            if (logMINOR) {
                                                                Logger.minor(this, "Moved scan at " + cis.count() + ", found a marker type " + Integer.toHexString(x));
                                                            }
                                                            if (output == null) continue block5;
                                                            output.write(x);
                                                            continue block5;
                                                        }
                                                        prevChar = x;
                                                    }
                                                }
                                                if (markerType != 224) break block81;
                                                if (logMINOR) {
                                                    Logger.minor(this, "APP0");
                                                }
                                                type22 = this.readNullTerminatedAsciiString(dis);
                                                if (baos != null) {
                                                    this.writeNullTerminatedString(baos, type22);
                                                }
                                                if (logMINOR) {
                                                    Logger.minor(this, "Type: " + type22 + " length " + type22.length());
                                                }
                                                if (!type22.equals("JFIF")) break block82;
                                                Logger.minor(this, "JFIF Header");
                                                int majorVersion = dis.readUnsignedByte();
                                                if (majorVersion != 1) {
                                                    this.throwError("Invalid header", "Unrecognized major version " + majorVersion + ".");
                                                }
                                                if (dos != null) {
                                                    dos.write(majorVersion);
                                                }
                                                if ((minorVersion = dis.readUnsignedByte()) > 2) {
                                                    this.throwError("Invalid header", "Unrecognized version 1." + minorVersion + ".");
                                                }
                                                if (dos != null) {
                                                    dos.write(minorVersion);
                                                }
                                                if ((units = dis.readUnsignedByte()) > 2) {
                                                    this.throwError("Invalid header", "Unrecognized units type " + units + ".");
                                                }
                                                if (dos != null) {
                                                    dos.write(units);
                                                }
                                                if (dos != null) {
                                                    dos.writeShort(dis.readShort());
                                                    dos.writeShort(dis.readShort());
                                                } else {
                                                    dis.readShort();
                                                    dis.readShort();
                                                }
                                                int thumbX = dis.readUnsignedByte();
                                                if (dos != null) {
                                                    dos.writeByte(thumbX);
                                                }
                                                int thumbY = dis.readUnsignedByte();
                                                if (dos != null) {
                                                    dos.writeByte(thumbY);
                                                }
                                                if ((long)(thumbLen = thumbX * thumbY * 3) > length - cis.count()) {
                                                    this.throwError("Invalid header", "There should be " + thumbLen + " bytes of thumbnail but there are only " + (length - cis.count()) + " bytes left in the file.");
                                                }
                                                if (dos != null) {
                                                    byte[] buf = new byte[thumbLen];
                                                    dis.readFully(buf);
                                                    dos.write(buf);
                                                    break block76;
                                                } else {
                                                    this.skipBytes(dis, thumbLen);
                                                }
                                                break block76;
                                            }
                                            if (type22.equals("JFXX")) {
                                                int extensionCode2 = dis.readUnsignedByte();
                                                if (extensionCode2 == 16 || extensionCode2 == 17 || extensionCode2 == 19) {
                                                    this.skipRest(blockLength, countAtStart, cis, dis, dos, "thumbnail frame");
                                                    Logger.minor(this, "Thumbnail frame");
                                                    break block76;
                                                } else {
                                                    this.throwError("Unknown JFXX extension " + extensionCode2, "The file contains an unknown JFXX extension.");
                                                }
                                                break block76;
                                            } else {
                                                if (logMINOR) {
                                                    Logger.minor(this, "Dropping application-specific APP0 chunk named " + type22);
                                                }
                                                if (output == null) {
                                                    extensionCode2 = null;
                                                    break block77;
                                                } else {
                                                    this.skipRest(blockLength, countAtStart, cis, dis, dos, "application-specific frame");
                                                    continue;
                                                }
                                            }
                                        }
                                        if (markerType == 225) {
                                            if (output == null && deleteExif) {
                                                type22 = null;
                                                break block78;
                                            }
                                            if (deleteExif) {
                                                if (logMINOR) {
                                                    Logger.minor(this, "Dropping EXIF data");
                                                }
                                                this.skipBytes(dis, blockLength - 2);
                                                continue;
                                            }
                                            this.skipRest(blockLength, countAtStart, cis, dis, dos, "EXIF frame");
                                        } else if (markerType == 254) {
                                            if (output == null && deleteComments) {
                                                type22 = null;
                                                break block79;
                                            }
                                            if (deleteComments) {
                                                this.skipBytes(dis, blockLength - 2);
                                                if (!logMINOR) continue;
                                                Logger.minor(this, "Dropping comment length " + (blockLength - 2) + '.');
                                                continue;
                                            }
                                            this.skipRest(blockLength, countAtStart, cis, dis, dos, "comment");
                                        } else if (markerType == 217) {
                                            finished = true;
                                            if (logMINOR) {
                                                Logger.minor(this, "End of image");
                                            }
                                        } else {
                                            boolean valid = false;
                                            switch (markerType) {
                                                case 192: 
                                                case 193: 
                                                case 194: 
                                                case 195: 
                                                case 196: 
                                                case 197: 
                                                case 198: 
                                                case 199: 
                                                case 201: 
                                                case 202: 
                                                case 203: 
                                                case 204: 
                                                case 205: 
                                                case 207: 
                                                case 208: 
                                                case 209: 
                                                case 210: 
                                                case 211: 
                                                case 212: 
                                                case 213: 
                                                case 214: 
                                                case 215: 
                                                case 216: 
                                                case 217: 
                                                case 218: 
                                                case 219: 
                                                case 220: 
                                                case 221: 
                                                case 222: 
                                                case 223: {
                                                    valid = true;
                                                    break;
                                                }
                                            }
                                            if (valid) {
                                                if (blockLength < 2) {
                                                    this.throwError("Invalid frame length", "The file includes an invalid frame (length " + blockLength + ").");
                                                }
                                                if (dos != null) {
                                                    byte[] buf = new byte[blockLength - 2];
                                                    dis.readFully(buf);
                                                    dos.write(buf);
                                                } else {
                                                    this.skipBytes(dis, blockLength - 2);
                                                }
                                                Logger.minor(this, "Essential frame type " + Integer.toHexString(markerType) + " length " + (blockLength - 2) + " offset at end " + cis.count());
                                            } else {
                                                if (markerType >= 224 && markerType <= 239) {
                                                    if (logMINOR) {
                                                        Logger.minor(this, "Dropping application marker type " + Integer.toHexString(markerType) + " length " + blockLength);
                                                    }
                                                } else if (logMINOR) {
                                                    Logger.minor(this, "Dropping unknown frame type " + Integer.toHexString(markerType) + " blockLength");
                                                }
                                                this.skipBytes(dis, blockLength - 2);
                                                continue;
                                            }
                                        }
                                    }
                                    if (cis.count() != countAtStart + (long)blockLength) {
                                        this.throwError("Invalid frame", "The length of the frame is incorrect (read " + (cis.count() - countAtStart) + " bytes, frame length " + blockLength + " for type " + Integer.toHexString(markerType) + ").");
                                    }
                                    if (dos == null) continue;
                                    baos.writeTo(output);
                                }
                                dis.close();
                                break block80;
                            }
                            catch (Throwable throwable) {
                                Object var33_44 = null;
                                Closer.close(dis);
                                throw throwable;
                            }
                        }
                        Closer.close(dis);
                        return bucket;
                    }
                    Object var33_40 = null;
                    Closer.close(dis);
                    return extensionCode2;
                }
                Object var33_41 = null;
                Closer.close(dis);
                return type22;
            }
            Object var33_42 = null;
            Closer.close(dis);
            return type22;
        }
        Object var33_43 = null;
        Closer.close(dis);
        return data;
    }

    private static String l10n(String key) {
        return L10n.getString("JPEGFilter." + key);
    }

    private void writeNullTerminatedString(ByteArrayOutputStream baos, String type) throws IOException {
        try {
            byte[] data = type.getBytes("ISO-8859-1");
            baos.write(data);
            baos.write(0);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support ISO-8859-1: " + e, e);
        }
    }

    private String readNullTerminatedAsciiString(DataInputStream dis) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int x;
            if ((x = dis.read()) == -1) {
                this.throwError("Invalid extension frame", "Could not read an extension frame name.");
            }
            if (x == 0) break;
            char c = (char)x;
            if (x > 128 || c < ' ' && c != '\n' && c != '\r') {
                this.throwError("Invalid extension frame name", "Non-ASCII character in extension frame name");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void skipRest(int blockLength, long countAtStart, CountedInputStream cis, DataInputStream dis, DataOutputStream dos, String thing) throws IOException {
        int skip = (int)((long)blockLength - (cis.count() - countAtStart));
        if (skip < 0) {
            this.throwError("Invalid " + thing, "The file includes an invalid " + thing + '.');
        }
        if (skip == 0) {
            return;
        }
        if (dos != null) {
            byte[] buf = new byte[skip];
            dis.readFully(buf);
            dos.write(buf);
        } else {
            this.skipBytes(dis, skip);
        }
    }

    private void skipBytes(DataInputStream dis, int skip) throws IOException {
        int skipped = 0;
        while (skipped < skip) {
            long x = dis.skip(skip - skipped);
            if (x <= 0L) {
                byte[] buf = new byte[Math.min(4096, skip - skipped)];
                dis.readFully(buf);
                skipped += buf.length;
                continue;
            }
            skipped = (int)((long)skipped + x);
        }
    }

    private void assertHeader(DataInputStream dis, byte[] expected) throws IOException {
        byte[] read = new byte[expected.length];
        dis.readFully(read);
        if (!Arrays.equals(read, expected)) {
            this.throwError("Invalid header", "The file does not start with a valid JPEG (JFIF) header.");
        }
    }

    private void throwError(String shortReason, String reason) throws DataFilterException {
        String message = JPEGFilter.l10n("notJpeg");
        if (reason != null) {
            message = message + ' ' + reason;
        }
        if (shortReason != null) {
            message = message + " - " + shortReason;
        }
        DataFilterException e = new DataFilterException(shortReason, shortReason, "<p>" + message + "</p>", new HTMLNode("p").addChild("#", message));
        if (Logger.shouldLog(8, this)) {
            Logger.normal(this, "Throwing " + e, e);
        }
        throw e;
    }

    @Override
    public Bucket writeFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        return null;
    }
}

