/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.CSSParser;
import freenet.clients.http.filter.CharsetExtractor;
import freenet.clients.http.filter.CommentException;
import freenet.clients.http.filter.ContentDataFilter;
import freenet.clients.http.filter.DataFilterException;
import freenet.clients.http.filter.FilterCallback;
import freenet.clients.http.filter.NullFilterCallback;
import freenet.clients.http.filter.UnknownCharsetException;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.support.HTMLDecoder;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import freenet.support.io.NullWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLFilter
implements ContentDataFilter,
CharsetExtractor {
    private static boolean logMINOR;
    private static boolean logDEBUG;
    private static boolean deleteWierdStuff;
    private static boolean deleteErrors;
    static final Map<String, TagVerifier> allowedTagsVerifiers;
    static final String[] emptyStringArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket readFilter(Bucket bucket, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        logMINOR = Logger.shouldLog(4, this);
        logDEBUG = Logger.shouldLog(2, this);
        if (logMINOR) {
            Logger.minor(this, "readFilter(): charset=" + charset);
        }
        InputStream strm = bucket.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(strm, 4096);
        Bucket temp = bf.makeBucket(-1L);
        OutputStream os = temp.getOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(os, 4096);
        BufferedReader r = null;
        BufferedWriter w = null;
        InputStreamReader isr = null;
        OutputStreamWriter osw = null;
        try {
            try {
                isr = new InputStreamReader((InputStream)bis, charset);
                osw = new OutputStreamWriter((OutputStream)bos, charset);
                r = new BufferedReader(isr, 4096);
                w = new BufferedWriter(osw, 4096);
            }
            catch (UnsupportedEncodingException e) {
                throw UnknownCharsetException.create(e, charset);
            }
            HTMLParseContext pc = new HTMLParseContext(r, w, charset, cb, false);
            pc.run(temp);
            ((Writer)w).close();
            os = null;
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            Closer.close(os);
            Closer.close(strm);
            throw throwable;
        }
        Closer.close(os);
        Closer.close(strm);
        return temp;
    }

    @Override
    public Bucket writeFilter(Bucket bucket, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCharset(Bucket bucket, String parseCharset) throws DataFilterException, IOException {
        HTMLParseContext pc;
        block12: {
            BufferedReader r;
            block11: {
                logMINOR = Logger.shouldLog(4, this);
                if (logMINOR) {
                    Logger.minor(this, "getCharset(): default=" + parseCharset);
                }
                InputStream strm = bucket.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(strm, 4096);
                NullWriter w = new NullWriter();
                try {
                    r = new BufferedReader(new InputStreamReader((InputStream)bis, parseCharset), 4096);
                }
                catch (UnsupportedEncodingException e) {
                    strm.close();
                    throw e;
                }
                pc = new HTMLParseContext(r, w, null, new NullFilterCallback(), true);
                try {
                    pc.run(null);
                }
                catch (MalformedInputException e) {
                    return null;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (!logMINOR) break block11;
                    Logger.minor(this, "Caught " + t + " trying to detect MIME type with " + parseCharset);
                }
            }
            try {
                ((Reader)r).close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                if (!logMINOR) break block12;
                Logger.minor(this, "Caught " + t + " closing stream after trying to detect MIME type with " + parseCharset);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Returning charset " + pc.detectedCharset);
        }
        return pc.detectedCharset;
    }

    void saveText(StringBuilder s, String tagName, Writer w, HTMLParseContext pc) throws IOException {
        if (pc.noOutput) {
            return;
        }
        if (logDEBUG) {
            Logger.debug(this, "Saving text: " + s.toString());
        }
        if (pc.killText) {
            return;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            s.deleteCharAt(i);
            if (!logDEBUG) continue;
            Logger.debug(this, "Removing '" + c + "' from the output stream");
        }
        String style = s.toString();
        if (pc.inStyle || pc.inScript) {
            pc.currentStyleScriptChunk = pc.currentStyleScriptChunk + style;
            return;
        }
        StringBuilder out = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            out.append(c);
        }
        String sout = out.toString();
        if (pc.cb != null) {
            pc.cb.onText(HTMLDecoder.decode(sout), tagName);
        }
        w.write(sout);
    }

    void processTag(List<String> splitTag, Writer w, HTMLParseContext pc) throws IOException, DataFilterException {
        if (logDEBUG) {
            for (int i = 0; i < splitTag.size(); ++i) {
                Logger.debug(this, "Tag[" + i + "]=" + splitTag.get(i));
            }
        }
        ParsedTag t = new ParsedTag(splitTag);
        if (!pc.killTag) {
            t = t.sanitize(pc);
            if (pc.noOutput) {
                return;
            }
            if (t != null) {
                if (pc.writeStyleScriptWithTag) {
                    pc.writeStyleScriptWithTag = false;
                    String style = pc.currentStyleScriptChunk;
                    if (style == null || style.length() == 0) {
                        pc.writeAfterTag.append("<!-- " + HTMLFilter.l10n("deletedUnknownStyle") + " -->");
                    } else {
                        w.write(style);
                    }
                    pc.currentStyleScriptChunk = "";
                }
                t.write(w);
                if (pc.writeAfterTag.length() > 0) {
                    w.write(pc.writeAfterTag.toString());
                    pc.writeAfterTag = new StringBuilder(1024);
                }
            } else {
                pc.writeStyleScriptWithTag = false;
            }
        } else {
            pc.killTag = false;
            pc.writeStyleScriptWithTag = false;
        }
    }

    void saveComment(StringBuilder s, Writer w, HTMLParseContext pc) throws IOException {
        if (pc.noOutput) {
            return;
        }
        if (s.length() > 3 && s.charAt(0) == '!' && s.charAt(1) == '-' && s.charAt(2) == '-') {
            s.delete(0, 3);
            if (s.charAt(s.length() - 1) == '-') {
                s.setLength(s.length() - 1);
            }
            if (s.charAt(s.length() - 1) == '-') {
                s.setLength(s.length() - 1);
            }
        }
        if (logDEBUG) {
            Logger.debug(this, "Saving comment: " + s.toString());
        }
        if (pc.expectingBadComment) {
            return;
        }
        if (pc.inStyle || pc.inScript) {
            pc.currentStyleScriptChunk = pc.currentStyleScriptChunk + s;
            return;
        }
        if (pc.killTag) {
            pc.killTag = false;
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            sb.append(c);
        }
        s = sb;
        w.write("<!-- ");
        w.write(s.toString());
        w.write(" -->");
    }

    static void throwFilterException(String msg) throws DataFilterException {
        String longer = HTMLFilter.l10n("failedToParseLabel");
        throw new DataFilterException(longer, longer, msg, new HTMLNode("div", msg));
    }

    static String stripQuotes(String s) {
        String quotes = "\"'";
        if (s.length() >= 2) {
            int n = "\"'".length();
            for (int x = 0; x < n; ++x) {
                char cc = "\"'".charAt(x);
                if (s.charAt(0) != cc || s.charAt(s.length() - 1) != cc) continue;
                if (s.length() > 2) {
                    s = s.substring(1, s.length() - 1);
                    break;
                }
                s = "";
                break;
            }
        }
        return s;
    }

    static String sanitizeStyle(String style, FilterCallback cb, HTMLParseContext hpc) throws DataFilterException {
        if (style == null) {
            return null;
        }
        if (hpc.noOutput) {
            return null;
        }
        StringReader r = new StringReader(style);
        StringWriter w = new StringWriter();
        style = style.trim();
        if (logMINOR) {
            Logger.minor(HTMLFilter.class, "Sanitizing style: " + style);
        }
        CSSParser pc = new CSSParser(r, w, false, cb);
        try {
            pc.parse();
        }
        catch (IOException e) {
            Logger.error(HTMLFilter.class, "IOException parsing inline CSS!");
        }
        catch (Error e) {
            if (e.getMessage().equals("Error: could not match input")) {
                Logger.normal(HTMLFilter.class, "CSS Parse Error!", e);
                return "/* " + HTMLFilter.l10n("couldNotParseStyle") + " */";
            }
            throw e;
        }
        String s = ((Object)w).toString();
        if (s == null || s.length() == 0) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(HTMLFilter.class, "Style finally: " + s);
        }
        return s;
    }

    static String escapeQuotes(String s) {
        StringBuilder buf = new StringBuilder(s.length());
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c == '\"') {
                buf.append("&quot;");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static String sanitizeScripting(String script) {
        return null;
    }

    static String sanitizeURI(String uri, FilterCallback cb, boolean inline) throws CommentException {
        return HTMLFilter.sanitizeURI(uri, null, null, cb, inline);
    }

    static String[] splitType(String type) {
        String charset = null;
        StringFieldParser sfp = new StringFieldParser(type, ';');
        type = sfp.nextField().trim();
        while (sfp.hasMoreFields()) {
            String param = sfp.nextField();
            int x = param.indexOf(61);
            if (x == -1) continue;
            String name = param.substring(0, x).trim();
            String value = param.substring(x + 1).trim();
            if (!name.equals("charset")) continue;
            charset = value;
        }
        return new String[]{type, charset};
    }

    static String htmlSanitizeURI(String suri, String overrideType, String overrideCharset, FilterCallback cb, HTMLParseContext pc, boolean inline) {
        try {
            return HTMLFilter.sanitizeURI(suri, overrideType, overrideCharset, cb, inline);
        }
        catch (CommentException e) {
            pc.writeAfterTag.append("<!-- ").append(HTMLEncoder.encode(e.toString())).append(" -->");
            return null;
        }
    }

    static String sanitizeURI(String suri, String overrideType, String overrideCharset, FilterCallback cb, boolean inline) throws CommentException {
        if (logMINOR) {
            Logger.minor(HTMLFilter.class, "Sanitizing URI: " + suri + " ( override type " + overrideType + " override charset " + overrideCharset + " ) inline=" + inline, (Throwable)new Exception("debug"));
        }
        if (overrideCharset != null && overrideCharset.length() > 0) {
            overrideType = overrideType + "; charset=" + overrideCharset;
        }
        return cb.processURI(suri, overrideType, false, inline);
    }

    static String getHashString(Map<String, Object> h, String key) {
        Object o = h.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    private static String l10n(String key) {
        return L10n.getString("HTMLFilter." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return L10n.getString("HTMLFilter." + key, pattern, value);
    }

    static {
        deleteWierdStuff = true;
        deleteErrors = true;
        allowedTagsVerifiers = new HashMap<String, TagVerifier>();
        emptyStringArray = new String[0];
        allowedTagsVerifiers.put("?xml", new XmlTagVerifier());
        allowedTagsVerifiers.put("!doctype", new DocTypeTagVerifier("!doctype"));
        allowedTagsVerifiers.put("html", new HtmlTagVerifier());
        allowedTagsVerifiers.put("head", new TagVerifier("head", new String[]{"id"}, new String[]{"profile"}, null));
        allowedTagsVerifiers.put("title", new TagVerifier("title", new String[]{"id"}));
        allowedTagsVerifiers.put("meta", new MetaTagVerifier());
        allowedTagsVerifiers.put("body", new CoreTagVerifier("body", new String[]{"bgcolor", "text", "link", "vlink", "alink"}, null, new String[]{"background"}, new String[]{"onload", "onunload"}));
        String[] group = new String[]{"div", "h1", "h2", "h3", "h4", "h5", "h6", "p", "caption"};
        for (int x = 0; x < group.length; ++x) {
            allowedTagsVerifiers.put(group[x], new CoreTagVerifier(group[x], new String[]{"align"}, emptyStringArray, emptyStringArray, emptyStringArray));
        }
        String[] group2 = new String[]{"span", "address", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "sub", "sup", "dt", "dd", "tt", "i", "b", "big", "small", "strike", "s", "u", "noframes", "fieldset", "xmp", "listing", "plaintext", "center", "bdo"};
        for (int x = 0; x < group2.length; ++x) {
            allowedTagsVerifiers.put(group2[x], new CoreTagVerifier(group2[x], emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        }
        allowedTagsVerifiers.put("blockquote", new CoreTagVerifier("blockquote", emptyStringArray, new String[]{"cite"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("q", new CoreTagVerifier("q", emptyStringArray, new String[]{"cite"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("br", new BaseCoreTagVerifier("br", new String[]{"clear"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("pre", new CoreTagVerifier("pre", new String[]{"width", "xml:space"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("ins", new CoreTagVerifier("ins", new String[]{"datetime"}, new String[]{"cite"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("del", new CoreTagVerifier("del", new String[]{"datetime"}, new String[]{"cite"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("ul", new CoreTagVerifier("ul", new String[]{"type", "compact"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("ol", new CoreTagVerifier("ol", new String[]{"type", "compact", "start"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("li", new CoreTagVerifier("li", new String[]{"type", "value"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("dl", new CoreTagVerifier("dl", new String[]{"compact"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("dir", new CoreTagVerifier("dir", new String[]{"compact"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("menu", new CoreTagVerifier("menu", new String[]{"compact"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("table", new CoreTagVerifier("table", new String[]{"summary", "width", "border", "frame", "rules", "cellspacing", "cellpadding", "align", "bgcolor"}, emptyStringArray, new String[]{"background"}, emptyStringArray));
        allowedTagsVerifiers.put("thead", new CoreTagVerifier("thead", new String[]{"align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("tfoot", new CoreTagVerifier("tfoot", new String[]{"align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("tbody", new CoreTagVerifier("tbody", new String[]{"align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("colgroup", new CoreTagVerifier("colgroup", new String[]{"span", "width", "align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("col", new CoreTagVerifier("col", new String[]{"span", "width", "align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("tr", new CoreTagVerifier("tr", new String[]{"align", "char", "charoff", "valign", "bgcolor"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("th", new CoreTagVerifier("th", new String[]{"abbr", "axis", "headers", "scope", "rowspan", "colspan", "align", "char", "charoff", "valign", "nowrap", "bgcolor", "width", "height"}, emptyStringArray, new String[]{"background"}, emptyStringArray));
        allowedTagsVerifiers.put("td", new CoreTagVerifier("td", new String[]{"abbr", "axis", "headers", "scope", "rowspan", "colspan", "align", "char", "charoff", "valign", "nowrap", "bgcolor", "width", "height"}, emptyStringArray, new String[]{"background"}, emptyStringArray));
        allowedTagsVerifiers.put("a", new LinkTagVerifier("a", new String[]{"accesskey", "tabindex", "name", "shape", "coords", "target"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur"}));
        allowedTagsVerifiers.put("link", new LinkTagVerifier("link", new String[]{"media", "target"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("base", new BaseHrefTagVerifier("base", new String[]{"id", "target"}, new String[0]));
        allowedTagsVerifiers.put("img", new CoreTagVerifier("img", new String[]{"alt", "name", "height", "width", "ismap", "align", "border", "hspace", "vspace"}, new String[]{"longdesc", "usemap"}, new String[]{"src"}, emptyStringArray));
        allowedTagsVerifiers.put("map", new CoreTagVerifier("map", new String[]{"name"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("area", new CoreTagVerifier("area", new String[]{"accesskey", "tabindex", "shape", "coords", "nohref", "alt", "target"}, new String[]{"href"}, emptyStringArray, new String[]{"onfocus", "onblur"}));
        allowedTagsVerifiers.put("style", new StyleTagVerifier());
        allowedTagsVerifiers.put("font", new BaseCoreTagVerifier("font", new String[]{"size", "color", "face"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("basefont", new BaseCoreTagVerifier("basefont", new String[]{"size", "color", "face"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("hr", new CoreTagVerifier("hr", new String[]{"align", "noshade", "size", "width"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("frameset", new CoreTagVerifier("frameset", new String[]{"rows", "cols"}, emptyStringArray, emptyStringArray, new String[]{"onload", "onunload"}, false));
        allowedTagsVerifiers.put("frame", new BaseCoreTagVerifier("frame", new String[]{"name", "frameborder", "marginwidth", "marginheight", "noresize", "scrolling"}, new String[]{"longdesc"}, new String[]{"src"}));
        allowedTagsVerifiers.put("iframe", new BaseCoreTagVerifier("iframe", new String[]{"name", "frameborder", "marginwidth", "marginheight", "scrolling", "align", "height", "width"}, new String[]{"longdesc"}, new String[]{"src"}));
        allowedTagsVerifiers.put("form", new FormTagVerifier("form", new String[]{"name"}, new String[0], new String[]{"onsubmit", "onreset"}));
        allowedTagsVerifiers.put("input", new InputTagVerifier("input", new String[]{"accesskey", "tabindex", "type", "name", "value", "checked", "disabled", "readonly", "size", "maxlength", "alt", "ismap", "accept", "align"}, new String[]{"usemap"}, new String[]{"src"}, new String[]{"onfocus", "onblur", "onselect", "onchange"}));
        allowedTagsVerifiers.put("button", new CoreTagVerifier("button", new String[]{"accesskey", "tabindex", "name", "value", "type", "disabled"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur"}));
        allowedTagsVerifiers.put("select", new CoreTagVerifier("select", new String[]{"name", "size", "multiple", "disabled", "tabindex"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur", "onchange"}));
        allowedTagsVerifiers.put("optgroup", new CoreTagVerifier("optgroup", new String[]{"disabled", "label"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("option", new CoreTagVerifier("option", new String[]{"selected", "disabled", "label", "value"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("textarea", new CoreTagVerifier("textarea", new String[]{"accesskey", "tabindex", "name", "rows", "cols", "disabled", "readonly"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur", "onselect", "onchange"}));
        allowedTagsVerifiers.put("isindex", new BaseCoreTagVerifier("isindex", new String[]{"prompt"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("label", new CoreTagVerifier("label", new String[]{"for", "accesskey"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur"}));
        allowedTagsVerifiers.put("legend", new CoreTagVerifier("legend", new String[]{"accesskey", "align"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("script", new ScriptTagVerifier());
    }

    static class StringFieldParser {
        private String str;
        private int maxPos;
        private int curPos;
        private char c;

        public StringFieldParser(String str) {
            this(str, '\t');
        }

        public StringFieldParser(String str, char c) {
            this.str = str;
            this.maxPos = str.length();
            this.curPos = 0;
            this.c = c;
        }

        public boolean hasMoreFields() {
            return this.curPos <= this.maxPos;
        }

        public String nextField() {
            if (this.curPos > this.maxPos) {
                return null;
            }
            int start = this.curPos;
            while (this.curPos < this.maxPos && this.str.charAt(this.curPos) != this.c) {
                ++this.curPos;
            }
            int end = this.curPos++;
            return this.str.substring(start, end);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BaseHrefTagVerifier
    extends TagVerifier {
        BaseHrefTagVerifier(String string, String[] strings, String[] strings2) {
            super(string, strings, strings2, null);
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            String ref;
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String baseHref = HTMLFilter.getHashString(hn, "href");
            if (baseHref != null && (ref = pc.cb.onBaseHref(baseHref)) != null) {
                hn.put("href", ref);
            }
            return hn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HtmlTagVerifier
    extends TagVerifier {
        HtmlTagVerifier() {
            super("html", new String[]{"id", "version"});
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String xmlns = HTMLFilter.getHashString(h, "xmlns");
            if (xmlns != null && xmlns.equals("http://www.w3.org/1999/xhtml")) {
                hn.put("xmlns", xmlns);
            }
            return hn;
        }
    }

    static class XmlTagVerifier
    extends TagVerifier {
        XmlTagVerifier() {
            super("?xml", null);
        }

        ParsedTag sanitize(ParsedTag t, HTMLParseContext pc) {
            if (t.unparsedAttrs.length != 2) {
                return null;
            }
            if (!t.unparsedAttrs[0].equals("version=\"1.0\"")) {
                return null;
            }
            if (!t.unparsedAttrs[1].startsWith("encoding=\"") && !t.unparsedAttrs[1].endsWith("\"?")) {
                return null;
            }
            if (!t.unparsedAttrs[1].substring(10, t.unparsedAttrs[1].length() - 2).equalsIgnoreCase(pc.charset)) {
                return null;
            }
            return t;
        }
    }

    static class DocTypeTagVerifier
    extends TagVerifier {
        static final Map<String, Object> DTDs = new HashMap<String, Object>();

        DocTypeTagVerifier(String tag) {
            super(tag, null);
        }

        ParsedTag sanitize(ParsedTag t, HTMLParseContext pc) {
            if (t.unparsedAttrs.length != 3 && t.unparsedAttrs.length != 4) {
                return null;
            }
            if (!t.unparsedAttrs[0].equalsIgnoreCase("html")) {
                return null;
            }
            if (!t.unparsedAttrs[1].equalsIgnoreCase("public")) {
                return null;
            }
            String s = HTMLFilter.stripQuotes(t.unparsedAttrs[2]);
            if (!DTDs.containsKey(s)) {
                return null;
            }
            if (t.unparsedAttrs.length == 4) {
                String ss = HTMLFilter.stripQuotes(t.unparsedAttrs[3]);
                String spec = HTMLFilter.getHashString(DTDs, s);
                if (spec != null && !spec.equals(ss)) {
                    return null;
                }
            }
            return t;
        }

        static {
            DTDs.put("-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
            DTDs.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
            DTDs.put("-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
            DTDs.put("-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd");
            DTDs.put("-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd");
            DTDs.put("-//W3C//DTD HTML 4.01 Frameset//EN", "http://www.w3.org/TR/html4/frameset.dtd");
            DTDs.put("-//W3C//DTD HTML 3.2 Final//EN", new Object());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MetaTagVerifier
    extends TagVerifier {
        MetaTagVerifier() {
            super("meta", new String[]{"id"});
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String http_equiv = HTMLFilter.getHashString(h, "http-equiv");
            String name = HTMLFilter.getHashString(h, "name");
            String content = HTMLFilter.getHashString(h, "content");
            String scheme = HTMLFilter.getHashString(h, "scheme");
            if (logMINOR) {
                Logger.minor(this, "meta: name=" + name + ", content=" + content + ", http-equiv=" + http_equiv + ", scheme=" + scheme);
            }
            if (content != null) {
                if (name != null && http_equiv == null) {
                    if (name.equalsIgnoreCase("Author")) {
                        hn.put("name", name);
                        hn.put("content", content);
                    } else if (name.equalsIgnoreCase("Keywords")) {
                        hn.put("name", name);
                        hn.put("content", content);
                    } else if (name.equalsIgnoreCase("Description")) {
                        hn.put("name", name);
                        hn.put("content", content);
                    }
                } else if (http_equiv != null && name == null) {
                    if (http_equiv.equalsIgnoreCase("Expires")) {
                        hn.put("http-equiv", http_equiv);
                        hn.put("content", content);
                    } else if (!http_equiv.equalsIgnoreCase("Content-Script-Type")) {
                        if (http_equiv.equalsIgnoreCase("Content-Style-Type")) {
                            if (content.equalsIgnoreCase("text/css")) {
                                hn.put("http-equiv", http_equiv);
                                hn.put("content", content);
                            }
                        } else if (http_equiv.equalsIgnoreCase("Content-Type")) {
                            if (logMINOR) {
                                Logger.minor(this, "Found http-equiv content-type=" + content);
                            }
                            String[] typesplit = HTMLFilter.splitType(content);
                            if (logDEBUG) {
                                for (int i = 0; i < typesplit.length; ++i) {
                                    Logger.debug(this, "[" + i + "] = " + typesplit[i]);
                                }
                            }
                            if (typesplit[0].equalsIgnoreCase("text/html") && (typesplit[1] == null || typesplit[1].equalsIgnoreCase(pc.charset))) {
                                hn.put("http-equiv", http_equiv);
                                hn.put("content", typesplit[0] + (typesplit[1] != null ? "; charset=" + typesplit[1] : ""));
                            }
                            if (typesplit[1] != null) {
                                pc.detectedCharset = typesplit[1].trim();
                            }
                        } else if (http_equiv.equalsIgnoreCase("Content-Language")) {
                            hn.put("http-equiv", "Content-Language");
                            hn.put("content", content);
                        }
                    }
                }
            }
            return hn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InputTagVerifier
    extends CoreTagVerifier {
        final HashSet<String> allowedTypes;
        String[] types = new String[]{"text", "password", "checkbox", "radio", "submit", "reset,", "hidden", "image", "button"};

        InputTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] eventAttrs) {
            super(tag, allowedAttrs, uriAttrs, inlineURIAttrs, eventAttrs);
            this.allowedTypes = new HashSet();
            if (this.types != null) {
                for (int x = 0; x < this.types.length; ++x) {
                    this.allowedTypes.add(this.types[x]);
                }
            }
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            if (!this.allowedTypes.contains(hn.get("type"))) {
                return null;
            }
            return hn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FormTagVerifier
    extends CoreTagVerifier {
        FormTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] eventAttrs) {
            super(tag, allowedAttrs, uriAttrs, null, eventAttrs);
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            String finalAction;
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            if (p.startSlash) {
                return hn;
            }
            String method = (String)h.get("method");
            String action = (String)h.get("action");
            try {
                finalAction = pc.cb.processForm(method, action);
            }
            catch (CommentException e) {
                pc.writeAfterTag.append("<!-- ").append(HTMLEncoder.encode(e.toString())).append(" -->");
                return null;
            }
            if (finalAction == null) {
                return null;
            }
            hn.put("method", method);
            hn.put("action", finalAction);
            hn.put("enctype", "multipart/form-data");
            hn.put("accept-charset", "UTF-8");
            return hn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LinkTagVerifier
    extends CoreTagVerifier {
        LinkTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] eventAttrs) {
            super(tag, allowedAttrs, uriAttrs, inlineURIAttrs, eventAttrs);
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            String href;
            String c;
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String hreflang = HTMLFilter.getHashString(h, "hreflang");
            String charset = null;
            String type = HTMLFilter.getHashString(h, "type");
            if (type != null) {
                String[] typesplit = HTMLFilter.splitType(type);
                type = typesplit[0];
                if (typesplit[1] != null && typesplit[1].length() > 0) {
                    charset = typesplit[1];
                }
                if (logDEBUG) {
                    Logger.debug(this, "Processing link tag, type=" + type + ", charset=" + charset);
                }
            }
            if ((c = HTMLFilter.getHashString(h, "charset")) != null) {
                charset = c;
            }
            if ((href = HTMLFilter.getHashString(h, "href")) != null) {
                String[] rels = new String[]{"rel", "rev"};
                for (int x = 0; x < rels.length; ++x) {
                    String reltype = rels[x];
                    String rel = HTMLFilter.getHashString(h, reltype);
                    if (rel == null) continue;
                    StringTokenizer tok = new StringTokenizer(rel, " ");
                    while (tok.hasMoreTokens()) {
                        String t = tok.nextToken();
                        if (!t.equalsIgnoreCase("alternate") && !t.equalsIgnoreCase("stylesheet")) continue;
                        type = "text/css";
                    }
                    hn.put(reltype, rel);
                }
                href = HTMLDecoder.decode(href);
                if ((href = HTMLFilter.htmlSanitizeURI(href, type, charset, pc.cb, pc, false)) != null) {
                    href = HTMLEncoder.encode(href);
                    hn.put("href", href);
                    if (type != null) {
                        hn.put("type", type);
                    }
                    if (charset != null) {
                        hn.put("charset", charset);
                    }
                    if (charset != null && hreflang != null) {
                        hn.put("hreflang", hreflang);
                    }
                }
            }
            return hn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CoreTagVerifier
    extends BaseCoreTagVerifier {
        final HashSet<String> eventAttrs = new HashSet();
        static final String[] stdEvents = new String[]{"onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmousemove", "onmouseout", "onkeypress", "onkeydown", "onkeyup", "onload", "onfocus", "onblur", "oncontextmenu", "onresize", "onscroll", "onunload", "onmouseenter", "onchange", "onreset", "onselect", "onsubmit", "onerror"};

        CoreTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] eventAttrs) {
            this(tag, allowedAttrs, uriAttrs, inlineURIAttrs, eventAttrs, true);
        }

        CoreTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] eventAttrs, boolean addStdEvents) {
            super(tag, allowedAttrs, uriAttrs, inlineURIAttrs);
            int x;
            if (eventAttrs != null) {
                for (x = 0; x < eventAttrs.length; ++x) {
                    this.eventAttrs.add(eventAttrs[x]);
                }
            }
            if (addStdEvents) {
                for (x = 0; x < stdEvents.length; ++x) {
                    this.eventAttrs.add(stdEvents[x]);
                }
            }
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            for (String name : this.eventAttrs) {
                String arg = HTMLFilter.getHashString(h, name);
                if (arg == null || (arg = HTMLFilter.sanitizeScripting(arg)) == null) continue;
                hn.put(name, arg);
            }
            return hn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BaseCoreTagVerifier
    extends TagVerifier {
        BaseCoreTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs) {
            super(tag, allowedAttrs, uriAttrs, inlineURIAttrs);
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            String title;
            String style;
            String classNames;
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String id = HTMLFilter.getHashString(h, "id");
            if (id != null) {
                hn.put("id", id);
            }
            if ((classNames = HTMLFilter.getHashString(h, "class")) != null) {
                hn.put("class", classNames);
            }
            if ((style = HTMLFilter.getHashString(h, "style")) != null) {
                if ((style = HTMLFilter.sanitizeStyle(style, pc.cb, pc)) != null) {
                    style = HTMLFilter.escapeQuotes(style);
                }
                if (style != null) {
                    hn.put("style", style);
                }
            }
            if ((title = HTMLFilter.getHashString(h, "title")) != null) {
                hn.put("title", title);
            }
            return hn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ScriptTagVerifier
    extends ScriptStyleTagVerifier {
        ScriptTagVerifier() {
            super("script", new String[]{"id", "charset", "type", "language", "defer", "xml:space"}, new String[]{"src"});
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> hn, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            super.sanitizeHash(hn, p, pc);
            return null;
        }

        @Override
        void setStyle(boolean b, HTMLParseContext pc) {
            pc.inScript = b;
        }

        @Override
        boolean getStyle(HTMLParseContext pc) {
            return pc.inScript;
        }

        @Override
        void processStyle(HTMLParseContext pc) {
            pc.currentStyleScriptChunk = HTMLFilter.sanitizeScripting(pc.currentStyleScriptChunk);
        }
    }

    static class StyleTagVerifier
    extends ScriptStyleTagVerifier {
        StyleTagVerifier() {
            super("style", new String[]{"id", "media", "title", "xml:space"}, emptyStringArray);
        }

        void setStyle(boolean b, HTMLParseContext pc) {
            pc.inStyle = b;
        }

        boolean getStyle(HTMLParseContext pc) {
            return pc.inStyle;
        }

        void processStyle(HTMLParseContext pc) {
            try {
                pc.currentStyleScriptChunk = HTMLFilter.sanitizeStyle(pc.currentStyleScriptChunk, pc.cb, pc);
            }
            catch (DataFilterException e) {
                Logger.error(this, "Error parsing style: " + e, e);
                pc.currentStyleScriptChunk = "";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ScriptStyleTagVerifier
    extends TagVerifier {
        ScriptStyleTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs) {
            super(tag, allowedAttrs, uriAttrs, null);
        }

        abstract void setStyle(boolean var1, HTMLParseContext var2);

        abstract boolean getStyle(HTMLParseContext var1);

        abstract void processStyle(HTMLParseContext var1);

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            if (p.startSlash) {
                return this.finish(h, hn, pc);
            }
            return this.start(h, hn, pc);
        }

        Map<String, Object> finish(Map<String, Object> h, Map<String, Object> hn, HTMLParseContext pc) throws DataFilterException {
            if (logDEBUG) {
                Logger.debug(this, "Finishing script/style");
            }
            this.setStyle(false, pc);
            --pc.styleScriptRecurseCount;
            if (pc.styleScriptRecurseCount < 0) {
                if (deleteErrors) {
                    pc.writeAfterTag.append("<!-- " + HTMLFilter.l10n("tooManyNestedStyleOrScriptTags") + " -->");
                } else {
                    HTMLFilter.throwFilterException(HTMLFilter.l10n("tooManyNestedStyleOrScriptTagsLong"));
                }
                return null;
            }
            if (!pc.killStyle) {
                this.processStyle(pc);
                pc.writeStyleScriptWithTag = true;
            } else {
                pc.killStyle = false;
                pc.currentStyleScriptChunk = "";
            }
            pc.expectingBadComment = false;
            return hn;
        }

        Map<String, Object> start(Map<String, Object> h, Map<String, Object> hn, HTMLParseContext pc) throws DataFilterException {
            if (logDEBUG) {
                Logger.debug(this, "Starting script/style");
            }
            ++pc.styleScriptRecurseCount;
            if (pc.styleScriptRecurseCount > 1) {
                if (deleteErrors) {
                    pc.writeAfterTag.append("<!-- " + HTMLFilter.l10n("tooManyNestedStyleOrScriptTags") + " -->");
                } else {
                    HTMLFilter.throwFilterException(HTMLFilter.l10n("tooManyNestedStyleOrScriptTagsLong"));
                }
                return null;
            }
            this.setStyle(true, pc);
            String type = HTMLFilter.getHashString(h, "type");
            if (type != null) {
                if (!type.equalsIgnoreCase("text/css")) {
                    pc.killStyle = true;
                    pc.expectingBadComment = true;
                    return null;
                }
                hn.put("type", "text/css");
            }
            return hn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TagVerifier {
        final String tag;
        final HashSet<String> allowedAttrs;
        final HashSet<String> uriAttrs;
        final HashSet<String> inlineURIAttrs;

        TagVerifier(String tag, String[] allowedAttrs) {
            this(tag, allowedAttrs, null, null);
        }

        TagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs) {
            int x;
            this.tag = tag;
            this.allowedAttrs = new HashSet();
            if (allowedAttrs != null) {
                for (x = 0; x < allowedAttrs.length; ++x) {
                    this.allowedAttrs.add(allowedAttrs[x]);
                }
            }
            this.uriAttrs = new HashSet();
            if (uriAttrs != null) {
                for (x = 0; x < uriAttrs.length; ++x) {
                    this.uriAttrs.add(uriAttrs[x]);
                }
            }
            this.inlineURIAttrs = new HashSet();
            if (inlineURIAttrs != null) {
                for (x = 0; x < inlineURIAttrs.length; ++x) {
                    this.inlineURIAttrs.add(inlineURIAttrs[x]);
                }
            }
        }

        ParsedTag sanitize(ParsedTag t, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> h = new HashMap<String, Object>();
            boolean equals = false;
            String prevX = "";
            if (t.unparsedAttrs != null) {
                for (int i = 0; i < t.unparsedAttrs.length; ++i) {
                    String s = t.unparsedAttrs[i];
                    if (equals) {
                        equals = false;
                        s = HTMLFilter.stripQuotes(s);
                        h.remove(prevX);
                        h.put(prevX, s);
                        prevX = "";
                        continue;
                    }
                    int idx = s.indexOf(61);
                    if (idx == s.length() - 1) {
                        equals = true;
                        if (idx == 0) continue;
                        prevX = s.substring(0, s.length() - 1);
                        prevX = prevX.toLowerCase();
                        continue;
                    }
                    if (idx > -1) {
                        String x = s.substring(0, idx);
                        if (x.length() == 0) {
                            x = prevX;
                        }
                        x = x.toLowerCase();
                        String y = idx == s.length() - 1 ? "" : s.substring(idx + 1, s.length());
                        y = HTMLFilter.stripQuotes(y);
                        h.remove(x);
                        h.put(x, y);
                        prevX = x;
                        continue;
                    }
                    h.remove(s);
                    h.put(s, new Object());
                    prevX = s;
                }
            }
            if ((h = this.sanitizeHash(h, t, pc)) == null) {
                return null;
            }
            if (t.startSlash) {
                return new ParsedTag(t, null);
            }
            String[] outAttrs = new String[h.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry : h.entrySet()) {
                String x = entry.getKey();
                Object o = entry.getValue();
                String y = o instanceof String ? (String)o : null;
                StringBuilder out = new StringBuilder(x);
                if (y != null) {
                    out.append("=\"").append(y).append('\"');
                }
                outAttrs[i++] = out.toString();
            }
            return new ParsedTag(t, outAttrs);
        }

        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            HashMap<String, Object> hn = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : h.entrySet()) {
                String uri;
                String x = entry.getKey();
                Object o = entry.getValue();
                if (this.allowedAttrs.contains(x)) {
                    hn.put(x, o);
                    continue;
                }
                if (this.uriAttrs.contains(x)) {
                    if (logMINOR) {
                        Logger.minor(this, "Non-inline URI attribute: " + x);
                    }
                    if (o instanceof String) {
                        uri = (String)o;
                        uri = HTMLDecoder.decode(uri);
                        if ((uri = HTMLFilter.htmlSanitizeURI(uri, null, null, pc.cb, pc, false)) != null) {
                            uri = HTMLEncoder.encode(uri);
                            hn.put(x, uri);
                        }
                    }
                }
                if (!this.inlineURIAttrs.contains(x)) continue;
                if (logMINOR) {
                    Logger.minor(this, "Inline URI attribute: " + x);
                }
                if (!(o instanceof String)) continue;
                uri = (String)o;
                uri = HTMLDecoder.decode(uri);
                if ((uri = HTMLFilter.htmlSanitizeURI(uri, null, null, pc.cb, pc, true)) == null) continue;
                uri = HTMLEncoder.encode(uri);
                hn.put(x, uri);
            }
            String s = HTMLFilter.getHashString(h, "lang");
            if (s != null) {
                hn.put("lang", s);
            }
            if ((s = HTMLFilter.getHashString(h, "xml:lang")) != null) {
                hn.put("xml:lang", s);
            }
            if ((s = HTMLFilter.getHashString(h, "dir")) != null && (s.equalsIgnoreCase("ltr") || s.equalsIgnoreCase("rtl"))) {
                hn.put("dir", s);
            }
            return hn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParsedTag {
        final String element;
        final String[] unparsedAttrs;
        final boolean startSlash;
        final boolean endSlash;

        public ParsedTag(ParsedTag t, String[] outAttrs) {
            this.element = t.element;
            this.unparsedAttrs = outAttrs;
            this.startSlash = t.startSlash;
            this.endSlash = t.endSlash;
        }

        public ParsedTag(List<String> v) {
            int len = v.size();
            if (len == 0) {
                this.element = null;
                this.unparsedAttrs = new String[0];
                this.endSlash = false;
                this.startSlash = false;
                return;
            }
            String s = v.get(len - 1);
            if ((len - 1 != 0 || s.length() > 1) && s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
                v.set(len - 1, s);
                if (s.length() == 0) {
                    --len;
                }
                this.endSlash = true;
            } else {
                this.endSlash = false;
            }
            s = v.get(0);
            if (s.length() > 1 && s.startsWith("/")) {
                s = s.substring(1);
                v.set(0, s);
                this.startSlash = true;
            } else {
                this.startSlash = false;
            }
            this.element = v.get(0);
            if (len > 1) {
                this.unparsedAttrs = new String[len - 1];
                for (int x = 1; x < len; ++x) {
                    this.unparsedAttrs[x - 1] = v.get(x);
                }
            } else {
                this.unparsedAttrs = new String[0];
            }
            if (logDEBUG) {
                Logger.debug(this, "Element = " + this.element);
            }
        }

        public ParsedTag sanitize(HTMLParseContext pc) throws DataFilterException {
            TagVerifier tv = allowedTagsVerifiers.get(this.element.toLowerCase());
            if (logDEBUG) {
                Logger.debug(this, "Got verifier: " + tv + " for " + this.element);
            }
            if (tv == null) {
                if (deleteWierdStuff) {
                    return null;
                }
                String err = "<!-- " + HTMLEncoder.encode(HTMLFilter.l10n("unknownTag", "tag", this.element)) + " -->";
                if (!deleteErrors) {
                    HTMLFilter.throwFilterException(HTMLFilter.l10n("unknownTagLabel") + ' ' + err);
                }
                return null;
            }
            return tv.sanitize(this, pc);
        }

        public String toString() {
            if (this.element == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder("<");
            if (this.startSlash) {
                sb.append('/');
            }
            sb.append(this.element);
            if (this.unparsedAttrs != null) {
                int n = this.unparsedAttrs.length;
                for (int i = 0; i < n; ++i) {
                    sb.append(' ').append(this.unparsedAttrs[i]);
                }
            }
            if (this.endSlash) {
                sb.append(" /");
            }
            sb.append('>');
            return sb.toString();
        }

        public void write(Writer w) throws IOException {
            String s = this.toString();
            if (s != null) {
                w.write(s);
            }
        }
    }

    class HTMLParseContext {
        Reader r;
        Writer w;
        String charset;
        String detectedCharset;
        final FilterCallback cb;
        final boolean noOutput;
        int mode;
        static final int INTEXT = 0;
        static final int INTAG = 1;
        static final int INTAGQUOTES = 2;
        static final int INTAGSQUOTES = 3;
        static final int INTAGCOMMENT = 4;
        static final int INTAGCOMMENTCLOSING = 5;
        static final int INTAGWHITESPACE = 6;
        boolean killTag = false;
        boolean writeStyleScriptWithTag = false;
        boolean expectingBadComment = false;
        boolean inStyle = false;
        boolean inScript = false;
        boolean killText = false;
        boolean killStyle = false;
        int styleScriptRecurseCount = 0;
        String currentStyleScriptChunk = "";
        StringBuilder writeAfterTag = new StringBuilder(1024);

        HTMLParseContext(Reader r, Writer w, String charset, FilterCallback cb, boolean noOutput) {
            this.r = r;
            this.w = w;
            this.charset = charset;
            this.cb = cb;
            this.noOutput = noOutput;
        }

        Bucket run(Bucket temp) throws IOException, DataFilterException {
            StringBuilder b = new StringBuilder(100);
            StringBuilder balt = new StringBuilder(4000);
            ArrayList<String> splitTag = new ArrayList<String>();
            String currentTag = null;
            char pprevC = '\u0000';
            char prevC = '\u0000';
            char c = '\u0000';
            this.mode = 0;
            block20: while (true) {
                int x;
                try {
                    x = this.r.read();
                }
                catch (CharConversionException cce) {
                    if (Node.checkForGCJCharConversionBug()) {
                        x = -1;
                    }
                    throw cce;
                }
                if (x == -1) {
                    switch (this.mode) {
                        case 0: {
                            HTMLFilter.this.saveText(b, currentTag, this.w, this);
                            break;
                        }
                        case 1: {
                            this.w.write("<!-- truncated page: last tag not unfinished -->");
                            break;
                        }
                        case 2: {
                            this.w.write("<!-- truncated page: deleted unfinished tag: still in quotes -->");
                            break;
                        }
                        case 3: {
                            this.w.write("<!-- truncated page: deleted unfinished tag: still in single quotes -->");
                            break;
                        }
                        case 6: {
                            this.w.write("<!-- truncated page: deleted unfinished tag: still in whitespace -->");
                            break;
                        }
                        case 4: {
                            this.w.write("<!-- truncated page: deleted unfinished comment -->");
                            break;
                        }
                        case 5: {
                            this.w.write("<!-- truncated page: deleted unfinished comment, might be closing -->");
                            break;
                        }
                    }
                    break;
                }
                pprevC = prevC;
                prevC = c;
                c = (char)x;
                switch (this.mode) {
                    case 0: {
                        if (c == '<') {
                            HTMLFilter.this.saveText(b, currentTag, this.w, this);
                            b.setLength(0);
                            balt.setLength(0);
                            this.mode = 1;
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 1: {
                        balt.append(c);
                        if (HTMLDecoder.isWhitespace(c)) {
                            splitTag.add(b.toString());
                            this.mode = 6;
                            b.setLength(0);
                            break;
                        }
                        if (c == '<' && Character.isWhitespace(balt.charAt(0))) {
                            HTMLFilter.this.saveText(b, currentTag, this.w, this);
                            balt.setLength(0);
                            b.setLength(0);
                            splitTag.clear();
                            break;
                        }
                        if (c == '>') {
                            splitTag.add(b.toString());
                            b.setLength(0);
                            HTMLFilter.this.processTag(splitTag, this.w, this);
                            currentTag = (String)splitTag.get(0);
                            splitTag.clear();
                            balt.setLength(0);
                            this.mode = 0;
                            break;
                        }
                        if (b.length() == 2 && c == '-' && prevC == '-' && pprevC == '!') {
                            this.mode = 4;
                            b.append(c);
                            break;
                        }
                        if (c == '\"') {
                            this.mode = 2;
                            b.append(c);
                            break;
                        }
                        if (c == '\'') {
                            this.mode = 3;
                            b.append(c);
                            break;
                        }
                        if (c == '/') {
                            currentTag = null;
                            b.append(c);
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 2: {
                        if (c == '\"') {
                            this.mode = 1;
                            b.append(c);
                            break;
                        }
                        if (c == '>') {
                            b.append("&gt;");
                            break;
                        }
                        if (c == '<') {
                            b.append("&lt;");
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 3: {
                        if (c == '\'') {
                            this.mode = 1;
                            b.append(c);
                            break;
                        }
                        if (c == '<') {
                            b.append("&lt;");
                            break;
                        }
                        if (c == '>') {
                            b.append("&gt;");
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 4: {
                        if (b.length() >= 4 && c == '-' && prevC == '-') {
                            b.append(c);
                            this.mode = 5;
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 5: {
                        if (c == '>') {
                            HTMLFilter.this.saveComment(b, this.w, this);
                            b.setLength(0);
                            this.mode = 0;
                            break;
                        }
                        b.append(c);
                        if (c == '-') break;
                        this.mode = 4;
                        break;
                    }
                    case 6: {
                        if (c == '\"') {
                            this.mode = 2;
                            b.append(c);
                            break;
                        }
                        if (c == '\'') {
                            this.mode = 3;
                            b.append(c);
                            break;
                        }
                        if (c == '>') {
                            if (!this.killTag) {
                                HTMLFilter.this.processTag(splitTag, this.w, this);
                            }
                            this.killTag = false;
                            currentTag = (String)splitTag.get(0);
                            splitTag.clear();
                            b.setLength(0);
                            balt.setLength(0);
                            this.mode = 0;
                            break;
                        }
                        if (c == '<' && Character.isWhitespace(balt.charAt(0))) {
                            HTMLFilter.this.saveText(balt, currentTag, this.w, this);
                            balt.setLength(0);
                            b.setLength(0);
                            splitTag.clear();
                            this.mode = 1;
                            break;
                        }
                        if (HTMLDecoder.isWhitespace(c)) continue block20;
                        this.mode = 1;
                        b.append(c);
                    }
                }
            }
            return temp;
        }
    }
}

