/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.filter.CommentException;
import freenet.clients.http.filter.FilterCallback;
import freenet.clients.http.filter.FoundURICallback;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.support.HTMLEncoder;
import freenet.support.Logger;
import freenet.support.URIPreEncoder;
import freenet.support.api.HTTPRequest;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashSet;

public class GenericReadFilterCallback
implements FilterCallback {
    public static final String magicHTTPEscapeString = "_CHECKED_HTTP_";
    public static final HashSet<String> allowedProtocols = new HashSet();
    private URI baseURI;
    private URI strippedBaseURI;
    private final FoundURICallback cb;
    protected static final String UNRESERVED = "[a-zA-Z0-9\\-\\._~]";
    protected static final String PCT_ENCODED = "%[0-9A-Fa-f][0-9A-Fa-f]";
    protected static final String SUB_DELIMS = "[\\!\\$&'\\(\\)\\*\\+,;=]";
    protected static final String PCHAR = "([a-zA-Z0-9\\-\\._~]|%[0-9A-Fa-f][0-9A-Fa-f]|[\\!\\$&'\\(\\)\\*\\+,;=]|[:@])";
    protected static final String FRAGMENT = "(([a-zA-Z0-9\\-\\._~]|%[0-9A-Fa-f][0-9A-Fa-f]|[\\!\\$&'\\(\\)\\*\\+,;=]|[:@])|\\/|\\?)*";
    static final String PLUGINS_PREFIX = "/plugins/";

    public GenericReadFilterCallback(URI uri, FoundURICallback cb) {
        this.baseURI = uri;
        this.cb = cb;
        this.setStrippedURI(uri.toString());
    }

    public GenericReadFilterCallback(FreenetURI uri, FoundURICallback cb) {
        try {
            this.baseURI = uri.toRelativeURI();
            this.setStrippedURI(this.baseURI.toString());
            this.cb = cb;
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    private void setStrippedURI(String u) {
        int idx = u.lastIndexOf(47);
        if (idx > 0) {
            u = u.substring(0, idx + 1);
            try {
                this.strippedBaseURI = new URI(u);
            }
            catch (URISyntaxException e) {
                Logger.error(this, "Can't strip base URI: " + e + " parsing " + u);
                this.strippedBaseURI = this.baseURI;
            }
        } else {
            this.strippedBaseURI = this.baseURI;
        }
    }

    public String processURI(String u, String overrideType) throws CommentException {
        return this.processURI(u, overrideType, false, false);
    }

    public String processURI(String u, String overrideType, boolean noRelative, boolean inline) throws CommentException {
        URI resolved;
        URI uri;
        if (u.matches("^#(([a-zA-Z0-9\\-\\._~]|%[0-9A-Fa-f][0-9A-Fa-f]|[\\!\\$&'\\(\\)\\*\\+,;=]|[:@])|\\/|\\?)*$")) {
            return u;
        }
        u = u.replaceAll(" #", " %23");
        boolean logMINOR = Logger.shouldLog(4, this);
        try {
            if (logMINOR) {
                Logger.minor(this, "Processing " + u);
            }
            uri = URIPreEncoder.encodeURI(u).normalize();
            if (logMINOR) {
                Logger.minor(this, "Processing " + uri);
            }
            resolved = !noRelative ? this.baseURI.resolve(uri) : uri;
            if (logMINOR) {
                Logger.minor(this, "Resolved: " + resolved);
            }
        }
        catch (URISyntaxException e1) {
            if (logMINOR) {
                Logger.minor(this, "Failed to parse URI: " + e1);
            }
            throw new CommentException(GenericReadFilterCallback.l10n("couldNotParseURIWithError", "error", e1.getMessage()));
        }
        String path = uri.getPath();
        HTTPRequestImpl req = new HTTPRequestImpl(uri, "GET");
        if (path != null) {
            if (path.equals("/") && req.isParameterSet("newbookmark")) {
                String bookmark_key = req.getParam("newbookmark");
                String bookmark_desc = req.getParam("desc");
                String bookmark_activelink = req.getParam("hasAnActivelink", "");
                bookmark_key = HTMLEncoder.encode(bookmark_key);
                bookmark_desc = HTMLEncoder.encode(bookmark_desc);
                String url = "/?newbookmark=" + bookmark_key + "&desc=" + bookmark_desc;
                if (!bookmark_activelink.equals("")) {
                    bookmark_activelink = HTMLEncoder.encode(bookmark_activelink);
                    url = url + "&hasAnActivelink=true";
                }
                return url;
            }
            if (path.startsWith("/static/")) {
                return path;
            }
        }
        String reason = "";
        String rpath = uri.getPath();
        boolean isAbsolute = false;
        if (rpath != null) {
            if (logMINOR) {
                Logger.minor(this, "Resolved URI (rpath absolute): " + rpath);
            }
            try {
                String p = rpath;
                while (p.startsWith("/")) {
                    isAbsolute = true;
                    p = p.substring(1);
                }
                FreenetURI furi = new FreenetURI(p);
                if (logMINOR) {
                    Logger.minor(this, "Parsed: " + furi);
                }
                return this.processURI(furi, uri, overrideType, noRelative, inline);
            }
            catch (MalformedURLException e) {
                if (logMINOR) {
                    Logger.minor(this, "Malformed URL (a): " + e, (Throwable)e);
                }
                reason = e.getMessage() != null ? GenericReadFilterCallback.l10n("malformedAbsoluteURL", "error", e.getMessage()) : GenericReadFilterCallback.l10n("couldNotParseAbsoluteFreenetURI");
            }
        }
        if (!isAbsolute) {
            rpath = resolved.getPath();
            if (rpath == null) {
                throw new CommentException("No URI");
            }
            if (logMINOR) {
                Logger.minor(this, "Resolved URI (rpath relative): " + rpath);
            }
            try {
                String p = rpath;
                while (p.startsWith("/")) {
                    p = p.substring(1);
                }
                FreenetURI furi = new FreenetURI(p);
                if (logMINOR) {
                    Logger.minor(this, "Parsed: " + furi);
                }
                return this.processURI(furi, uri, overrideType, noRelative, inline);
            }
            catch (MalformedURLException e) {
                if (logMINOR) {
                    Logger.minor(this, "Malformed URL (b): " + e, (Throwable)e);
                }
                reason = e.getMessage() != null ? GenericReadFilterCallback.l10n("malformedRelativeURL", "error", e.getMessage()) : GenericReadFilterCallback.l10n("couldNotParseRelativeFreenetURI");
            }
        }
        if (allowedProtocols.contains(uri.getScheme())) {
            return "/?_CHECKED_HTTP_=" + uri;
        }
        if (uri.getScheme() == null) {
            throw new CommentException(reason);
        }
        throw new CommentException(GenericReadFilterCallback.l10n("protocolNotEscaped", "protocol", uri.getScheme()));
    }

    private static String l10n(String key, String pattern, String value) {
        return L10n.getString("GenericReadFilterCallback." + key, pattern, value);
    }

    private static String l10n(String key) {
        return L10n.getString("GenericReadFilterCallback." + key);
    }

    private String finishProcess(HTTPRequest req, String overrideType, String path, URI u, boolean noRelative) {
        String typeOverride = req.getParam("type", null);
        if (overrideType != null) {
            typeOverride = overrideType;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(path);
            if (typeOverride != null) {
                sb.append("?type=");
                sb.append(typeOverride);
            }
            if (u.getFragment() != null) {
                sb.append('#');
                sb.append(u.getRawFragment());
            }
            URI uri = new URI(sb.toString());
            if (!noRelative) {
                uri = this.strippedBaseURI.relativize(uri);
            }
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Returning " + uri.toASCIIString() + " from " + path + " from baseURI=" + this.baseURI);
            }
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            Logger.error(this, "Could not parse own URI: path=" + path + ", typeOverride=" + typeOverride + ", frag=" + u.getFragment() + " : " + e, e);
            String p = path;
            if (typeOverride != null) {
                p = p + "?type=" + typeOverride;
            }
            if (u.getFragment() != null) {
                try {
                    p = p + URLEncoder.encode(u.getFragment(), "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                }
            }
            return p;
        }
    }

    private String processURI(FreenetURI furi, URI uri, String overrideType, boolean noRelative, boolean inline) {
        HTTPRequestImpl req = new HTTPRequestImpl(uri, "GET");
        if (this.cb != null) {
            this.cb.foundURI(furi);
        }
        if (this.cb != null) {
            this.cb.foundURI(furi, inline);
        }
        return this.finishProcess(req, overrideType, '/' + furi.toString(false, false), uri, noRelative);
    }

    public String onBaseHref(String baseHref) {
        String ret;
        try {
            ret = this.processURI(baseHref, null, true, false);
        }
        catch (CommentException e1) {
            Logger.error(this, "Failed to parse base href: " + baseHref + " -> " + e1.getMessage());
            ret = null;
        }
        if (ret == null) {
            Logger.error(this, "onBaseHref() failed: cannot sanitize " + baseHref);
            return null;
        }
        try {
            this.baseURI = new URI(ret);
            this.setStrippedURI(ret);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        return this.baseURI.toASCIIString();
    }

    public void onText(String s, String type) {
        if (this.cb != null) {
            this.cb.onText(s, type, this.baseURI);
        }
    }

    public String processForm(String method, String action) throws CommentException {
        if (action == null) {
            return null;
        }
        if (method == null) {
            method = "GET";
        }
        if (!(method = method.toUpperCase()).equals("POST") && !method.equals("GET")) {
            return null;
        }
        if (action.equals("/")) {
            return action;
        }
        try {
            URI uri = URIPreEncoder.encodeURI(action);
            if (uri.getScheme() != null || uri.getHost() != null || uri.getPort() != -1 || uri.getUserInfo() != null) {
                throw new CommentException(GenericReadFilterCallback.l10n("invalidFormURI"));
            }
            String path = uri.getPath();
            if (path.startsWith(PLUGINS_PREFIX)) {
                String after = path.substring(PLUGINS_PREFIX.length());
                if (after.indexOf("../") > -1) {
                    throw new CommentException(GenericReadFilterCallback.l10n("invalidFormURIAttemptToEscape"));
                }
                if (after.matches("[A-Za-z0-9\\.]+")) {
                    return uri.toASCIIString();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new CommentException(GenericReadFilterCallback.l10n("couldNotParseFormURIWithError", "error", e.getLocalizedMessage()));
        }
        return null;
    }

    public static String escapeURL(String uri) {
        return "/?_CHECKED_HTTP_=" + uri;
    }

    static {
        allowedProtocols.add("http");
        allowedProtocols.add("https");
        allowedProtocols.add("ftp");
        allowedProtocols.add("mailto");
        allowedProtocols.add("nntp");
        allowedProtocols.add("news");
        allowedProtocols.add("snews");
        allowedProtocols.add("about");
        allowedProtocols.add("irc");
    }
}

