/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.ContentDataFilter;
import freenet.clients.http.filter.DataFilterException;
import freenet.clients.http.filter.FilterCallback;
import freenet.l10n.L10n;
import freenet.support.HTMLNode;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GIFFilter
implements ContentDataFilter {
    static final int HEADER_SIZE = 6;
    static final byte[] gif87aHeader = new byte[]{71, 73, 70, 56, 55, 97};
    static final byte[] gif89aHeader = new byte[]{71, 73, 70, 56, 57, 97};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket readFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        if (data.size() < 6L) {
            this.throwHeaderError(GIFFilter.l10n("tooShortTitle"), GIFFilter.l10n("tooShort"));
        }
        InputStream is = data.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        try {
            byte[] headerCheck = new byte[6];
            dis.readFully(headerCheck);
            if (!Arrays.equals(headerCheck, gif87aHeader) && !Arrays.equals(headerCheck, gif89aHeader)) {
                this.throwHeaderError(GIFFilter.l10n("invalidHeaderTitle"), GIFFilter.l10n("invalidHeader"));
            }
            dis.close();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Closer.close(dis);
            throw throwable;
        }
        Closer.close(dis);
        return data;
    }

    private static String l10n(String key) {
        return L10n.getString("GIFFilter." + key);
    }

    private void throwHeaderError(String shortReason, String reason) throws DataFilterException {
        String message = GIFFilter.l10n("notGif");
        if (reason != null) {
            message = message + ' ' + reason;
        }
        if (shortReason != null) {
            message = message + " - (" + shortReason + ')';
        }
        throw new DataFilterException(shortReason, shortReason, "<p>" + message + "</p>", new HTMLNode("p").addChild("#", message));
    }

    @Override
    public Bucket writeFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        return null;
    }
}

