/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.CSSReadFilter;
import freenet.clients.http.filter.DataFilterException;
import freenet.clients.http.filter.FoundURICallback;
import freenet.clients.http.filter.GIFFilter;
import freenet.clients.http.filter.GenericReadFilterCallback;
import freenet.clients.http.filter.HTMLFilter;
import freenet.clients.http.filter.JPEGFilter;
import freenet.clients.http.filter.MIMEType;
import freenet.clients.http.filter.PNGFilter;
import freenet.clients.http.filter.UnknownContentTypeException;
import freenet.clients.http.filter.UnsafeContentTypeException;
import freenet.l10n.L10n;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;

public class ContentFilter {
    static final Hashtable<String, MIMEType> mimeTypesByName = new Hashtable();
    static byte[] bom_utf8;
    static byte[] bom_utf16_be;
    static byte[] bom_utf16_le;
    static byte[] bom_utf32_be;
    static byte[] bom_utf32_le;
    static byte[] bom_scsu;
    static byte[] bom_utf7_1;
    static byte[] bom_utf7_2;
    static byte[] bom_utf7_3;
    static byte[] bom_utf7_4;
    static byte[] bom_utf7_5;
    static byte[] bom_utf_ebcdic;
    static byte[] bom_bocu_1;

    public static void init() {
        ContentFilter.register(new MIMEType("text/plain", "txt", new String[0], new String[]{"text", "pot"}, true, true, null, null, false, false, false, false, false, false, ContentFilter.l10n("textPlainReadAdvice"), ContentFilter.l10n("textPlainWriteAdvice"), true, "US-ASCII", null));
        ContentFilter.register(new MIMEType("image/gif", "gif", new String[0], new String[0], true, false, new GIFFilter(), null, false, false, false, false, false, false, ContentFilter.l10n("imageGifReadAdvice"), ContentFilter.l10n("imageGifWriteAdvice"), false, null, null));
        ContentFilter.register(new MIMEType("image/jpeg", "jpeg", new String[0], new String[]{"jpg"}, true, false, new JPEGFilter(true, true), null, false, false, false, false, false, false, ContentFilter.l10n("imageJpegReadAdvice"), ContentFilter.l10n("imageJpegWriteAdvice"), false, null, null));
        ContentFilter.register(new MIMEType("image/png", "png", new String[0], new String[0], true, false, new PNGFilter(true, true, true), null, false, false, false, false, true, false, ContentFilter.l10n("imagePngReadAdvice"), ContentFilter.l10n("imagePngWriteAdvice"), false, null, null));
        ContentFilter.register(new MIMEType("image/x-icon", "ico", new String[]{"image/vnd.microsoft.icon", "image/ico", "application/ico"}, new String[0], true, false, null, null, false, false, false, false, false, false, ContentFilter.l10n("imageIcoReadAdvice"), ContentFilter.l10n("imageIcoWriteAdvice"), false, null, null));
        ContentFilter.register(new MIMEType("application/pdf", "pdf", new String[]{"application/x-pdf"}, new String[0], false, false, null, null, true, true, true, false, true, true, ContentFilter.l10n("applicationPdfReadAdvice"), ContentFilter.l10n("applicationPdfWriteAdvice"), false, null, null));
        ContentFilter.register(new MIMEType("text/html", "html", new String[]{"text/xhtml", "text/xml+xhtml", "application/xhtml+xml"}, new String[]{"htm"}, false, false, new HTMLFilter(), null, true, true, true, true, true, true, ContentFilter.l10n("textHtmlReadAdvice"), ContentFilter.l10n("textHtmlWriteAdvice"), true, "iso-8859-1", new HTMLFilter()));
        ContentFilter.register(new MIMEType("text/css", "css", new String[0], new String[0], false, false, new CSSReadFilter(), null, true, true, true, true, true, false, ContentFilter.l10n("textCssReadAdvice"), ContentFilter.l10n("textCssWriteAdvice"), true, "utf-8", new CSSReadFilter()));
    }

    private static String l10n(String key) {
        return L10n.getString("ContentFilter." + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(MIMEType mimeType) {
        Hashtable<String, MIMEType> hashtable = mimeTypesByName;
        synchronized (hashtable) {
            mimeTypesByName.put(mimeType.primaryMimeType, mimeType);
            String[] alt = mimeType.alternateMimeTypes;
            if (alt != null && alt.length > 0) {
                for (int i = 0; i < alt.length; ++i) {
                    mimeTypesByName.put(alt[i], mimeType);
                }
            }
        }
    }

    public static MIMEType getMIMEType(String mimeType) {
        return mimeTypesByName.get(mimeType);
    }

    public static FilterOutput filter(Bucket data, BucketFactory bf, String typeName, URI baseURI, FoundURICallback cb) throws UnsafeContentTypeException, IOException {
        MIMEType handler;
        if (Logger.shouldLog(4, ContentFilter.class)) {
            Logger.minor(ContentFilter.class, "filter(data.size=" + data.size() + " typeName=" + typeName);
        }
        String type = typeName;
        String options = "";
        String charset = null;
        HashMap<String, String> otherParams = null;
        int idx = type.indexOf(59);
        if (idx != -1) {
            options = type.substring(idx + 1);
            type = type.substring(0, idx);
            String[] rawOpts = options.split(";");
            for (int i = 0; i < rawOpts.length; ++i) {
                String raw = rawOpts[i];
                idx = raw.indexOf(61);
                if (idx == -1) {
                    Logger.error(ContentFilter.class, "idx = -1 for '=' on option: " + raw + " from " + typeName);
                    continue;
                }
                String before = raw.substring(0, idx).trim();
                String after = raw.substring(idx + 1).trim();
                if (before.equals("charset")) {
                    charset = after;
                    continue;
                }
                if (otherParams == null) {
                    otherParams = new HashMap<String, String>();
                }
                otherParams.put(before, after);
            }
        }
        if ((handler = ContentFilter.getMIMEType(type)) == null) {
            throw new UnknownContentTypeException(typeName);
        }
        if (handler.readFilter != null) {
            if (handler.takesACharset && (charset == null || charset.length() == 0)) {
                charset = ContentFilter.detectCharset(data, handler);
            }
            Bucket outputData = handler.readFilter.readFilter(data, bf, charset, otherParams, new GenericReadFilterCallback(baseURI, cb));
            if (charset != null) {
                type = type + "; charset=" + charset;
            }
            return new FilterOutput(outputData, type);
        }
        if (handler.safeToRead) {
            return new FilterOutput(data, typeName);
        }
        handler.throwUnsafeContentTypeException();
        return null;
    }

    private static String detectCharset(Bucket data, MIMEType handler) throws IOException {
        String charset = ContentFilter.detectBOM(data);
        if (charset == null && handler.charsetExtractor != null) {
            if (handler.defaultCharset != null) {
                try {
                    charset = handler.charsetExtractor.getCharset(data, handler.defaultCharset);
                    if (charset != null) {
                        if (Logger.shouldLog(4, ContentFilter.class)) {
                            Logger.minor(ContentFilter.class, "Returning charset: " + charset);
                        }
                        return charset;
                    }
                }
                catch (DataFilterException e) {
                    // empty catch block
                }
            }
            try {
                charset = handler.charsetExtractor.getCharset(data, "ISO-8859-1");
                if (charset != null) {
                    return charset;
                }
            }
            catch (DataFilterException e) {
                // empty catch block
            }
            try {
                charset = handler.charsetExtractor.getCharset(data, "UTF-8");
                if (charset != null) {
                    return charset;
                }
            }
            catch (DataFilterException e) {
                // empty catch block
            }
            try {
                charset = handler.charsetExtractor.getCharset(data, "UTF-16");
                if (charset != null) {
                    return charset;
                }
            }
            catch (DataFilterException e) {
                // empty catch block
            }
            try {
                charset = handler.charsetExtractor.getCharset(data, "UTF-32");
                if (charset != null) {
                    return charset;
                }
            }
            catch (UnsupportedEncodingException e) {
                if (Logger.shouldLog(4, ContentFilter.class)) {
                    Logger.minor(ContentFilter.class, "UTF-32 not supported");
                }
            }
            catch (DataFilterException dataFilterException) {
                // empty catch block
            }
        }
        return handler.defaultCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String detectBOM(Bucket bucket) throws IOException {
        BufferedInputStream is;
        block18: {
            byte[] data;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    String string;
                                    is = null;
                                    try {
                                        data = new byte[5];
                                        is = new BufferedInputStream(bucket.getInputStream());
                                        int read = 0;
                                        while (read < data.length) {
                                            int x;
                                            try {
                                                x = ((InputStream)is).read(data, read, data.length - read);
                                            }
                                            catch (EOFException e) {
                                                x = -1;
                                            }
                                            if (x > 0) continue;
                                            break;
                                        }
                                        if (!ContentFilter.startsWith(data, bom_utf8)) break block12;
                                        string = "UTF-8";
                                    }
                                    catch (Throwable throwable) {
                                        Closer.close(is);
                                        throw throwable;
                                    }
                                    Closer.close(is);
                                    return string;
                                }
                                if (!ContentFilter.startsWith(data, bom_utf16_be) && !ContentFilter.startsWith(data, bom_utf16_le)) break block13;
                                String string = "UTF-16";
                                Closer.close(is);
                                return string;
                            }
                            if (!ContentFilter.startsWith(data, bom_utf32_be) && !ContentFilter.startsWith(data, bom_utf32_le)) break block14;
                            String string = "UTF-32";
                            Closer.close(is);
                            return string;
                        }
                        if (!ContentFilter.startsWith(data, bom_scsu)) break block15;
                        String string = "SCSU";
                        Closer.close(is);
                        return string;
                    }
                    if (!ContentFilter.startsWith(data, bom_utf7_1) && !ContentFilter.startsWith(data, bom_utf7_2) && !ContentFilter.startsWith(data, bom_utf7_3) && !ContentFilter.startsWith(data, bom_utf7_4) && !ContentFilter.startsWith(data, bom_utf7_5)) break block16;
                    String string = "UTF-7";
                    Closer.close(is);
                    return string;
                }
                if (!ContentFilter.startsWith(data, bom_utf_ebcdic)) break block17;
                String string = "UTF-EBCDIC";
                Closer.close(is);
                return string;
            }
            if (!ContentFilter.startsWith(data, bom_bocu_1)) break block18;
            String string = "BOCU-1";
            Closer.close(is);
            return string;
        }
        ((InputStream)is).close();
        String string = null;
        Closer.close(is);
        return string;
    }

    private static boolean startsWith(byte[] data, byte[] cmp) {
        for (int i = 0; i < cmp.length; ++i) {
            if (data[i] == cmp[i]) continue;
            return false;
        }
        return true;
    }

    static {
        ContentFilter.init();
        bom_utf8 = new byte[]{-17, -69, -65};
        bom_utf16_be = new byte[]{-2, -1};
        bom_utf16_le = new byte[]{-1, -2};
        bom_utf32_be = new byte[]{0, 0, -2, -1};
        bom_utf32_le = new byte[]{-1, -2, 0, 0};
        bom_scsu = new byte[]{14, -2, -1};
        bom_utf7_1 = new byte[]{43, 47, 118, 56};
        bom_utf7_2 = new byte[]{43, 47, 118, 57};
        bom_utf7_3 = new byte[]{43, 47, 118, 43};
        bom_utf7_4 = new byte[]{43, 47, 118, 47};
        bom_utf7_5 = new byte[]{43, 47, 118, 56, 45};
        bom_utf_ebcdic = new byte[]{-35, 115, 102, 115};
        bom_bocu_1 = new byte[]{-5, -18, 40};
    }

    public static class FilterOutput {
        public final Bucket data;
        public final String type;

        FilterOutput(Bucket data, String type) {
            this.data = data;
            this.type = type;
        }
    }
}

