/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.CSSParser;
import freenet.clients.http.filter.CharsetExtractor;
import freenet.clients.http.filter.ContentDataFilter;
import freenet.clients.http.filter.DataFilterException;
import freenet.clients.http.filter.FilterCallback;
import freenet.clients.http.filter.NullFilterCallback;
import freenet.clients.http.filter.UnknownCharsetException;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import freenet.support.io.NullWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSReadFilter
implements ContentDataFilter,
CharsetExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket readFilter(Bucket bucket, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        if (Logger.shouldLog(2, this)) {
            Logger.debug(this, "running " + this + " on " + bucket + ',' + charset);
        }
        InputStream strm = bucket.getInputStream();
        Bucket temp = bf.makeBucket(-1L);
        OutputStream os = temp.getOutputStream();
        BufferedReader r = null;
        BufferedWriter w = null;
        InputStreamReader isr = null;
        OutputStreamWriter osw = null;
        try {
            try {
                isr = new InputStreamReader(strm, charset);
                osw = new OutputStreamWriter(os, charset);
                r = new BufferedReader(isr, 32768);
                w = new BufferedWriter(osw, 32768);
            }
            catch (UnsupportedEncodingException e) {
                Closer.close(osw);
                Closer.close(os);
                throw UnknownCharsetException.create(e, charset);
            }
            CSSParser parser = new CSSParser(r, w, false, cb);
            parser.parse();
            ((Reader)r).close();
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            Closer.close(strm);
            Closer.close(isr);
            Closer.close(r);
            Closer.close(w);
            throw throwable;
        }
        Closer.close(strm);
        Closer.close(isr);
        Closer.close(r);
        Closer.close(w);
        return temp;
    }

    @Override
    public Bucket writeFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCharset(Bucket bucket, String parseCharset) throws DataFilterException, IOException {
        CSSParser parser;
        BufferedReader r;
        block2: {
            InputStream strm = bucket.getInputStream();
            NullWriter w = new NullWriter();
            r = new BufferedReader(new InputStreamReader(strm, parseCharset), 32768);
            parser = new CSSParser(r, w, false, new NullFilterCallback());
            try {
                parser.parse();
            }
            catch (Throwable t) {
                if (!Logger.shouldLog(4, this)) break block2;
                Logger.minor(this, "Caught " + t + " trying to detect MIME type with " + parseCharset);
            }
        }
        ((Reader)r).close();
        return parser.detectedCharset;
    }
}

