/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.CSSTokenizerFilter;
import freenet.clients.http.filter.CommentException;
import freenet.clients.http.filter.DataFilterException;
import freenet.clients.http.filter.FilterCallback;
import freenet.clients.http.filter.HTMLFilter;
import freenet.support.Logger;
import java.io.Reader;
import java.io.Writer;

class CSSParser
extends CSSTokenizerFilter {
    final FilterCallback cb;

    CSSParser(Reader r, Writer w, boolean paranoidStringCheck, FilterCallback cb) {
        super(r, w, paranoidStringCheck);
        this.cb = cb;
        this.deleteErrors = this.deleteErrors;
    }

    void throwError(String s) throws DataFilterException {
        HTMLFilter.throwFilterException(s);
    }

    String processImportURL(String s) throws CommentException {
        return HTMLFilter.sanitizeURI(HTMLFilter.stripQuotes(s), "text/css", null, this.cb, true);
    }

    String processURL(String s) throws CommentException {
        return HTMLFilter.sanitizeURI(HTMLFilter.stripQuotes(s), null, null, this.cb, true);
    }

    void log(String s) {
        if (Logger.shouldLog(2, this)) {
            Logger.debug(this, s);
        }
    }

    void logError(String s) {
        Logger.error(this, s);
    }
}

