/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.filter;

import freenet.clients.http.filter.ContentDataFilter;
import freenet.clients.http.filter.DataFilterException;
import freenet.clients.http.filter.FilterCallback;
import freenet.l10n.L10n;
import freenet.support.HTMLNode;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BMPFilter
implements ContentDataFilter {
    static final byte[] bmpHeaderwindows = new byte[]{66, 77};
    static final byte[] bmpHeaderos2bArray = new byte[]{66, 65};
    static final byte[] bmpHeaderos2cIcon = new byte[]{67, 73};
    static final byte[] bmpHeaderos2cPointer = new byte[]{67, 80};
    static final byte[] bmpHeaderos2Icon = new byte[]{73, 67};
    static final byte[] bmpHeaderos2Pointer = new byte[]{80, 84};

    private int unsignedByte(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public int readInt(DataInputStream dis) throws IOException {
        byte[] data = new byte[4];
        int result = dis.read(data);
        if (result < 0) {
            throw new EOFException();
        }
        result = this.unsignedByte(data[2]) << 16 | this.unsignedByte(data[1]) << 8 | this.unsignedByte(data[0]);
        return result |= this.unsignedByte(data[3]) << 24;
    }

    public int readShort(DataInputStream dis) throws IOException {
        int result = dis.read();
        if (result < 0) {
            throw new EOFException();
        }
        int r2 = dis.read();
        if (r2 < 0) {
            throw new EOFException();
        }
        return result | r2 * 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket readFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        if (data.size() < 54L) {
            this.throwHeaderError(BMPFilter.l10n("Too short file"), BMPFilter.l10n("The file is too short to contain a bmp header"));
        }
        InputStream is = data.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        try {
            int imagedatasize;
            int compression_type;
            int bitDepth;
            int no_plane;
            int size_bitmapinfoheader;
            byte[] StartWord = new byte[2];
            dis.readFully(StartWord);
            if (!(Arrays.equals(StartWord, bmpHeaderwindows) || Arrays.equals(StartWord, bmpHeaderos2bArray) || Arrays.equals(StartWord, bmpHeaderos2cIcon) || Arrays.equals(StartWord, bmpHeaderos2cPointer) || Arrays.equals(StartWord, bmpHeaderos2Icon) || Arrays.equals(StartWord, bmpHeaderos2Pointer))) {
                this.throwHeaderError(BMPFilter.l10n("Invalid start word"), BMPFilter.l10n("invalidHeader"));
            }
            int fileSize = this.readInt(dis);
            byte[] skipbytes = new byte[4];
            dis.readFully(skipbytes);
            int headerSize = this.readInt(dis);
            if (headerSize < 0) {
                this.throwHeaderError(BMPFilter.l10n("Invalid offset"), BMPFilter.l10n("Image has invalid pixel offset of " + headerSize));
            }
            if ((size_bitmapinfoheader = this.readInt(dis)) != 40) {
                this.throwHeaderError(BMPFilter.l10n("Invalid Bit Map info header size"), BMPFilter.l10n("Size of bitmap info header is not 40"));
            }
            int imageWidth = this.readInt(dis);
            int imageHeight = this.readInt(dis);
            if (imageWidth < 0 || imageHeight < 0) {
                this.throwHeaderError(BMPFilter.l10n("Invalid Dimensions"), BMPFilter.l10n("The image has invalid width or height"));
            }
            if ((no_plane = this.readShort(dis)) != 1) {
                this.throwHeaderError(BMPFilter.l10n("Invalid no of plannes"), BMPFilter.l10n("The image has " + no_plane + " planes"));
            }
            if ((bitDepth = this.readShort(dis)) != 1 && bitDepth != 2 && bitDepth != 4 && bitDepth != 8 && bitDepth != 16 && bitDepth != 24 && bitDepth != 32) {
                this.throwHeaderError(BMPFilter.l10n("Invalid bit depth"), BMPFilter.l10n("The bit depth field is set to" + bitDepth + ". It is not of 1,2,4,8,16, and 32."));
            }
            if ((compression_type = this.readInt(dis)) < 0 || compression_type > 3) {
                this.throwHeaderError(BMPFilter.l10n("Invalid Compression type"), BMPFilter.l10n("Compression type field is set to " + compression_type + " instead of 0-3"));
            }
            if (fileSize != headerSize + (imagedatasize = this.readInt(dis))) {
                this.throwHeaderError(BMPFilter.l10n("Invalid File size"), BMPFilter.l10n("File size is not matching to headersize+ imagedatasize"));
            }
            int horizontal_resolution = this.readInt(dis);
            int vertical_resolution = this.readInt(dis);
            if (horizontal_resolution < 0 || vertical_resolution < 0) {
                this.throwHeaderError(BMPFilter.l10n("Invalid resolution"), BMPFilter.l10n("This image file has resolution of " + horizontal_resolution + "x" + vertical_resolution));
            }
            if (compression_type == 0) {
                int calculatedsize;
                int bytesperline = (int)Math.ceil(imageWidth * bitDepth / 8);
                int paddingperline = 0;
                if (bytesperline % 4 != 0) {
                    paddingperline = 4 - bytesperline % 4;
                }
                if ((calculatedsize = (int)Math.ceil(imageWidth * imageHeight * bitDepth / 8) + paddingperline * imageHeight) != imagedatasize) {
                    this.throwHeaderError(BMPFilter.l10n("Invalid size of image data"), BMPFilter.l10n("The calculated image data size (" + calculatedsize + ") is not matching with the actual size (" + imagedatasize + ")"));
                }
            }
            dis.close();
            Object var26_25 = null;
        }
        catch (Throwable throwable) {
            Object var26_26 = null;
            Closer.close(dis);
            throw throwable;
        }
        Closer.close(dis);
        return data;
    }

    private static String l10n(String key) {
        return L10n.getString("BMPFilter." + key);
    }

    private void throwHeaderError(String shortReason, String reason) throws DataFilterException {
        String message = BMPFilter.l10n("notBMP");
        if (reason != null) {
            message = message + ' ' + reason;
        }
        if (shortReason != null) {
            message = message + " - (" + shortReason + ')';
        }
        throw new DataFilterException(shortReason, shortReason, "<p>" + message + "</p>", new HTMLNode("p").addChild("#", message));
    }

    @Override
    public Bucket writeFilter(Bucket data, BucketFactory bf, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        return null;
    }
}

